/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.misc.OrderedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<T> {
    protected Map<T, Node<T>> nodes = new HashMap<T, Node<T>>();

    public void addEdge(T a15, T b15) {
        Node<T> a_node = this.getNode(a15);
        Node<T> b_node = this.getNode(b15);
        a_node.addEdge(b_node);
    }

    protected Node<T> getNode(T a15) {
        Node<T> existing = this.nodes.get(a15);
        if (existing != null) {
            return existing;
        }
        Node<T> n15 = new Node<T>(a15);
        this.nodes.put(a15, n15);
        return n15;
    }

    public List<T> sort() {
        OrderedHashSet<Node<T>> visited = new OrderedHashSet<Node<T>>();
        ArrayList sorted2 = new ArrayList();
        while (visited.size() < this.nodes.size()) {
            Node<T> tNode;
            Node<T> n15 = null;
            Iterator<Node<T>> i$ = this.nodes.values().iterator();
            while (i$.hasNext() && visited.contains(n15 = (tNode = i$.next()))) {
            }
            this.DFS(n15, visited, sorted2);
        }
        return sorted2;
    }

    public void DFS(Node<T> n15, Set<Node<T>> visited, ArrayList<T> sorted2) {
        if (visited.contains(n15)) {
            return;
        }
        visited.add(n15);
        if (n15.edges != null) {
            for (Node target : n15.edges) {
                this.DFS(target, visited, sorted2);
            }
        }
        sorted2.add(n15.payload);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node<T> {
        T payload;
        List<Node<T>> edges;

        public Node(T payload) {
            this.payload = payload;
        }

        public void addEdge(Node<T> n15) {
            if (this.edges == null) {
                this.edges = new ArrayList<Node<T>>();
            }
            if (!this.edges.contains(n15)) {
                this.edges.add(n15);
            }
        }

        public String toString() {
            return this.payload.toString();
        }
    }
}

