/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.HashSet;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Transition;
import org.antlr.misc.Utils;
import org.antlr.tool.Grammar;

public class DFAOptimizer {
    public static boolean PRUNE_EBNF_EXIT_BRANCHES = true;
    public static boolean PRUNE_TOKENS_RULE_SUPERFLUOUS_EOT_EDGES = true;
    public static boolean COLLAPSE_ALL_PARALLEL_EDGES = true;
    public static boolean MERGE_STOP_STATES = true;
    protected Set<Integer> visited = new HashSet<Integer>();
    protected Grammar grammar;

    public DFAOptimizer(Grammar grammar) {
        this.grammar = grammar;
    }

    public void optimize() {
        for (int decisionNumber = 1; decisionNumber <= this.grammar.getNumberOfDecisions(); ++decisionNumber) {
            DFA dfa = this.grammar.getLookaheadDFA(decisionNumber);
            this.optimize(dfa);
        }
    }

    protected void optimize(DFA dfa) {
        if (dfa == null) {
            return;
        }
        if (PRUNE_EBNF_EXIT_BRANCHES && dfa.canInlineDecision()) {
            this.visited.clear();
            int decisionType = dfa.getNFADecisionStartState().decisionStateType;
            if (dfa.isGreedy() && (decisionType == 3 || decisionType == 1)) {
                this.optimizeExitBranches(dfa.startState);
            }
        }
        if (PRUNE_TOKENS_RULE_SUPERFLUOUS_EOT_EDGES && dfa.isTokensRuleDecision() && dfa.probe.stateToSyntacticallyAmbiguousTokensRuleAltsMap.size() > 0) {
            this.visited.clear();
            this.optimizeEOTBranches(dfa.startState);
        }
    }

    protected void optimizeExitBranches(DFAState d15) {
        Integer sI2 = Utils.integer(d15.stateNumber);
        if (this.visited.contains(sI2)) {
            return;
        }
        this.visited.add(sI2);
        int nAlts = d15.dfa.getNumberOfAlts();
        for (int i15 = 0; i15 < d15.getNumberOfTransitions(); ++i15) {
            Transition edge = d15.transition(i15);
            DFAState edgeTarget = (DFAState)edge.target;
            if (edgeTarget.isAcceptState() && edgeTarget.getUniquelyPredictedAlt() == nAlts) {
                d15.removeTransition(i15);
                --i15;
            }
            this.optimizeExitBranches(edgeTarget);
        }
    }

    protected void optimizeEOTBranches(DFAState d15) {
        Integer sI2 = Utils.integer(d15.stateNumber);
        if (this.visited.contains(sI2)) {
            return;
        }
        this.visited.add(sI2);
        for (int i15 = 0; i15 < d15.getNumberOfTransitions(); ++i15) {
            Transition edge = d15.transition(i15);
            DFAState edgeTarget = (DFAState)edge.target;
            if (PRUNE_TOKENS_RULE_SUPERFLUOUS_EOT_EDGES && edgeTarget.isAcceptState() && d15.getNumberOfTransitions() == 1 && edge.label.isAtom() && edge.label.getAtom() == -2) {
                d15.removeTransition(i15);
                d15.setAcceptState(true);
                d15.cachedUniquelyPredicatedAlt = edgeTarget.getUniquelyPredictedAlt();
                --i15;
            }
            this.optimizeEOTBranches(edgeTarget);
        }
    }
}

