/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingFlag;
import net.fabricmc.mappingio.MappingUtil;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;
import org.jetbrains.annotations.Nullable;

public class OuterClassNamePropagator
extends ForwardingMappingVisitor {
    private static final int COLLECT_CLASSES_PASS = 1;
    private static final int FIX_OUTER_CLASSES_PASS = 2;
    private static final int FIST_EMIT_PASS = 3;
    private final boolean processRemappedDstNames;
    private final Map<String, String[]> dstNamesBySrcName = new HashMap<String, String[]>();
    private final Set<String> modifiedClasses = new HashSet<String>();
    private List<String> dstNamespaces;
    private Collection<String> dstNamespacesToProcess;
    private Collection<Integer> dstNamespaceIndicesToProcess;
    private int pass = 1;
    private int dstNsCount = -1;
    private String srcName;
    private boolean[] visitedDstName;
    private Map<String, String>[] dstNameBySrcNameByNamespace;

    public OuterClassNamePropagator(MappingVisitor next) {
        this(next, null, true);
    }

    public OuterClassNamePropagator(MappingVisitor next, @Nullable Collection<String> namespaces, boolean processRemappedDstNames) {
        super(next);
        this.dstNamespacesToProcess = namespaces;
        this.processRemappedDstNames = processRemappedDstNames;
    }

    @Override
    public Set<MappingFlag> getFlags() {
        EnumSet<MappingFlag> ret = EnumSet.noneOf(MappingFlag.class);
        ret.addAll(this.next.getFlags());
        ret.add(MappingFlag.NEEDS_MULTIPLE_PASSES);
        return ret;
    }

    @Override
    public boolean visitHeader() throws IOException {
        if (this.pass < 3) {
            return true;
        }
        return super.visitHeader();
    }

    @Override
    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
        if (this.pass == 1) {
            if (this.dstNamespacesToProcess == null) {
                this.dstNamespacesToProcess = dstNamespaces;
            } else {
                if (this.dstNamespacesToProcess.contains(srcNamespace)) {
                    throw new UnsupportedOperationException(srcNamespace + " was passed as a destination namespace to propagate outer class names in, but has been visited as the source namespace.");
                }
                for (String ns4 : this.dstNamespacesToProcess) {
                    if (dstNamespaces.contains(ns4)) continue;
                    throw new IllegalArgumentException(ns4 + " was passed as a destination namespace to propagate outer class names in, but is not present in the namespaces of the current visitation pass.");
                }
            }
            this.dstNamespaces = dstNamespaces;
            this.dstNsCount = dstNamespaces.size();
            if (this.dstNamespaceIndicesToProcess == null) {
                this.dstNamespaceIndicesToProcess = new ArrayList<Integer>();
                for (int i15 = 0; i15 < this.dstNsCount; ++i15) {
                    if (!this.dstNamespacesToProcess.contains(dstNamespaces.get(i15))) continue;
                    this.dstNamespaceIndicesToProcess.add(i15);
                }
            }
            this.visitedDstName = new boolean[this.dstNsCount];
            this.dstNameBySrcNameByNamespace = new HashMap[this.dstNsCount];
        } else if (this.pass >= 3) {
            super.visitNamespaces(srcNamespace, dstNamespaces);
        }
    }

    @Override
    public void visitMetadata(String key, @Nullable String value) throws IOException {
        if (this.pass < 3) {
            return;
        }
        super.visitMetadata(key, value);
    }

    @Override
    public boolean visitContent() throws IOException {
        if (this.pass < 3) {
            return true;
        }
        return super.visitContent();
    }

    @Override
    public boolean visitClass(String srcName) throws IOException {
        this.srcName = srcName;
        if (this.pass == 1) {
            this.dstNamesBySrcName.putIfAbsent(srcName, new String[this.dstNsCount]);
        } else if (this.pass >= 3) {
            super.visitClass(srcName);
        }
        return true;
    }

    @Override
    public void visitDstName(MappedElementKind targetKind, int namespace, String name) throws IOException {
        if (this.pass == 1) {
            if (targetKind != MappedElementKind.CLASS) {
                return;
            }
            this.dstNamesBySrcName.get((Object)this.srcName)[namespace] = name;
        } else if (this.pass >= 3) {
            if (targetKind == MappedElementKind.CLASS) {
                this.visitedDstName[namespace] = true;
                name = this.dstNamesBySrcName.get(this.srcName)[namespace];
            }
            super.visitDstName(targetKind, namespace, name);
        }
    }

    @Override
    public void visitDstDesc(MappedElementKind targetKind, int namespace, String desc) throws IOException {
        if (this.pass < 3) {
            return;
        }
        if (this.modifiedClasses.contains(this.srcName)) {
            Map nsDstNameBySrcName = this.dstNameBySrcNameByNamespace[namespace];
            if (nsDstNameBySrcName == null) {
                this.dstNameBySrcNameByNamespace[namespace] = nsDstNameBySrcName = (Map)this.dstNamesBySrcName.entrySet().stream().filter(entry -> ((String[])entry.getValue())[namespace] != null).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), ((String[])entry.getValue())[namespace]), HashMap::putAll);
            }
            desc = MappingUtil.mapDesc(desc, nsDstNameBySrcName);
        }
        super.visitDstDesc(targetKind, namespace, desc);
    }

    @Override
    public boolean visitElementContent(MappedElementKind targetKind) throws IOException {
        if (targetKind == MappedElementKind.CLASS && this.pass > 1) {
            String[] dstNames = this.dstNamesBySrcName.get(this.srcName);
            block0: for (int ns4 = 0; ns4 < dstNames.length; ++ns4) {
                if (!this.dstNamespacesToProcess.contains(this.dstNamespaces.get(ns4))) continue;
                String dstName = dstNames[ns4];
                if (this.pass == 2) {
                    String[] dstParts;
                    if (!this.processRemappedDstNames && dstName != null && !dstName.equals(this.srcName)) continue;
                    String[] srcParts = this.srcName.split(Pattern.quote("$"));
                    String[] stringArray = dstParts = dstName == null ? srcParts : dstName.split(Pattern.quote("$"));
                    assert (dstParts.length == srcParts.length);
                    for (int pos = srcParts.length - 2; pos >= 0; --pos) {
                        String outerDstName;
                        String outerSrcName = String.join((CharSequence)"$", Arrays.copyOfRange(srcParts, 0, pos + 1));
                        if (dstName != null && !dstParts[pos].equals(srcParts[pos]) || (outerDstName = this.dstNamesBySrcName.get(outerSrcName)[ns4]) == null || outerDstName.equals(outerSrcName)) continue;
                        dstNames[ns4] = dstName = outerDstName + "$" + String.join((CharSequence)"$", Arrays.copyOfRange(dstParts, pos + 1, dstParts.length));
                        this.modifiedClasses.add(this.srcName);
                        continue block0;
                    }
                    continue;
                }
                if (this.visitedDstName[ns4] || dstName == null) continue;
                super.visitDstName(targetKind, ns4, dstName);
            }
        }
        if (this.pass < 3) {
            return false;
        }
        Arrays.fill(this.visitedDstName, false);
        return super.visitElementContent(targetKind);
    }

    @Override
    public boolean visitEnd() throws IOException {
        if (this.pass++ < 3) {
            return false;
        }
        return super.visitEnd();
    }
}

