/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.rx;

import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.core.FlowableOnSubscribe;
import jadx.gui.utils.rx.CustomDisposable;
import jadx.gui.utils.ui.DocumentUpdateListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.function.Supplier;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class RxUtils {
    public static Flowable<String> textFieldChanges(JTextField textField) {
        FlowableOnSubscribe source = emitter -> {
            DocumentUpdateListener listener = new DocumentUpdateListener(ev4 -> emitter.onNext(textField.getText()));
            textField.getDocument().addDocumentListener(listener);
            emitter.setDisposable(new CustomDisposable(() -> textField.getDocument().removeDocumentListener(listener)));
        };
        return Flowable.create(source, BackpressureStrategy.LATEST).distinctUntilChanged();
    }

    public static Flowable<String> textFieldEnterPress(JTextField textField) {
        FlowableOnSubscribe source = emitter -> {
            KeyListener keyListener = RxUtils.enterKeyListener(emitter, textField::getText);
            textField.addKeyListener(keyListener);
            emitter.setDisposable(new CustomDisposable(() -> textField.removeKeyListener(keyListener)));
        };
        return Flowable.create(source, BackpressureStrategy.LATEST).distinctUntilChanged();
    }

    public static Flowable<String> spinnerChanges(JSpinner spinner) {
        FlowableOnSubscribe source = emitter -> {
            ChangeListener changeListener = e15 -> emitter.onNext(String.valueOf(spinner.getValue()));
            spinner.addChangeListener(changeListener);
            emitter.setDisposable(new CustomDisposable(() -> spinner.removeChangeListener(changeListener)));
        };
        return Flowable.create(source, BackpressureStrategy.LATEST).distinctUntilChanged();
    }

    public static Flowable<String> spinnerEnterPress(JSpinner spinner) {
        FlowableOnSubscribe source = emitter -> {
            KeyListener keyListener = RxUtils.enterKeyListener(emitter, () -> String.valueOf(spinner.getValue()));
            spinner.addKeyListener(keyListener);
            emitter.setDisposable(new CustomDisposable(() -> spinner.removeKeyListener(keyListener)));
        };
        return Flowable.create(source, BackpressureStrategy.LATEST).distinctUntilChanged();
    }

    @NotNull
    private static KeyListener enterKeyListener(final FlowableEmitter<String> emitter, final Supplier<String> supplier) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ev4) {
                if (ev4.getKeyCode() == 10) {
                    emitter.onNext((String)supplier.get());
                }
            }
        };
    }
}

