/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.hexviewer.search;

import java.util.Objects;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.auxiliary.binary_data.array.ByteArrayEditableData;
import org.exbin.bined.CodeAreaUtils;

public class SearchCondition {
    private SearchMode searchMode = SearchMode.TEXT;
    private String searchText = "";
    private EditableBinaryData binaryData;

    public SearchCondition() {
    }

    public SearchCondition(SearchCondition source) {
        this.searchMode = source.getSearchMode();
        this.searchText = source.getSearchText();
        this.binaryData = new ByteArrayEditableData();
        if (source.getBinaryData() != null) {
            this.binaryData.insert(0L, source.getBinaryData());
        }
    }

    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public BinaryData getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(EditableBinaryData binaryData) {
        this.binaryData = binaryData;
    }

    public boolean isEmpty() {
        switch (this.searchMode.ordinal()) {
            case 0: {
                return this.searchText == null || this.searchText.isEmpty();
            }
            case 1: {
                return this.binaryData == null || this.binaryData.isEmpty();
            }
        }
        throw CodeAreaUtils.getInvalidTypeException(this.searchMode);
    }

    public int hashCode() {
        int hash = 3;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchCondition other = (SearchCondition)obj;
        if (this.searchMode != other.searchMode) {
            return false;
        }
        if (this.searchMode == SearchMode.TEXT) {
            return Objects.equals(this.searchText, other.searchText);
        }
        return Objects.equals(this.binaryData, other.binaryData);
    }

    public void clear() {
        this.searchText = "";
        if (this.binaryData != null) {
            this.binaryData.clear();
        }
    }

    public static enum SearchMode {
        TEXT,
        BINARY;

    }
}

