/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.mappings;

import jadx.api.args.UserRenamesMappingsMode;
import jadx.api.plugins.utils.CommonFileUtils;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.Utils;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.plugins.mappings.JInputMapping;
import jadx.gui.settings.JadxProject;
import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JRoot;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.filedialog.FileDialogWrapper;
import jadx.gui.ui.filedialog.FileOpenMode;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.ActionHandler;
import jadx.plugins.mappings.save.MappingExporter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.format.MappingFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameMappingsGui {
    private static final Logger LOG = LoggerFactory.getLogger(RenameMappingsGui.class);
    private final MainWindow mainWindow;
    private boolean renamesChanged = false;
    private JInputMapping mappingNode;
    private transient JMenu openMappingsMenu;
    private transient Action saveMappingsAction;
    private transient JMenu saveMappingsAsMenu;
    private transient Action closeMappingsAction;

    public RenameMappingsGui(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        mainWindow.addLoadListener(this::onLoad);
        mainWindow.addTreeUpdateListener(this::treeUpdate);
    }

    public void addMenuActions(JMenu menu) {
        this.openMappingsMenu = new JMenu(NLS.str("file.open_mappings"));
        this.openMappingsMenu.add(new ActionHandler(ev4 -> this.openMappings(MappingFormat.PROGUARD_FILE, true)).withNameAndDesc("Proguard (inverted)"));
        this.openMappingsMenu.add(new ActionHandler(ev4 -> this.openMappings(MappingFormat.PROGUARD_FILE, false)).withNameAndDesc("Proguard"));
        this.saveMappingsAction = new ActionHandler(this::saveMappings).withNameAndDesc(NLS.str("file.save_mappings"));
        this.saveMappingsAsMenu = new JMenu(NLS.str("file.save_mappings_as"));
        for (MappingFormat mappingFormat : MappingFormat.values()) {
            if (mappingFormat != MappingFormat.PROGUARD_FILE) {
                this.openMappingsMenu.add(new ActionHandler(ev4 -> this.openMappings(mappingFormat, false)).withNameAndDesc(mappingFormat.name));
            }
            this.saveMappingsAsMenu.add(new ActionHandler(ev4 -> this.saveMappingsAs(mappingFormat)).withNameAndDesc(mappingFormat.name));
        }
        this.closeMappingsAction = new ActionHandler(ev4 -> this.closeMappingsAndRemoveFromProject()).withNameAndDesc(NLS.str("file.close_mappings"));
        menu.addSeparator();
        menu.add(this.openMappingsMenu);
        menu.add(this.saveMappingsAction);
        menu.add(this.saveMappingsAsMenu);
        menu.add(this.closeMappingsAction);
    }

    private boolean onLoad(boolean loaded) {
        this.renamesChanged = false;
        this.mappingNode = null;
        if (loaded) {
            RootNode rootNode = this.mainWindow.getWrapper().getRootNode();
            rootNode.registerCodeDataUpdateListener(codeData -> this.onRename());
        } else {
            JadxProject project = this.mainWindow.getProject();
            JadxSettings settings = this.mainWindow.getSettings();
            if (project.getMappingsPath() != null && settings.getUserRenamesMappingsMode() == UserRenamesMappingsMode.READ_AND_AUTOSAVE_BEFORE_CLOSING) {
                this.saveMappings();
            }
        }
        return false;
    }

    private void onRename() {
        JadxProject project = this.mainWindow.getProject();
        JadxSettings settings = this.mainWindow.getSettings();
        if (project.getMappingsPath() != null && settings.getUserRenamesMappingsMode() == UserRenamesMappingsMode.READ_AND_AUTOSAVE_EVERY_CHANGE) {
            this.saveMappings();
        } else {
            this.renamesChanged = true;
            UiUtils.uiRun(this.mainWindow::update);
        }
    }

    public void onUpdate(boolean loaded) {
        JadxProject project = this.mainWindow.getProject();
        this.openMappingsMenu.setEnabled(loaded);
        this.saveMappingsAction.setEnabled(loaded && this.renamesChanged && project.getMappingsPath() != null);
        this.saveMappingsAsMenu.setEnabled(loaded);
        this.closeMappingsAction.setEnabled(project.getMappingsPath() != null);
    }

    private void treeUpdate(JRoot treeRoot) {
        TabbedPane tabbedPane;
        ContentPanel openedTab;
        if (this.mappingNode != null) {
            return;
        }
        Path mappingsPath = this.mainWindow.getProject().getMappingsPath();
        if (mappingsPath == null) {
            return;
        }
        JNode node = treeRoot.followStaticPath("JInputs");
        JNode currentNode = node.removeNode(n15 -> n15.getClass().equals(JInputMapping.class));
        if (currentNode != null && (openedTab = (tabbedPane = this.mainWindow.getTabbedPane()).getTabByNode(currentNode)) != null) {
            tabbedPane.closeCodePanel(openedTab);
        }
        this.mappingNode = new JInputMapping(mappingsPath);
        node.add(this.mappingNode);
    }

    private void openMappings(MappingFormat mappingFormat, boolean inverted) {
        FileDialogWrapper fileDialog = new FileDialogWrapper(this.mainWindow, FileOpenMode.CUSTOM_OPEN);
        fileDialog.setTitle(NLS.str("file.open_mappings"));
        if (mappingFormat.hasSingleFile()) {
            fileDialog.setFileExtList(Collections.singletonList(mappingFormat.fileExt));
            fileDialog.setSelectionMode(0);
        } else {
            fileDialog.setSelectionMode(1);
        }
        List<Path> selectedPaths = fileDialog.show();
        if (selectedPaths.size() != 1) {
            return;
        }
        Path filePath = selectedPaths.get(0);
        LOG.info("Loading mappings from: {}", (Object)filePath.toAbsolutePath());
        JadxProject project = this.mainWindow.getProject();
        project.setMappingsPath(filePath);
        project.updatePluginOptions(options -> {
            options.put("rename-mappings.format", mappingFormat.name());
            options.put("rename-mappings.invert", inverted ? "yes" : "no");
        });
        this.mainWindow.reopen();
    }

    public void closeMappingsAndRemoveFromProject() {
        this.mainWindow.getProject().setMappingsPath(null);
        this.mainWindow.reopen();
    }

    private void saveMappings() {
        this.renamesChanged = false;
        this.saveInBackground(this.getCurrentMappingFormat(), this.mainWindow.getProject().getMappingsPath(), s15 -> this.mainWindow.update());
    }

    private void saveMappingsAs(MappingFormat mappingFormat) {
        FileDialogWrapper fileDialog = new FileDialogWrapper(this.mainWindow, FileOpenMode.CUSTOM_SAVE);
        fileDialog.setTitle(NLS.str("file.save_mappings_as"));
        if (mappingFormat.hasSingleFile()) {
            Path currentDir = Utils.getOrElse(fileDialog.getCurrentDir(), CommonFileUtils.CWD_PATH);
            fileDialog.setSelectedFile(currentDir.resolve("mappings." + mappingFormat.fileExt));
            fileDialog.setFileExtList(Collections.singletonList(mappingFormat.fileExt));
            fileDialog.setSelectionMode(0);
        } else {
            fileDialog.setSelectionMode(1);
        }
        List<Path> selectedPaths = fileDialog.show();
        if (selectedPaths.size() != 1) {
            return;
        }
        Path selectedPath = selectedPaths.get(0);
        Path savePath = mappingFormat.hasSingleFile() && !selectedPath.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(mappingFormat.fileExt) ? selectedPath.resolveSibling(String.valueOf(selectedPath.getFileName()) + "." + mappingFormat.fileExt) : selectedPath;
        if (Files.exists(savePath, new LinkOption[0])) {
            int res;
            boolean emptyDir = false;
            try (Stream<Path> entries2 = Files.list(savePath);){
                emptyDir = entries2.findFirst().isEmpty();
            }
            catch (IOException entries2) {
                // empty catch block
            }
            if (!emptyDir && (res = JOptionPane.showConfirmDialog(this.mainWindow, NLS.str("confirm.save_as_message", savePath.getFileName()), NLS.str("confirm.save_as_title"), 0)) == 1) {
                return;
            }
        }
        LOG.info("Saving mappings to: {}", (Object)savePath.toAbsolutePath());
        JadxProject project = this.mainWindow.getProject();
        project.setMappingsPath(savePath);
        project.updatePluginOptions(options -> {
            options.put("rename-mappings.format", mappingFormat.name());
            options.put("rename-mappings.invert", "no");
        });
        this.saveInBackground(mappingFormat, savePath, s15 -> {
            this.mappingNode = null;
            this.mainWindow.reloadTree();
        });
    }

    private void saveInBackground(MappingFormat mappingFormat, Path savePath, Consumer<TaskStatus> onFinishUiRunnable) {
        this.mainWindow.getBackgroundExecutor().execute(NLS.str("progress.save_mappings"), () -> new MappingExporter(this.mainWindow.getWrapper().getRootNode()).exportMappings(savePath, this.mainWindow.getProject().getCodeData(), mappingFormat), onFinishUiRunnable);
    }

    private MappingFormat getCurrentMappingFormat() {
        JadxProject project = this.mainWindow.getProject();
        String fmtStr = project.getPluginOption("rename-mappings.format");
        if (fmtStr != null) {
            return MappingFormat.valueOf(fmtStr);
        }
        Path mappingsPath = project.getMappingsPath();
        try {
            return MappingReader.detectFormat(mappingsPath);
        }
        catch (IOException e15) {
            throw new RuntimeException("Failed to detect mapping format for: " + String.valueOf(mappingsPath));
        }
    }
}

