/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.plugins.files;

import jadx.core.plugins.files.IJadxFilesGetter;
import jadx.core.utils.files.FileUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TempFilesGetter
implements IJadxFilesGetter {
    public static final TempFilesGetter INSTANCE = new TempFilesGetter();

    private TempFilesGetter() {
    }

    @Override
    public Path getConfigDir() {
        return this.makeSubDir("config");
    }

    @Override
    public Path getCacheDir() {
        return this.makeSubDir("cache");
    }

    @Override
    public Path getTempDir() {
        return this.makeSubDir("tmp");
    }

    private Path makeSubDir(String subDir) {
        Path dir = TempRootHolder.TEMP_ROOT_DIR.resolve(subDir);
        FileUtils.makeDirs(dir);
        return dir;
    }

    private static final class TempRootHolder {
        public static final Path TEMP_ROOT_DIR;

        private TempRootHolder() {
        }

        static {
            try {
                TEMP_ROOT_DIR = Files.createTempDirectory("jadx-temp-", new FileAttribute[0]);
                TEMP_ROOT_DIR.toFile().deleteOnExit();
            }
            catch (Exception e15) {
                throw new RuntimeException("Failed to create temp directory", e15);
            }
        }
    }
}

