/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.plugins;

import jadx.api.JadxDecompiler;
import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.input.JadxCodeInput;
import jadx.api.plugins.loader.JadxPluginLoader;
import jadx.api.plugins.options.JadxPluginOptions;
import jadx.api.plugins.options.OptionDescription;
import jadx.core.plugins.AppContext;
import jadx.core.plugins.JadxPluginsData;
import jadx.core.plugins.PluginContext;
import jadx.core.plugins.versions.VerifyRequiredVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxPluginManager {
    private static final Logger LOG = LoggerFactory.getLogger(JadxPluginManager.class);
    private final JadxDecompiler decompiler;
    private final JadxPluginsData pluginsData;
    private final Set<String> disabledPlugins;
    private final SortedSet<PluginContext> allPlugins = new TreeSet<PluginContext>();
    private final SortedSet<PluginContext> resolvedPlugins = new TreeSet<PluginContext>();
    private final Map<String, String> provideSuggestions = new TreeMap<String, String>();
    private final List<Consumer<PluginContext>> addPluginListeners = new ArrayList<Consumer<PluginContext>>();

    public JadxPluginManager(JadxDecompiler decompiler) {
        this.decompiler = decompiler;
        this.pluginsData = new JadxPluginsData(decompiler, this);
        this.disabledPlugins = decompiler.getArgs().getDisabledPlugins();
    }

    public void providesSuggestion(String provides, String pluginId) {
        this.provideSuggestions.put(provides, pluginId);
    }

    public void load(JadxPluginLoader pluginLoader) {
        this.allPlugins.clear();
        VerifyRequiredVersion verifyRequiredVersion = new VerifyRequiredVersion();
        for (JadxPlugin plugin : pluginLoader.load()) {
            this.addPlugin(plugin, verifyRequiredVersion);
        }
        this.resolve();
    }

    public void register(JadxPlugin plugin) {
        Objects.requireNonNull(plugin);
        PluginContext addedPlugin = this.addPlugin(plugin, new VerifyRequiredVersion());
        if (addedPlugin == null) {
            LOG.debug("Can't register plugin, it was disabled: {}", (Object)plugin.getPluginInfo().getPluginId());
            return;
        }
        LOG.debug("Register plugin: {}", (Object)addedPlugin.getPluginId());
        this.resolve();
    }

    @Nullable
    private PluginContext addPlugin(JadxPlugin plugin, VerifyRequiredVersion verifyRequiredVersion) {
        PluginContext pluginContext = new PluginContext(this.decompiler, this.pluginsData, plugin);
        if (this.disabledPlugins.contains(pluginContext.getPluginId())) {
            return null;
        }
        String requiredJadxVersion = pluginContext.getPluginInfo().getRequiredJadxVersion();
        if (!verifyRequiredVersion.isCompatible(requiredJadxVersion)) {
            LOG.warn("Plugin '{}' not loaded: requires '{}' jadx version which it is not compatible with current: {}", pluginContext, requiredJadxVersion, verifyRequiredVersion.getJadxVersion());
            return null;
        }
        LOG.debug("Loading plugin: {}", (Object)pluginContext);
        if (!this.allPlugins.add(pluginContext)) {
            throw new IllegalArgumentException("Duplicate plugin id: " + String.valueOf(pluginContext) + ", class " + String.valueOf(plugin.getClass()));
        }
        this.addPluginListeners.forEach(l15 -> l15.accept(pluginContext));
        return pluginContext;
    }

    public boolean unload(String pluginId) {
        boolean result = this.allPlugins.removeIf(context -> {
            if (context.getPluginId().equals(pluginId)) {
                LOG.debug("Unload plugin: {}", (Object)pluginId);
                return true;
            }
            return false;
        });
        this.resolve();
        return result;
    }

    public SortedSet<PluginContext> getAllPluginContexts() {
        return this.allPlugins;
    }

    public SortedSet<PluginContext> getResolvedPluginContexts() {
        return this.resolvedPlugins;
    }

    private synchronized void resolve() {
        Map<String, List<PluginContext>> provides = this.allPlugins.stream().collect(Collectors.groupingBy(p15 -> p15.getPluginInfo().getProvides()));
        ArrayList resolved = new ArrayList(provides.size());
        provides.forEach((provide, list2) -> {
            if (list2.size() == 1) {
                resolved.add((PluginContext)list2.get(0));
            } else {
                String suggestion = this.provideSuggestions.get(provide);
                if (suggestion != null) {
                    list2.stream().filter(p15 -> p15.getPluginId().equals(suggestion)).findFirst().ifPresent(resolved::add);
                } else {
                    PluginContext selected = (PluginContext)list2.get(0);
                    resolved.add(selected);
                    LOG.debug("Select providing '{}' plugin '{}', candidates: {}", provide, selected, list2);
                }
            }
        });
        this.resolvedPlugins.clear();
        this.resolvedPlugins.addAll(resolved);
    }

    public void initAll() {
        this.init(this.allPlugins);
    }

    public void initResolved() {
        this.init(this.resolvedPlugins);
    }

    public void init(SortedSet<PluginContext> pluginContexts) {
        AppContext defAppContext = this.buildDefaultAppContext();
        for (PluginContext context : pluginContexts) {
            try {
                if (context.getAppContext() == null) {
                    context.setAppContext(defAppContext);
                }
                context.init();
            }
            catch (Exception e15) {
                LOG.error("Failed to init plugin: {}", (Object)context.getPluginId(), (Object)e15);
            }
        }
        for (PluginContext context : pluginContexts) {
            JadxPluginOptions options = context.getOptions();
            if (options == null) continue;
            this.verifyOptions(context, options);
        }
    }

    public void unloadAll() {
        this.unload(this.allPlugins);
    }

    public void unloadResolved() {
        this.unload(this.resolvedPlugins);
    }

    public void unload(SortedSet<PluginContext> pluginContexts) {
        for (PluginContext context : pluginContexts) {
            try {
                context.unload();
            }
            catch (Exception e15) {
                LOG.warn("Failed to unload plugin: {}", (Object)context.getPluginId(), (Object)e15);
            }
        }
    }

    private AppContext buildDefaultAppContext() {
        AppContext appContext = new AppContext();
        appContext.setGuiContext(null);
        appContext.setFilesGetter(this.decompiler.getArgs().getFilesGetter());
        return appContext;
    }

    private void verifyOptions(PluginContext pluginContext, JadxPluginOptions options) {
        String pluginId = pluginContext.getPluginId();
        List<OptionDescription> descriptions = options.getOptionsDescriptions();
        if (descriptions == null) {
            throw new IllegalArgumentException("Null option descriptions in plugin id: " + pluginId);
        }
        String prefix = pluginId + ".";
        descriptions.forEach(descObj -> {
            String optName = descObj.name();
            if (optName == null || !optName.startsWith(prefix)) {
                throw new IllegalArgumentException("Plugin option name should start with plugin id: '" + prefix + "', option: " + optName);
            }
            String desc = descObj.description();
            if (desc == null || desc.isEmpty()) {
                throw new IllegalArgumentException("Plugin option description not set, plugin: " + pluginId);
            }
            List<String> values2 = descObj.values();
            if (values2 == null) {
                throw new IllegalArgumentException("Plugin option values is null, option: " + optName + ", plugin: " + pluginId);
            }
        });
    }

    public List<JadxCodeInput> getCodeInputs() {
        return this.getResolvedPluginContexts().stream().flatMap(p15 -> p15.getCodeInputs().stream()).collect(Collectors.toList());
    }

    public void registerAddPluginListener(Consumer<PluginContext> listener) {
        this.addPluginListeners.add(listener);
        this.getAllPluginContexts().forEach(listener);
    }
}

