/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.SwitchData;
import jadx.core.dex.instructions.TargetInsnNode;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchInsn
extends TargetInsnNode {
    private final int dataTarget;
    private final boolean packed;
    @Nullable
    private SwitchData switchData;
    private int def;
    private Object[] modifiedKeys;
    private BlockNode[] targetBlocks;
    private BlockNode defTargetBlock;

    public SwitchInsn(InsnArg arg, int dataTarget, boolean packed) {
        super(InsnType.SWITCH, 1);
        this.addArg(arg);
        this.dataTarget = dataTarget;
        this.packed = packed;
    }

    public boolean needData() {
        return this.switchData == null;
    }

    public void attachSwitchData(SwitchData data, int def) {
        this.switchData = data;
        this.def = def;
    }

    @Override
    public void initBlocks(BlockNode curBlock) {
        if (this.switchData == null) {
            throw new JadxRuntimeException("Switch data not yet attached");
        }
        List<BlockNode> successors = curBlock.getSuccessors();
        int[] targets = this.switchData.getTargets();
        int len = targets.length;
        this.targetBlocks = new BlockNode[len];
        for (int i15 = 0; i15 < len; ++i15) {
            this.targetBlocks[i15] = BlockUtils.getBlockByOffset(targets[i15], successors);
        }
        this.defTargetBlock = BlockUtils.getBlockByOffset(this.def, successors);
    }

    @Override
    public boolean replaceTargetBlock(BlockNode origin, BlockNode replace) {
        if (this.targetBlocks == null) {
            return false;
        }
        int count = 0;
        int len = this.targetBlocks.length;
        for (int i15 = 0; i15 < len; ++i15) {
            if (this.targetBlocks[i15] != origin) continue;
            this.targetBlocks[i15] = replace;
            ++count;
        }
        if (this.defTargetBlock == origin) {
            this.defTargetBlock = replace;
            ++count;
        }
        return count > 0;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SwitchInsn) || !super.isSame(obj)) {
            return false;
        }
        SwitchInsn other = (SwitchInsn)obj;
        return this.dataTarget == other.dataTarget && this.packed == other.packed;
    }

    @Override
    public InsnNode copy() {
        SwitchInsn copy = new SwitchInsn(this.getArg(0), this.dataTarget, this.packed);
        copy.switchData = this.switchData;
        copy.def = this.def;
        copy.targetBlocks = this.targetBlocks;
        copy.defTargetBlock = this.defTargetBlock;
        return this.copyCommonParams(copy);
    }

    @Override
    public String toString() {
        StringBuilder sb5 = new StringBuilder();
        sb5.append(this.baseString());
        if (this.switchData == null) {
            sb5.append("no payload");
        } else {
            int size = this.switchData.getSize();
            int[] keys2 = this.switchData.getKeys();
            if (this.targetBlocks != null) {
                for (int i15 = 0; i15 < size; ++i15) {
                    sb5.append('\n');
                    sb5.append(" case ").append(keys2[i15]).append(": goto ").append(this.targetBlocks[i15]);
                }
                if (this.def != -1) {
                    sb5.append('\n').append(" default: goto ").append(this.defTargetBlock);
                }
            } else {
                int[] targets = this.switchData.getTargets();
                for (int i16 = 0; i16 < size; ++i16) {
                    sb5.append('\n');
                    sb5.append(" case ").append(keys2[i16]).append(": goto ").append(InsnUtils.formatOffset(targets[i16]));
                }
                if (this.def != -1) {
                    sb5.append('\n');
                    sb5.append(" default: goto ").append(InsnUtils.formatOffset(this.def));
                }
            }
        }
        this.appendAttributes(sb5);
        return sb5.toString();
    }

    public int getDataTarget() {
        return this.dataTarget;
    }

    public boolean isPacked() {
        return this.packed;
    }

    public int getDefaultCaseOffset() {
        return this.def;
    }

    @NotNull
    private SwitchData getSwitchData() {
        if (this.switchData == null) {
            throw new JadxRuntimeException("Switch data not yet attached");
        }
        return this.switchData;
    }

    public int[] getTargets() {
        return this.getSwitchData().getTargets();
    }

    public int[] getKeys() {
        return this.getSwitchData().getKeys();
    }

    public Object getKey(int i15) {
        if (this.modifiedKeys != null) {
            return this.modifiedKeys[i15];
        }
        return this.getSwitchData().getKeys()[i15];
    }

    public void modifyKey(int i15, Object newKey) {
        if (this.modifiedKeys == null) {
            int[] keys2 = this.getKeys();
            int caseCount = keys2.length;
            Object[] newKeys = new Object[caseCount];
            for (int j15 = 0; j15 < caseCount; ++j15) {
                newKeys[j15] = keys2[j15];
            }
            this.modifiedKeys = newKeys;
        }
        this.modifiedKeys[i15] = newKey;
    }

    public BlockNode[] getTargetBlocks() {
        return this.targetBlocks;
    }

    public BlockNode getDefTargetBlock() {
        return this.defTargetBlock;
    }
}

