/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen.utils;

import jadx.api.CommentsLevel;
import jadx.api.ICodeWriter;
import jadx.api.data.CommentStyle;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.SourceFileAttr;
import jadx.core.codegen.utils.CodeComment;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.attributes.nodes.JadxCommentsAttr;
import jadx.core.dex.attributes.nodes.NotificationAttrNode;
import jadx.core.dex.attributes.nodes.RenameReasonAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.utils.Utils;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class CodeGenUtils {
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\\R");

    public static void addErrorsAndComments(ICodeWriter code, NotificationAttrNode node) {
        CodeGenUtils.addComments(code, node);
        CodeGenUtils.addErrors(code, node);
    }

    public static void addErrors(ICodeWriter code, NotificationAttrNode node) {
        if (!node.checkCommentsLevel(CommentsLevel.ERROR)) {
            return;
        }
        List errors = node.getAll(AType.JADX_ERROR);
        if (!errors.isEmpty()) {
            errors.stream().distinct().sorted().forEach(err -> CodeGenUtils.addError(code, err.getError(), err.getCause()));
        }
    }

    public static void addError(ICodeWriter code, String errMsg, Throwable cause) {
        code.startLine("/*  JADX ERROR: ").add(errMsg);
        if (cause != null) {
            code.incIndent();
            Utils.appendStackTrace(code, cause);
            code.decIndent();
        }
        code.add("*/");
    }

    public static void addComments(ICodeWriter code, NotificationAttrNode node) {
        JadxCommentsAttr commentsAttr = node.get(AType.JADX_COMMENTS);
        if (commentsAttr != null) {
            commentsAttr.formatAndFilter(node.getCommentsLevel()).forEach(comment -> code.startLine("/* ").addMultiLine((String)comment).add(" */"));
        }
        CodeGenUtils.addCodeComments(code, node, node);
    }

    public static void addCodeComments(ICodeWriter code, NotificationAttrNode parent, @Nullable IAttributeNode node) {
        if (node == null) {
            return;
        }
        if (parent.checkCommentsLevel(CommentsLevel.USER_ONLY)) {
            CodeGenUtils.addCodeComments(code, node);
        }
    }

    private static void addCodeComments(ICodeWriter code, @Nullable IAttributeNode node) {
        if (node == null) {
            return;
        }
        boolean startNewLine = node instanceof ICodeNode;
        for (CodeComment comment : node.getAll(AType.CODE_COMMENTS)) {
            CodeGenUtils.addCodeComment(code, comment, startNewLine);
        }
    }

    private static void addCodeComment(ICodeWriter code, CodeComment comment, boolean startNewLine) {
        if (startNewLine) {
            code.startLine();
        } else {
            code.add(' ');
        }
        CodeGenUtils.addCommentWithStyle(code, comment.getStyle(), comment.getComment());
    }

    public static void addJadxNodeComment(ICodeWriter code, NotificationAttrNode node, CommentsLevel level, BiConsumer<ICodeWriter, String> commentFunc) {
        if (node.checkCommentsLevel(level)) {
            code.startLine();
            CodeGenUtils.addCommentWithStyle(code, CommentStyle.BLOCK_CONDENSED, (ICodeWriter commentCode, String newLinePrefix) -> {
                commentCode.add("JADX ").add(level.name()).add(": ");
                commentFunc.accept((ICodeWriter)commentCode, (String)newLinePrefix);
            });
        }
    }

    public static void addJadxComment(ICodeWriter code, CommentsLevel level, String commentStr) {
        code.startLine();
        CodeGenUtils.addCommentWithStyle(code, CommentStyle.BLOCK_CONDENSED, "JADX " + level.name() + ": " + commentStr);
    }

    private static void addCommentWithStyle(ICodeWriter code, CommentStyle style, String commentStr) {
        CodeGenUtils.appendMultiLineString(code, "", style.getStart());
        CodeGenUtils.appendMultiLineString(code, style.getOnNewLine(), commentStr);
        CodeGenUtils.appendMultiLineString(code, "", style.getEnd());
    }

    private static void addCommentWithStyle(ICodeWriter code, CommentStyle style, BiConsumer<ICodeWriter, String> commentFunc) {
        CodeGenUtils.appendMultiLineString(code, "", style.getStart());
        commentFunc.accept(code, style.getOnNewLine());
        CodeGenUtils.appendMultiLineString(code, "", style.getEnd());
    }

    private static void appendMultiLineString(ICodeWriter code, String onNewLine, String str) {
        String[] lines = NEW_LINE_PATTERN.split(str);
        int linesCount = lines.length;
        if (linesCount == 0) {
            return;
        }
        code.add(lines[0]);
        for (int i15 = 1; i15 < linesCount; ++i15) {
            code.startLine(onNewLine);
            code.add(lines[i15]);
        }
    }

    public static void addClassRenamedComment(ICodeWriter code, ClassNode cls) {
        ClassInfo classInfo = cls.getClassInfo();
        if (classInfo.hasAlias()) {
            CodeGenUtils.addRenamedComment(code, cls, classInfo.getType().getObject());
        }
    }

    public static void addRenamedComment(ICodeWriter code, NotificationAttrNode node, String origName) {
        CodeGenUtils.addJadxNodeComment(code, node, CommentsLevel.INFO, (commentCode, newLinePrefix) -> {
            commentCode.add("renamed from: ").add(origName);
            RenameReasonAttr renameReasonAttr = node.get(AType.RENAME_REASON);
            if (renameReasonAttr != null) {
                commentCode.add(", reason: ").add(renameReasonAttr.getDescription());
            }
        });
    }

    public static void addSourceFileInfo(ICodeWriter code, ClassNode node) {
        if (!node.checkCommentsLevel(CommentsLevel.INFO)) {
            return;
        }
        SourceFileAttr sourceFileAttr = node.get(JadxAttrType.SOURCE_FILE);
        if (sourceFileAttr != null) {
            String fileName = sourceFileAttr.getFileName();
            String topClsName = node.getTopParentClass().getClassInfo().getShortName();
            if (topClsName.contains(fileName)) {
                return;
            }
            CodeGenUtils.addJadxComment(code, CommentsLevel.INFO, "compiled from: " + fileName);
        }
    }

    public static void addInputFileInfo(ICodeWriter code, ClassNode cls) {
        String inputFileName;
        if (cls.checkCommentsLevel(CommentsLevel.INFO) && cls.getClsData() != null && (inputFileName = cls.getClsData().getInputFileName()) != null) {
            ClassNode declCls = cls.getDeclaringClass();
            if (declCls != null && declCls.getClsData() != null && inputFileName.equals(declCls.getClsData().getInputFileName())) {
                return;
            }
            CodeGenUtils.addJadxComment(code, CommentsLevel.INFO, "loaded from: " + inputFileName);
        }
    }

    public static CodeVar getCodeVar(RegisterArg arg) {
        SSAVar svar = arg.getSVar();
        if (svar != null) {
            return svar.getCodeVar();
        }
        return null;
    }

    private CodeGenUtils() {
    }
}

