/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.security.impl;

import jadx.api.security.IJadxSecurity;
import jadx.api.security.JadxSecurityFlag;
import jadx.core.deobf.NameMapper;
import jadx.zip.IZipEntry;
import jadx.zip.security.DisabledZipSecurity;
import jadx.zip.security.IJadxZipSecurity;
import jadx.zip.security.JadxZipSecurity;
import java.io.File;
import java.io.InputStream;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class JadxSecurity
implements IJadxSecurity {
    private static final Logger LOG = LoggerFactory.getLogger(JadxSecurity.class);
    private final Set<JadxSecurityFlag> flags;
    private final IJadxZipSecurity zipSecurity;

    public JadxSecurity(Set<JadxSecurityFlag> flags) {
        this.flags = flags;
        this.zipSecurity = flags.contains((Object)JadxSecurityFlag.SECURE_ZIP_READER) ? new JadxZipSecurity() : DisabledZipSecurity.INSTANCE;
    }

    public JadxSecurity(Set<JadxSecurityFlag> flags, IJadxZipSecurity zipSecurity) {
        this.flags = flags;
        this.zipSecurity = zipSecurity;
    }

    @Override
    public boolean isValidEntry(IZipEntry entry) {
        return this.zipSecurity.isValidEntry(entry);
    }

    @Override
    public boolean isValidEntryName(String entryName) {
        return this.zipSecurity.isValidEntryName(entryName);
    }

    @Override
    public boolean isInSubDirectory(File baseDir, File file2) {
        return this.zipSecurity.isInSubDirectory(baseDir, file2);
    }

    @Override
    public boolean useLimitedDataStream() {
        return this.zipSecurity.useLimitedDataStream();
    }

    @Override
    public int getMaxEntriesCount() {
        return this.zipSecurity.getMaxEntriesCount();
    }

    @Override
    public String verifyAppPackage(String appPackage) {
        if (this.flags.contains((Object)JadxSecurityFlag.VERIFY_APP_PACKAGE) && !NameMapper.isValidFullIdentifier(appPackage)) {
            LOG.warn("App package '{}' has invalid format and will be ignored", (Object)appPackage);
            return "INVALID_PACKAGE";
        }
        return appPackage;
    }

    @Override
    public Document parseXml(InputStream in4) {
        DocumentBuilderFactory dbf = this.flags.contains((Object)JadxSecurityFlag.SECURE_XML_PARSER) ? SecureDBFHolder.INSTANCE : SimpleDBFHolder.INSTANCE;
        try {
            return dbf.newDocumentBuilder().parse(in4);
        }
        catch (Exception e15) {
            throw new RuntimeException("Failed to parse xml", e15);
        }
    }

    private static final class SecureDBFHolder {
        private static final DocumentBuilderFactory INSTANCE = SecureDBFHolder.buildSecureDBF();

        private SecureDBFHolder() {
        }

        private static DocumentBuilderFactory buildSecureDBF() {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                dbf.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
                dbf.setXIncludeAware(false);
                dbf.setExpandEntityReferences(false);
                return dbf;
            }
            catch (Exception e15) {
                throw new RuntimeException("Fail to build secure XML DocumentBuilderFactory", e15);
            }
        }
    }

    private static final class SimpleDBFHolder {
        private static final DocumentBuilderFactory INSTANCE = DocumentBuilderFactory.newInstance();

        private SimpleDBFHolder() {
        }
    }
}

