/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.observers.BasicQueueDisposable;
import java.util.Iterator;
import java.util.Objects;

public final class ObservableFromIterable<T>
extends Observable<T> {
    final Iterable<? extends T> source;

    public ObservableFromIterable(Iterable<? extends T> source) {
        this.source = source;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        boolean hasNext;
        Iterator<T> it;
        try {
            it = this.source.iterator();
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptyDisposable.error(e15, observer);
            return;
        }
        try {
            hasNext = it.hasNext();
        }
        catch (Throwable e16) {
            Exceptions.throwIfFatal(e16);
            EmptyDisposable.error(e16, observer);
            return;
        }
        if (!hasNext) {
            EmptyDisposable.complete(observer);
            return;
        }
        FromIterableDisposable<T> d15 = new FromIterableDisposable<T>(observer, it);
        observer.onSubscribe(d15);
        if (!d15.fusionMode) {
            d15.run();
        }
    }

    static final class FromIterableDisposable<T>
    extends BasicQueueDisposable<T> {
        final Observer<? super T> downstream;
        final Iterator<? extends T> it;
        volatile boolean disposed;
        boolean fusionMode;
        boolean done;
        boolean checkNext;

        FromIterableDisposable(Observer<? super T> actual, Iterator<? extends T> it) {
            this.downstream = actual;
            this.it = it;
        }

        void run() {
            boolean hasNext;
            do {
                T v15;
                if (this.isDisposed()) {
                    return;
                }
                try {
                    v15 = Objects.requireNonNull(this.it.next(), "The iterator returned a null value");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.downstream.onError(e15);
                    return;
                }
                this.downstream.onNext(v15);
                if (this.isDisposed()) {
                    return;
                }
                try {
                    hasNext = this.it.hasNext();
                }
                catch (Throwable e16) {
                    Exceptions.throwIfFatal(e16);
                    this.downstream.onError(e16);
                    return;
                }
            } while (hasNext);
            if (!this.isDisposed()) {
                this.downstream.onComplete();
            }
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.fusionMode = true;
                return 1;
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() {
            if (this.done) {
                return null;
            }
            if (this.checkNext) {
                if (!this.it.hasNext()) {
                    this.done = true;
                    return null;
                }
            } else {
                this.checkNext = true;
            }
            return Objects.requireNonNull(this.it.next(), "The iterator returned a null value");
        }

        @Override
        public boolean isEmpty() {
            return this.done;
        }

        @Override
        public void clear() {
            this.done = true;
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

