/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.internal.observers.BasicQueueDisposable;
import java.util.Objects;

public final class ObservableFromArray<T>
extends Observable<T> {
    final T[] array;

    public ObservableFromArray(T[] array) {
        this.array = array;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        FromArrayDisposable<T> d15 = new FromArrayDisposable<T>(observer, this.array);
        observer.onSubscribe(d15);
        if (d15.fusionMode) {
            return;
        }
        d15.run();
    }

    static final class FromArrayDisposable<T>
    extends BasicQueueDisposable<T> {
        final Observer<? super T> downstream;
        final T[] array;
        int index;
        boolean fusionMode;
        volatile boolean disposed;

        FromArrayDisposable(Observer<? super T> actual, T[] array) {
            this.downstream = actual;
            this.array = array;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.fusionMode = true;
                return 1;
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() {
            int i15 = this.index;
            T[] a15 = this.array;
            if (i15 != a15.length) {
                this.index = i15 + 1;
                return Objects.requireNonNull(a15[i15], "The array element is null");
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.index == this.array.length;
        }

        @Override
        public void clear() {
            this.index = this.array.length;
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        void run() {
            T[] a15 = this.array;
            int n15 = a15.length;
            for (int i15 = 0; i15 < n15 && !this.isDisposed(); ++i15) {
                T value = a15[i15];
                if (value == null) {
                    this.downstream.onError(new NullPointerException("The element at index " + i15 + " is null"));
                    return;
                }
                this.downstream.onNext(value);
            }
            if (!this.isDisposed()) {
                this.downstream.onComplete();
            }
        }
    }
}

