/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.observers.BasicFuseableObserver;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.Objects;

public final class ObservableDistinct<T, K>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super T, K> keySelector;
    final Supplier<? extends Collection<? super K>> collectionSupplier;

    public ObservableDistinct(ObservableSource<T> source, Function<? super T, K> keySelector, Supplier<? extends Collection<? super K>> collectionSupplier) {
        super(source);
        this.keySelector = keySelector;
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        Collection<? super K> collection;
        try {
            collection = ExceptionHelper.nullCheck(this.collectionSupplier.get(), "The collectionSupplier returned a null Collection.");
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            EmptyDisposable.error(ex4, observer);
            return;
        }
        this.source.subscribe(new DistinctObserver<T, K>(observer, this.keySelector, collection));
    }

    static final class DistinctObserver<T, K>
    extends BasicFuseableObserver<T, T> {
        final Collection<? super K> collection;
        final Function<? super T, K> keySelector;

        DistinctObserver(Observer<? super T> actual, Function<? super T, K> keySelector, Collection<? super K> collection) {
            super(actual);
            this.keySelector = keySelector;
            this.collection = collection;
        }

        @Override
        public void onNext(T value) {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0) {
                boolean b15;
                try {
                    K key = Objects.requireNonNull(this.keySelector.apply(value), "The keySelector returned a null key");
                    b15 = this.collection.add(key);
                }
                catch (Throwable ex4) {
                    this.fail(ex4);
                    return;
                }
                if (b15) {
                    this.downstream.onNext(value);
                }
            } else {
                this.downstream.onNext(null);
            }
        }

        @Override
        public void onError(Throwable e15) {
            if (this.done) {
                RxJavaPlugins.onError(e15);
            } else {
                this.done = true;
                this.collection.clear();
                this.downstream.onError(e15);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.collection.clear();
                this.downstream.onComplete();
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v15;
            while ((v15 = this.qd.poll()) != null && !this.collection.add(Objects.requireNonNull(this.keySelector.apply(v15), "The keySelector returned a null key"))) {
            }
            return v15;
        }

        @Override
        public void clear() {
            this.collection.clear();
            super.clear();
        }
    }
}

