/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.observers.SerializedObserver;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableDebounceTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Consumer<? super T> onDropped;

    public ObservableDebounceTimed(ObservableSource<T> source, long timeout, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onDropped) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.onDropped = onDropped;
    }

    @Override
    public void subscribeActual(Observer<? super T> t15) {
        this.source.subscribe(new DebounceTimedObserver<T>(new SerializedObserver<T>(t15), this.timeout, this.unit, this.scheduler.createWorker(), this.onDropped));
    }

    static final class DebounceEmitter<T>
    extends AtomicReference<Disposable>
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = 6812032969491025141L;
        final T value;
        final long idx;
        final DebounceTimedObserver<T> parent;
        final AtomicBoolean once = new AtomicBoolean();

        DebounceEmitter(T value, long idx, DebounceTimedObserver<T> parent) {
            this.value = value;
            this.idx = idx;
            this.parent = parent;
        }

        @Override
        public void run() {
            if (this.once.compareAndSet(false, true)) {
                this.parent.emit(this.idx, this.value, this);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == DisposableHelper.DISPOSED;
        }

        public void setResource(Disposable d15) {
            DisposableHelper.replace(this, d15);
        }
    }

    static final class DebounceTimedObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final Consumer<? super T> onDropped;
        Disposable upstream;
        DebounceEmitter<T> timer;
        volatile long index;
        boolean done;

        DebounceTimedObserver(Observer<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker, Consumer<? super T> onDropped) {
            this.downstream = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            DebounceEmitter<T> currentEmitter = this.timer;
            if (currentEmitter != null) {
                currentEmitter.dispose();
            }
            if (this.onDropped != null && currentEmitter != null) {
                try {
                    this.onDropped.accept(this.timer.value);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.upstream.dispose();
                    this.downstream.onError(ex4);
                    this.done = true;
                }
            }
            DebounceEmitter<T> newEmitter = new DebounceEmitter<T>(t15, idx, this);
            this.timer = newEmitter;
            newEmitter.setResource(this.worker.schedule(newEmitter, this.timeout, this.unit));
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            DebounceEmitter<T> d15 = this.timer;
            if (d15 != null) {
                d15.dispose();
            }
            this.done = true;
            this.downstream.onError(t15);
            this.worker.dispose();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            DebounceEmitter<T> d15 = this.timer;
            if (d15 != null) {
                d15.dispose();
            }
            if (d15 != null) {
                d15.run();
            }
            this.downstream.onComplete();
            this.worker.dispose();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.worker.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.worker.isDisposed();
        }

        void emit(long idx, T t15, DebounceEmitter<T> emitter) {
            if (idx == this.index) {
                this.downstream.onNext(t15);
                emitter.dispose();
            }
        }
    }
}

