/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiConsumer;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.fuseable.FuseToObservable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableCollect;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;

public final class ObservableCollectSingle<T, U>
extends Single<U>
implements FuseToObservable<U> {
    final ObservableSource<T> source;
    final Supplier<? extends U> initialSupplier;
    final BiConsumer<? super U, ? super T> collector;

    public ObservableCollectSingle(ObservableSource<T> source, Supplier<? extends U> initialSupplier, BiConsumer<? super U, ? super T> collector) {
        this.source = source;
        this.initialSupplier = initialSupplier;
        this.collector = collector;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super U> t15) {
        U u15;
        try {
            u15 = Objects.requireNonNull(this.initialSupplier.get(), "The initialSupplier returned a null value");
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptyDisposable.error(e15, t15);
            return;
        }
        this.source.subscribe(new CollectObserver<T, U>(t15, u15, this.collector));
    }

    @Override
    public Observable<U> fuseToObservable() {
        return RxJavaPlugins.onAssembly(new ObservableCollect<T, U>(this.source, this.initialSupplier, this.collector));
    }

    static final class CollectObserver<T, U>
    implements Observer<T>,
    Disposable {
        final SingleObserver<? super U> downstream;
        final BiConsumer<? super U, ? super T> collector;
        final U u;
        Disposable upstream;
        boolean done;

        CollectObserver(SingleObserver<? super U> actual, U u15, BiConsumer<? super U, ? super T> collector) {
            this.downstream = actual;
            this.collector = collector;
            this.u = u15;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            try {
                this.collector.accept(this.u, t15);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.upstream.dispose();
                this.onError(e15);
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onSuccess(this.u);
        }
    }
}

