/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableAmb<T>
extends Flowable<T> {
    final Publisher<? extends T>[] sources;
    final Iterable<? extends Publisher<? extends T>> sourcesIterable;

    public FlowableAmb(Publisher<? extends T>[] sources, Iterable<? extends Publisher<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s15) {
        Publisher<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new Publisher[8];
            try {
                for (Publisher<? extends T> publisher : this.sourcesIterable) {
                    if (publisher == null) {
                        EmptySubscription.error(new NullPointerException("One of the sources is null"), s15);
                        return;
                    }
                    if (count == sources.length) {
                        Publisher[] b15 = new Publisher[count + (count >> 2)];
                        System.arraycopy(sources, 0, b15, 0, count);
                        sources = b15;
                    }
                    sources[count++] = publisher;
                }
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                EmptySubscription.error(e15, s15);
                return;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptySubscription.complete(s15);
            return;
        }
        if (count == 1) {
            sources[0].subscribe(s15);
            return;
        }
        AmbCoordinator<? extends T> ac5 = new AmbCoordinator<T>(s15, count);
        ac5.subscribe(sources);
    }

    static final class AmbInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -1185974347409665484L;
        final AmbCoordinator<T> parent;
        final int index;
        final Subscriber<? super T> downstream;
        boolean won;
        final AtomicLong missedRequested = new AtomicLong();

        AmbInnerSubscriber(AmbCoordinator<T> parent, int index, Subscriber<? super T> downstream) {
            this.parent = parent;
            this.index = index;
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.deferredSetOnce(this, this.missedRequested, s15);
        }

        @Override
        public void request(long n15) {
            SubscriptionHelper.deferredRequest(this, this.missedRequested, n15);
        }

        @Override
        public void onNext(T t15) {
            if (this.won) {
                this.downstream.onNext(t15);
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.downstream.onNext(t15);
            } else {
                ((Subscription)this.get()).cancel();
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.won) {
                this.downstream.onError(t15);
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.downstream.onError(t15);
            } else {
                ((Subscription)this.get()).cancel();
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (this.won) {
                this.downstream.onComplete();
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.downstream.onComplete();
            } else {
                ((Subscription)this.get()).cancel();
            }
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class AmbCoordinator<T>
    implements Subscription {
        final Subscriber<? super T> downstream;
        final AmbInnerSubscriber<T>[] subscribers;
        final AtomicInteger winner = new AtomicInteger();

        AmbCoordinator(Subscriber<? super T> actual, int count) {
            this.downstream = actual;
            this.subscribers = new AmbInnerSubscriber[count];
        }

        public void subscribe(Publisher<? extends T>[] sources) {
            int i15;
            AmbInnerSubscriber<T>[] as4 = this.subscribers;
            int len = as4.length;
            for (i15 = 0; i15 < len; ++i15) {
                as4[i15] = new AmbInnerSubscriber<T>(this, i15 + 1, this.downstream);
            }
            this.winner.lazySet(0);
            this.downstream.onSubscribe(this);
            for (i15 = 0; i15 < len; ++i15) {
                if (this.winner.get() != 0) {
                    return;
                }
                sources[i15].subscribe(as4[i15]);
            }
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                int w15 = this.winner.get();
                if (w15 > 0) {
                    this.subscribers[w15 - 1].request(n15);
                } else if (w15 == 0) {
                    for (AmbInnerSubscriber<T> a15 : this.subscribers) {
                        a15.request(n15);
                    }
                }
            }
        }

        public boolean win(int index) {
            int w15 = this.winner.get();
            if (w15 == 0 && this.winner.compareAndSet(0, index)) {
                AmbInnerSubscriber<T>[] a15 = this.subscribers;
                int n15 = a15.length;
                for (int i15 = 0; i15 < n15; ++i15) {
                    if (i15 + 1 == index) continue;
                    a15[i15].cancel();
                }
                return true;
            }
            return false;
        }

        @Override
        public void cancel() {
            if (this.winner.get() != -1) {
                this.winner.lazySet(-1);
                for (AmbInnerSubscriber<T> a15 : this.subscribers) {
                    a15.cancel();
                }
            }
        }
    }
}

