/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Notification;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subscribers.DisposableSubscriber;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;

public final class BlockingFlowableLatest<T>
implements Iterable<T> {
    final Publisher<? extends T> source;

    public BlockingFlowableLatest(Publisher<? extends T> source) {
        this.source = source;
    }

    @Override
    public Iterator<T> iterator() {
        LatestSubscriberIterator lio = new LatestSubscriberIterator();
        Flowable.fromPublisher(this.source).materialize().subscribe(lio);
        return lio;
    }

    static final class LatestSubscriberIterator<T>
    extends DisposableSubscriber<Notification<T>>
    implements Iterator<T> {
        final Semaphore notify = new Semaphore(0);
        final AtomicReference<Notification<T>> value = new AtomicReference();
        Notification<T> iteratorNotification;

        LatestSubscriberIterator() {
        }

        @Override
        public void onNext(Notification<T> args) {
            boolean wasNotAvailable;
            boolean bl4 = wasNotAvailable = this.value.getAndSet(args) == null;
            if (wasNotAvailable) {
                this.notify.release();
            }
        }

        @Override
        public void onError(Throwable e15) {
            RxJavaPlugins.onError(e15);
        }

        @Override
        public void onComplete() {
        }

        @Override
        public boolean hasNext() {
            if (this.iteratorNotification != null && this.iteratorNotification.isOnError()) {
                throw ExceptionHelper.wrapOrThrow(this.iteratorNotification.getError());
            }
            if ((this.iteratorNotification == null || this.iteratorNotification.isOnNext()) && this.iteratorNotification == null) {
                Notification n15;
                try {
                    BlockingHelper.verifyNonBlocking();
                    this.notify.acquire();
                }
                catch (InterruptedException ex4) {
                    this.dispose();
                    this.iteratorNotification = Notification.createOnError(ex4);
                    throw ExceptionHelper.wrapOrThrow(ex4);
                }
                this.iteratorNotification = n15 = (Notification)this.value.getAndSet(null);
                if (n15.isOnError()) {
                    throw ExceptionHelper.wrapOrThrow(n15.getError());
                }
            }
            return this.iteratorNotification.isOnNext();
        }

        @Override
        public T next() {
            if (this.hasNext() && this.iteratorNotification.isOnNext()) {
                T v15 = this.iteratorNotification.getValue();
                this.iteratorNotification = null;
                return v15;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only iterator.");
        }
    }
}

