/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.disposables;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Cancellable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class CancellableDisposable
extends AtomicReference<Cancellable>
implements Disposable {
    private static final long serialVersionUID = 5718521705281392066L;

    public CancellableDisposable(Cancellable cancellable) {
        super(cancellable);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == null;
    }

    @Override
    public void dispose() {
        Cancellable c15;
        if (this.get() != null && (c15 = (Cancellable)this.getAndSet(null)) != null) {
            try {
                c15.cancel();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
        }
    }
}

