/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl;

import io.github.skylot.raung.common.utils.FileUtils;
import io.github.skylot.raung.common.utils.ZipUtils;
import io.github.skylot.raung.disasm.impl.RaungDisasmBuilder;
import io.github.skylot.raung.disasm.impl.utils.RaungDisasmException;
import io.github.skylot.raung.disasm.impl.utils.ValidateDisasmArgs;
import io.github.skylot.raung.disasm.impl.visitors.RaungClassVisitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaungDisasmExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RaungDisasmExecutor.class);

    public static void process(RaungDisasmBuilder args) {
        ValidateDisasmArgs.process(args);
        RaungDisasmExecutor.processFiles(args);
    }

    public static String processSingleClass(RaungDisasmBuilder args, Path clsFile) {
        FileUtils.checkInputFile(clsFile);
        ValidateDisasmArgs.processOptions(args);
        return RaungDisasmExecutor.runForSingleClass(args, clsFile).getResult();
    }

    public static String processInputStream(RaungDisasmBuilder args, InputStream in4) throws IOException {
        ValidateDisasmArgs.processOptions(args);
        return RaungDisasmExecutor.runForInputStream(args, in4).getResult();
    }

    public static String processBytes(RaungDisasmBuilder args, byte[] bytes) {
        ValidateDisasmArgs.processOptions(args);
        return RaungDisasmExecutor.execute(args, new ClassReader(bytes)).getResult();
    }

    private static RaungClassVisitor runForSingleClass(RaungDisasmBuilder args, Path clsFile) {
        RaungClassVisitor raungClassVisitor;
        BufferedInputStream in4 = new BufferedInputStream(Files.newInputStream(clsFile, StandardOpenOption.READ));
        try {
            raungClassVisitor = RaungDisasmExecutor.runForInputStream(args, in4);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in4).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e15) {
                throw new RaungDisasmException("Failed to process class file: " + clsFile, e15);
            }
        }
        ((InputStream)in4).close();
        return raungClassVisitor;
    }

    private static RaungClassVisitor runForInputStream(RaungDisasmBuilder args, InputStream in4) throws IOException {
        return RaungDisasmExecutor.execute(args, new ClassReader(in4));
    }

    private static RaungClassVisitor execute(RaungDisasmBuilder args, ClassReader reader) {
        RaungClassVisitor visitor2 = new RaungClassVisitor(args);
        reader.accept(visitor2, 0);
        return visitor2;
    }

    private static void processFiles(RaungDisasmBuilder args) {
        Path output = args.getOutput();
        boolean isOutputRaungFile = Objects.equals(FileUtils.getExt(output), "raung");
        List<Path> inputFiles = FileUtils.expandDirs(args.getInputs());
        if (inputFiles.size() == 1 && inputFiles.get(0).getFileName().toString().endsWith(".class")) {
            Path inputFile = inputFiles.get(0);
            RaungClassVisitor rcv = RaungDisasmExecutor.runForSingleClass(args, inputFile);
            if (output == null) {
                String fileName = inputFile.getFileName().toString();
                String baseFileName = fileName.substring(0, fileName.length() - 6) + ".raung";
                Path raungFile = inputFile.toAbsolutePath().getParent().resolve(baseFileName);
                LOG.info("Saving to {}", (Object)raungFile);
                FileUtils.saveFile(raungFile, rcv.getResult());
                return;
            }
            if (isOutputRaungFile) {
                FileUtils.saveFile(output, rcv.getResult());
                return;
            }
            RaungDisasmExecutor.saveResult(args, rcv);
            return;
        }
        if (isOutputRaungFile || Files.isRegularFile(output, new LinkOption[0])) {
            throw new RaungDisasmException("Expect output to be directory, got file: " + output);
        }
        for (Path input : inputFiles) {
            RaungDisasmExecutor.runForFile(args, input);
        }
    }

    private static void runForFile(RaungDisasmBuilder args, Path inputFile) {
        String fileName = inputFile.getFileName().toString();
        if (fileName.endsWith(".class")) {
            RaungDisasmExecutor.saveResult(args, RaungDisasmExecutor.runForSingleClass(args, inputFile));
            return;
        }
        if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
            RaungDisasmExecutor.runForZip(args, inputFile);
        }
    }

    private static void runForZip(RaungDisasmBuilder args, Path zipPath) {
        Path resDir = args.getOutput().resolve("resources");
        ZipUtils.visitZipEntries(zipPath.toFile(), (zip, entry) -> {
            String entryName = entry.getName();
            if (entryName.endsWith(".class")) {
                try (InputStream in4 = ZipUtils.getInputStreamForEntry(zip, entry);){
                    RaungDisasmExecutor.saveResult(args, RaungDisasmExecutor.runForInputStream(args, in4));
                }
                catch (Exception e15) {
                    LOG.error("Error process zip entry: {}", (Object)entry.getName(), (Object)e15);
                }
            } else if (!entry.isDirectory()) {
                try (InputStream in5 = ZipUtils.getInputStreamForEntry(zip, entry);){
                    FileUtils.saveInputStream(resDir, entryName, in5);
                }
                catch (Exception e16) {
                    LOG.error("Error process zip entry: {}", (Object)entry.getName(), (Object)e16);
                }
            }
            return null;
        });
    }

    private static void saveResult(RaungDisasmBuilder args, RaungClassVisitor rcv) {
        String fileName = rcv.getClsFullName().replace('/', File.separatorChar) + ".raung";
        FileUtils.saveFile(args.getOutput(), fileName, rcv.getResult());
    }
}

