/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.util.DuplicateHandler;
import com.twelvemonkeys.util.FilterIterator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class CollectionUtil {
    public static void main(String[] stringArray) {
        String string;
        int n15 = 1000;
        if (stringArray.length > 0) {
            n15 = Integer.parseInt(stringArray[0]);
        }
        String[] stringArray2 = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
        stringArray2 = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
        System.out.println("\nFilterIterators:\n");
        List<String> list2 = Arrays.asList(stringArray2);
        FilterIterator<String> filterIterator = new FilterIterator<String>(list2.iterator(), new FilterIterator.Filter(){

            public boolean accept(Object object) {
                return ((String)object).length() > 5;
            }
        });
        while (filterIterator.hasNext()) {
            string = (String)filterIterator.next();
            System.out.println(string + " has more than 5 letters!");
        }
        filterIterator = new FilterIterator<String>(list2.iterator(), new FilterIterator.Filter(){

            public boolean accept(Object object) {
                return ((String)object).length() <= 5;
            }
        });
        while (filterIterator.hasNext()) {
            string = (String)filterIterator.next();
            System.out.println(string + " has less than, or exactly 5 letters!");
        }
        long l15 = System.currentTimeMillis();
        for (int i15 = 0; i15 < n15; ++i15) {
            filterIterator = new FilterIterator<String>(list2.iterator(), new FilterIterator.Filter(){

                public boolean accept(Object object) {
                    return ((String)object).length() <= 5;
                }
            });
            while (filterIterator.hasNext()) {
                filterIterator.next();
                System.out.print("");
            }
        }
    }

    private CollectionUtil() {
    }

    public static Object mergeArrays(Object object, Object object2) {
        return CollectionUtil.mergeArrays(object, 0, Array.getLength(object), object2, 0, Array.getLength(object2));
    }

    public static Object mergeArrays(Object object, int n15, int n16, Object object2, int n17, int n18) {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = clazz.getComponentType();
        Object object3 = Array.newInstance(clazz2, n16 + n18);
        System.arraycopy(object, n15, object3, 0, n16);
        System.arraycopy(object2, n17, object3, n16, n18);
        return object3;
    }

    public static Object subArray(Object object, int n15) {
        return CollectionUtil.subArray(object, n15, -1);
    }

    public static <T> T[] subArray(T[] TArray, int n15) {
        return CollectionUtil.subArray(TArray, n15, -1);
    }

    public static Object subArray(Object object, int n15, int n16) {
        Object object2;
        int n17;
        Validate.notNull(object, "array");
        if (n15 < 0) {
            throw new ArrayIndexOutOfBoundsException(n15 + " < 0");
        }
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == null) {
            throw new IllegalArgumentException("Not an array: " + object);
        }
        int n18 = Array.getLength(object);
        int n19 = n17 = n16 < 0 ? Math.max(0, n18 - n15) : Math.min(n16, Math.max(0, n18 - n15));
        if (n17 < n18) {
            object2 = Array.newInstance(clazz, n17);
            System.arraycopy(object, n15, object2, 0, n17);
        } else {
            object2 = object;
        }
        return object2;
    }

    public static <T> T[] subArray(T[] TArray, int n15, int n16) {
        return (Object[])CollectionUtil.subArray(TArray, n15, n16);
    }

    public static <T> Iterator<T> iterator(final Enumeration<T> enumeration) {
        Validate.notNull(enumeration, "enumeration");
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> void addAll(Collection<E> collection, Iterator<? extends E> iterator2) {
        while (iterator2.hasNext()) {
            collection.add(iterator2.next());
        }
    }

    public static <E> ListIterator<E> iterator(E[] EArray) {
        return CollectionUtil.iterator(EArray, 0, Validate.notNull(EArray).length);
    }

    public static <E> ListIterator<E> iterator(E[] EArray, int n15, int n16) {
        return new ArrayIterator<E>(EArray, n15, n16);
    }

    public static <K, V> Map<V, K> invert(Map<K, V> map) {
        return CollectionUtil.invert(map, null, null);
    }

    public static <K, V> Map<V, K> invert(Map<K, V> map, Map<V, K> map2, DuplicateHandler<K> duplicateHandler) {
        if (map == null) {
            throw new IllegalArgumentException("source == null");
        }
        Map map3 = map2;
        if (map3 == null) {
            try {
                map3 = (Map)map.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (map3 == null) {
                throw new IllegalArgumentException("result == null and source class " + map.getClass() + " cannot be instantiated.");
            }
        }
        Set<Map.Entry<K, V>> set = map.entrySet();
        for (Map.Entry<K, V> entry : set) {
            V v15 = entry.getValue();
            K k15 = entry.getKey();
            if (map3.containsKey(v15)) {
                if (duplicateHandler != null) {
                    k15 = duplicateHandler.resolve(map3.get(v15), k15);
                } else {
                    throw new IllegalArgumentException("Result would include duplicate keys, but no DuplicateHandler specified.");
                }
            }
            map3.put(v15, k15);
        }
        return map3;
    }

    public static <T> Comparator<T> reverseOrder(Comparator<T> comparator) {
        return new ReverseComparator<T>(comparator);
    }

    static <T extends Iterator<? super E>, E> T generify(Iterator<?> iterator2, Class<E> clazz) {
        return (T)iterator2;
    }

    static <T extends Collection<? super E>, E> T generify(Collection<?> collection, Class<E> clazz) {
        return (T)collection;
    }

    static <T extends Map<? super K, ? super V>, K, V> T generify(Map<?, ?> map, Class<K> clazz, Class<V> clazz2) {
        return (T)map;
    }

    static <T extends Collection<? super E>, E> T generify2(Collection<?> collection) {
        return (T)collection;
    }

    private static class ArrayIterator<E>
    implements ListIterator<E> {
        private int next;
        private final int start;
        private final int length;
        private final E[] array;

        public ArrayIterator(E[] EArray, int n15, int n16) {
            this.array = Validate.notNull(EArray, "array");
            this.start = Validate.isTrue(n15 >= 0, n15, "start < 0: %d");
            this.length = Validate.isTrue(n16 <= EArray.length - n15, n16, "length > array.length - start: %d");
            this.next = this.start;
        }

        @Override
        public boolean hasNext() {
            return this.next < this.length + this.start;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return this.array[this.next++];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                NoSuchElementException noSuchElementException = new NoSuchElementException(arrayIndexOutOfBoundsException.getMessage());
                noSuchElementException.initCause(arrayIndexOutOfBoundsException);
                throw noSuchElementException;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e15) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.next > this.start;
        }

        @Override
        public int nextIndex() {
            return this.next - this.start;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            try {
                return this.array[--this.next];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                NoSuchElementException noSuchElementException = new NoSuchElementException(arrayIndexOutOfBoundsException.getMessage());
                noSuchElementException.initCause(arrayIndexOutOfBoundsException);
                throw noSuchElementException;
            }
        }

        @Override
        public int previousIndex() {
            return this.nextIndex() - 1;
        }

        @Override
        public void set(E e15) {
            this.array[this.next - 1] = e15;
        }
    }

    private static class ReverseComparator<T>
    implements Comparator<T> {
        private final Comparator<T> comparator;

        public ReverseComparator(Comparator<T> comparator) {
            this.comparator = Validate.notNull(comparator);
        }

        @Override
        public int compare(T t15, T t16) {
            int n15 = this.comparator.compare(t15, t16);
            return -(n15 | n15 >>> 1);
        }
    }
}

