/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

@Deprecated
public final class BufferedImageInputStream
extends ImageInputStreamImpl
implements ImageInputStream {
    static final int DEFAULT_BUFFER_SIZE = 8192;
    private ImageInputStream stream;
    private ByteBuffer buffer;
    private final ByteBuffer integralCache = ByteBuffer.allocate(8);
    private final byte[] integralCacheArray = this.integralCache.array();

    public BufferedImageInputStream(ImageInputStream imageInputStream) throws IOException {
        this(imageInputStream, 8192);
    }

    private BufferedImageInputStream(ImageInputStream imageInputStream, int n15) throws IOException {
        this.stream = Validate.notNull(imageInputStream, "stream");
        this.streamPos = imageInputStream.getStreamPosition();
        this.buffer = ByteBuffer.allocate(n15);
        this.buffer.limit(0);
    }

    private void fillBuffer() throws IOException {
        this.buffer.clear();
        int n15 = this.stream.read(this.buffer.array(), 0, this.buffer.capacity());
        if (n15 >= 0) {
            this.buffer.position(n15);
            this.buffer.flip();
        } else {
            this.buffer.limit(0);
        }
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        super.setByteOrder(byteOrder);
        this.integralCache.order(byteOrder);
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (!this.buffer.hasRemaining()) {
            this.fillBuffer();
            if (!this.buffer.hasRemaining()) {
                return -1;
            }
        }
        this.bitOffset = 0;
        ++this.streamPos;
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n15, int n16) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        if (!this.buffer.hasRemaining()) {
            if (n16 >= this.buffer.capacity()) {
                return this.readDirect(byArray, n15, n16);
            }
            this.fillBuffer();
        }
        return this.readBuffered(byArray, n15, n16);
    }

    private int readDirect(byte[] byArray, int n15, int n16) throws IOException {
        this.buffer.limit(0);
        int n17 = this.stream.read(byArray, n15, n16);
        if (n17 > 0) {
            this.streamPos += (long)n17;
        }
        return n17;
    }

    private int readBuffered(byte[] byArray, int n15, int n16) {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int n17 = Math.min(this.buffer.remaining(), n16);
        if (n17 > 0) {
            int n18 = this.buffer.position();
            System.arraycopy(this.buffer.array(), n18, byArray, n15, n17);
            this.buffer.position(n18 + n17);
        }
        this.streamPos += (long)n17;
        return n17;
    }

    @Override
    public short readShort() throws IOException {
        this.readFully(this.integralCacheArray, 0, 2);
        return this.integralCache.getShort(0);
    }

    @Override
    public int readInt() throws IOException {
        this.readFully(this.integralCacheArray, 0, 4);
        return this.integralCache.getInt(0);
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this.integralCacheArray, 0, 8);
        return this.integralCache.getLong(0);
    }

    @Override
    public int readBit() throws IOException {
        this.checkClosed();
        if (!this.buffer.hasRemaining()) {
            this.fillBuffer();
            if (!this.buffer.hasRemaining()) {
                throw new EOFException();
            }
        }
        int n15 = this.bitOffset + 1 & 7;
        int n16 = this.buffer.get() & 0xFF;
        if (n15 != 0) {
            this.buffer.position(this.buffer.position() - 1);
            n16 >>= 8 - n15;
        } else {
            ++this.streamPos;
        }
        this.bitOffset = n15;
        return n16 & 1;
    }

    @Override
    public long readBits(int n15) throws IOException {
        int n16;
        this.checkClosed();
        if (n15 < 0 || n15 > 64) {
            throw new IllegalArgumentException();
        }
        if (n15 == 0) {
            return 0L;
        }
        int n17 = this.bitOffset + n15 & 7;
        long l15 = 0L;
        for (n16 = n15 + this.bitOffset; n16 > 0; n16 -= 8) {
            if (!this.buffer.hasRemaining()) {
                this.fillBuffer();
                if (!this.buffer.hasRemaining()) {
                    throw new EOFException();
                }
            }
            int n18 = this.buffer.get() & 0xFF;
            ++this.streamPos;
            l15 <<= 8;
            l15 |= (long)n18;
        }
        if (n17 != 0) {
            this.buffer.position(this.buffer.position() - 1);
            --this.streamPos;
        }
        this.bitOffset = n17;
        l15 >>>= -n16;
        return l15 &= -1L >>> 64 - n15;
    }

    @Override
    public void seek(long l15) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        if (this.streamPos == l15) {
            return;
        }
        long l16 = (long)this.buffer.position() + l15 - this.streamPos;
        if (l16 >= 0L && l16 <= (long)this.buffer.limit()) {
            this.buffer.position((int)l16);
        } else {
            this.buffer.limit(0);
            this.stream.seek(l15);
        }
        this.streamPos = l15;
    }

    @Override
    public void flushBefore(long l15) throws IOException {
        this.checkClosed();
        this.stream.flushBefore(l15);
    }

    @Override
    public long getFlushedPosition() {
        return this.stream.getFlushedPosition();
    }

    @Override
    public boolean isCached() {
        return this.stream.isCached();
    }

    @Override
    public boolean isCachedMemory() {
        return this.stream.isCachedMemory();
    }

    @Override
    public boolean isCachedFile() {
        return this.stream.isCachedFile();
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream = null;
            this.buffer = null;
        }
        super.close();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public long length() {
        try {
            return this.stream.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

