/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.AffineTransformOp;
import com.twelvemonkeys.image.BrightnessContrastFilter;
import com.twelvemonkeys.image.BufferedImageFactory;
import com.twelvemonkeys.image.DiffusionDither;
import com.twelvemonkeys.image.GrayFilter;
import com.twelvemonkeys.image.IndexImage;
import com.twelvemonkeys.image.ResampleOp;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;
import java.awt.image.Kernel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public final class ImageUtil {
    public static final int ROTATE_90_CCW = -90;
    public static final int ROTATE_90_CW = 90;
    public static final int ROTATE_180 = 180;
    public static final int FLIP_VERTICAL = -1;
    public static final int FLIP_HORIZONTAL = 1;
    public static final int EDGE_ZERO_FILL = 0;
    public static final int EDGE_NO_OP = 1;
    public static final int EDGE_REFLECT = 2;
    public static final int EDGE_WRAP = 3;
    public static final int DITHER_DEFAULT = 0;
    public static final int DITHER_NONE = 1;
    public static final int DITHER_DIFFUSION = 2;
    public static final int DITHER_DIFFUSION_ALTSCANS = 3;
    public static final int COLOR_SELECTION_DEFAULT = 0;
    public static final int COLOR_SELECTION_FAST = 256;
    public static final int COLOR_SELECTION_QUALITY = 512;
    public static final int TRANSPARENCY_DEFAULT = 0;
    public static final int TRANSPARENCY_OPAQUE = 65536;
    public static final int TRANSPARENCY_BITMASK = 131072;
    protected static final int TRANSPARENCY_TRANSLUCENT = 196608;
    private static final int BI_TYPE_ANY = -1;
    private static boolean VM_SUPPORTS_ACCELERATION = true;
    private static final float[] SHARPEN_MATRIX = new float[]{0.0f, -0.3f, 0.0f, -0.3f, 2.2f, -0.3f, 0.0f, -0.3f, 0.0f};
    private static final Kernel SHARPEN_KERNEL = new Kernel(3, 3, SHARPEN_MATRIX);
    private static final Component NULL_COMPONENT = new Component(){};
    private static MediaTracker sTracker = new MediaTracker(NULL_COMPONENT);
    protected static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    protected static final Point LOCATION_UPPER_LEFT = new Point(0, 0);
    private static final GraphicsConfiguration DEFAULT_CONFIGURATION = ImageUtil.getDefaultGraphicsConfiguration();

    private static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!graphicsEnvironment.isHeadlessInstance()) {
                return graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
            }
        }
        catch (LinkageError linkageError) {
            VM_SUPPORTS_ACCELERATION = false;
        }
        return null;
    }

    private ImageUtil() {
    }

    public static BufferedImage toBuffered(RenderedImage renderedImage) {
        WritableRaster writableRaster;
        String[] stringArray;
        Hashtable<String, Object> hashtable;
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        if (renderedImage == null) {
            throw new IllegalArgumentException("original == null");
        }
        String[] stringArray2 = renderedImage.getPropertyNames();
        if (stringArray2 != null && stringArray2.length > 0) {
            hashtable = new Hashtable<String, Object>(stringArray2.length);
            stringArray = stringArray2;
            int n15 = stringArray.length;
            for (int i15 = 0; i15 < n15; ++i15) {
                String string = stringArray[i15];
                hashtable.put(string, renderedImage.getProperty(string));
            }
        } else {
            hashtable = null;
        }
        if ((stringArray = renderedImage.getData()) instanceof WritableRaster) {
            writableRaster = (WritableRaster)stringArray;
        } else {
            writableRaster = stringArray.createCompatibleWritableRaster();
            writableRaster = renderedImage.copyData(writableRaster);
        }
        ColorModel colorModel = renderedImage.getColorModel();
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage toBuffered(RenderedImage renderedImage, int n15) {
        if (renderedImage instanceof BufferedImage && ((BufferedImage)renderedImage).getType() == n15) {
            return (BufferedImage)renderedImage;
        }
        if (renderedImage == null) {
            throw new IllegalArgumentException("original == null");
        }
        BufferedImage bufferedImage = ImageUtil.createBuffered(renderedImage.getWidth(), renderedImage.getHeight(), n15, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawRenderedImage(renderedImage, IDENTITY_TRANSFORM);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public static BufferedImage toBuffered(BufferedImage bufferedImage, int n15) {
        return ImageUtil.toBuffered((RenderedImage)bufferedImage, n15);
    }

    public static BufferedImage toBuffered(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        if (image == null) {
            throw new IllegalArgumentException("original == null");
        }
        BufferedImageFactory bufferedImageFactory = new BufferedImageFactory(image);
        return bufferedImageFactory.getBufferedImage();
    }

    public static BufferedImage createCopy(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("image == null");
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
        ImageUtil.drawOnto(bufferedImage2, bufferedImage);
        return bufferedImage2;
    }

    static WritableRaster createRaster(int n15, int n16, Object object, ColorModel colorModel) {
        int n17;
        Object object2;
        DataBuffer dataBuffer = null;
        WritableRaster writableRaster = null;
        if (object instanceof int[]) {
            object2 = (int[])object;
            dataBuffer = new DataBufferInt((int[])object2, ((int[])object2).length);
            n17 = colorModel.getNumComponents();
        } else if (object instanceof short[]) {
            object2 = (short[])object;
            dataBuffer = new DataBufferUShort((short[])object2, ((int[])object2).length);
            n17 = ((int[])object2).length / (n15 * n16);
        } else if (object instanceof byte[]) {
            object2 = (byte[])object;
            dataBuffer = new DataBufferByte((byte[])object2, ((int[])object2).length);
            n17 = colorModel instanceof IndexColorModel ? 1 : ((int[])object2).length / (n15 * n16);
        } else {
            n17 = -1;
            writableRaster = colorModel.createCompatibleWritableRaster(n15, n16);
            writableRaster.setDataElements(0, 0, n15, n16, object);
        }
        if (writableRaster == null) {
            if (colorModel instanceof IndexColorModel && ImageUtil.isIndexedPacked((IndexColorModel)colorModel)) {
                writableRaster = Raster.createPackedRaster(dataBuffer, n15, n16, colorModel.getPixelSize(), LOCATION_UPPER_LEFT);
            } else if (colorModel instanceof PackedColorModel) {
                object2 = (PackedColorModel)colorModel;
                writableRaster = Raster.createPackedRaster(dataBuffer, n15, n16, n15, ((PackedColorModel)object2).getMasks(), LOCATION_UPPER_LEFT);
            } else {
                object2 = new int[n17];
                int n18 = 0;
                while (n18 < n17) {
                    object2[n18++] = n17 - n18;
                }
                writableRaster = Raster.createInterleavedRaster(dataBuffer, n15, n16, n15 * n17, n17, (int[])object2, LOCATION_UPPER_LEFT);
            }
        }
        return writableRaster;
    }

    private static boolean isIndexedPacked(IndexColorModel indexColorModel) {
        return indexColorModel.getPixelSize() == 1 || indexColorModel.getPixelSize() == 2 || indexColorModel.getPixelSize() == 4;
    }

    static WritableRaster createCompatibleWritableRaster(BufferedImage bufferedImage, ColorModel colorModel, int n15, int n16) {
        if (colorModel == null || ImageUtil.equals(bufferedImage.getColorModel(), colorModel)) {
            switch (bufferedImage.getType()) {
                case 5: {
                    int[] nArray = new int[]{2, 1, 0};
                    return Raster.createInterleavedRaster(0, n15, n16, n15 * 3, 3, nArray, null);
                }
                case 6: 
                case 7: {
                    int[] nArray = new int[]{3, 2, 1, 0};
                    return Raster.createInterleavedRaster(0, n15, n16, n15 * 4, 4, nArray, null);
                }
                case 0: {
                    SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
                    if (!(sampleModel instanceof ComponentSampleModel)) break;
                    int[] nArray = ((ComponentSampleModel)sampleModel).getBandOffsets();
                    return Raster.createInterleavedRaster(sampleModel.getDataType(), n15, n16, n15 * nArray.length, nArray.length, nArray, null);
                }
            }
            return bufferedImage.getColorModel().createCompatibleWritableRaster(n15, n16);
        }
        return colorModel.createCompatibleWritableRaster(n15, n16);
    }

    public static BufferedImage toBuffered(Image image, int n15) {
        return ImageUtil.toBuffered(image, n15, null);
    }

    private static BufferedImage toBuffered(Image image, int n15, IndexColorModel indexColorModel) {
        if (image instanceof BufferedImage && ((BufferedImage)image).getType() == n15 && (indexColorModel == null || ImageUtil.equals(((BufferedImage)image).getColorModel(), indexColorModel))) {
            return (BufferedImage)image;
        }
        if (image == null) {
            throw new IllegalArgumentException("original == null");
        }
        BufferedImage bufferedImage = indexColorModel == null ? ImageUtil.createBuffered(ImageUtil.getWidth(image), ImageUtil.getHeight(image), n15, 3) : new BufferedImage(ImageUtil.getWidth(image), ImageUtil.getHeight(image), n15, indexColorModel);
        ImageUtil.drawOnto(bufferedImage, image);
        return bufferedImage;
    }

    static void drawOnto(BufferedImage bufferedImage, Image image) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            graphics2D.drawImage(image, 0, 0, null);
        }
        finally {
            graphics2D.dispose();
        }
    }

    public static BufferedImage createFlipped(Image image, int n15) {
        AffineTransform affineTransform;
        switch (n15) {
            case -1: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal direction: " + n15);
            }
        }
        BufferedImage bufferedImage = ImageUtil.toBuffered(image);
        if (n15 == 1) {
            affineTransform = AffineTransform.getTranslateInstance(0.0, bufferedImage.getHeight());
            affineTransform.scale(1.0, -1.0);
        } else {
            affineTransform = AffineTransform.getTranslateInstance(bufferedImage.getWidth(), 0.0);
            affineTransform.scale(-1.0, 1.0);
        }
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        return affineTransformOp.filter(bufferedImage, null);
    }

    public static BufferedImage createRotated(Image image, int n15) {
        switch (n15) {
            case -90: 
            case 90: 
            case 180: {
                return ImageUtil.createRotated(image, Math.toRadians(n15));
            }
        }
        throw new IllegalArgumentException("Illegal direction: " + n15);
    }

    public static BufferedImage createRotated(Image image, double d15) {
        return ImageUtil.createRotated0(ImageUtil.toBuffered(image), d15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage createRotated0(BufferedImage bufferedImage, double d15) {
        if (Math.abs(Math.toDegrees(d15)) % 360.0 == 0.0) {
            return bufferedImage;
        }
        boolean bl4 = Math.abs(Math.toDegrees(d15)) % 90.0 == 0.0;
        int n15 = bufferedImage.getWidth();
        int n16 = bufferedImage.getHeight();
        double d16 = Math.abs(Math.sin(d15));
        double d17 = Math.abs(Math.cos(d15));
        int n17 = (int)Math.floor((double)n15 * d17 + (double)n16 * d16);
        int n18 = (int)Math.floor((double)n16 * d17 + (double)n15 * d16);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)(n17 - n15) / 2.0, (double)(n18 - n16) / 2.0);
        affineTransform.rotate(d15, (double)n15 / 2.0, (double)n16 / 2.0);
        BufferedImage bufferedImage2 = ImageUtil.createTransparent(n17, n18);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.transform(affineTransform);
            if (!bl4) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight())));
                graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            } else {
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            }
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static BufferedImage createScaled(Image image, int n15, int n16, int n17) {
        Object object;
        ColorModel colorModel;
        int n18 = -1;
        if (image instanceof RenderedImage) {
            colorModel = ((RenderedImage)((Object)image)).getColorModel();
            if (image instanceof BufferedImage) {
                n18 = ((BufferedImage)image).getType();
            }
        } else {
            object = new BufferedImageFactory(image);
            colorModel = ((BufferedImageFactory)object).getColorModel();
        }
        if (n18 != ((BufferedImage)(object = ImageUtil.createResampled(image, n15, n16, n17))).getType() && n18 != -1 || !ImageUtil.equals(((BufferedImage)object).getColorModel(), colorModel)) {
            WritableRaster writableRaster = image instanceof BufferedImage ? ImageUtil.createCompatibleWritableRaster((BufferedImage)image, colorModel, n15, n16) : colorModel.createCompatibleWritableRaster(n15, n16);
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            if (colorModel instanceof IndexColorModel && n17 == 4) {
                new DiffusionDither((IndexColorModel)colorModel).filter((BufferedImage)object, bufferedImage);
            } else {
                ImageUtil.drawOnto(bufferedImage, (Image)object);
            }
            object = bufferedImage;
        }
        return object;
    }

    private static boolean equals(ColorModel colorModel, ColorModel colorModel2) {
        if (colorModel == colorModel2) {
            return true;
        }
        if (!colorModel.equals(colorModel2)) {
            return false;
        }
        if (colorModel instanceof IndexColorModel) {
            int n15;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            IndexColorModel indexColorModel2 = (IndexColorModel)colorModel2;
            int n16 = indexColorModel.getMapSize();
            if (n16 != (n15 = indexColorModel2.getMapSize())) {
                return false;
            }
            for (int i15 = 0; i15 < n16; ++i15) {
                if (indexColorModel.getRGB(i15) == indexColorModel2.getRGB(i15)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static BufferedImage createResampled(Image image, int n15, int n16, int n17) {
        BufferedImage bufferedImage = image instanceof BufferedImage ? (BufferedImage)image : ImageUtil.toBuffered(image, 6);
        return ImageUtil.createResampled(bufferedImage, n15, n16, n17);
    }

    public static BufferedImage createResampled(RenderedImage renderedImage, int n15, int n16, int n17) {
        BufferedImage bufferedImage = renderedImage instanceof BufferedImage ? (BufferedImage)renderedImage : ImageUtil.toBuffered(renderedImage, renderedImage.getColorModel().hasAlpha() ? 6 : 5);
        return ImageUtil.createResampled(bufferedImage, n15, n16, n17);
    }

    public static BufferedImage createResampled(BufferedImage bufferedImage, int n15, int n16, int n17) {
        return new ResampleOp(n15, n16, ImageUtil.convertAWTHints(n17)).filter(bufferedImage, null);
    }

    private static int convertAWTHints(int n15) {
        switch (n15) {
            case 2: 
            case 8: {
                return 1;
            }
            case 16: {
                return 2;
            }
            case 4: {
                return 13;
            }
        }
        return 9;
    }

    public static IndexColorModel getIndexColorModel(Image image, int n15, int n16) {
        return IndexImage.getIndexColorModel(image, n15, n16);
    }

    public static BufferedImage createIndexed(Image image) {
        return IndexImage.getIndexedImage(ImageUtil.toBuffered(image), 256, Color.black, 0);
    }

    public static BufferedImage createIndexed(Image image, int n15, Color color, int n16) {
        return IndexImage.getIndexedImage(ImageUtil.toBuffered(image), n15, color, n16);
    }

    public static BufferedImage createIndexed(Image image, IndexColorModel indexColorModel, Color color, int n15) {
        return IndexImage.getIndexedImage(ImageUtil.toBuffered(image), indexColorModel, color, n15);
    }

    public static BufferedImage createIndexed(Image image, Image image2, Color color, int n15) {
        return IndexImage.getIndexedImage(ImageUtil.toBuffered(image), IndexImage.getIndexColorModel(image2, 255, n15), color, n15);
    }

    public static BufferedImage sharpen(BufferedImage bufferedImage) {
        return ImageUtil.convolve(bufferedImage, SHARPEN_KERNEL, 2);
    }

    public static BufferedImage sharpen(BufferedImage bufferedImage, float f15) {
        if (f15 == 0.0f) {
            return bufferedImage;
        }
        float[] fArray = new float[]{0.0f, -f15, 0.0f, -f15, 4.0f * f15 + 1.0f, -f15, 0.0f, -f15, 0.0f};
        return ImageUtil.convolve(bufferedImage, new Kernel(3, 3, fArray), 2);
    }

    public static BufferedImage blur(BufferedImage bufferedImage) {
        return ImageUtil.blur(bufferedImage, 1.5f);
    }

    public static BufferedImage blur(BufferedImage bufferedImage, float f15) {
        if (f15 <= 1.0f) {
            return bufferedImage;
        }
        Kernel kernel = ImageUtil.makeKernel(f15);
        Kernel kernel2 = new Kernel(kernel.getHeight(), kernel.getWidth(), kernel.getKernelData(null));
        BufferedImage bufferedImage2 = ImageUtil.addBorder(bufferedImage, kernel.getWidth() / 2, kernel2.getHeight() / 2, 2);
        bufferedImage2 = ImageUtil.convolve(bufferedImage2, kernel, 1);
        bufferedImage2 = ImageUtil.convolve(bufferedImage2, kernel2, 1);
        return bufferedImage2.getSubimage(kernel.getWidth() / 2, kernel2.getHeight() / 2, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    private static Kernel makeKernel(float f15) {
        int n15;
        int n16 = (int)Math.ceil(f15);
        int n17 = n16 * 2 + 1;
        float[] fArray = new float[n17];
        float f16 = f15 / 3.0f;
        float f17 = 2.0f * f16 * f16;
        float f18 = (float)(Math.PI * 2 * (double)f16);
        float f19 = (float)Math.sqrt(f18);
        float f25 = f15 * f15;
        float f26 = 0.0f;
        int n18 = 0;
        for (n15 = -n16; n15 <= n16; ++n15) {
            float f27 = n15 * n15;
            fArray[n18] = f27 > f25 ? 0.0f : (float)Math.exp(-f27 / f17) / f19;
            f26 += fArray[n18];
            ++n18;
        }
        n15 = 0;
        while (n15 < n17) {
            int n19 = n15++;
            fArray[n19] = fArray[n19] / f26;
        }
        return new Kernel(n17, 1, fArray);
    }

    public static BufferedImage convolve(BufferedImage bufferedImage, Kernel kernel, int n15) {
        BufferedImage bufferedImage2;
        switch (n15) {
            case 2: 
            case 3: {
                bufferedImage2 = ImageUtil.addBorder(bufferedImage, kernel.getWidth() / 2, kernel.getHeight() / 2, n15);
                break;
            }
            default: {
                bufferedImage2 = bufferedImage;
            }
        }
        ConvolveOp convolveOp = new ConvolveOp(kernel, n15, null);
        BufferedImage bufferedImage3 = null;
        if (bufferedImage2.getType() == 5) {
            bufferedImage3 = ImageUtil.createBuffered(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType(), bufferedImage.getColorModel().getTransparency());
        }
        BufferedImage bufferedImage4 = convolveOp.filter(bufferedImage2, bufferedImage3);
        if (bufferedImage != bufferedImage2) {
            bufferedImage4 = bufferedImage4.getSubimage(kernel.getWidth() / 2, kernel.getHeight() / 2, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        return bufferedImage4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BufferedImage addBorder(BufferedImage bufferedImage, int n15, int n16, int n17) {
        int n18 = bufferedImage.getWidth();
        int n19 = bufferedImage.getHeight();
        ColorModel colorModel = bufferedImage.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n18 + 2 * n15, n19 + 2 * n16);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            graphics2D.drawImage((Image)bufferedImage, n15, n16, null);
            switch (n17) {
                case 2: {
                    graphics2D.drawImage(bufferedImage, n15, 0, n15 + n18, n16, 0, 0, n18, 1, null);
                    graphics2D.drawImage(bufferedImage, -n18 + n15, n16, n15, n19 + n16, 0, 0, 1, n19, null);
                    graphics2D.drawImage(bufferedImage, n18 + n15, n16, 2 * n15 + n18, n19 + n16, n18 - 1, 0, n18, n19, null);
                    graphics2D.drawImage(bufferedImage, n15, n16 + n19, n15 + n18, 2 * n16 + n19, 0, n19 - 1, n18, n19, null);
                    return bufferedImage2;
                }
                case 3: {
                    graphics2D.drawImage((Image)bufferedImage, -n18 + n15, -n19 + n16, null);
                    graphics2D.drawImage((Image)bufferedImage, n15, -n19 + n16, null);
                    graphics2D.drawImage((Image)bufferedImage, n18 + n15, -n19 + n16, null);
                    graphics2D.drawImage((Image)bufferedImage, -n18 + n15, n16, null);
                    graphics2D.drawImage((Image)bufferedImage, n18 + n15, n16, null);
                    graphics2D.drawImage((Image)bufferedImage, -n18 + n15, n19 + n16, null);
                    graphics2D.drawImage((Image)bufferedImage, n15, n19 + n16, null);
                    graphics2D.drawImage((Image)bufferedImage, n18 + n15, n19 + n16, null);
                    return bufferedImage2;
                }
                default: {
                    throw new IllegalArgumentException("Illegal edge operation " + n17);
                }
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    public static Image contrast(Image image) {
        return ImageUtil.contrast(image, 0.3f);
    }

    public static Image contrast(Image image, float f15) {
        if (f15 == 0.0f) {
            return image;
        }
        BrightnessContrastFilter brightnessContrastFilter = new BrightnessContrastFilter(0.0f, f15);
        return ImageUtil.filter(image, brightnessContrastFilter);
    }

    public static Image brightness(Image image, float f15) {
        if (f15 == 0.0f) {
            return image;
        }
        BrightnessContrastFilter brightnessContrastFilter = new BrightnessContrastFilter(f15, 0.0f);
        return ImageUtil.filter(image, brightnessContrastFilter);
    }

    public static Image grayscale(Image image) {
        GrayFilter grayFilter = new GrayFilter();
        return ImageUtil.filter(image, grayFilter);
    }

    public static Image filter(Image image, ImageFilter imageFilter) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static BufferedImage accelerate(Image image) {
        return ImageUtil.accelerate(image, null, DEFAULT_CONFIGURATION);
    }

    public static BufferedImage accelerate(Image image, GraphicsConfiguration graphicsConfiguration) {
        return ImageUtil.accelerate(image, null, graphicsConfiguration);
    }

    static BufferedImage accelerate(Image image, Color color, GraphicsConfiguration graphicsConfiguration) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage && (bufferedImage = (BufferedImage)image).getType() != 0 && ImageUtil.equals(bufferedImage.getColorModel(), graphicsConfiguration.getColorModel(bufferedImage.getTransparency()))) {
            return bufferedImage;
        }
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        int n15 = ImageUtil.getWidth(image);
        int n16 = ImageUtil.getHeight(image);
        BufferedImage bufferedImage2 = ImageUtil.createClear(n15, n16, -1, ImageUtil.getTransparency(image), color, graphicsConfiguration);
        ImageUtil.drawOnto(bufferedImage2, image);
        return bufferedImage2;
    }

    private static int getTransparency(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getTransparency();
        }
        return 1;
    }

    public static BufferedImage createTransparent(int n15, int n16) {
        return ImageUtil.createTransparent(n15, n16, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createTransparent(int n15, int n16, int n17) {
        BufferedImage bufferedImage = ImageUtil.createBuffered(n15, n16, n17, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, n15, n16);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public static BufferedImage createClear(int n15, int n16, Color color) {
        return ImageUtil.createClear(n15, n16, -1, color);
    }

    public static BufferedImage createClear(int n15, int n16, int n17, Color color) {
        return ImageUtil.createClear(n15, n16, n17, 1, color, DEFAULT_CONFIGURATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BufferedImage createClear(int n15, int n16, int n17, int n18, Color color, GraphicsConfiguration graphicsConfiguration) {
        int n19 = color != null ? color.getTransparency() : n18;
        BufferedImage bufferedImage = ImageUtil.createBuffered(n15, n16, n17, n19, graphicsConfiguration);
        if (color != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, n15, n16);
            }
            finally {
                graphics2D.dispose();
            }
        }
        return bufferedImage;
    }

    private static BufferedImage createBuffered(int n15, int n16, int n17, int n18) {
        return ImageUtil.createBuffered(n15, n16, n17, n18, DEFAULT_CONFIGURATION);
    }

    static BufferedImage createBuffered(int n15, int n16, int n17, int n18, GraphicsConfiguration graphicsConfiguration) {
        GraphicsEnvironment graphicsEnvironment;
        if (VM_SUPPORTS_ACCELERATION && n17 == -1 && ImageUtil.supportsAcceleration(graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment())) {
            return ImageUtil.getConfiguration(graphicsConfiguration).createCompatibleImage(n15, n16, n18);
        }
        return new BufferedImage(n15, n16, ImageUtil.getImageType(n17, n18));
    }

    private static GraphicsConfiguration getConfiguration(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration != null ? graphicsConfiguration : DEFAULT_CONFIGURATION;
    }

    private static int getImageType(int n15, int n16) {
        if (n15 != -1) {
            return n15;
        }
        switch (n16) {
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unknown transparency type: " + n16);
    }

    private static boolean supportsAcceleration(GraphicsEnvironment graphicsEnvironment) {
        try {
            return !graphicsEnvironment.isHeadlessInstance();
        }
        catch (LinkageError linkageError) {
            VM_SUPPORTS_ACCELERATION = false;
            return false;
        }
    }

    public static int getWidth(Image image) {
        int n15 = image.getWidth(NULL_COMPONENT);
        if (n15 < 0) {
            if (!ImageUtil.waitForImage(image)) {
                return -1;
            }
            n15 = image.getWidth(NULL_COMPONENT);
        }
        return n15;
    }

    public static int getHeight(Image image) {
        int n15 = image.getHeight(NULL_COMPONENT);
        if (n15 < 0) {
            if (!ImageUtil.waitForImage(image)) {
                return -1;
            }
            n15 = image.getHeight(NULL_COMPONENT);
        }
        return n15;
    }

    public static boolean waitForImage(Image image) {
        return ImageUtil.waitForImages(new Image[]{image}, -1L);
    }

    public static boolean waitForImage(Image image, long l15) {
        return ImageUtil.waitForImages(new Image[]{image}, l15);
    }

    public static boolean waitForImages(Image[] imageArray) {
        return ImageUtil.waitForImages(imageArray, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImages(Image[] imageArray, long l15) {
        boolean bl4 = true;
        int n15 = imageArray.length == 1 ? System.identityHashCode(imageArray[0]) : System.identityHashCode(imageArray);
        for (Image image : imageArray) {
            sTracker.addImage(image, n15);
            if (!sTracker.checkID(n15, false)) continue;
            sTracker.removeImage(image, n15);
        }
        try {
            if (l15 < 0L) {
                sTracker.waitForID(n15);
            } else {
                bl4 = sTracker.waitForID(n15, l15);
            }
        }
        catch (InterruptedException interruptedException) {
            bl4 = false;
            return bl4;
        }
        finally {
            for (Image image : imageArray) {
                sTracker.removeImage(image, n15);
            }
        }
        return bl4 && !sTracker.isErrorID(n15);
    }

    public static boolean hasTransparentPixels(RenderedImage renderedImage, boolean bl4) {
        if (renderedImage == null) {
            return false;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        if (!colorModel.hasAlpha()) {
            return false;
        }
        if (colorModel.getTransparency() != 2 && colorModel.getTransparency() != 3) {
            return false;
        }
        Object object = null;
        for (int i15 = renderedImage.getMinTileY(); i15 < renderedImage.getNumYTiles(); ++i15) {
            for (int i16 = renderedImage.getMinTileX(); i16 < renderedImage.getNumXTiles(); ++i16) {
                Raster raster = renderedImage.getTile(i16, i15);
                int n15 = bl4 ? Math.max(raster.getWidth() / 10, 1) : 1;
                int n16 = bl4 ? Math.max(raster.getHeight() / 10, 1) : 1;
                for (int i17 = 0; i17 < raster.getHeight(); i17 += n16) {
                    for (int i18 = 0; i18 < raster.getWidth(); i18 += n15) {
                        if (colorModel.getAlpha(object = raster.getDataElements(i18, i17, object)) == 255) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Color createTranslucent(Color color, int n15) {
        return new Color((n15 & 0xFF) << 24 | color.getRGB() & 0xFFFFFF, true);
    }

    static int blend(int n15, int n16) {
        return (((n15 ^ n16) & 0xFEFEFEFE) >> 1) + (n15 & n16);
    }

    public static Color blend(Color color, Color color2) {
        return new Color(ImageUtil.blend(color.getRGB(), color2.getRGB()), true);
    }

    public static Color blend(Color color, Color color2, float f15) {
        float f16 = 1.0f - f15;
        return new Color(ImageUtil.clamp((float)color.getRed() * f16 + (float)color2.getRed() * f15), ImageUtil.clamp((float)color.getGreen() * f16 + (float)color2.getGreen() * f15), ImageUtil.clamp((float)color.getBlue() * f16 + (float)color2.getBlue() * f15), ImageUtil.clamp((float)color.getAlpha() * f16 + (float)color2.getAlpha() * f15));
    }

    private static int clamp(float f15) {
        return (int)f15;
    }
}

