/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.UnicodeEscaper;
import org.jspecify.annotations.Nullable;

@GwtCompatible
public final class PercentEscaper
extends UnicodeEscaper {
    private static final char[] plusSign = new char[]{'+'};
    private static final char[] upperHexDigits = "0123456789ABCDEF".toCharArray();
    private final boolean plusForSpace;
    private final boolean[] safeOctets;

    public PercentEscaper(String safeChars, boolean plusForSpace) {
        Preconditions.checkNotNull(safeChars);
        if (safeChars.matches(".*[0-9A-Za-z].*")) {
            throw new IllegalArgumentException("Alphanumeric characters are always 'safe' and should not be explicitly specified");
        }
        safeChars = safeChars + "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        if (plusForSpace && safeChars.contains(" ")) {
            throw new IllegalArgumentException("plusForSpace cannot be specified when space is a 'safe' character");
        }
        this.plusForSpace = plusForSpace;
        this.safeOctets = PercentEscaper.createSafeOctets(safeChars);
    }

    private static boolean[] createSafeOctets(String safeChars) {
        char[] safeCharArray;
        int maxChar = -1;
        for (char c15 : safeCharArray = safeChars.toCharArray()) {
            maxChar = Math.max(c15, maxChar);
        }
        boolean[] octets = new boolean[maxChar + 1];
        for (char c16 : safeCharArray) {
            octets[c16] = true;
        }
        return octets;
    }

    @Override
    protected int nextEscapeIndex(CharSequence csq, int index, int end) {
        char c15;
        Preconditions.checkNotNull(csq);
        while (index < end && (c15 = csq.charAt(index)) < this.safeOctets.length && this.safeOctets[c15]) {
            ++index;
        }
        return index;
    }

    @Override
    public String escape(String s15) {
        Preconditions.checkNotNull(s15);
        int slen = s15.length();
        for (int index = 0; index < slen; ++index) {
            char c15 = s15.charAt(index);
            if (c15 < this.safeOctets.length && this.safeOctets[c15]) continue;
            return this.escapeSlow(s15, index);
        }
        return s15;
    }

    @Override
    protected char @Nullable [] escape(int cp4) {
        if (cp4 < this.safeOctets.length && this.safeOctets[cp4]) {
            return null;
        }
        if (cp4 == 32 && this.plusForSpace) {
            return plusSign;
        }
        if (cp4 <= 127) {
            char[] dest = new char[3];
            dest[0] = 37;
            dest[2] = upperHexDigits[cp4 & 0xF];
            dest[1] = upperHexDigits[cp4 >>> 4];
            return dest;
        }
        if (cp4 <= 2047) {
            char[] dest = new char[6];
            dest[0] = 37;
            dest[3] = 37;
            dest[5] = upperHexDigits[cp4 & 0xF];
            dest[4] = upperHexDigits[8 | (cp4 >>>= 4) & 3];
            dest[2] = upperHexDigits[(cp4 >>>= 2) & 0xF];
            dest[1] = upperHexDigits[0xC | (cp4 >>>= 4)];
            return dest;
        }
        if (cp4 <= 65535) {
            char[] dest = new char[9];
            dest[0] = 37;
            dest[1] = 69;
            dest[3] = 37;
            dest[6] = 37;
            dest[8] = upperHexDigits[cp4 & 0xF];
            dest[7] = upperHexDigits[8 | (cp4 >>>= 4) & 3];
            dest[5] = upperHexDigits[(cp4 >>>= 2) & 0xF];
            dest[4] = upperHexDigits[8 | (cp4 >>>= 4) & 3];
            dest[2] = upperHexDigits[cp4 >>>= 2];
            return dest;
        }
        if (cp4 <= 0x10FFFF) {
            char[] dest = new char[12];
            dest[0] = 37;
            dest[1] = 70;
            dest[3] = 37;
            dest[6] = 37;
            dest[9] = 37;
            dest[11] = upperHexDigits[cp4 & 0xF];
            dest[10] = upperHexDigits[8 | (cp4 >>>= 4) & 3];
            dest[8] = upperHexDigits[(cp4 >>>= 2) & 0xF];
            dest[7] = upperHexDigits[8 | (cp4 >>>= 4) & 3];
            dest[5] = upperHexDigits[(cp4 >>>= 2) & 0xF];
            dest[4] = upperHexDigits[8 | (cp4 >>>= 4) & 3];
            dest[2] = upperHexDigits[(cp4 >>>= 2) & 7];
            return dest;
        }
        throw new IllegalArgumentException("Invalid unicode character value " + cp4);
    }
}

