/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jspecify.annotations.Nullable;

abstract class AbstractByteHasher
extends AbstractHasher {
    private @Nullable ByteBuffer scratch;

    AbstractByteHasher() {
    }

    protected abstract void update(byte var1);

    protected void update(byte[] b15) {
        this.update(b15, 0, b15.length);
    }

    protected void update(byte[] b15, int off, int len) {
        for (int i15 = off; i15 < off + len; ++i15) {
            this.update(b15[i15]);
        }
    }

    protected void update(ByteBuffer b15) {
        if (b15.hasArray()) {
            this.update(b15.array(), b15.arrayOffset() + b15.position(), b15.remaining());
            Java8Compatibility.position(b15, b15.limit());
        } else {
            for (int remaining = b15.remaining(); remaining > 0; --remaining) {
                this.update(b15.get());
            }
        }
    }

    @CanIgnoreReturnValue
    private Hasher update(ByteBuffer scratch, int bytes) {
        try {
            this.update(scratch.array(), 0, bytes);
        }
        finally {
            Java8Compatibility.clear(scratch);
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putByte(byte b15) {
        this.update(b15);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(byte[] bytes) {
        Preconditions.checkNotNull(bytes);
        this.update(bytes);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(byte[] bytes, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes.length);
        this.update(bytes, off, len);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(ByteBuffer bytes) {
        this.update(bytes);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putShort(short s15) {
        ByteBuffer scratch = this.scratch();
        scratch.putShort(s15);
        return this.update(scratch, 2);
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putInt(int i15) {
        ByteBuffer scratch = this.scratch();
        scratch.putInt(i15);
        return this.update(scratch, 4);
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putLong(long l15) {
        ByteBuffer scratch = this.scratch();
        scratch.putLong(l15);
        return this.update(scratch, 8);
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putChar(char c15) {
        ByteBuffer scratch = this.scratch();
        scratch.putChar(c15);
        return this.update(scratch, 2);
    }

    private ByteBuffer scratch() {
        if (this.scratch == null) {
            this.scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        }
        return this.scratch;
    }
}

