/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;

@GwtCompatible
public final class Ascii {
    public static final byte NUL = 0;
    public static final byte SOH = 1;
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte EOT = 4;
    public static final byte ENQ = 5;
    public static final byte ACK = 6;
    public static final byte BEL = 7;
    public static final byte BS = 8;
    public static final byte HT = 9;
    public static final byte LF = 10;
    public static final byte NL = 10;
    public static final byte VT = 11;
    public static final byte FF = 12;
    public static final byte CR = 13;
    public static final byte SO = 14;
    public static final byte SI = 15;
    public static final byte DLE = 16;
    public static final byte DC1 = 17;
    public static final byte XON = 17;
    public static final byte DC2 = 18;
    public static final byte DC3 = 19;
    public static final byte XOFF = 19;
    public static final byte DC4 = 20;
    public static final byte NAK = 21;
    public static final byte SYN = 22;
    public static final byte ETB = 23;
    public static final byte CAN = 24;
    public static final byte EM = 25;
    public static final byte SUB = 26;
    public static final byte ESC = 27;
    public static final byte FS = 28;
    public static final byte GS = 29;
    public static final byte RS = 30;
    public static final byte US = 31;
    public static final byte SP = 32;
    public static final byte SPACE = 32;
    public static final byte DEL = 127;
    public static final char MIN = '\u0000';
    public static final char MAX = '\u007f';
    private static final char CASE_MASK = ' ';

    private Ascii() {
    }

    public static String toLowerCase(String string) {
        int length = string.length();
        for (int i15 = 0; i15 < length; ++i15) {
            if (!Ascii.isUpperCase(string.charAt(i15))) continue;
            char[] chars = string.toCharArray();
            while (i15 < length) {
                char c15 = chars[i15];
                if (Ascii.isUpperCase(c15)) {
                    chars[i15] = (char)(c15 ^ 0x20);
                }
                ++i15;
            }
            return String.valueOf(chars);
        }
        return string;
    }

    public static String toLowerCase(CharSequence chars) {
        if (chars instanceof String) {
            return Ascii.toLowerCase((String)chars);
        }
        char[] newChars = new char[chars.length()];
        for (int i15 = 0; i15 < newChars.length; ++i15) {
            newChars[i15] = Ascii.toLowerCase(chars.charAt(i15));
        }
        return String.valueOf(newChars);
    }

    public static char toLowerCase(char c15) {
        return Ascii.isUpperCase(c15) ? (char)(c15 ^ 0x20) : c15;
    }

    public static String toUpperCase(String string) {
        int length = string.length();
        for (int i15 = 0; i15 < length; ++i15) {
            if (!Ascii.isLowerCase(string.charAt(i15))) continue;
            char[] chars = string.toCharArray();
            while (i15 < length) {
                char c15 = chars[i15];
                if (Ascii.isLowerCase(c15)) {
                    chars[i15] = (char)(c15 ^ 0x20);
                }
                ++i15;
            }
            return String.valueOf(chars);
        }
        return string;
    }

    public static String toUpperCase(CharSequence chars) {
        if (chars instanceof String) {
            return Ascii.toUpperCase((String)chars);
        }
        char[] newChars = new char[chars.length()];
        for (int i15 = 0; i15 < newChars.length; ++i15) {
            newChars[i15] = Ascii.toUpperCase(chars.charAt(i15));
        }
        return String.valueOf(newChars);
    }

    public static char toUpperCase(char c15) {
        return Ascii.isLowerCase(c15) ? (char)(c15 ^ 0x20) : c15;
    }

    public static boolean isLowerCase(char c15) {
        return c15 >= 'a' && c15 <= 'z';
    }

    public static boolean isUpperCase(char c15) {
        return c15 >= 'A' && c15 <= 'Z';
    }

    public static String truncate(CharSequence seq, int maxLength, String truncationIndicator) {
        Preconditions.checkNotNull(seq);
        int truncationLength = maxLength - truncationIndicator.length();
        Preconditions.checkArgument(truncationLength >= 0, "maxLength (%s) must be >= length of the truncation indicator (%s)", maxLength, truncationIndicator.length());
        if (seq.length() <= maxLength) {
            String string = seq.toString();
            if (string.length() <= maxLength) {
                return string;
            }
            seq = string;
        }
        return new StringBuilder(maxLength).append(seq, 0, truncationLength).append(truncationIndicator).toString();
    }

    public static boolean equalsIgnoreCase(CharSequence s15, CharSequence s25) {
        int length = s15.length();
        if (s15 == s25) {
            return true;
        }
        if (length != s25.length()) {
            return false;
        }
        for (int i15 = 0; i15 < length; ++i15) {
            int alphaIndex;
            char c25;
            char c15 = s15.charAt(i15);
            if (c15 == (c25 = s25.charAt(i15)) || (alphaIndex = Ascii.getAlphaIndex(c15)) < 26 && alphaIndex == Ascii.getAlphaIndex(c25)) continue;
            return false;
        }
        return true;
    }

    private static int getAlphaIndex(char c15) {
        return (char)((c15 | 0x20) - 97);
    }
}

