/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.util;

import com.github.weisj.jsvg.attributes.value.TransformValue;
import com.github.weisj.jsvg.geometry.size.FloatInsets;
import com.github.weisj.jsvg.geometry.util.PathLengthCalculator;
import com.github.weisj.jsvg.geometry.util.TransformUtil;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GeometryUtil {
    private static final float EPS = 1.0E-4f;

    private GeometryUtil() {
    }

    public static boolean approximatelyEqual(double a15, double b15) {
        return Math.abs(a15 - b15) < (double)1.0E-4f;
    }

    public static boolean approximatelyZero(double a15) {
        return GeometryUtil.approximatelyEqual(a15, 0.0);
    }

    public static boolean notablyGreater(double a15, double b15) {
        return a15 - b15 > (double)1.0E-4f;
    }

    public static boolean approximatelyNegative(double a15) {
        return a15 < (double)1.0E-4f;
    }

    public static boolean approximatelyPositive(double a15) {
        return a15 > (double)-1.0E-4f;
    }

    public static double scaleXOfTransform(@Nullable AffineTransform at4) {
        if (at4 == null) {
            return 1.0;
        }
        double sx4 = at4.getScaleX();
        double shy = at4.getShearY();
        return Math.sqrt(sx4 * sx4 + shy * shy);
    }

    public static double scaleYOfTransform(@Nullable AffineTransform at4) {
        if (at4 == null) {
            return 1.0;
        }
        double sy4 = at4.getScaleY();
        double shx = at4.getShearX();
        return Math.sqrt(sy4 * sy4 + shx * shx);
    }

    @NotNull
    public static Point2D.Float midPoint(@NotNull Point2D.Float x15, @NotNull Point2D.Float y15) {
        return new Point2D.Float((x15.x + y15.x) / 2.0f, (x15.y + y15.y) / 2.0f);
    }

    @NotNull
    public static Point2D.Float lerp(float t15, @NotNull Point2D.Float a15, @NotNull Point2D.Float b15) {
        return new Point2D.Float(GeometryUtil.lerp(t15, b15.x, a15.x), GeometryUtil.lerp(t15, b15.y, a15.y));
    }

    public static float lerp(float t15, float a15, float b15) {
        return (1.0f - t15) * a15 + t15 * b15;
    }

    public static double lerp(float t15, double a15, double b15) {
        return (double)(1.0f - t15) * a15 + (double)t15 * b15;
    }

    public static double distanceSquared(@NotNull Point2D.Float p15, @NotNull Point2D.Float p25, float scaleX, float scaleY) {
        return GeometryUtil.distanceSquared(scaleX * p15.x, scaleY * p15.y, (double)(scaleX * p25.x), (double)(scaleY * p25.y));
    }

    public static double distanceSquared(@NotNull Point2D.Float p15, @NotNull Point2D.Float p25) {
        return GeometryUtil.distanceSquared(p15.x, p15.y, (double)p25.x, (double)p25.y);
    }

    public static double distanceSquared(double x15, double y15, double x25, double y25) {
        double dx4 = x25 - x15;
        double dy4 = y25 - y15;
        return dx4 * dx4 + dy4 * dy4;
    }

    public static double pathLength(@NotNull Shape shape) {
        PathLengthCalculator pathLengthCalculator = new PathLengthCalculator();
        PathIterator pathIterator = shape.getPathIterator(null);
        double length = 0.0;
        double[] args = new double[6];
        while (!pathIterator.isDone()) {
            length += pathLengthCalculator.segmentLength(pathIterator.currentSegment(args), args);
            pathIterator.next();
        }
        return length;
    }

    public static boolean isSingleClosedPath(@NotNull Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        int numPaths = 0;
        int numClosedPaths = 0;
        float[] segment = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(segment)) {
                case 0: {
                    ++numPaths;
                    break;
                }
                case 4: {
                    ++numClosedPaths;
                    break;
                }
            }
            pathIterator.next();
        }
        return numPaths == 1 && numClosedPaths == 1;
    }

    public static double lineLength(double x15, double y15, double x25, double y25) {
        return Math.sqrt(GeometryUtil.distanceSquared(x15, y15, x25, y25));
    }

    @NotNull
    public static Rectangle2D containingBoundsAfterTransform(@NotNull AffineTransform transform, @NotNull Rectangle2D rect) {
        if (transform.isIdentity()) {
            return rect.getBounds2D();
        }
        Point2D.Double p15 = new Point2D.Double(rect.getX(), rect.getY());
        Point2D.Double p25 = new Point2D.Double(rect.getX() + rect.getWidth(), rect.getY());
        Point2D.Double p35 = new Point2D.Double(rect.getX(), rect.getY() + rect.getHeight());
        Point2D.Double p45 = new Point2D.Double(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight());
        Rectangle2D r15 = rect.getBounds2D();
        r15.setFrameFromDiagonal(transform.transform(p15, p15), transform.transform(p25, p25));
        Rectangle2D r25 = rect.getBounds2D();
        r25.setFrameFromDiagonal(transform.transform(p35, p35), transform.transform(p45, p45));
        Rectangle2D.union(r15, r25, r15);
        return r15;
    }

    public static float left(@NotNull Rectangle2D rect) {
        return (float)rect.getX();
    }

    public static float top(@NotNull Rectangle2D rect) {
        return (float)rect.getY();
    }

    public static float right(@NotNull Rectangle2D rect) {
        return (float)(rect.getX() + rect.getWidth());
    }

    public static float bottom(@NotNull Rectangle2D rect) {
        return (float)(rect.getY() + rect.getHeight());
    }

    @NotNull
    public static Rectangle2D grow(@NotNull Rectangle2D bounds, FloatInsets grow) {
        return new Rectangle2D.Double(bounds.getX() - (double)grow.left(), bounds.getY() - (double)grow.top(), bounds.getWidth() + (double)grow.left() + (double)grow.right(), bounds.getHeight() + (double)grow.top() + (double)grow.bottom());
    }

    @NotNull
    public static Rectangle2D grow(@NotNull Rectangle2D bounds, double increase) {
        return new Rectangle2D.Double(bounds.getX() - increase, bounds.getY() - increase, bounds.getWidth() + 2.0 * increase, bounds.getHeight() + 2.0 * increase);
    }

    @NotNull
    public static FloatInsets max(@NotNull FloatInsets in12, @NotNull FloatInsets in22) {
        return new FloatInsets(Math.max(in12.top(), in22.top()), Math.max(in12.left(), in22.left()), Math.max(in12.bottom(), in22.bottom()), Math.max(in12.right(), in22.right()));
    }

    @NotNull
    public static FloatInsets min(@NotNull FloatInsets in12, @NotNull FloatInsets in22) {
        return new FloatInsets(Math.min(in12.top(), in22.top()), Math.min(in12.left(), in22.left()), Math.min(in12.bottom(), in22.bottom()), Math.min(in12.right(), in22.right()));
    }

    @NotNull
    public static FloatInsets overhangInsets(@NotNull Rectangle2D reference, @NotNull Rectangle2D bounds) {
        return new FloatInsets(Math.max(0.0f, GeometryUtil.top(reference) - GeometryUtil.top(bounds)), Math.max(0.0f, GeometryUtil.left(reference) - GeometryUtil.left(bounds)), Math.max(0.0f, GeometryUtil.bottom(bounds) - GeometryUtil.bottom(reference)), Math.max(0.0f, GeometryUtil.right(bounds) - GeometryUtil.right(reference)));
    }

    @NotNull
    public static String compactRepresentation(@NotNull Rectangle2D rect) {
        return "[" + rect.getX() + ", " + rect.getY() + ", " + rect.getWidth() + "x" + rect.getHeight() + "]";
    }

    @NotNull
    public static Rectangle2D toIntegerBounds(@NotNull Rectangle2D in4, @NotNull Rectangle2D out) {
        double minY = Math.floor(in4.getMinY());
        double minX = Math.floor(in4.getMinX());
        double maxX = Math.ceil(in4.getMaxX());
        double maxY = Math.ceil(in4.getMaxY());
        out.setFrame(minX, minY, maxX - minX, maxY - minY);
        return out;
    }

    @NotNull
    public static Rectangle2D adjustForAliasing(@NotNull Rectangle2D r15) {
        return GeometryUtil.toIntegerBounds(r15, r15);
    }

    @NotNull
    public static AffineTransform createInverse(@NotNull AffineTransform at4) {
        try {
            return at4.createInverse();
        }
        catch (NoninvertibleTransformException e15) {
            throw new IllegalStateException(e15);
        }
    }

    @Nullable
    public static AffineTransform toAwtTransform(@NotNull RenderContext context, @Nullable TransformValue transform) {
        if (transform == null) {
            return null;
        }
        return transform.get(context.measureContext());
    }

    @NotNull
    public static Rectangle2D convertBounds(@NotNull RenderContext context, @NotNull Rectangle2D r15, @NotNull Space from, @NotNull Space to4) {
        if (from == to4) {
            return r15;
        }
        Rectangle2D out = r15;
        if (from == Space.USER) {
            if (to4 == Space.ROOT) {
                out = GeometryUtil.containingBoundsAfterTransform(context.userSpaceTransform(), r15);
            } else if (to4 == Space.DEVICE) {
                out = GeometryUtil.containingBoundsAfterTransform(context.userSpaceTransform(), r15);
                out = GeometryUtil.containingBoundsAfterTransform(context.rootTransform(), out);
            }
        }
        if (from == Space.ROOT) {
            if (to4 == Space.USER) {
                out = GeometryUtil.containingBoundsAfterTransform(GeometryUtil.createInverse(context.rootTransform()), r15);
            } else if (to4 == Space.DEVICE) {
                out = GeometryUtil.containingBoundsAfterTransform(context.rootTransform(), r15);
            }
        }
        if (from == Space.DEVICE) {
            if (to4 == Space.USER) {
                out = GeometryUtil.containingBoundsAfterTransform(GeometryUtil.createInverse(context.rootTransform()), r15);
                out = GeometryUtil.containingBoundsAfterTransform(GeometryUtil.createInverse(context.userSpaceTransform()), out);
            } else if (to4 == Space.ROOT) {
                out = GeometryUtil.containingBoundsAfterTransform(GeometryUtil.createInverse(context.rootTransform()), r15);
            }
        }
        return out;
    }

    @NotNull
    public static Rectangle2D userBoundsToDeviceBounds(@NotNull RenderContext context, @NotNull Rectangle2D r15) {
        return GeometryUtil.convertBounds(context, r15, Space.USER, Space.DEVICE);
    }

    @NotNull
    public static Point2D getLocation(@NotNull Rectangle2D r15) {
        return new Point2D.Double(r15.getX(), r15.getY());
    }

    public static boolean isValidRect(@NotNull Rectangle2D r15) {
        return !Double.isNaN(r15.getX()) && !Double.isNaN(r15.getY()) && !Double.isNaN(r15.getWidth()) && !Double.isNaN(r15.getHeight());
    }

    @NotNull
    public static AffineTransform interpolate(@NotNull AffineTransform a15, @NotNull AffineTransform b15, float t15) {
        return TransformUtil.interpolate(a15, b15, t15);
    }

    public static enum Space {
        USER,
        ROOT,
        DEVICE;

    }
}

