/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry;

import com.github.weisj.jsvg.attributes.value.LengthValue;
import com.github.weisj.jsvg.geometry.SVGCircle;
import com.github.weisj.jsvg.geometry.SVGShape;
import com.github.weisj.jsvg.renderer.MeasureContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public final class SVGEllipse
implements SVGShape {
    @NotNull
    private final Ellipse2D.Float ellipse = new Ellipse2D.Float();
    @NotNull
    private final LengthValue cx;
    @NotNull
    private final LengthValue cy;
    @NotNull
    private final LengthValue rx;
    @NotNull
    private final LengthValue ry;

    public SVGEllipse(@NotNull LengthValue cx4, @NotNull LengthValue cy4, @NotNull LengthValue rx4, @NotNull LengthValue ry4) {
        this.cx = cx4;
        this.cy = cy4;
        this.rx = rx4;
        this.ry = ry4;
    }

    private void validateShape(@NotNull MeasureContext measureContext) {
        float x15 = this.cx.resolve(measureContext);
        float y15 = this.cy.resolve(measureContext);
        float rrx = this.rx.resolve(measureContext);
        float rry = this.ry.resolve(measureContext);
        this.ellipse.setFrame(x15 - rrx, y15 - rry, 2.0f * rrx, 2.0f * rry);
    }

    @Override
    @NotNull
    public Shape shape(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.ellipse;
    }

    @Override
    @NotNull
    public Rectangle2D bounds(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.ellipse.getBounds2D();
    }

    @Override
    public double pathLength(@NotNull RenderContext context) {
        float b15;
        MeasureContext measureContext = context.measureContext();
        float a15 = this.rx.resolve(measureContext);
        if (a15 == (b15 = this.ry.resolve(measureContext))) {
            return SVGCircle.circumference(a15);
        }
        return SVGEllipse.ellipseCircumference(a15, b15);
    }

    @Override
    public boolean isClosed(@NotNull RenderContext context) {
        return true;
    }

    static double ellipseCircumference(double a15, double b15) {
        double h15 = (a15 - b15) * (a15 - b15) / ((a15 + b15) * (a15 + b15));
        double h45 = h15 / 4.0;
        return 0.7853981633974483 * (a15 + b15) * (3.0 * (1.0 + h45) + 1.0 / (1.0 - h45));
    }
}

