/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatRootPaneUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.ui.FlatUIAction;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuBarUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class FlatMenuBarUI
extends BasicMenuBarUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Insets itemMargins;
    @FlatStylingSupport.Styleable
    protected Insets selectionInsets;
    @FlatStylingSupport.Styleable
    protected Insets selectionEmbeddedInsets;
    @FlatStylingSupport.Styleable
    protected int selectionArc = -1;
    @FlatStylingSupport.Styleable
    protected Color hoverBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionForeground;
    @FlatStylingSupport.Styleable
    protected Color underlineSelectionBackground;
    @FlatStylingSupport.Styleable
    protected Color underlineSelectionColor;
    @FlatStylingSupport.Styleable
    protected int underlineSelectionHeight = -1;
    private PropertyChangeListener propertyChangeListener;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent c15) {
        return new FlatMenuBarUI();
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.menuBar, "opaque", false);
        LayoutManager layout = this.menuBar.getLayout();
        if (layout == null || layout instanceof UIResource) {
            this.menuBar.setLayout(new FlatMenuBarLayout(this.menuBar));
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.oldStyleValues = null;
        this.borderShared = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = FlatStylingSupport.createPropertyChangeListener(this.menuBar, this::installStyle, null);
        this.menuBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuBar.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap map = SwingUtilities.getUIActionMap(this.menuBar);
        if (map != null && !(map.get("takeFocus") instanceof TakeFocusAction)) {
            map.put("takeFocus", new TakeFocusAction("takeFocus"));
        }
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.menuBar, "MenuBar"));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, key, value, this.menuBar, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.menuBar.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.menuBar.getBorder(), key);
    }

    @Override
    public void update(Graphics g15, JComponent c15) {
        Color background = this.getBackground(c15);
        if (background != null) {
            g15.setColor(background);
            g15.fillRect(0, 0, c15.getWidth(), c15.getHeight());
        }
        this.paint(g15, c15);
    }

    protected Color getBackground(JComponent c15) {
        Color background = c15.getBackground();
        if (c15.isOpaque()) {
            return background;
        }
        if (!(background instanceof UIResource)) {
            return null;
        }
        JRootPane rootPane = SwingUtilities.getRootPane(c15);
        if (rootPane == null || !(rootPane.getParent() instanceof Window) || rootPane.getJMenuBar() != c15) {
            return background;
        }
        if (FlatMenuBarUI.useUnifiedBackground(c15)) {
            background = FlatUIUtils.getParentBackground(c15);
        }
        if (FlatUIUtils.isFullScreen(rootPane)) {
            return background;
        }
        return FlatRootPaneUI.isMenuBarEmbedded(rootPane) ? null : background;
    }

    static boolean useUnifiedBackground(Component c15) {
        JRootPane rootPane;
        return UIManager.getBoolean("TitlePane.unifiedBackground") && (rootPane = SwingUtilities.getRootPane(c15)) != null && rootPane.getParent() instanceof Window && rootPane.getJMenuBar() == c15 && rootPane.getWindowDecorationStyle() != 0;
    }

    private static class TakeFocusAction
    extends FlatUIAction {
        TakeFocusAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e15) {
            JMenuBar menuBar = (JMenuBar)e15.getSource();
            JMenu menu = menuBar.getMenu(0);
            if (menu != null) {
                MenuElement[] menuElementArray;
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                if (SystemInfo.isWindows) {
                    MenuElement[] menuElementArray2 = new MenuElement[2];
                    menuElementArray2[0] = menuBar;
                    menuElementArray = menuElementArray2;
                    menuElementArray2[1] = menu;
                } else {
                    MenuElement[] menuElementArray3 = new MenuElement[3];
                    menuElementArray3[0] = menuBar;
                    menuElementArray3[1] = menu;
                    menuElementArray = menuElementArray3;
                    menuElementArray3[2] = menu.getPopupMenu();
                }
                menuSelectionManager.setSelectedPath(menuElementArray);
                FlatLaf.showMnemonics(menuBar);
            }
        }
    }

    protected static class FlatMenuBarLayout
    extends DefaultMenuLayout {
        public FlatMenuBarLayout(Container target) {
            super(target, 2);
        }

        @Override
        public void layoutContainer(Container target) {
            block14: {
                int offset;
                super.layoutContainer(target);
                JRootPane rootPane = SwingUtilities.getRootPane(target);
                if (rootPane == null || rootPane.getJMenuBar() != target) {
                    return;
                }
                FlatTitlePane titlePane = FlatRootPaneUI.getTitlePane(rootPane);
                if (titlePane == null || !titlePane.isMenuBarEmbedded()) {
                    return;
                }
                Component horizontalGlue = titlePane.findHorizontalGlue((JMenuBar)target);
                int minTitleWidth = UIScale.scale(titlePane.titleMinimumWidth);
                if (horizontalGlue == null || horizontalGlue.getWidth() >= minTitleWidth) break block14;
                int glueIndex = -1;
                Component[] components = target.getComponents();
                for (int i15 = components.length - 1; i15 >= 0; --i15) {
                    if (components[i15] != horizontalGlue) continue;
                    glueIndex = i15;
                    break;
                }
                if (glueIndex < 0) {
                    return;
                }
                if (target.getComponentOrientation().isLeftToRight()) {
                    Component c15;
                    int i16;
                    offset = minTitleWidth - horizontalGlue.getWidth();
                    horizontalGlue.setSize(minTitleWidth, horizontalGlue.getHeight());
                    int minGlueX = target.getWidth() - target.getInsets().right - minTitleWidth;
                    if (minGlueX < horizontalGlue.getX()) {
                        offset -= horizontalGlue.getX() - minGlueX;
                        horizontalGlue.setLocation(minGlueX, horizontalGlue.getY());
                        for (i16 = glueIndex - 1; i16 >= 0; --i16) {
                            c15 = components[i16];
                            if (c15.getX() <= minGlueX) {
                                c15.setSize(minGlueX - c15.getX(), c15.getHeight());
                                break;
                            }
                            c15.setBounds(minGlueX, c15.getY(), 0, c15.getHeight());
                        }
                    }
                    for (i16 = glueIndex + 1; i16 < components.length; ++i16) {
                        c15 = components[i16];
                        c15.setLocation(c15.getX() + offset, c15.getY());
                    }
                } else {
                    offset = minTitleWidth - horizontalGlue.getWidth();
                    horizontalGlue.setBounds(horizontalGlue.getX() - offset, horizontalGlue.getY(), minTitleWidth, horizontalGlue.getHeight());
                    int minGlueX = target.getInsets().left;
                    if (minGlueX > horizontalGlue.getX()) {
                        offset -= horizontalGlue.getX() - minGlueX;
                        horizontalGlue.setLocation(minGlueX, horizontalGlue.getY());
                        int x15 = horizontalGlue.getX() + horizontalGlue.getWidth();
                        for (int i17 = glueIndex - 1; i17 >= 0; --i17) {
                            Component c16 = components[i17];
                            if (c16.getX() + c16.getWidth() >= x15) {
                                c16.setBounds(x15, c16.getY(), c16.getWidth() - (x15 - c16.getX()), c16.getHeight());
                                break;
                            }
                            c16.setBounds(x15, c16.getY(), 0, c16.getHeight());
                        }
                    }
                    for (int i18 = glueIndex + 1; i18 < components.length; ++i18) {
                        Component c17 = components[i18];
                        c17.setLocation(c17.getX() - offset, c17.getY());
                    }
                }
            }
        }
    }
}

