/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatComboBoxUI;
import com.formdev.flatlaf.ui.FlatScrollPaneUI;
import com.formdev.flatlaf.ui.FlatSpinnerUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicBorders;

public class FlatBorder
extends BasicBorders.MarginBorder
implements FlatStylingSupport.StyleableObject {
    @FlatStylingSupport.Styleable
    protected int focusWidth = UIManager.getInt("Component.focusWidth");
    @FlatStylingSupport.Styleable
    protected float innerFocusWidth = FlatUIUtils.getUIFloat("Component.innerFocusWidth", 0.0f);
    @FlatStylingSupport.Styleable
    protected float innerOutlineWidth = FlatUIUtils.getUIFloat("Component.innerOutlineWidth", 0.0f);
    @FlatStylingSupport.Styleable
    protected float borderWidth = FlatUIUtils.getUIFloat("Component.borderWidth", 1.0f);
    @FlatStylingSupport.Styleable
    protected Color focusColor = UIManager.getColor("Component.focusColor");
    @FlatStylingSupport.Styleable
    protected Color borderColor = UIManager.getColor("Component.borderColor");
    @FlatStylingSupport.Styleable
    protected Color disabledBorderColor = UIManager.getColor("Component.disabledBorderColor");
    @FlatStylingSupport.Styleable
    protected Color focusedBorderColor = UIManager.getColor("Component.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color errorBorderColor = UIManager.getColor("Component.error.borderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color errorFocusedBorderColor = UIManager.getColor("Component.error.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color warningBorderColor = UIManager.getColor("Component.warning.borderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color warningFocusedBorderColor = UIManager.getColor("Component.warning.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color successBorderColor = UIManager.getColor("Component.success.borderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color successFocusedBorderColor = UIManager.getColor("Component.success.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color customBorderColor = UIManager.getColor("Component.custom.borderColor");
    @FlatStylingSupport.Styleable
    protected String outline;
    @FlatStylingSupport.Styleable
    protected Color outlineColor;
    @FlatStylingSupport.Styleable
    protected Color outlineFocusedColor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
        Graphics2D g25 = (Graphics2D)g15.create();
        try {
            FlatUIUtils.setRenderingHints(g25);
            float focusWidth = UIScale.scale((float)this.getFocusWidth(c15));
            float focusInnerWidth = 0.0f;
            float borderWidth = UIScale.scale(this.getBorderWidth(c15));
            float arc = UIScale.scale((float)this.getArc(c15));
            Color outlineColor = this.getOutlineColor(c15);
            Color focusColor = null;
            if (outlineColor != null || this.isFocused(c15)) {
                float innerWidth;
                float f15 = !this.isCellEditor(c15) && !(c15 instanceof JScrollPane) ? (outlineColor != null ? this.innerOutlineWidth : this.getInnerFocusWidth(c15)) : (innerWidth = 0.0f);
                if (focusWidth > 0.0f || innerWidth > 0.0f) {
                    focusColor = outlineColor != null ? outlineColor : this.getFocusColor(c15);
                    focusInnerWidth = borderWidth + UIScale.scale(innerWidth);
                }
            }
            Color borderColor = outlineColor != null ? outlineColor : this.getBorderColor(c15);
            FlatUIUtils.paintOutlinedComponent(g25, x15, y15, width, height, focusWidth, 1.0f, focusInnerWidth, borderWidth, arc, focusColor, borderColor, null, c15 instanceof JScrollPane);
        }
        finally {
            g25.dispose();
        }
    }

    protected Color getOutlineColor(Component c15) {
        if (!(c15 instanceof JComponent)) {
            return null;
        }
        Color[] outline = ((JComponent)c15).getClientProperty("JComponent.outline");
        if (outline == null) {
            outline = this.outline;
        }
        if (outline == null) {
            if (this.outlineColor != null && this.outlineFocusedColor != null) {
                outline = new Color[]{this.outlineFocusedColor, this.outlineColor};
            } else if (this.outlineColor != null) {
                outline = this.outlineColor;
            } else if (this.outlineFocusedColor != null) {
                outline = this.outlineFocusedColor;
            }
        }
        if (outline instanceof String) {
            switch ((String)outline) {
                case "error": {
                    return this.isFocused(c15) ? this.errorFocusedBorderColor : this.errorBorderColor;
                }
                case "warning": {
                    return this.isFocused(c15) ? this.warningFocusedBorderColor : this.warningBorderColor;
                }
                case "success": {
                    return this.isFocused(c15) ? this.successFocusedBorderColor : this.successBorderColor;
                }
            }
        } else {
            if (outline instanceof Color) {
                Color color = (Color)outline;
                if (!this.isFocused(c15) && this.customBorderColor instanceof DerivedColor) {
                    color = ((DerivedColor)this.customBorderColor).derive(color);
                }
                return color;
            }
            if (outline instanceof Color[] && ((Color[])outline).length >= 2) {
                return ((Color[])outline)[this.isFocused(c15) ? 0 : 1];
            }
        }
        return null;
    }

    protected Color getFocusColor(Component c15) {
        return this.focusColor;
    }

    protected Paint getBorderColor(Component c15) {
        return this.isEnabled(c15) ? (this.isFocused(c15) ? this.focusedBorderColor : this.borderColor) : this.disabledBorderColor;
    }

    protected boolean isEnabled(Component c15) {
        Component view;
        if (c15 instanceof JScrollPane && (view = FlatScrollPaneUI.getView((JScrollPane)c15)) != null && !this.isEnabled(view)) {
            return false;
        }
        return c15.isEnabled();
    }

    protected boolean isFocused(Component c15) {
        if (c15 instanceof JScrollPane) {
            return FlatScrollPaneUI.isPermanentFocusOwner((JScrollPane)c15);
        }
        if (c15 instanceof JComboBox) {
            return FlatComboBoxUI.isPermanentFocusOwner((JComboBox)c15);
        }
        if (c15 instanceof JSpinner) {
            return FlatSpinnerUI.isPermanentFocusOwner((JSpinner)c15);
        }
        return FlatUIUtils.isPermanentFocusOwner(c15);
    }

    protected boolean isCellEditor(Component c15) {
        return FlatUIUtils.isCellEditor(c15);
    }

    @Override
    public Insets getBorderInsets(Component c15, Insets insets) {
        float focusWidth = UIScale.scale((float)this.getFocusWidth(c15));
        int ow4 = Math.round(focusWidth + UIScale.scale((float)this.getLineWidth(c15)));
        insets = super.getBorderInsets(c15, insets);
        insets.top = UIScale.scale(insets.top) + ow4;
        insets.left = UIScale.scale(insets.left) + ow4;
        insets.bottom = UIScale.scale(insets.bottom) + ow4;
        insets.right = UIScale.scale(insets.right) + ow4;
        if (this.isCellEditor(c15)) {
            insets.bottom = 0;
            insets.top = 0;
            if (c15.getComponentOrientation().isLeftToRight()) {
                insets.right = 0;
            } else {
                insets.left = 0;
            }
        }
        return insets;
    }

    protected int getFocusWidth(Component c15) {
        if (this.isCellEditor(c15)) {
            return 0;
        }
        return this.focusWidth;
    }

    protected float getInnerFocusWidth(Component c15) {
        return this.innerFocusWidth;
    }

    protected int getLineWidth(Component c15) {
        return 1;
    }

    protected float getBorderWidth(Component c15) {
        return this.borderWidth;
    }

    protected int getArc(Component c15) {
        return 0;
    }
}

