/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatWindowAbstractIcon;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

public class FlatWindowRestoreIcon
extends FlatWindowAbstractIcon {
    public FlatWindowRestoreIcon() {
        this(null);
    }

    public FlatWindowRestoreIcon(String windowStyle) {
        super(windowStyle);
    }

    @Override
    protected void paintIconAt1x(Graphics2D g15, int x15, int y15, int width, int height, double scaleFactor) {
        int iwh = (int)((double)this.symbolHeight * scaleFactor);
        int ix4 = x15 + (width - iwh) / 2;
        int iy4 = y15 + (height - iwh) / 2;
        boolean isWindows10 = SystemInfo.isWindows_10_orLater && !SystemInfo.isWindows_11_orLater;
        float thickness = Math.max(isWindows10 ? (float)((int)scaleFactor) : (float)scaleFactor, 1.0f);
        int arc = Math.max((int)(1.5 * scaleFactor), 2);
        int arcOuter = (int)((double)arc + 1.5 * scaleFactor);
        int rwh = (int)((double)(this.symbolHeight - 2) * scaleFactor);
        int ro22 = iwh - rwh;
        Path2D r15 = SystemInfo.isWindows_11_orLater ? FlatUIUtils.createRoundRectangle(ix4 + ro22, iy4, rwh, rwh, thickness, arc, arcOuter, arc, arc) : FlatUIUtils.createRectangle(ix4 + ro22, iy4, rwh, rwh, thickness);
        Path2D r25 = SystemInfo.isWindows_11_orLater ? FlatUIUtils.createRoundRectangle(ix4, iy4 + ro22, rwh, rwh, thickness, arc, arc, arc, arc) : FlatUIUtils.createRectangle(ix4, iy4 + ro22, rwh, rwh, thickness);
        Area area = new Area(r15);
        if (SystemInfo.isWindows_11_orLater) {
            area.subtract(new Area(new Rectangle2D.Float(ix4, (float)((double)iy4 + scaleFactor), rwh, rwh)));
            area.subtract(new Area(new Rectangle2D.Float((float)((double)ix4 + scaleFactor), iy4 + ro22, rwh, rwh)));
        } else {
            area.subtract(new Area(new Rectangle2D.Float(ix4, iy4 + ro22, rwh, rwh)));
        }
        g15.fill(area);
        g15.fill(r25);
    }
}

