/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked;

import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.util.ExceptionWithContext;
import com.android.tools.smali.util.Utf8Utils;
import javax.annotation.Nonnull;

public class DexReader<T extends DexBuffer> {
    @Nonnull
    public final T dexBuf;
    private int offset;

    public DexReader(@Nonnull T dexBuf, int offset) {
        this.dexBuf = dexBuf;
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int readSleb128() {
        int result;
        int end = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        if ((result = buf[end++] & 0xFF) <= 127) {
            result = result << 25 >> 25;
        } else {
            int currentByteValue = buf[end++] & 0xFF;
            result = result & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue <= 127) {
                result = result << 18 >> 18;
            } else {
                currentByteValue = buf[end++] & 0xFF;
                result |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue <= 127) {
                    result = result << 11 >> 11;
                } else {
                    currentByteValue = buf[end++] & 0xFF;
                    result |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue <= 127) {
                        result = result << 4 >> 4;
                    } else {
                        if ((currentByteValue = buf[end++] & 0xFF) > 127) {
                            throw new ExceptionWithContext("Invalid sleb128 integer encountered at offset 0x%x", this.offset);
                        }
                        result |= currentByteValue << 28;
                    }
                }
            }
        }
        this.offset = end - ((DexBuffer)this.dexBuf).baseOffset;
        return result;
    }

    public int peekSleb128Size() {
        int currentByteValue;
        int result;
        int end = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        if ((result = buf[end++] & 0xFF) > 127 && (currentByteValue = buf[end++] & 0xFF) > 127 && (currentByteValue = buf[end++] & 0xFF) > 127 && (currentByteValue = buf[end++] & 0xFF) > 127 && (currentByteValue = buf[end++] & 0xFF) > 127) {
            throw new ExceptionWithContext("Invalid sleb128 integer encountered at offset 0x%x", this.offset);
        }
        return end - (((DexBuffer)this.dexBuf).baseOffset + this.offset);
    }

    public int readSmallUleb128() {
        return this.readUleb128(false);
    }

    public int peekSmallUleb128Size() {
        return this.peekUleb128Size(false);
    }

    private int readUleb128(boolean allowLarge) {
        int result;
        int end = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        if ((result = buf[end++] & 0xFF) > 127) {
            int currentByteValue = buf[end++] & 0xFF;
            result = result & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue > 127) {
                currentByteValue = buf[end++] & 0xFF;
                result |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue > 127) {
                    currentByteValue = buf[end++] & 0xFF;
                    result |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue > 127) {
                        if ((currentByteValue = buf[end++]) < 0) {
                            throw new ExceptionWithContext("Invalid uleb128 integer encountered at offset 0x%x", this.offset);
                        }
                        if ((currentByteValue & 0xF) > 7 && !allowLarge) {
                            throw new ExceptionWithContext("Encountered valid uleb128 that is out of range at offset 0x%x", this.offset);
                        }
                        result |= currentByteValue << 28;
                    }
                }
            }
        }
        this.offset = end - ((DexBuffer)this.dexBuf).baseOffset;
        return result;
    }

    private int peekUleb128Size(boolean allowLarge) {
        int currentByteValue;
        int result;
        int end = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        if ((result = buf[end++] & 0xFF) > 127 && (currentByteValue = buf[end++] & 0xFF) > 127 && (currentByteValue = buf[end++] & 0xFF) > 127 && (currentByteValue = buf[end++] & 0xFF) > 127) {
            if ((currentByteValue = buf[end++]) < 0) {
                throw new ExceptionWithContext("Invalid uleb128 integer encountered at offset 0x%x", this.offset);
            }
            if ((currentByteValue & 0xF) > 7 && !allowLarge) {
                throw new ExceptionWithContext("Encountered valid uleb128 that is out of range at offset 0x%x", this.offset);
            }
        }
        return end - (((DexBuffer)this.dexBuf).baseOffset + this.offset);
    }

    public int readLargeUleb128() {
        return this.readUleb128(true);
    }

    public int readBigUleb128() {
        int result;
        int end = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        if ((result = buf[end++] & 0xFF) > 127) {
            int currentByteValue = buf[end++] & 0xFF;
            result = result & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue > 127) {
                currentByteValue = buf[end++] & 0xFF;
                result |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue > 127) {
                    currentByteValue = buf[end++] & 0xFF;
                    result |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue > 127) {
                        if ((currentByteValue = buf[end++]) < 0) {
                            throw new ExceptionWithContext("Invalid uleb128 integer encountered at offset 0x%x", this.offset);
                        }
                        result |= currentByteValue << 28;
                    }
                }
            }
        }
        this.offset = end - ((DexBuffer)this.dexBuf).baseOffset;
        return result;
    }

    public int peekBigUleb128Size() {
        int currentByteValue;
        int result;
        int end = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        if ((result = buf[end++] & 0xFF) > 127 && (currentByteValue = buf[end++] & 0xFF) > 127 && (currentByteValue = buf[end++] & 0xFF) > 127 && (currentByteValue = buf[end++] & 0xFF) > 127 && (currentByteValue = buf[end++]) < 0) {
            throw new ExceptionWithContext("Invalid uleb128 integer encountered at offset 0x%x", this.offset);
        }
        return end - (((DexBuffer)this.dexBuf).baseOffset + this.offset);
    }

    public void skipUleb128() {
        byte currentByteValue;
        int end = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        if ((currentByteValue = buf[end++]) < 0 && (currentByteValue = buf[end++]) < 0 && (currentByteValue = buf[end++]) < 0 && (currentByteValue = buf[end++]) < 0 && (currentByteValue = buf[end++]) < 0) {
            throw new ExceptionWithContext("Invalid uleb128 integer encountered at offset 0x%x", this.offset);
        }
        this.offset = end - ((DexBuffer)this.dexBuf).baseOffset;
    }

    public int readSmallUint() {
        int o15 = this.offset;
        int result = ((DexBuffer)this.dexBuf).readSmallUint(o15);
        this.offset = o15 + 4;
        return result;
    }

    public int readOptionalUint() {
        int o15 = this.offset;
        int result = ((DexBuffer)this.dexBuf).readOptionalUint(o15);
        this.offset = o15 + 4;
        return result;
    }

    public int peekUshort() {
        return ((DexBuffer)this.dexBuf).readUshort(this.offset);
    }

    public int readUshort() {
        int o15 = this.offset;
        int result = ((DexBuffer)this.dexBuf).readUshort(this.offset);
        this.offset = o15 + 2;
        return result;
    }

    public int peekUbyte() {
        return ((DexBuffer)this.dexBuf).readUbyte(this.offset);
    }

    public int readUbyte() {
        int o15 = this.offset;
        int result = ((DexBuffer)this.dexBuf).readUbyte(this.offset);
        this.offset = o15 + 1;
        return result;
    }

    public long readLong() {
        int o15 = this.offset;
        long result = ((DexBuffer)this.dexBuf).readLong(this.offset);
        this.offset = o15 + 8;
        return result;
    }

    public int readInt() {
        int o15 = this.offset;
        int result = ((DexBuffer)this.dexBuf).readInt(this.offset);
        this.offset = o15 + 4;
        return result;
    }

    public int readShort() {
        int o15 = this.offset;
        int result = ((DexBuffer)this.dexBuf).readShort(this.offset);
        this.offset = o15 + 2;
        return result;
    }

    public int readByte() {
        int o15 = this.offset;
        int result = ((DexBuffer)this.dexBuf).readByte(this.offset);
        this.offset = o15 + 1;
        return result;
    }

    public void skipByte() {
        ++this.offset;
    }

    public void moveRelative(int i15) {
        this.offset += i15;
    }

    public int readSmallUint(int offset) {
        return ((DexBuffer)this.dexBuf).readSmallUint(offset);
    }

    public int readUshort(int offset) {
        return ((DexBuffer)this.dexBuf).readUshort(offset);
    }

    public int readUbyte(int offset) {
        return ((DexBuffer)this.dexBuf).readUbyte(offset);
    }

    public long readLong(int offset) {
        return ((DexBuffer)this.dexBuf).readLong(offset);
    }

    public int readInt(int offset) {
        return ((DexBuffer)this.dexBuf).readInt(offset);
    }

    public int readShort(int offset) {
        return ((DexBuffer)this.dexBuf).readShort(offset);
    }

    public int readByte(int offset) {
        return ((DexBuffer)this.dexBuf).readByte(offset);
    }

    public int readSizedInt(int bytes) {
        int result;
        int o15 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        switch (bytes) {
            case 4: {
                result = buf[o15] & 0xFF | (buf[o15 + 1] & 0xFF) << 8 | (buf[o15 + 2] & 0xFF) << 16 | buf[o15 + 3] << 24;
                break;
            }
            case 3: {
                result = buf[o15] & 0xFF | (buf[o15 + 1] & 0xFF) << 8 | buf[o15 + 2] << 16;
                break;
            }
            case 2: {
                result = buf[o15] & 0xFF | buf[o15 + 1] << 8;
                break;
            }
            case 1: {
                result = buf[o15];
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized int at offset 0x%x", bytes, this.offset);
            }
        }
        this.offset = o15 + bytes - ((DexBuffer)this.dexBuf).baseOffset;
        return result;
    }

    public int readSizedSmallUint(int bytes) {
        int o15 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        int result = 0;
        switch (bytes) {
            case 4: {
                byte b15 = buf[o15 + 3];
                if (b15 < 0) {
                    throw new ExceptionWithContext("Encountered valid sized uint that is out of range at offset 0x%x", this.offset);
                }
                result = b15 << 24;
            }
            case 3: {
                result |= (buf[o15 + 2] & 0xFF) << 16;
            }
            case 2: {
                result |= (buf[o15 + 1] & 0xFF) << 8;
            }
            case 1: {
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized uint at offset 0x%x", bytes, this.offset);
            }
        }
        this.offset = o15 + bytes - ((DexBuffer)this.dexBuf).baseOffset;
        return result |= buf[o15] & 0xFF;
    }

    public int readSizedRightExtendedInt(int bytes) {
        int result;
        int o15 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        switch (bytes) {
            case 4: {
                result = buf[o15] & 0xFF | (buf[o15 + 1] & 0xFF) << 8 | (buf[o15 + 2] & 0xFF) << 16 | buf[o15 + 3] << 24;
                break;
            }
            case 3: {
                result = (buf[o15] & 0xFF) << 8 | (buf[o15 + 1] & 0xFF) << 16 | buf[o15 + 2] << 24;
                break;
            }
            case 2: {
                result = (buf[o15] & 0xFF) << 16 | buf[o15 + 1] << 24;
                break;
            }
            case 1: {
                result = buf[o15] << 24;
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized, right extended int at offset 0x%x", bytes, this.offset);
            }
        }
        this.offset = o15 + bytes - ((DexBuffer)this.dexBuf).baseOffset;
        return result;
    }

    public long readSizedRightExtendedLong(int bytes) {
        long result;
        int o15 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        switch (bytes) {
            case 8: {
                result = (long)(buf[o15] & 0xFF | (buf[o15 + 1] & 0xFF) << 8 | (buf[o15 + 2] & 0xFF) << 16) | ((long)buf[o15 + 3] & 0xFFL) << 24 | ((long)buf[o15 + 4] & 0xFFL) << 32 | ((long)buf[o15 + 5] & 0xFFL) << 40 | ((long)buf[o15 + 6] & 0xFFL) << 48 | (long)buf[o15 + 7] << 56;
                break;
            }
            case 7: {
                result = (long)((buf[o15] & 0xFF) << 8 | (buf[o15 + 1] & 0xFF) << 16) | ((long)buf[o15 + 2] & 0xFFL) << 24 | ((long)buf[o15 + 3] & 0xFFL) << 32 | ((long)buf[o15 + 4] & 0xFFL) << 40 | ((long)buf[o15 + 5] & 0xFFL) << 48 | (long)buf[o15 + 6] << 56;
                break;
            }
            case 6: {
                result = (long)((buf[o15] & 0xFF) << 16) | ((long)buf[o15 + 1] & 0xFFL) << 24 | ((long)buf[o15 + 2] & 0xFFL) << 32 | ((long)buf[o15 + 3] & 0xFFL) << 40 | ((long)buf[o15 + 4] & 0xFFL) << 48 | (long)buf[o15 + 5] << 56;
                break;
            }
            case 5: {
                result = ((long)buf[o15] & 0xFFL) << 24 | ((long)buf[o15 + 1] & 0xFFL) << 32 | ((long)buf[o15 + 2] & 0xFFL) << 40 | ((long)buf[o15 + 3] & 0xFFL) << 48 | (long)buf[o15 + 4] << 56;
                break;
            }
            case 4: {
                result = ((long)buf[o15] & 0xFFL) << 32 | ((long)buf[o15 + 1] & 0xFFL) << 40 | ((long)buf[o15 + 2] & 0xFFL) << 48 | (long)buf[o15 + 3] << 56;
                break;
            }
            case 3: {
                result = ((long)buf[o15] & 0xFFL) << 40 | ((long)buf[o15 + 1] & 0xFFL) << 48 | (long)buf[o15 + 2] << 56;
                break;
            }
            case 2: {
                result = ((long)buf[o15] & 0xFFL) << 48 | (long)buf[o15 + 1] << 56;
                break;
            }
            case 1: {
                result = (long)buf[o15] << 56;
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized, right extended long at offset 0x%x", bytes, this.offset);
            }
        }
        this.offset = o15 + bytes - ((DexBuffer)this.dexBuf).baseOffset;
        return result;
    }

    public long readSizedLong(int bytes) {
        long result;
        int o15 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] buf = ((DexBuffer)this.dexBuf).buf;
        switch (bytes) {
            case 8: {
                result = (long)(buf[o15] & 0xFF | (buf[o15 + 1] & 0xFF) << 8 | (buf[o15 + 2] & 0xFF) << 16) | ((long)buf[o15 + 3] & 0xFFL) << 24 | ((long)buf[o15 + 4] & 0xFFL) << 32 | ((long)buf[o15 + 5] & 0xFFL) << 40 | ((long)buf[o15 + 6] & 0xFFL) << 48 | (long)buf[o15 + 7] << 56;
                break;
            }
            case 7: {
                result = (long)(buf[o15] & 0xFF | (buf[o15 + 1] & 0xFF) << 8 | (buf[o15 + 2] & 0xFF) << 16) | ((long)buf[o15 + 3] & 0xFFL) << 24 | ((long)buf[o15 + 4] & 0xFFL) << 32 | ((long)buf[o15 + 5] & 0xFFL) << 40 | (long)buf[o15 + 6] << 48;
                break;
            }
            case 6: {
                result = (long)(buf[o15] & 0xFF | (buf[o15 + 1] & 0xFF) << 8 | (buf[o15 + 2] & 0xFF) << 16) | ((long)buf[o15 + 3] & 0xFFL) << 24 | ((long)buf[o15 + 4] & 0xFFL) << 32 | (long)buf[o15 + 5] << 40;
                break;
            }
            case 5: {
                result = (long)(buf[o15] & 0xFF | (buf[o15 + 1] & 0xFF) << 8 | (buf[o15 + 2] & 0xFF) << 16) | ((long)buf[o15 + 3] & 0xFFL) << 24 | (long)buf[o15 + 4] << 32;
                break;
            }
            case 4: {
                result = (long)(buf[o15] & 0xFF | (buf[o15 + 1] & 0xFF) << 8 | (buf[o15 + 2] & 0xFF) << 16) | (long)buf[o15 + 3] << 24;
                break;
            }
            case 3: {
                result = buf[o15] & 0xFF | (buf[o15 + 1] & 0xFF) << 8 | buf[o15 + 2] << 16;
                break;
            }
            case 2: {
                result = buf[o15] & 0xFF | buf[o15 + 1] << 8;
                break;
            }
            case 1: {
                result = buf[o15];
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized long at offset 0x%x", bytes, this.offset);
            }
        }
        this.offset = o15 + bytes - ((DexBuffer)this.dexBuf).baseOffset;
        return result;
    }

    public String readString(int utf16Length) {
        int[] ret = new int[1];
        String value = Utf8Utils.utf8BytesWithUtf16LengthToString(((DexBuffer)this.dexBuf).buf, ((DexBuffer)this.dexBuf).baseOffset + this.offset, utf16Length, ret);
        this.offset += ret[0];
        return value;
    }

    public int peekStringLength(int utf16Length) {
        int[] ret = new int[1];
        Utf8Utils.utf8BytesWithUtf16LengthToString(((DexBuffer)this.dexBuf).buf, ((DexBuffer)this.dexBuf).baseOffset + this.offset, utf16Length, ret);
        return ret[0];
    }
}

