import '@grafana/data';
import { c as chanceExports } from '../../_virtual/chance.js';
import { fireEvent } from '../../node_modules/@testing-library/react/dist/@testing-library/react.esm.js';
import { userEvent } from '../../node_modules/@testing-library/user-event/dist/esm/setup/index.js';
import '../../node_modules/@testing-library/user-event/dist/esm/options.js';
import { kebabCase } from 'lodash';
import { getQueriesForElement, waitFor as waitForWrapper } from '../../node_modules/@testing-library/dom/dist/@testing-library/dom.esm.js';

const generateBoolean = () => chanceExports.Chance().pickone([true, false]);
const undefinedOr = (fn) => chanceExports.Chance().pickone([undefined, fn()]);
const generateArrayOf = (fn, numberOf = 3) => Array.from(new Array(numberOf), () => fn());
const openSelect = (container, optionLabel) => {
  const selectInput = getQueriesForElement(container).getByRole("textbox");
  fireEvent.blur(selectInput);
  userEvent.type(selectInput, optionLabel != null ? optionLabel : "{arrowdown}");
};
const selectOption = async (container, optionLabel, typeOptionLabel) => {
  openSelect(container, typeOptionLabel ? optionLabel : undefined);
  const option = await waitForWrapper(() => getQueriesForElement(container).getByText(optionLabel));
  userEvent.click(option);
};
const generateOptions = () => {
  const numberOfOptions = 5;
  return Array.from(new Array(numberOfOptions), () => {
    const name = chanceExports.Chance().name();
    return {
      label: name,
      value: kebabCase(name)
    };
  });
};

export { generateArrayOf, generateBoolean, generateOptions, openSelect, selectOption, undefinedOr };
//# sourceMappingURL=utils.js.map
