import { jsx, jsxs } from 'react/jsx-runtime';
import { useCallback } from 'react';
import { toOption } from '@grafana/data';
import '../types.js';
import { setGroupByField } from '../utils/sql.utils.js';
import { EditorList } from '../EditorList.js';
import { Select } from '@grafana/ui';
import { AccessoryButton } from '../AccessoryButton.js';
import { InputGroup } from '../InputGroup.js';

function GroupByRow({ sql, columns, onSqlChange }) {
  const onGroupByChange = useCallback(
    (item) => {
      const cleaned = item.map((v) => {
        var _a;
        return setGroupByField((_a = v.property) == null ? undefined : _a.name);
      });
      const newSql = { ...sql, groupBy: cleaned };
      onSqlChange(newSql);
    },
    [onSqlChange, sql]
  );
  return /* @__PURE__ */ jsx(
    EditorList,
    {
      items: sql.groupBy,
      onChange: onGroupByChange,
      renderItem: makeRenderColumn({
        options: columns
      })
    }
  );
}
function makeRenderColumn({ options }) {
  const renderColumn = function(item, onChangeItem, onDeleteItem) {
    var _a;
    return /* @__PURE__ */ jsxs(InputGroup, { children: [
      /* @__PURE__ */ jsx(
        Select,
        {
          value: ((_a = item.property) == null ? undefined : _a.name) ? toOption(item.property.name) : null,
          "aria-label": "Group by",
          options,
          menuShouldPortal: true,
          onChange: ({ value }) => value && onChangeItem(setGroupByField(value))
        }
      ),
      /* @__PURE__ */ jsx(AccessoryButton, { "aria-label": "Remove group by column", icon: "times", variant: "secondary", onClick: onDeleteItem })
    ] });
  };
  return renderColumn;
}

export { GroupByRow };
//# sourceMappingURL=GroupByRow.js.map
