import { jsxs, jsx } from 'react/jsx-runtime';
import { forwardRef } from 'react';
import { Button } from '@grafana/ui';
import { EditorStack } from './EditorStack.js';

const EditorList = forwardRef(function EditorList2({ items, renderItem, onChange }, ref) {
  const onAddItem = () => {
    const newItems = [...items, {}];
    onChange(newItems);
  };
  const onChangeItem = (itemIndex, newItem) => {
    const newItems = [...items];
    newItems[itemIndex] = newItem;
    onChange(newItems);
  };
  const onDeleteItem = (itemIndex) => {
    const newItems = [...items];
    newItems.splice(itemIndex, 1);
    onChange(newItems);
  };
  return /* @__PURE__ */ jsxs(EditorStack, { children: [
    items.map((item, index) => /* @__PURE__ */ jsx("div", { children: renderItem(
      item,
      (newItem) => onChangeItem(index, newItem),
      () => onDeleteItem(index)
    ) }, index)),
    /* @__PURE__ */ jsx(Button, { ref, onClick: onAddItem, variant: "secondary", size: "md", icon: "plus", "aria-label": "Add", type: "button" })
  ] });
});

export { EditorList };
//# sourceMappingURL=EditorList.js.map
