/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.logging.LogLevel;
import org.gradle.cli.CommandLineConverter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.internal.logging.LoggingConfigurationBuildOptions;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;
import org.jspecify.annotations.NonNull;

public class BuildLogLevelMixIn {
    private final LogLevel logLevel;

    public BuildLogLevelMixIn(ProviderOperationParameters parameters) {
        this.logLevel = BuildLogLevelMixIn.calcBuildLogLevel(parameters);
    }

    public LogLevel getBuildLogLevel() {
        return this.logLevel;
    }

    private static LogLevel calcBuildLogLevel(ProviderOperationParameters parameters) {
        LoggingConfigurationBuildOptions loggingBuildOptions = new LoggingConfigurationBuildOptions();
        CommandLineConverter converter = loggingBuildOptions.commandLineConverter();
        SystemPropertiesCommandLineConverter propertiesCommandLineConverter = new SystemPropertiesCommandLineConverter();
        CommandLineParser parser = new CommandLineParser().allowUnknownOptions().allowMixedSubcommandsAndOptions();
        converter.configure(parser);
        propertiesCommandLineConverter.configure(parser);
        List<String> arguments = parameters.getArguments();
        ParsedCommandLine parsedCommandLine = parser.parse(arguments == null ? Collections.emptyList() : arguments);
        return BuildLogLevelMixIn.getLogLevelFromCommandLineOptions(loggingBuildOptions, parsedCommandLine).orElseGet(() -> BuildLogLevelMixIn.getLogLevelFromCommandLineProperties(propertiesCommandLineConverter, parsedCommandLine).orElseGet(() -> {
            if (parameters.getVerboseLogging()) {
                return LogLevel.DEBUG;
            }
            return null;
        }));
    }

    private static @NonNull Optional<LogLevel> getLogLevelFromCommandLineOptions(LoggingConfigurationBuildOptions loggingBuildOptions, ParsedCommandLine parsedCommandLine) {
        return loggingBuildOptions.getLongLogLevelOptions().stream().filter(arg_0 -> ((ParsedCommandLine)parsedCommandLine).hasOption(arg_0)).map(LoggingConfigurationBuildOptions.LogLevelOption::parseLogLevel).findFirst();
    }

    private static Optional<LogLevel> getLogLevelFromCommandLineProperties(SystemPropertiesCommandLineConverter propertiesCommandLineConverter, ParsedCommandLine parsedCommandLine) {
        Map properties = propertiesCommandLineConverter.convert(parsedCommandLine, new HashMap());
        String logLevelCommandLineProperty = (String)properties.get("org.gradle.logging.level");
        if (logLevelCommandLineProperty != null) {
            try {
                return Optional.of(LoggingConfigurationBuildOptions.LogLevelOption.parseLogLevel((String)logLevelCommandLineProperty));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

