/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.LexicalValue;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class TextDecorationManager
extends AbstractValueManager {
    protected static final StringMap<Value> values = new StringMap(6);

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 18;
    }

    @Override
    public String getPropertyName() {
        return "text-decoration";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lunit, CSSEngine engine) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case IDENT: {
                if (lunit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
                ListValue lv = new ListValue(' ');
                LexicalUnit lu = lunit;
                do {
                    switch (lu.getLexicalUnitType()) {
                        case IDENT: {
                            String s = lu.getStringValue().toLowerCase(Locale.ROOT).intern();
                            Value obj = values.get(s);
                            if (obj == null) {
                                throw this.createInvalidIdentifierDOMException(lu.getStringValue());
                            }
                            lv.append(obj);
                            lu = lu.getNextLexicalUnit();
                            break;
                        }
                        case VAR: 
                        case ATTR: {
                            return new LexicalValue(lunit);
                        }
                        default: {
                            throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
                        }
                    }
                } while (lu != null);
                return lv;
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return new LexicalValue(lunit);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
    }

    static {
        values.put("blink", ValueConstants.BLINK_VALUE);
        values.put("line-through", ValueConstants.LINE_THROUGH_VALUE);
        values.put("overline", ValueConstants.OVERLINE_VALUE);
        values.put("underline", ValueConstants.UNDERLINE_VALUE);
    }
}

