/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.ai.chat.AssistantProfile;

public class AssistantProfileStore {
    static final String PROFILES_FILE_NAME = "ai-assistant-profiles.json";
    private static final String PROFILES_RESOURCE = "/org/freeplane/plugin/ai/assistant-profiles.json";
    private final ObjectMapper objectMapper;
    private final Path profilesPath;

    public AssistantProfileStore() {
        this(new ObjectMapper(), AssistantProfileStore.resolveDefaultPath());
    }

    AssistantProfileStore(ObjectMapper objectMapper, Path profilesPath) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        this.profilesPath = Objects.requireNonNull(profilesPath, "profilesPath");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AssistantProfile> loadProfiles() {
        if (!Files.exists(this.profilesPath, new LinkOption[0])) {
            if (!this.copyDefaultProfiles()) return new ArrayList<AssistantProfile>();
            return this.loadProfiles();
        }
        try (InputStream inputStream = Files.newInputStream(this.profilesPath, new OpenOption[0]);){
            AssistantProfile[] loaded = (AssistantProfile[])this.objectMapper.readValue(inputStream, AssistantProfile[].class);
            if (loaded == null) {
                ArrayList<AssistantProfile> arrayList2 = new ArrayList<AssistantProfile>();
                return arrayList2;
            }
            ArrayList<AssistantProfile> arrayList = new ArrayList<AssistantProfile>(Arrays.asList(loaded));
            return arrayList;
        }
        catch (IOException error) {
            LogUtils.severe((Throwable)error);
            return new ArrayList<AssistantProfile>();
        }
    }

    public void saveProfiles(List<AssistantProfile> profiles) {
        this.ensureParentDirectory();
        try (OutputStream outputStream = Files.newOutputStream(this.profilesPath, new OpenOption[0]);){
            this.objectMapper.writeValue(outputStream, profiles);
        }
        catch (IOException error) {
            LogUtils.severe((Throwable)error);
        }
    }

    private void ensureParentDirectory() {
        Path parent = this.profilesPath.getParent();
        if (parent == null) {
            return;
        }
        try {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        catch (IOException error) {
            LogUtils.severe((Throwable)error);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean copyDefaultProfiles() {
        this.ensureParentDirectory();
        try (InputStream inputStream = AssistantProfileStore.class.getResourceAsStream(PROFILES_RESOURCE);){
            boolean bl;
            block16: {
                if (inputStream == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                OutputStream outputStream = Files.newOutputStream(this.profilesPath, new OpenOption[0]);
                try {
                    inputStream.transferTo(outputStream);
                    bl = true;
                    if (outputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputStream.close();
            }
            return bl;
        }
        catch (IOException error) {
            LogUtils.severe((Throwable)error);
            return false;
        }
    }

    private static Path resolveDefaultPath() {
        String userDirectory = ResourceController.getResourceController().getFreeplaneUserDirectory();
        return Paths.get(userDirectory, new String[0]).resolve(PROFILES_FILE_NAME);
    }
}

