/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.MongoSecurityException;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.Authenticator;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.DefaultAuthenticator;
import com.mongodb.internal.connection.DescriptionHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.InternalConnectionInitializationDescription;
import com.mongodb.internal.connection.InternalConnectionInitializer;
import com.mongodb.internal.connection.SpeculativeAuthenticator;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;

public class InternalStreamConnectionInitializer
implements InternalConnectionInitializer {
    private final ClusterConnectionMode clusterConnectionMode;
    private final Authenticator authenticator;
    private final BsonDocument clientMetadataDocument;
    private final List<MongoCompressor> requestedCompressors;
    private final boolean checkSaslSupportedMechs;
    private final ServerApi serverApi;

    public InternalStreamConnectionInitializer(ClusterConnectionMode clusterConnectionMode, @Nullable Authenticator authenticator, @Nullable BsonDocument clientMetadataDocument, List<MongoCompressor> requestedCompressors, @Nullable ServerApi serverApi) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.authenticator = authenticator;
        this.clientMetadataDocument = clientMetadataDocument;
        this.requestedCompressors = Assertions.notNull("requestedCompressors", requestedCompressors);
        this.checkSaslSupportedMechs = authenticator instanceof DefaultAuthenticator;
        this.serverApi = serverApi;
    }

    @Override
    public InternalConnectionInitializationDescription startHandshake(InternalConnection internalConnection) {
        Assertions.notNull("internalConnection", internalConnection);
        return this.initializeConnectionDescription(internalConnection);
    }

    @Override
    public InternalConnectionInitializationDescription finishHandshake(InternalConnection internalConnection, InternalConnectionInitializationDescription description) {
        Assertions.notNull("internalConnection", internalConnection);
        Assertions.notNull("description", description);
        ConnectionDescription connectionDescription = description.getConnectionDescription();
        if (Authenticator.shouldAuthenticate(this.authenticator, connectionDescription)) {
            this.authenticator.authenticate(internalConnection, connectionDescription);
        }
        return this.completeConnectionDescriptionInitialization(internalConnection, description);
    }

    @Override
    public void startHandshakeAsync(InternalConnection internalConnection, SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        long startTime = System.nanoTime();
        CommandHelper.executeCommandAsync("admin", this.createHelloCommand(this.authenticator, internalConnection), this.clusterConnectionMode, this.serverApi, internalConnection, (helloResult, t) -> {
            if (t != null) {
                callback.onResult(null, t instanceof MongoException ? this.mapHelloException((MongoException)t) : t);
            } else {
                InternalConnectionInitializationDescription initializationDescription;
                this.setSpeculativeAuthenticateResponse((BsonDocument)helloResult);
                try {
                    initializationDescription = this.createInitializationDescription((BsonDocument)helloResult, internalConnection, startTime);
                }
                catch (Throwable localThrowable) {
                    callback.onResult(null, localThrowable);
                    return;
                }
                callback.onResult(initializationDescription, null);
            }
        });
    }

    @Override
    public void finishHandshakeAsync(InternalConnection internalConnection, InternalConnectionInitializationDescription description, SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        ConnectionDescription connectionDescription = description.getConnectionDescription();
        if (!Authenticator.shouldAuthenticate(this.authenticator, connectionDescription)) {
            this.completeConnectionDescriptionInitializationAsync(internalConnection, description, callback);
        } else {
            this.authenticator.authenticateAsync(internalConnection, connectionDescription, (result1, t1) -> {
                if (t1 != null) {
                    callback.onResult(null, t1);
                } else {
                    this.completeConnectionDescriptionInitializationAsync(internalConnection, description, callback);
                }
            });
        }
    }

    private InternalConnectionInitializationDescription initializeConnectionDescription(InternalConnection internalConnection) {
        BsonDocument helloResult;
        BsonDocument helloCommandDocument = this.createHelloCommand(this.authenticator, internalConnection);
        long start = System.nanoTime();
        try {
            helloResult = CommandHelper.executeCommand("admin", helloCommandDocument, this.clusterConnectionMode, this.serverApi, internalConnection);
        }
        catch (MongoException e) {
            throw this.mapHelloException(e);
        }
        this.setSpeculativeAuthenticateResponse(helloResult);
        return this.createInitializationDescription(helloResult, internalConnection, start);
    }

    private MongoException mapHelloException(MongoException e) {
        if (this.checkSaslSupportedMechs && e.getCode() == 11) {
            MongoCredential credential = this.authenticator.getMongoCredential();
            return new MongoSecurityException(credential, String.format("Exception authenticating %s", credential), (Throwable)e);
        }
        return e;
    }

    private InternalConnectionInitializationDescription createInitializationDescription(BsonDocument helloResult, InternalConnection internalConnection, long startTime) {
        ConnectionId connectionId = internalConnection.getDescription().getConnectionId();
        ConnectionDescription connectionDescription = DescriptionHelper.createConnectionDescription(this.clusterConnectionMode, connectionId, helloResult);
        ServerDescription serverDescription = DescriptionHelper.createServerDescription(internalConnection.getDescription().getServerAddress(), helloResult, System.nanoTime() - startTime);
        return new InternalConnectionInitializationDescription(connectionDescription, serverDescription);
    }

    private BsonDocument createHelloCommand(Authenticator authenticator, InternalConnection connection) {
        BsonDocument speculativeAuthenticateDocument;
        BsonDocument helloCommandDocument = new BsonDocument(this.getHandshakeCommandName(), (BsonValue)new BsonInt32(1)).append("helloOk", (BsonValue)BsonBoolean.TRUE);
        if (this.clientMetadataDocument != null) {
            helloCommandDocument.append("client", (BsonValue)this.clientMetadataDocument);
        }
        if (this.clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED) {
            helloCommandDocument.append("loadBalanced", (BsonValue)BsonBoolean.TRUE);
        }
        if (!this.requestedCompressors.isEmpty()) {
            BsonArray compressors = new BsonArray(this.requestedCompressors.size());
            for (MongoCompressor cur : this.requestedCompressors) {
                compressors.add((BsonValue)new BsonString(cur.getName()));
            }
            helloCommandDocument.append("compression", (BsonValue)compressors);
        }
        if (this.checkSaslSupportedMechs) {
            MongoCredential credential = authenticator.getMongoCredential();
            helloCommandDocument.append("saslSupportedMechs", (BsonValue)new BsonString(credential.getSource() + "." + credential.getUserName()));
        }
        if (authenticator instanceof SpeculativeAuthenticator && (speculativeAuthenticateDocument = ((SpeculativeAuthenticator)((Object)authenticator)).createSpeculativeAuthenticateCommand(connection)) != null) {
            helloCommandDocument.append("speculativeAuthenticate", (BsonValue)speculativeAuthenticateDocument);
        }
        return helloCommandDocument;
    }

    private InternalConnectionInitializationDescription completeConnectionDescriptionInitialization(InternalConnection internalConnection, InternalConnectionInitializationDescription description) {
        if (description.getConnectionDescription().getConnectionId().getServerValue() != null) {
            return description;
        }
        return this.applyGetLastErrorResult(CommandHelper.executeCommandWithoutCheckingForFailure("admin", new BsonDocument("getlasterror", (BsonValue)new BsonInt32(1)), this.clusterConnectionMode, this.serverApi, internalConnection), description);
    }

    private void setSpeculativeAuthenticateResponse(BsonDocument helloResult) {
        if (this.authenticator instanceof SpeculativeAuthenticator) {
            ((SpeculativeAuthenticator)((Object)this.authenticator)).setSpeculativeAuthenticateResponse(helloResult.getDocument((Object)"speculativeAuthenticate", null));
        }
    }

    private void completeConnectionDescriptionInitializationAsync(InternalConnection internalConnection, InternalConnectionInitializationDescription description, SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        if (description.getConnectionDescription().getConnectionId().getServerValue() != null) {
            callback.onResult(description, null);
            return;
        }
        CommandHelper.executeCommandAsync("admin", new BsonDocument("getlasterror", (BsonValue)new BsonInt32(1)), this.clusterConnectionMode, this.serverApi, internalConnection, (result, t) -> {
            if (t != null) {
                callback.onResult(description, null);
            } else {
                callback.onResult(this.applyGetLastErrorResult((BsonDocument)result, description), null);
            }
        });
    }

    private InternalConnectionInitializationDescription applyGetLastErrorResult(BsonDocument getLastErrorResult, InternalConnectionInitializationDescription description) {
        ConnectionDescription connectionDescription = description.getConnectionDescription();
        ConnectionId connectionId = getLastErrorResult.containsKey((Object)"connectionId") ? connectionDescription.getConnectionId().withServerValue(getLastErrorResult.getNumber((Object)"connectionId").longValue()) : connectionDescription.getConnectionId();
        return description.withConnectionDescription(connectionDescription.withConnectionId(connectionId));
    }

    private String getHandshakeCommandName() {
        return this.serverApi == null ? "isMaster" : "hello";
    }
}

