/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.auth.mschap;

import com.axlradius.radclient4.attributes.Attribute;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.attributes.Microsoft;
import com.axlradius.radclient4.attributes.VendorSpecific;
import com.axlradius.radclient4.radutil.RADIUSEncode;
import com.axlradius.radclient4.radutil.Rand;

public class MPPEClient {
    private boolean s = false;
    private boolean t = false;
    private byte[] N;
    private byte[] O;
    private byte[] P;
    private byte[] Q;

    public MPPEClient() {
        new Microsoft();
    }

    public void extract(AttributeList objectArray, byte[] byArray, byte[] byArray2) {
        if (objectArray.getVendorSpecific(311).length == 0) {
            return;
        }
        Attribute[] attributeArray = objectArray.getVendorSpecific(311, 8);
        if (attributeArray.length > 0) {
            if (attributeArray[0].getDataLength() == 4) {
                this.N = attributeArray[0].getData();
            }
        } else {
            this.N = new byte[4];
            this.N[3] = 96;
        }
        if ((attributeArray = objectArray.getVendorSpecific(311, 7)).length > 0 && attributeArray[0].getDataLength() > 0) {
            if (attributeArray[0].getDataLength() == 4) {
                attributeArray[0].getData();
            }
        } else {
            (new byte[4])[3] = 96;
        }
        if ((attributeArray = objectArray.getVendorSpecific(311, 12)).length > 0) {
            byte[] byArray3 = attributeArray[0].getData();
            objectArray = byArray3;
            if (byArray3 == null || objectArray.length != 32) {
                return;
            }
            this.t = true;
            objectArray = RADIUSEncode.decodePAPPassword((byte[])objectArray, byArray, byArray2);
            this.O = (byte[])objectArray;
            return;
        }
        attributeArray = objectArray.getVendorSpecific(311, 16);
        objectArray = objectArray.getVendorSpecific(311, 17);
        if (attributeArray.length == 0 || objectArray.length == 0) {
            return;
        }
        this.s = true;
        this.P = attributeArray[0].getData();
        this.Q = objectArray[0].getData();
        this.P = RADIUSEncode.saltDecode(this.P, byArray, byArray2);
        this.Q = RADIUSEncode.saltDecode(this.Q, byArray, byArray2);
    }

    public boolean hasV1Keys() {
        return this.t;
    }

    public boolean hasV2Keys() {
        return this.s;
    }

    public byte[] getEncryptionPolicy() {
        return null;
    }

    public byte[] getSendKey() {
        return this.P;
    }

    public byte[] getReceiveKey() {
        return this.Q;
    }

    public byte[] getMPPEKeys() {
        return this.O;
    }

    public byte[] getNTKey() {
        if (this.hasV1Keys()) {
            byte[] byArray = new byte[16];
            System.arraycopy(this.O, 8, byArray, 0, 16);
            return byArray;
        }
        return null;
    }

    public AttributeList createMPPEKeys(byte[] object, byte[] byArray, byte[] byArray2, boolean bl) {
        AttributeList attributeList = new AttributeList();
        byte[] byArray3 = new byte[32];
        if (bl) {
            byte[] byArray4 = new byte[2];
            Rand.nextBytes(byArray4);
            byArray4[0] = (byte)(byArray4[0] & 0x80);
            byArray3 = RADIUSEncode.saltEncode(byArray4, byArray3, byArray, byArray2);
        }
        VendorSpecific vendorSpecific = new VendorSpecific(311);
        object = vendorSpecific;
        vendorSpecific.add(12, byArray3);
        attributeList.add(((VendorSpecific)object).getAttribute());
        object = new VendorSpecific(311);
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = byArray5;
        byArray5[3] = 1;
        ((AttributeList)object).add(7, byArray6);
        attributeList.add(((VendorSpecific)object).getAttribute());
        object = new VendorSpecific(311);
        byte[] byArray7 = new byte[4];
        byArray = byArray7;
        byArray7[3] = 6;
        ((AttributeList)object).add(8, byArray);
        attributeList.add(((VendorSpecific)object).getAttribute());
        return attributeList;
    }
}

