/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api.wfiexperience;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.service.trace.api.device.TraceDeviceStats;
import com.ubnt.service.trace.api.wfiexperience.AccessPointWifiStats;
import com.ubnt.service.trace.api.wfiexperience.VapConnectivityStats;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Generated(from="AccessPointWifiStats", generator="Immutables")
public final class ImmutableAccessPointWifiStats
implements AccessPointWifiStats {
    private final TraceDeviceStats deviceMeta;
    private final List<Map<String, VapConnectivityStats>> vapConnectivityStats;

    private ImmutableAccessPointWifiStats(Builder builder) {
        this.deviceMeta = builder.deviceMeta;
        this.vapConnectivityStats = ImmutableAccessPointWifiStats.PeMbw(true, builder.vapConnectivityStats);
    }

    @Override
    @JsonProperty(value="deviceMeta")
    public TraceDeviceStats deviceMeta() {
        return this.deviceMeta;
    }

    @Override
    @JsonProperty(value="vapConnectivityStats")
    public List<Map<String, VapConnectivityStats>> vapConnectivityStats() {
        return this.vapConnectivityStats;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableAccessPointWifiStats && this.PeMbw(0, (ImmutableAccessPointWifiStats)object);
    }

    private boolean PeMbw(int n, ImmutableAccessPointWifiStats immutableAccessPointWifiStats) {
        return Objects.equals(this.deviceMeta, immutableAccessPointWifiStats.deviceMeta) && this.vapConnectivityStats.equals(immutableAccessPointWifiStats.vapConnectivityStats);
    }

    public int hashCode() {
        int n = 5381;
        n += (n << 5) + Objects.hashCode(this.deviceMeta);
        n += (n << 5) + this.vapConnectivityStats.hashCode();
        return n;
    }

    public String toString() {
        return "AccessPointWifiStats{deviceMeta=" + String.valueOf(this.deviceMeta) + ", vapConnectivityStats=" + String.valueOf(this.vapConnectivityStats) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccessPointWifiStats PeMbw(ntiBWujauPv ntiBWujauPv2) {
        Builder builder = ImmutableAccessPointWifiStats.builder();
        if (ntiBWujauPv2.PeMbw != null) {
            builder.deviceMeta(ntiBWujauPv2.PeMbw);
        }
        if (ntiBWujauPv2.gVykWPBqZJEwrqYSrp != null) {
            builder.addAllVapConnectivityStats(ntiBWujauPv2.gVykWPBqZJEwrqYSrp);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> PeMbw(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n = ((Collection)iterable).size();
            if (n == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t : iterable) {
            if (bl2 && t == null) continue;
            if (bl) {
                Objects.requireNonNull(t, "element");
            }
            arrayList.add(t);
        }
        return arrayList;
    }

    private static <T> List<T> PeMbw(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AccessPointWifiStats", generator="Immutables")
    public static final class Builder {
        @Nullable
        private TraceDeviceStats deviceMeta;
        private List<Map<String, VapConnectivityStats>> vapConnectivityStats = new ArrayList<Map<String, VapConnectivityStats>>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccessPointWifiStats accessPointWifiStats) {
            Objects.requireNonNull(accessPointWifiStats, "instance");
            TraceDeviceStats traceDeviceStats = accessPointWifiStats.deviceMeta();
            if (traceDeviceStats != null) {
                this.deviceMeta(traceDeviceStats);
            }
            this.addAllVapConnectivityStats(accessPointWifiStats.vapConnectivityStats());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deviceMeta(TraceDeviceStats traceDeviceStats) {
            this.deviceMeta = traceDeviceStats;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addVapConnectivityStats(@Nullable Map<String, VapConnectivityStats> map) {
            this.vapConnectivityStats.add(map);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addVapConnectivityStats(Map<String, VapConnectivityStats> ... mapArray) {
            for (Map<String, VapConnectivityStats> map : mapArray) {
                this.vapConnectivityStats.add(map);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder vapConnectivityStats(Iterable<? extends Map<String, VapConnectivityStats>> iterable) {
            this.vapConnectivityStats.clear();
            return this.addAllVapConnectivityStats(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllVapConnectivityStats(Iterable<? extends Map<String, VapConnectivityStats>> iterable) {
            for (Map<String, VapConnectivityStats> map : iterable) {
                this.vapConnectivityStats.add(map);
            }
            return this;
        }

        public ImmutableAccessPointWifiStats build() {
            return new ImmutableAccessPointWifiStats(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccessPointWifiStats", generator="Immutables")
    static final class ntiBWujauPv
    implements AccessPointWifiStats {
        @Nullable
        TraceDeviceStats PeMbw;
        @Nullable
        List<Map<String, VapConnectivityStats>> gVykWPBqZJEwrqYSrp = Collections.emptyList();

        ntiBWujauPv() {
        }

        @JsonProperty(value="deviceMeta")
        public void PeMbw(TraceDeviceStats traceDeviceStats) {
            this.PeMbw = traceDeviceStats;
        }

        @JsonProperty(value="vapConnectivityStats")
        public void PeMbw(List<Map<String, VapConnectivityStats>> list) {
            this.gVykWPBqZJEwrqYSrp = list;
        }

        @Override
        public TraceDeviceStats deviceMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Map<String, VapConnectivityStats>> vapConnectivityStats() {
            throw new UnsupportedOperationException();
        }
    }
}

