/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api.device;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.ErPOSynhB;
import com.ubnt.service.trace.api.device.DeviceStateTransitionEvent;
import com.ubnt.service.trace.api.device.TraceDeviceStats;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceStateTransitionReport {
    @JsonProperty(value="eventTimestampMillis")
    private long eventTimestampMillis;
    @JsonProperty(value="previousState")
    private String previousState;
    @JsonProperty(value="newState")
    private String newState;
    @JsonProperty(value="deviceStats")
    private TraceDeviceStats deviceStats;
    @JsonProperty(value="transitionReasonType")
    private String transitionReasonType;
    @JsonProperty(value="transitionReasonDetails")
    private String transitionReasonDetails;
    @JsonProperty(value="newUpgradeState")
    private String newUpgradeState;
    @JsonProperty(value="previousUpgradeState")
    private String previousUpgradeState;

    public long getEventTimestampMillis() {
        return this.eventTimestampMillis;
    }

    public String getPreviousState() {
        return this.previousState;
    }

    public String getNewState() {
        return this.newState;
    }

    public TraceDeviceStats getDeviceStats() {
        return this.deviceStats;
    }

    public String getTransitionReasonType() {
        return this.transitionReasonType;
    }

    public String getTransitionReasonDetails() {
        return this.transitionReasonDetails;
    }

    public String getNewUpgradeState() {
        return this.newUpgradeState;
    }

    public String getPreviousUpgradeState() {
        return this.previousUpgradeState;
    }

    public static DeviceStateTransitionReport of(DeviceStateTransitionEvent deviceStateTransitionEvent) {
        ErPOSynhB erPOSynhB = deviceStateTransitionEvent.device();
        DeviceStateTransitionReport deviceStateTransitionReport = new DeviceStateTransitionReport();
        deviceStateTransitionReport.deviceStats = TraceDeviceStats.of(erPOSynhB);
        deviceStateTransitionReport.eventTimestampMillis = deviceStateTransitionEvent.eventTimestampMillis();
        deviceStateTransitionReport.previousState = ErPOSynhB.getStateName(deviceStateTransitionEvent.previousState());
        deviceStateTransitionReport.newState = ErPOSynhB.getStateName(deviceStateTransitionEvent.newState());
        deviceStateTransitionReport.transitionReasonType = deviceStateTransitionEvent.reason().name();
        deviceStateTransitionReport.transitionReasonDetails = deviceStateTransitionEvent.reason().PeMbw(erPOSynhB).orElse(null);
        deviceStateTransitionReport.previousUpgradeState = deviceStateTransitionEvent.previousUpgradeState().flatMap(ErPOSynhB.ntiBWujauPv::PeMbw).map(Enum::name).orElse(null);
        deviceStateTransitionReport.newUpgradeState = deviceStateTransitionEvent.newUpgradeState().flatMap(ErPOSynhB.ntiBWujauPv::PeMbw).map(Enum::name).orElse(null);
        return deviceStateTransitionReport;
    }
}

