/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.observability;

import com.mongodb.event.CommandStartedEvent;
import io.micrometer.common.KeyValues;
import org.springframework.data.mongodb.observability.MongoHandlerContext;
import org.springframework.data.mongodb.observability.MongoHandlerObservationConvention;
import org.springframework.data.mongodb.observability.MongoObservation;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class DefaultMongoHandlerObservationConvention
implements MongoHandlerObservationConvention {
    DefaultMongoHandlerObservationConvention() {
    }

    public KeyValues getLowCardinalityKeyValues(MongoHandlerContext context) {
        if (context.getCommandStartedEvent() == null) {
            throw new IllegalStateException("not command started event present");
        }
        return MongoObservation.LowCardinality.observe(context).toKeyValues();
    }

    public String getContextualName(MongoHandlerContext context) {
        String collectionName = context.getCollectionName();
        CommandStartedEvent commandStartedEvent = context.getCommandStartedEvent();
        Assert.notNull((Object)commandStartedEvent, (String)"CommandStartedEvent must not be null");
        if (ObjectUtils.isEmpty((Object)collectionName)) {
            return commandStartedEvent.getCommandName();
        }
        return collectionName + "." + commandStartedEvent.getCommandName();
    }
}

