/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"// SPDX-License-Identifier: BSD-3-Clause\n"
	"module ietf-netconf {\n"
	"\n"
	"  // the namespace for NETCONF XML definitions is unchanged\n"
	"  // from RFC 4741, which this document replaces\n"
	"  namespace \"urn:ietf:params:xml:ns:netconf:base:1.0\";\n"
	"\n"
	"  prefix nc;\n"
	"\n"
	"  import ietf-inet-types {\n"
	"    prefix inet;\n"
	"  }\n"
	"\n"
	"  import ietf-netconf-acm { prefix nacm; }\n"
	"\n"
	"  organization\n"
	"    \"IETF NETCONF (Network Configuration) Working Group\";\n"
	"\n"
	"  contact\n"
	"    \"WG Web:   <http://tools.ietf.org/wg/netconf/>\n"
	"     WG List:  <netconf@ietf.org>\n"
	"\n"
	"     WG Chair: Bert Wijnen\n"
	"               <bertietf@bwijnen.net>\n"
	"\n"
	"     WG Chair: Mehmet Ersue\n"
	"               <mehmet.ersue@nsn.com>\n"
	"\n"
	"     Editor:   Martin Bjorklund\n"
	"               <mbj@tail-f.com>\n"
	"\n"
	"     Editor:   Juergen Schoenwaelder\n"
	"               <j.schoenwaelder@jacobs-university.de>\n"
	"\n"
	"     Editor:   Andy Bierman\n"
	"               <andy.bierman@brocade.com>\";\n"
	"  description\n"
	"    \"NETCONF Protocol Data Types and Protocol Operations.\n"
	"\n"
	"     Copyright (c) 2011 IETF Trust and the persons identified as\n"
	"     the document authors.  All rights reserved.\n"
	"\n"
	"     Redistribution and use in source and binary forms, with or\n"
	"     without modification, is permitted pursuant to, and subject\n"
	"     to the license terms contained in, the Simplified BSD License\n"
	"     set forth in Section 4.c of the IETF Trust\'s Legal Provisions\n"
	"     Relating to IETF Documents\n"
	"     (http://trustee.ietf.org/license-info).\n"
	"\n"
	"     This version of this YANG module is part of RFC 6241; see\n"
	"     the RFC itself for full legal notices.\";\n"
	"\n"
	"  revision 2011-06-01 {\n"
	"    description\n"
	"      \"Initial revision;\n"
	"       2013-09-29: Updated to include NACM attributes,\n"
	"       as specified in RFC 6536: sec 3.2.5 and 3.2.8\";\n"
	"    reference\n"
	"      \"RFC 6241: Network Configuration Protocol\";\n"
	"  }\n"
	"\n"
	"  extension get-filter-element-attributes {\n"
	"    description\n"
	"      \"If this extension is present within an \'anyxml\'\n"
	"       statement named \'filter\', which must be conceptually\n"
	"       defined within the RPC input section for the <get>\n"
	"       and <get-config> protocol operations, then the\n"
	"       following unqualified XML attribute is supported\n"
	"       within the <filter> element, within a <get> or\n"
	"       <get-config> protocol operation:\n"
	"\n"
	"         type : optional attribute with allowed\n"
	"                value strings \'subtree\' and \'xpath\'.\n"
	"                If missing, the default value is \'subtree\'.\n"
	"\n"
	"       If the \'xpath\' feature is supported, then the\n"
	"       following unqualified XML attribute is\n"
	"       also supported:\n"
	"\n"
	"         select: optional attribute containing a\n"
	"                 string representing an XPath expression.\n"
	"                 The \'type\' attribute must be equal to \'xpath\'\n"
	"                 if this attribute is present.\";\n"
	"  }\n"
	"\n"
	"  // NETCONF capabilities defined as features\n"
	"  feature writable-running {\n"
	"    description\n"
	"      \"NETCONF :writable-running capability;\n"
	"       If the server advertises the :writable-running\n"
	"       capability for a session, then this feature must\n"
	"       also be enabled for that session.  Otherwise,\n"
	"       this feature must not be enabled.\";\n"
	"    reference \"RFC 6241, Section 8.2\";\n"
	"  }\n"
	"\n"
	"  feature candidate {\n"
	"    description\n"
	"      \"NETCONF :candidate capability;\n"
	"       If the server advertises the :candidate\n"
	"       capability for a session, then this feature must\n"
	"       also be enabled for that session.  Otherwise,\n"
	"       this feature must not be enabled.\";\n"
	"    reference \"RFC 6241, Section 8.3\";\n"
	"  }\n"
	"\n"
	"  feature confirmed-commit {\n"
	"    if-feature candidate;\n"
	"    description\n"
	"      \"NETCONF :confirmed-commit:1.1 capability;\n"
	"       If the server advertises the :confirmed-commit:1.1\n"
	"       capability for a session, then this feature must\n"
	"       also be enabled for that session.  Otherwise,\n"
	"       this feature must not be enabled.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 8.4\";\n"
	"  }\n"
	"\n"
	"  feature rollback-on-error {\n"
	"    description\n"
	"      \"NETCONF :rollback-on-error capability;\n"
	"       If the server advertises the :rollback-on-error\n"
	"       capability for a session, then this feature must\n"
	"       also be enabled for that session.  Otherwise,\n"
	"       this feature must not be enabled.\";\n"
	"    reference \"RFC 6241, Section 8.5\";\n"
	"  }\n"
	"\n"
	"  feature validate {\n"
	"    description\n"
	"      \"NETCONF :validate:1.1 capability;\n"
	"       If the server advertises the :validate:1.1\n"
	"       capability for a session, then this feature must\n"
	"       also be enabled for that session.  Otherwise,\n"
	"       this feature must not be enabled.\";\n"
	"    reference \"RFC 6241, Section 8.6\";\n"
	"  }\n"
	"\n"
	"  feature startup {\n"
	"    description\n"
	"      \"NETCONF :startup capability;\n"
	"       If the server advertises the :startup\n"
	"       capability for a session, then this feature must\n"
	"       also be enabled for that session.  Otherwise,\n"
	"       this feature must not be enabled.\";\n"
	"    reference \"RFC 6241, Section 8.7\";\n"
	"  }\n"
	"\n"
	"  feature url {\n"
	"    description\n"
	"      \"NETCONF :url capability;\n"
	"       If the server advertises the :url\n"
	"       capability for a session, then this feature must\n"
	"       also be enabled for that session.  Otherwise,\n"
	"       this feature must not be enabled.\";\n"
	"    reference \"RFC 6241, Section 8.8\";\n"
	"  }\n"
	"\n"
	"  feature xpath {\n"
	"    description\n"
	"      \"NETCONF :xpath capability;\n"
	"       If the server advertises the :xpath\n"
	"       capability for a session, then this feature must\n"
	"       also be enabled for that session.  Otherwise,\n"
	"       this feature must not be enabled.\";\n"
	"    reference \"RFC 6241, Section 8.9\";\n"
	"  }\n"
	"\n"
	"  // NETCONF Simple Types\n"
	"\n"
	"  typedef session-id-type {\n"
	"    type uint32 {\n"
	"      range \"1..max\";\n"
	"    }\n"
	"    description\n"
	"      \"NETCONF Session Id\";\n"
	"  }\n"
	"\n"
	"  typedef session-id-or-zero-type {\n"
	"    type uint32;\n"
	"    description\n"
	"      \"NETCONF Session Id or Zero to indicate none\";\n"
	"  }\n"
	"  typedef error-tag-type {\n"
	"    type enumeration {\n"
	"       enum in-use {\n"
	"         description\n"
	"           \"The request requires a resource that\n"
	"            already is in use.\";\n"
	"       }\n"
	"       enum invalid-value {\n"
	"         description\n"
	"           \"The request specifies an unacceptable value for one\n"
	"            or more parameters.\";\n"
	"       }\n"
	"       enum too-big {\n"
	"         description\n"
	"           \"The request or response (that would be generated) is\n"
	"            too large for the implementation to handle.\";\n"
	"       }\n"
	"       enum missing-attribute {\n"
	"         description\n"
	"           \"An expected attribute is missing.\";\n"
	"       }\n"
	"       enum bad-attribute {\n"
	"         description\n"
	"           \"An attribute value is not correct; e.g., wrong type,\n"
	"            out of range, pattern mismatch.\";\n"
	"       }\n"
	"       enum unknown-attribute {\n"
	"         description\n"
	"           \"An unexpected attribute is present.\";\n"
	"       }\n"
	"       enum missing-element {\n"
	"         description\n"
	"           \"An expected element is missing.\";\n"
	"       }\n"
	"       enum bad-element {\n"
	"         description\n"
	"           \"An element value is not correct; e.g., wrong type,\n"
	"            out of range, pattern mismatch.\";\n"
	"       }\n"
	"       enum unknown-element {\n"
	"         description\n"
	"           \"An unexpected element is present.\";\n"
	"       }\n"
	"       enum unknown-namespace {\n"
	"         description\n"
	"           \"An unexpected namespace is present.\";\n"
	"       }\n"
	"       enum access-denied {\n"
	"         description\n"
	"           \"Access to the requested protocol operation or\n"
	"            data model is denied because authorization failed.\";\n"
	"       }\n"
	"       enum lock-denied {\n"
	"         description\n"
	"           \"Access to the requested lock is denied because the\n"
	"            lock is currently held by another entity.\";\n"
	"       }\n"
	"       enum resource-denied {\n"
	"         description\n"
	"           \"Request could not be completed because of\n"
	"            insufficient resources.\";\n"
	"       }\n"
	"       enum rollback-failed {\n"
	"         description\n"
	"           \"Request to roll back some configuration change (via\n"
	"            rollback-on-error or <discard-changes> operations)\n"
	"            was not completed for some reason.\";\n"
	"\n"
	"       }\n"
	"       enum data-exists {\n"
	"         description\n"
	"           \"Request could not be completed because the relevant\n"
	"            data model content already exists.  For example,\n"
	"            a \'create\' operation was attempted on data that\n"
	"            already exists.\";\n"
	"       }\n"
	"       enum data-missing {\n"
	"         description\n"
	"           \"Request could not be completed because the relevant\n"
	"            data model content does not exist.  For example,\n"
	"            a \'delete\' operation was attempted on\n"
	"            data that does not exist.\";\n"
	"       }\n"
	"       enum operation-not-supported {\n"
	"         description\n"
	"           \"Request could not be completed because the requested\n"
	"            operation is not supported by this implementation.\";\n"
	"       }\n"
	"       enum operation-failed {\n"
	"         description\n"
	"           \"Request could not be completed because the requested\n"
	"            operation failed for some reason not covered by\n"
	"            any other error condition.\";\n"
	"       }\n"
	"       enum partial-operation {\n"
	"         description\n"
	"           \"This error-tag is obsolete, and SHOULD NOT be sent\n"
	"            by servers conforming to this document.\";\n"
	"       }\n"
	"       enum malformed-message {\n"
	"         description\n"
	"           \"A message could not be handled because it failed to\n"
	"            be parsed correctly.  For example, the message is not\n"
	"            well-formed XML or it uses an invalid character set.\";\n"
	"       }\n"
	"     }\n"
	"     description \"NETCONF Error Tag\";\n"
	"     reference \"RFC 6241, Appendix A\";\n"
	"  }\n"
	"\n"
	"  typedef error-severity-type {\n"
	"    type enumeration {\n"
	"      enum error {\n"
	"        description \"Error severity\";\n"
	"      }\n"
	"      enum warning {\n"
	"        description \"Warning severity\";\n"
	"      }\n"
	"    }\n"
	"    description \"NETCONF Error Severity\";\n"
	"    reference \"RFC 6241, Section 4.3\";\n"
	"  }\n"
	"\n"
	"  typedef edit-operation-type {\n"
	"    type enumeration {\n"
	"      enum merge {\n"
	"        description\n"
	"          \"The configuration data identified by the\n"
	"           element containing this attribute is merged\n"
	"           with the configuration at the corresponding\n"
	"           level in the configuration datastore identified\n"
	"           by the target parameter.\";\n"
	"      }\n"
	"      enum replace {\n"
	"        description\n"
	"          \"The configuration data identified by the element\n"
	"           containing this attribute replaces any related\n"
	"           configuration in the configuration datastore\n"
	"           identified by the target parameter.  If no such\n"
	"           configuration data exists in the configuration\n"
	"           datastore, it is created.  Unlike a\n"
	"           <copy-config> operation, which replaces the\n"
	"           entire target configuration, only the configuration\n"
	"           actually present in the config parameter is affected.\";\n"
	"      }\n"
	"      enum create {\n"
	"        description\n"
	"          \"The configuration data identified by the element\n"
	"           containing this attribute is added to the\n"
	"           configuration if and only if the configuration\n"
	"           data does not already exist in the configuration\n"
	"           datastore.  If the configuration data exists, an\n"
	"           <rpc-error> element is returned with an\n"
	"           <error-tag> value of \'data-exists\'.\";\n"
	"      }\n"
	"      enum delete {\n"
	"        description\n"
	"          \"The configuration data identified by the element\n"
	"           containing this attribute is deleted from the\n"
	"           configuration if and only if the configuration\n"
	"           data currently exists in the configuration\n"
	"           datastore.  If the configuration data does not\n"
	"           exist, an <rpc-error> element is returned with\n"
	"           an <error-tag> value of \'data-missing\'.\";\n"
	"      }\n"
	"      enum remove {\n"
	"        description\n"
	"          \"The configuration data identified by the element\n"
	"           containing this attribute is deleted from the\n"
	"           configuration if the configuration\n"
	"           data currently exists in the configuration\n"
	"           datastore.  If the configuration data does not\n"
	"           exist, the \'remove\' operation is silently ignored\n"
	"           by the server.\";\n"
	"      }\n"
	"    }\n"
	"    default \"merge\";\n"
	"    description \"NETCONF \'operation\' attribute values\";\n"
	"    reference \"RFC 6241, Section 7.2\";\n"
	"  }\n"
	"\n"
	"  // NETCONF Standard Protocol Operations\n"
	"\n"
	"  rpc get-config {\n"
	"    description\n"
	"      \"Retrieve all or part of a specified configuration.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 7.1\";\n"
	"\n"
	"    input {\n"
	"      container source {\n"
	"        description\n"
	"          \"Particular configuration to retrieve.\";\n"
	"\n"
	"        choice config-source {\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"The configuration to retrieve.\";\n"
	"          leaf candidate {\n"
	"            if-feature candidate;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The candidate configuration is the config source.\";\n"
	"          }\n"
	"          leaf running {\n"
	"            type empty;\n"
	"            description\n"
	"              \"The running configuration is the config source.\";\n"
	"          }\n"
	"          leaf startup {\n"
	"            if-feature startup;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The startup configuration is the config source.\n"
	"               This is optional-to-implement on the server because\n"
	"               not all servers will support filtering for this\n"
	"               datastore.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      anyxml filter {\n"
	"        description\n"
	"          \"Subtree or XPath filter to use.\";\n"
	"        nc:get-filter-element-attributes;\n"
	"      }\n"
	"    }\n"
	"\n"
	"    output {\n"
	"      anyxml data {\n"
	"        description\n"
	"          \"Copy of the source datastore subset that matched\n"
	"           the filter criteria (if any).  An empty data container\n"
	"           indicates that the request did not produce any results.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  rpc edit-config {\n"
	"    description\n"
	"      \"The <edit-config> operation loads all or part of a specified\n"
	"       configuration to the specified target configuration.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 7.2\";\n"
	"\n"
	"    input {\n"
	"      container target {\n"
	"        description\n"
	"          \"Particular configuration to edit.\";\n"
	"\n"
	"        choice config-target {\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"The configuration target.\";\n"
	"\n"
	"          leaf candidate {\n"
	"            if-feature candidate;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The candidate configuration is the config target.\";\n"
	"          }\n"
	"          leaf running {\n"
	"            if-feature writable-running;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The running configuration is the config source.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      leaf default-operation {\n"
	"        type enumeration {\n"
	"          enum merge {\n"
	"            description\n"
	"              \"The default operation is merge.\";\n"
	"          }\n"
	"          enum replace {\n"
	"            description\n"
	"              \"The default operation is replace.\";\n"
	"          }\n"
	"          enum none {\n"
	"            description\n"
	"              \"There is no default operation.\";\n"
	"          }\n"
	"        }\n"
	"        default \"merge\";\n"
	"        description\n"
	"          \"The default operation to use.\";\n"
	"      }\n"
	"\n"
	"      leaf test-option {\n"
	"        if-feature validate;\n"
	"        type enumeration {\n"
	"          enum test-then-set {\n"
	"            description\n"
	"              \"The server will test and then set if no errors.\";\n"
	"          }\n"
	"          enum set {\n"
	"            description\n"
	"              \"The server will set without a test first.\";\n"
	"          }\n"
	"\n"
	"          enum test-only {\n"
	"            description\n"
	"              \"The server will only test and not set, even\n"
	"               if there are no errors.\";\n"
	"          }\n"
	"        }\n"
	"        default \"test-then-set\";\n"
	"        description\n"
	"          \"The test option to use.\";\n"
	"      }\n"
	"\n"
	"      leaf error-option {\n"
	"        type enumeration {\n"
	"          enum stop-on-error {\n"
	"            description\n"
	"              \"The server will stop on errors.\";\n"
	"          }\n"
	"          enum continue-on-error {\n"
	"            description\n"
	"              \"The server may continue on errors.\";\n"
	"          }\n"
	"          enum rollback-on-error {\n"
	"            description\n"
	"              \"The server will roll back on errors.\n"
	"               This value can only be used if the \'rollback-on-error\'\n"
	"               feature is supported.\";\n"
	"          }\n"
	"        }\n"
	"        default \"stop-on-error\";\n"
	"        description\n"
	"          \"The error option to use.\";\n"
	"      }\n"
	"\n"
	"      choice edit-content {\n"
	"        mandatory true;\n"
	"        description\n"
	"          \"The content for the edit operation.\";\n"
	"\n"
	"        anyxml config {\n"
	"          description\n"
	"            \"Inline Config content.\";\n"
	"        }\n"
	"        leaf url {\n"
	"          if-feature url;\n"
	"          type inet:uri;\n"
	"          description\n"
	"            \"URL-based config content.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  rpc copy-config {\n"
	"    description\n"
	"      \"Create or replace an entire configuration datastore with the\n"
	"       contents of another complete configuration datastore.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 7.3\";\n"
	"\n"
	"    input {\n"
	"      container target {\n"
	"        description\n"
	"          \"Particular configuration to copy to.\";\n"
	"\n"
	"        choice config-target {\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"The configuration target of the copy operation.\";\n"
	"\n"
	"          leaf candidate {\n"
	"            if-feature candidate;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The candidate configuration is the config target.\";\n"
	"          }\n"
	"          leaf running {\n"
	"            if-feature writable-running;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The running configuration is the config target.\n"
	"               This is optional-to-implement on the server.\";\n"
	"          }\n"
	"          leaf startup {\n"
	"            if-feature startup;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The startup configuration is the config target.\";\n"
	"          }\n"
	"          leaf url {\n"
	"            if-feature url;\n"
	"            type inet:uri;\n"
	"            description\n"
	"              \"The URL-based configuration is the config target.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container source {\n"
	"        description\n"
	"          \"Particular configuration to copy from.\";\n"
	"\n"
	"        choice config-source {\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"The configuration source for the copy operation.\";\n"
	"\n"
	"          leaf candidate {\n"
	"            if-feature candidate;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The candidate configuration is the config source.\";\n"
	"          }\n"
	"          leaf running {\n"
	"            type empty;\n"
	"            description\n"
	"              \"The running configuration is the config source.\";\n"
	"          }\n"
	"          leaf startup {\n"
	"            if-feature startup;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The startup configuration is the config source.\";\n"
	"          }\n"
	"          leaf url {\n"
	"            if-feature url;\n"
	"            type inet:uri;\n"
	"            description\n"
	"              \"The URL-based configuration is the config source.\";\n"
	"          }\n"
	"          anyxml config {\n"
	"            description\n"
	"              \"Inline Config content: <config> element.  Represents\n"
	"               an entire configuration datastore, not\n"
	"               a subset of the running datastore.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  rpc delete-config {\n"
	"    nacm:default-deny-all;\n"
	"    description\n"
	"      \"Delete a configuration datastore.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 7.4\";\n"
	"\n"
	"    input {\n"
	"      container target {\n"
	"        description\n"
	"          \"Particular configuration to delete.\";\n"
	"\n"
	"        choice config-target {\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"The configuration target to delete.\";\n"
	"\n"
	"          leaf startup {\n"
	"            if-feature startup;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The startup configuration is the config target.\";\n"
	"          }\n"
	"          leaf url {\n"
	"            if-feature url;\n"
	"            type inet:uri;\n"
	"            description\n"
	"              \"The URL-based configuration is the config target.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  rpc lock {\n"
	"    description\n"
	"      \"The lock operation allows the client to lock the configuration\n"
	"       system of a device.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 7.5\";\n"
	"\n"
	"    input {\n"
	"      container target {\n"
	"        description\n"
	"          \"Particular configuration to lock.\";\n"
	"\n"
	"        choice config-target {\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"The configuration target to lock.\";\n"
	"\n"
	"          leaf candidate {\n"
	"            if-feature candidate;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The candidate configuration is the config target.\";\n"
	"          }\n"
	"          leaf running {\n"
	"            type empty;\n"
	"            description\n"
	"              \"The running configuration is the config target.\";\n"
	"          }\n"
	"          leaf startup {\n"
	"            if-feature startup;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The startup configuration is the config target.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  rpc unlock {\n"
	"    description\n"
	"      \"The unlock operation is used to release a configuration lock,\n"
	"       previously obtained with the \'lock\' operation.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 7.6\";\n"
	"\n"
	"    input {\n"
	"      container target {\n"
	"        description\n"
	"          \"Particular configuration to unlock.\";\n"
	"\n"
	"        choice config-target {\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"The configuration target to unlock.\";\n"
	"\n"
	"          leaf candidate {\n"
	"            if-feature candidate;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The candidate configuration is the config target.\";\n"
	"          }\n"
	"          leaf running {\n"
	"            type empty;\n"
	"            description\n"
	"              \"The running configuration is the config target.\";\n"
	"          }\n"
	"          leaf startup {\n"
	"            if-feature startup;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The startup configuration is the config target.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  rpc get {\n"
	"    description\n"
	"      \"Retrieve running configuration and device state information.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 7.7\";\n"
	"\n"
	"    input {\n"
	"      anyxml filter {\n"
	"        description\n"
	"          \"This parameter specifies the portion of the system\n"
	"           configuration and state data to retrieve.\";\n"
	"        nc:get-filter-element-attributes;\n"
	"      }\n"
	"    }\n"
	"\n"
	"    output {\n"
	"      anyxml data {\n"
	"        description\n"
	"          \"Copy of the running datastore subset and/or state\n"
	"           data that matched the filter criteria (if any).\n"
	"           An empty data container indicates that the request did not\n"
	"           produce any results.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  rpc close-session {\n"
	"    description\n"
	"      \"Request graceful termination of a NETCONF session.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 7.8\";\n"
	"  }\n"
	"\n"
	"  rpc kill-session {\n"
	"    nacm:default-deny-all;\n"
	"    description\n"
	"      \"Force the termination of a NETCONF session.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 7.9\";\n"
	"\n"
	"    input {\n"
	"      leaf session-id {\n"
	"        type session-id-type;\n"
	"        mandatory true;\n"
	"        description\n"
	"          \"Particular session to kill.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  rpc commit {\n"
	"    if-feature candidate;\n"
	"\n"
	"    description\n"
	"      \"Commit the candidate configuration as the device\'s new\n"
	"       current configuration.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 8.3.4.1\";\n"
	"\n"
	"    input {\n"
	"      leaf confirmed {\n"
	"        if-feature confirmed-commit;\n"
	"        type empty;\n"
	"        description\n"
	"          \"Requests a confirmed commit.\";\n"
	"        reference \"RFC 6241, Section 8.3.4.1\";\n"
	"      }\n"
	"\n"
	"      leaf confirm-timeout {\n"
	"        if-feature confirmed-commit;\n"
	"        type uint32 {\n"
	"          range \"1..max\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"600\";   // 10 minutes\n"
	"        description\n"
	"          \"The timeout interval for a confirmed commit.\";\n"
	"        reference \"RFC 6241, Section 8.3.4.1\";\n"
	"      }\n"
	"\n"
	"      leaf persist {\n"
	"        if-feature confirmed-commit;\n"
	"        type string;\n"
	"        description\n"
	"          \"This parameter is used to make a confirmed commit\n"
	"           persistent.  A persistent confirmed commit is not aborted\n"
	"           if the NETCONF session terminates.  The only way to abort\n"
	"           a persistent confirmed commit is to let the timer expire,\n"
	"           or to use the <cancel-commit> operation.\n"
	"\n"
	"           The value of this parameter is a token that must be given\n"
	"           in the \'persist-id\' parameter of <commit> or\n"
	"           <cancel-commit> operations in order to confirm or cancel\n"
	"           the persistent confirmed commit.\n"
	"\n"
	"           The token should be a random string.\";\n"
	"        reference \"RFC 6241, Section 8.3.4.1\";\n"
	"      }\n"
	"\n"
	"      leaf persist-id {\n"
	"        if-feature confirmed-commit;\n"
	"        type string;\n"
	"        description\n"
	"          \"This parameter is given in order to commit a persistent\n"
	"           confirmed commit.  The value must be equal to the value\n"
	"           given in the \'persist\' parameter to the <commit> operation.\n"
	"           If it does not match, the operation fails with an\n"
	"          \'invalid-value\' error.\";\n"
	"        reference \"RFC 6241, Section 8.3.4.1\";\n"
	"      }\n"
	"\n"
	"    }\n"
	"  }\n"
	"\n"
	"  rpc discard-changes {\n"
	"    if-feature candidate;\n"
	"\n"
	"    description\n"
	"      \"Revert the candidate configuration to the current\n"
	"       running configuration.\";\n"
	"    reference \"RFC 6241, Section 8.3.4.2\";\n"
	"  }\n"
	"\n"
	"  rpc cancel-commit {\n"
	"    if-feature confirmed-commit;\n"
	"    description\n"
	"      \"This operation is used to cancel an ongoing confirmed commit.\n"
	"       If the confirmed commit is persistent, the parameter\n"
	"       \'persist-id\' must be given, and it must match the value of the\n"
	"       \'persist\' parameter.\";\n"
	"    reference \"RFC 6241, Section 8.4.4.1\";\n"
	"\n"
	"    input {\n"
	"      leaf persist-id {\n"
	"        type string;\n"
	"        description\n"
	"          \"This parameter is given in order to cancel a persistent\n"
	"           confirmed commit.  The value must be equal to the value\n"
	"           given in the \'persist\' parameter to the <commit> operation.\n"
	"           If it does not match, the operation fails with an\n"
	"          \'invalid-value\' error.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  rpc validate {\n"
	"    if-feature validate;\n"
	"\n"
	"    description\n"
	"      \"Validates the contents of the specified configuration.\";\n"
	"\n"
	"    reference \"RFC 6241, Section 8.6.4.1\";\n"
	"\n"
	"    input {\n"
	"      container source {\n"
	"        description\n"
	"          \"Particular configuration to validate.\";\n"
	"\n"
	"        choice config-source {\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"The configuration source to validate.\";\n"
	"\n"
	"          leaf candidate {\n"
	"            if-feature candidate;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The candidate configuration is the config source.\";\n"
	"          }\n"
	"          leaf running {\n"
	"            type empty;\n"
	"            description\n"
	"              \"The running configuration is the config source.\";\n"
	"          }\n"
	"          leaf startup {\n"
	"            if-feature startup;\n"
	"            type empty;\n"
	"            description\n"
	"              \"The startup configuration is the config source.\";\n"
	"          }\n"
	"          leaf url {\n"
	"            if-feature url;\n"
	"            type inet:uri;\n"
	"            description\n"
	"              \"The URL-based configuration is the config source.\";\n"
	"          }\n"
	"          anyxml config {\n"
	"            description\n"
	"              \"Inline Config content: <config> element.  Represents\n"
	"               an entire configuration datastore, not\n"
	"               a subset of the running datastore.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "ietf-netconf",
	.mod_rev = "2011-06-01",
	.sub_mod_name = "",
	.sub_mod_rev = "",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
