/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"// SPDX-License-Identifier: BSD-3-Clause\n"
	"module ietf-interfaces {\n"
	"  yang-version 1.1;\n"
	"  namespace \"urn:ietf:params:xml:ns:yang:ietf-interfaces\";\n"
	"  prefix if;\n"
	"\n"
	"  import ietf-yang-types {\n"
	"    prefix yang;\n"
	"  }\n"
	"\n"
	"  organization\n"
	"    \"IETF NETMOD (Network Modeling) Working Group\";\n"
	"\n"
	"  contact\n"
	"    \"WG Web:   <https://datatracker.ietf.org/wg/netmod/>\n"
	"     WG List:  <mailto:netmod@ietf.org>\n"
	"\n"
	"     Editor:   Martin Bjorklund\n"
	"               <mailto:mbj@tail-f.com>\";\n"
	"\n"
	"  description\n"
	"    \"This module contains a collection of YANG definitions for\n"
	"     managing network interfaces.\n"
	"\n"
	"     Copyright (c) 2018 IETF Trust and the persons identified as\n"
	"     authors of the code.  All rights reserved.\n"
	"\n"
	"     Redistribution and use in source and binary forms, with or\n"
	"     without modification, is permitted pursuant to, and subject\n"
	"     to the license terms contained in, the Simplified BSD License\n"
	"     set forth in Section 4.c of the IETF Trust\'s Legal Provisions\n"
	"     Relating to IETF Documents\n"
	"     (https://trustee.ietf.org/license-info).\n"
	"\n"
	"     This version of this YANG module is part of RFC 8343; see\n"
	"     the RFC itself for full legal notices.\";\n"
	"\n"
	"  revision 2018-02-20 {\n"
	"    description\n"
	"      \"Updated to support NMDA.\";\n"
	"    reference\n"
	"      \"RFC 8343: A YANG Data Model for Interface Management\";\n"
	"  }\n"
	"\n"
	"  revision 2014-05-08 {\n"
	"    description\n"
	"      \"Initial revision.\";\n"
	"    reference\n"
	"      \"RFC 7223: A YANG Data Model for Interface Management\";\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Typedefs\n"
	"   */\n"
	"\n"
	"  typedef interface-ref {\n"
	"    type leafref {\n"
	"      path \"/if:interfaces/if:interface/if:name\";\n"
	"    }\n"
	"    description\n"
	"      \"This type is used by data models that need to reference\n"
	"       interfaces.\";\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Identities\n"
	"   */\n"
	"\n"
	"  identity interface-type {\n"
	"    description\n"
	"      \"Base identity from which specific interface types are\n"
	"       derived.\";\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Features\n"
	"   */\n"
	"\n"
	"  feature arbitrary-names {\n"
	"    description\n"
	"      \"This feature indicates that the device allows user-controlled\n"
	"       interfaces to be named arbitrarily.\";\n"
	"  }\n"
	"  feature pre-provisioning {\n"
	"    description\n"
	"      \"This feature indicates that the device supports\n"
	"       pre-provisioning of interface configuration, i.e., it is\n"
	"       possible to configure an interface whose physical interface\n"
	"       hardware is not present on the device.\";\n"
	"  }\n"
	"  feature if-mib {\n"
	"    description\n"
	"      \"This feature indicates that the device implements\n"
	"       the IF-MIB.\";\n"
	"    reference\n"
	"      \"RFC 2863: The Interfaces Group MIB\";\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Data nodes\n"
	"   */\n"
	"\n"
	"  container interfaces {\n"
	"    description\n"
	"      \"Interface parameters.\";\n"
	"\n"
	"    list interface {\n"
	"      key \"name\";\n"
	"\n"
	"      description\n"
	"        \"The list of interfaces on the device.\n"
	"\n"
	"         The status of an interface is available in this list in the\n"
	"         operational state.  If the configuration of a\n"
	"         system-controlled interface cannot be used by the system\n"
	"         (e.g., the interface hardware present does not match the\n"
	"         interface type), then the configuration is not applied to\n"
	"         the system-controlled interface shown in the operational\n"
	"         state.  If the configuration of a user-controlled interface\n"
	"         cannot be used by the system, the configured interface is\n"
	"         not instantiated in the operational state.\n"
	"\n"
	"         System-controlled interfaces created by the system are\n"
	"         always present in this list in the operational state,\n"
	"         whether or not they are configured.\";\n"
	"\n"
	"     leaf name {\n"
	"        type string;\n"
	"        description\n"
	"          \"The name of the interface.\n"
	"\n"
	"           A device MAY restrict the allowed values for this leaf,\n"
	"           possibly depending on the type of the interface.\n"
	"           For system-controlled interfaces, this leaf is the\n"
	"           device-specific name of the interface.\n"
	"\n"
	"           If a client tries to create configuration for a\n"
	"           system-controlled interface that is not present in the\n"
	"           operational state, the server MAY reject the request if\n"
	"           the implementation does not support pre-provisioning of\n"
	"           interfaces or if the name refers to an interface that can\n"
	"           never exist in the system.  A Network Configuration\n"
	"           Protocol (NETCONF) server MUST reply with an rpc-error\n"
	"           with the error-tag \'invalid-value\' in this case.\n"
	"\n"
	"           If the device supports pre-provisioning of interface\n"
	"           configuration, the \'pre-provisioning\' feature is\n"
	"           advertised.\n"
	"\n"
	"           If the device allows arbitrarily named user-controlled\n"
	"           interfaces, the \'arbitrary-names\' feature is advertised.\n"
	"\n"
	"           When a configured user-controlled interface is created by\n"
	"           the system, it is instantiated with the same name in the\n"
	"           operational state.\n"
	"\n"
	"           A server implementation MAY map this leaf to the ifName\n"
	"           MIB object.  Such an implementation needs to use some\n"
	"           mechanism to handle the differences in size and characters\n"
	"           allowed between this leaf and ifName.  The definition of\n"
	"           such a mechanism is outside the scope of this document.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifName\";\n"
	"      }\n"
	"\n"
	"      leaf description {\n"
	"        type string;\n"
	"        description\n"
	"          \"A textual description of the interface.\n"
	"\n"
	"           A server implementation MAY map this leaf to the ifAlias\n"
	"           MIB object.  Such an implementation needs to use some\n"
	"           mechanism to handle the differences in size and characters\n"
	"           allowed between this leaf and ifAlias.  The definition of\n"
	"           such a mechanism is outside the scope of this document.\n"
	"\n"
	"           Since ifAlias is defined to be stored in non-volatile\n"
	"           storage, the MIB implementation MUST map ifAlias to the\n"
	"           value of \'description\' in the persistently stored\n"
	"           configuration.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifAlias\";\n"
	"      }\n"
	"\n"
	"      leaf type {\n"
	"        type identityref {\n"
	"          base interface-type;\n"
	"        }\n"
	"        mandatory true;\n"
	"        description\n"
	"          \"The type of the interface.\n"
	"\n"
	"           When an interface entry is created, a server MAY\n"
	"           initialize the type leaf with a valid value, e.g., if it\n"
	"           is possible to derive the type from the name of the\n"
	"           interface.\n"
	"\n"
	"           If a client tries to set the type of an interface to a\n"
	"           value that can never be used by the system, e.g., if the\n"
	"           type is not supported or if the type does not match the\n"
	"           name of the interface, the server MUST reject the request.\n"
	"           A NETCONF server MUST reply with an rpc-error with the\n"
	"           error-tag \'invalid-value\' in this case.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifType\";\n"
	"      }\n"
	"\n"
	"      leaf enabled {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"This leaf contains the configured, desired state of the\n"
	"           interface.\n"
	"\n"
	"           Systems that implement the IF-MIB use the value of this\n"
	"           leaf in the intended configuration to set\n"
	"           IF-MIB.ifAdminStatus to \'up\' or \'down\' after an ifEntry\n"
	"           has been initialized, as described in RFC 2863.\n"
	"\n"
	"           Changes in this leaf in the intended configuration are\n"
	"           reflected in ifAdminStatus.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifAdminStatus\";\n"
	"      }\n"
	"\n"
	"      leaf link-up-down-trap-enable {\n"
	"        if-feature if-mib;\n"
	"        type enumeration {\n"
	"          enum enabled {\n"
	"            value 1;\n"
	"            description\n"
	"              \"The device will generate linkUp/linkDown SNMP\n"
	"               notifications for this interface.\";\n"
	"          }\n"
	"          enum disabled {\n"
	"            value 2;\n"
	"            description\n"
	"              \"The device will not generate linkUp/linkDown SNMP\n"
	"               notifications for this interface.\";\n"
	"          }\n"
	"        }\n"
	"        description\n"
	"          \"Controls whether linkUp/linkDown SNMP notifications\n"
	"           should be generated for this interface.\n"
	"\n"
	"           If this node is not configured, the value \'enabled\' is\n"
	"           operationally used by the server for interfaces that do\n"
	"           not operate on top of any other interface (i.e., there are\n"
	"           no \'lower-layer-if\' entries), and \'disabled\' otherwise.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB -\n"
	"                     ifLinkUpDownTrapEnable\";\n"
	"      }\n"
	"\n"
	"      leaf admin-status {\n"
	"        if-feature if-mib;\n"
	"        type enumeration {\n"
	"          enum up {\n"
	"            value 1;\n"
	"            description\n"
	"              \"Ready to pass packets.\";\n"
	"          }\n"
	"          enum down {\n"
	"            value 2;\n"
	"            description\n"
	"              \"Not ready to pass packets and not in some test mode.\";\n"
	"          }\n"
	"          enum testing {\n"
	"            value 3;\n"
	"            description\n"
	"              \"In some test mode.\";\n"
	"          }\n"
	"        }\n"
	"        config false;\n"
	"        mandatory true;\n"
	"        description\n"
	"          \"The desired state of the interface.\n"
	"\n"
	"           This leaf has the same read semantics as ifAdminStatus.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifAdminStatus\";\n"
	"      }\n"
	"\n"
	"      leaf oper-status {\n"
	"        type enumeration {\n"
	"          enum up {\n"
	"            value 1;\n"
	"            description\n"
	"              \"Ready to pass packets.\";\n"
	"          }\n"
	"          enum down {\n"
	"            value 2;\n"
	"\n"
	"            description\n"
	"              \"The interface does not pass any packets.\";\n"
	"          }\n"
	"          enum testing {\n"
	"            value 3;\n"
	"            description\n"
	"              \"In some test mode.  No operational packets can\n"
	"               be passed.\";\n"
	"          }\n"
	"          enum unknown {\n"
	"            value 4;\n"
	"            description\n"
	"              \"Status cannot be determined for some reason.\";\n"
	"          }\n"
	"          enum dormant {\n"
	"            value 5;\n"
	"            description\n"
	"              \"Waiting for some external event.\";\n"
	"          }\n"
	"          enum not-present {\n"
	"            value 6;\n"
	"            description\n"
	"              \"Some component (typically hardware) is missing.\";\n"
	"          }\n"
	"          enum lower-layer-down {\n"
	"            value 7;\n"
	"            description\n"
	"              \"Down due to state of lower-layer interface(s).\";\n"
	"          }\n"
	"        }\n"
	"        config false;\n"
	"        mandatory true;\n"
	"        description\n"
	"          \"The current operational state of the interface.\n"
	"\n"
	"           This leaf has the same semantics as ifOperStatus.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifOperStatus\";\n"
	"      }\n"
	"\n"
	"      leaf last-change {\n"
	"        type yang:date-and-time;\n"
	"        config false;\n"
	"        description\n"
	"          \"The time the interface entered its current operational\n"
	"           state.  If the current state was entered prior to the\n"
	"           last re-initialization of the local network management\n"
	"           subsystem, then this node is not present.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifLastChange\";\n"
	"      }\n"
	"\n"
	"      leaf if-index {\n"
	"        if-feature if-mib;\n"
	"        type int32 {\n"
	"          range \"1..2147483647\";\n"
	"        }\n"
	"        config false;\n"
	"        mandatory true;\n"
	"        description\n"
	"          \"The ifIndex value for the ifEntry represented by this\n"
	"           interface.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifIndex\";\n"
	"      }\n"
	"\n"
	"      leaf phys-address {\n"
	"        type yang:phys-address;\n"
	"        config false;\n"
	"        description\n"
	"          \"The interface\'s address at its protocol sub-layer.  For\n"
	"           example, for an 802.x interface, this object normally\n"
	"           contains a Media Access Control (MAC) address.  The\n"
	"           interface\'s media-specific modules must define the bit\n"
	"           and byte ordering and the format of the value of this\n"
	"           object.  For interfaces that do not have such an address\n"
	"           (e.g., a serial line), this node is not present.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifPhysAddress\";\n"
	"      }\n"
	"\n"
	"      leaf-list higher-layer-if {\n"
	"        type interface-ref;\n"
	"        config false;\n"
	"        description\n"
	"          \"A list of references to interfaces layered on top of this\n"
	"           interface.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifStackTable\";\n"
	"      }\n"
	"\n"
	"      leaf-list lower-layer-if {\n"
	"        type interface-ref;\n"
	"        config false;\n"
	"\n"
	"        description\n"
	"          \"A list of references to interfaces layered underneath this\n"
	"           interface.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifStackTable\";\n"
	"      }\n"
	"\n"
	"      leaf speed {\n"
	"        type yang:gauge64;\n"
	"        units \"bits/second\";\n"
	"        config false;\n"
	"        description\n"
	"            \"An estimate of the interface\'s current bandwidth in bits\n"
	"             per second.  For interfaces that do not vary in\n"
	"             bandwidth or for those where no accurate estimation can\n"
	"             be made, this node should contain the nominal bandwidth.\n"
	"             For interfaces that have no concept of bandwidth, this\n"
	"             node is not present.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB -\n"
	"                     ifSpeed, ifHighSpeed\";\n"
	"      }\n"
	"\n"
	"      container statistics {\n"
	"        config false;\n"
	"        description\n"
	"          \"A collection of interface-related statistics objects.\";\n"
	"\n"
	"        leaf discontinuity-time {\n"
	"          type yang:date-and-time;\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"The time on the most recent occasion at which any one or\n"
	"             more of this interface\'s counters suffered a\n"
	"             discontinuity.  If no such discontinuities have occurred\n"
	"             since the last re-initialization of the local management\n"
	"             subsystem, then this node contains the time the local\n"
	"             management subsystem re-initialized itself.\";\n"
	"        }\n"
	"\n"
	"        leaf in-octets {\n"
	"          type yang:counter64;\n"
	"          description\n"
	"            \"The total number of octets received on the interface,\n"
	"             including framing characters.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifHCInOctets\";\n"
	"        }\n"
	"\n"
	"        leaf in-unicast-pkts {\n"
	"          type yang:counter64;\n"
	"          description\n"
	"            \"The number of packets, delivered by this sub-layer to a\n"
	"             higher (sub-)layer, that were not addressed to a\n"
	"             multicast or broadcast address at this sub-layer.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifHCInUcastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf in-broadcast-pkts {\n"
	"          type yang:counter64;\n"
	"          description\n"
	"            \"The number of packets, delivered by this sub-layer to a\n"
	"             higher (sub-)layer, that were addressed to a broadcast\n"
	"             address at this sub-layer.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB -\n"
	"                       ifHCInBroadcastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf in-multicast-pkts {\n"
	"          type yang:counter64;\n"
	"          description\n"
	"            \"The number of packets, delivered by this sub-layer to a\n"
	"             higher (sub-)layer, that were addressed to a multicast\n"
	"             address at this sub-layer.  For a MAC-layer protocol,\n"
	"             this includes both Group and Functional addresses.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB -\n"
	"                       ifHCInMulticastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf in-discards {\n"
	"          type yang:counter32;\n"
	"          description\n"
	"            \"The number of inbound packets that were chosen to be\n"
	"             discarded even though no errors had been detected to\n"
	"             prevent their being deliverable to a higher-layer\n"
	"             protocol.  One possible reason for discarding such a\n"
	"             packet could be to free up buffer space.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifInDiscards\";\n"
	"        }\n"
	"\n"
	"        leaf in-errors {\n"
	"          type yang:counter32;\n"
	"          description\n"
	"            \"For packet-oriented interfaces, the number of inbound\n"
	"             packets that contained errors preventing them from being\n"
	"             deliverable to a higher-layer protocol.  For character-\n"
	"             oriented or fixed-length interfaces, the number of\n"
	"             inbound transmission units that contained errors\n"
	"             preventing them from being deliverable to a higher-layer\n"
	"             protocol.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifInErrors\";\n"
	"        }\n"
	"\n"
	"        leaf in-unknown-protos {\n"
	"          type yang:counter32;\n"
	"\n"
	"          description\n"
	"            \"For packet-oriented interfaces, the number of packets\n"
	"             received via the interface that were discarded because\n"
	"             of an unknown or unsupported protocol.  For\n"
	"             character-oriented or fixed-length interfaces that\n"
	"             support protocol multiplexing, the number of\n"
	"             transmission units received via the interface that were\n"
	"             discarded because of an unknown or unsupported protocol.\n"
	"             For any interface that does not support protocol\n"
	"             multiplexing, this counter is not present.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifInUnknownProtos\";\n"
	"        }\n"
	"\n"
	"        leaf out-octets {\n"
	"          type yang:counter64;\n"
	"          description\n"
	"            \"The total number of octets transmitted out of the\n"
	"             interface, including framing characters.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifHCOutOctets\";\n"
	"        }\n"
	"\n"
	"        leaf out-unicast-pkts {\n"
	"          type yang:counter64;\n"
	"          description\n"
	"            \"The total number of packets that higher-level protocols\n"
	"             requested be transmitted and that were not addressed\n"
	"             to a multicast or broadcast address at this sub-layer,\n"
	"             including those that were discarded or not sent.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifHCOutUcastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf out-broadcast-pkts {\n"
	"          type yang:counter64;\n"
	"          description\n"
	"            \"The total number of packets that higher-level protocols\n"
	"             requested be transmitted and that were addressed to a\n"
	"             broadcast address at this sub-layer, including those\n"
	"             that were discarded or not sent.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB -\n"
	"                       ifHCOutBroadcastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf out-multicast-pkts {\n"
	"          type yang:counter64;\n"
	"          description\n"
	"            \"The total number of packets that higher-level protocols\n"
	"             requested be transmitted and that were addressed to a\n"
	"             multicast address at this sub-layer, including those\n"
	"             that were discarded or not sent.  For a MAC-layer\n"
	"             protocol, this includes both Group and Functional\n"
	"             addresses.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB -\n"
	"                       ifHCOutMulticastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf out-discards {\n"
	"          type yang:counter32;\n"
	"          description\n"
	"            \"The number of outbound packets that were chosen to be\n"
	"             discarded even though no errors had been detected to\n"
	"             prevent their being transmitted.  One possible reason\n"
	"             for discarding such a packet could be to free up buffer\n"
	"             space.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifOutDiscards\";\n"
	"        }\n"
	"\n"
	"        leaf out-errors {\n"
	"          type yang:counter32;\n"
	"          description\n"
	"            \"For packet-oriented interfaces, the number of outbound\n"
	"             packets that could not be transmitted because of errors.\n"
	"             For character-oriented or fixed-length interfaces, the\n"
	"             number of outbound transmission units that could not be\n"
	"             transmitted because of errors.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifOutErrors\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"    }\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Legacy typedefs\n"
	"   */\n"
	"\n"
	"  typedef interface-state-ref {\n"
	"    type leafref {\n"
	"      path \"/if:interfaces-state/if:interface/if:name\";\n"
	"    }\n"
	"    status deprecated;\n"
	"    description\n"
	"      \"This type is used by data models that need to reference\n"
	"       the operationally present interfaces.\";\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Legacy operational state data nodes\n"
	"   */\n"
	"\n"
	"  container interfaces-state {\n"
	"    config false;\n"
	"    status deprecated;\n"
	"    description\n"
	"      \"Data nodes for the operational state of interfaces.\";\n"
	"\n"
	"    list interface {\n"
	"      key \"name\";\n"
	"      status deprecated;\n"
	"\n"
	"      description\n"
	"        \"The list of interfaces on the device.\n"
	"\n"
	"         System-controlled interfaces created by the system are\n"
	"         always present in this list, whether or not they are\n"
	"         configured.\";\n"
	"\n"
	"      leaf name {\n"
	"        type string;\n"
	"        status deprecated;\n"
	"        description\n"
	"          \"The name of the interface.\n"
	"\n"
	"           A server implementation MAY map this leaf to the ifName\n"
	"           MIB object.  Such an implementation needs to use some\n"
	"           mechanism to handle the differences in size and characters\n"
	"           allowed between this leaf and ifName.  The definition of\n"
	"           such a mechanism is outside the scope of this document.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifName\";\n"
	"      }\n"
	"\n"
	"      leaf type {\n"
	"        type identityref {\n"
	"          base interface-type;\n"
	"        }\n"
	"        mandatory true;\n"
	"        status deprecated;\n"
	"        description\n"
	"          \"The type of the interface.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifType\";\n"
	"      }\n"
	"\n"
	"      leaf admin-status {\n"
	"        if-feature if-mib;\n"
	"        type enumeration {\n"
	"          enum up {\n"
	"            value 1;\n"
	"            description\n"
	"              \"Ready to pass packets.\";\n"
	"          }\n"
	"          enum down {\n"
	"            value 2;\n"
	"            description\n"
	"              \"Not ready to pass packets and not in some test mode.\";\n"
	"          }\n"
	"          enum testing {\n"
	"            value 3;\n"
	"            description\n"
	"              \"In some test mode.\";\n"
	"          }\n"
	"        }\n"
	"        mandatory true;\n"
	"        status deprecated;\n"
	"        description\n"
	"          \"The desired state of the interface.\n"
	"\n"
	"           This leaf has the same read semantics as ifAdminStatus.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifAdminStatus\";\n"
	"      }\n"
	"\n"
	"      leaf oper-status {\n"
	"        type enumeration {\n"
	"          enum up {\n"
	"            value 1;\n"
	"            description\n"
	"              \"Ready to pass packets.\";\n"
	"          }\n"
	"          enum down {\n"
	"            value 2;\n"
	"            description\n"
	"              \"The interface does not pass any packets.\";\n"
	"          }\n"
	"          enum testing {\n"
	"            value 3;\n"
	"            description\n"
	"              \"In some test mode.  No operational packets can\n"
	"               be passed.\";\n"
	"          }\n"
	"          enum unknown {\n"
	"            value 4;\n"
	"            description\n"
	"              \"Status cannot be determined for some reason.\";\n"
	"          }\n"
	"          enum dormant {\n"
	"            value 5;\n"
	"            description\n"
	"              \"Waiting for some external event.\";\n"
	"          }\n"
	"          enum not-present {\n"
	"            value 6;\n"
	"            description\n"
	"              \"Some component (typically hardware) is missing.\";\n"
	"          }\n"
	"          enum lower-layer-down {\n"
	"            value 7;\n"
	"            description\n"
	"              \"Down due to state of lower-layer interface(s).\";\n"
	"          }\n"
	"        }\n"
	"        mandatory true;\n"
	"        status deprecated;\n"
	"        description\n"
	"          \"The current operational state of the interface.\n"
	"\n"
	"           This leaf has the same semantics as ifOperStatus.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifOperStatus\";\n"
	"      }\n"
	"\n"
	"      leaf last-change {\n"
	"        type yang:date-and-time;\n"
	"        status deprecated;\n"
	"        description\n"
	"          \"The time the interface entered its current operational\n"
	"           state.  If the current state was entered prior to the\n"
	"           last re-initialization of the local network management\n"
	"           subsystem, then this node is not present.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifLastChange\";\n"
	"      }\n"
	"\n"
	"      leaf if-index {\n"
	"        if-feature if-mib;\n"
	"        type int32 {\n"
	"          range \"1..2147483647\";\n"
	"        }\n"
	"        mandatory true;\n"
	"        status deprecated;\n"
	"        description\n"
	"          \"The ifIndex value for the ifEntry represented by this\n"
	"           interface.\";\n"
	"\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifIndex\";\n"
	"      }\n"
	"\n"
	"      leaf phys-address {\n"
	"        type yang:phys-address;\n"
	"        status deprecated;\n"
	"        description\n"
	"          \"The interface\'s address at its protocol sub-layer.  For\n"
	"           example, for an 802.x interface, this object normally\n"
	"           contains a Media Access Control (MAC) address.  The\n"
	"           interface\'s media-specific modules must define the bit\n"
	"           and byte ordering and the format of the value of this\n"
	"           object.  For interfaces that do not have such an address\n"
	"           (e.g., a serial line), this node is not present.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifPhysAddress\";\n"
	"      }\n"
	"\n"
	"      leaf-list higher-layer-if {\n"
	"        type interface-state-ref;\n"
	"        status deprecated;\n"
	"        description\n"
	"          \"A list of references to interfaces layered on top of this\n"
	"           interface.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifStackTable\";\n"
	"      }\n"
	"\n"
	"      leaf-list lower-layer-if {\n"
	"        type interface-state-ref;\n"
	"        status deprecated;\n"
	"        description\n"
	"          \"A list of references to interfaces layered underneath this\n"
	"           interface.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB - ifStackTable\";\n"
	"      }\n"
	"\n"
	"      leaf speed {\n"
	"        type yang:gauge64;\n"
	"        units \"bits/second\";\n"
	"        status deprecated;\n"
	"        description\n"
	"            \"An estimate of the interface\'s current bandwidth in bits\n"
	"             per second.  For interfaces that do not vary in\n"
	"             bandwidth or for those where no accurate estimation can\n"
	"\n"
	"             be made, this node should contain the nominal bandwidth.\n"
	"             For interfaces that have no concept of bandwidth, this\n"
	"             node is not present.\";\n"
	"        reference\n"
	"          \"RFC 2863: The Interfaces Group MIB -\n"
	"                     ifSpeed, ifHighSpeed\";\n"
	"      }\n"
	"\n"
	"      container statistics {\n"
	"        status deprecated;\n"
	"        description\n"
	"          \"A collection of interface-related statistics objects.\";\n"
	"\n"
	"        leaf discontinuity-time {\n"
	"          type yang:date-and-time;\n"
	"          mandatory true;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"The time on the most recent occasion at which any one or\n"
	"             more of this interface\'s counters suffered a\n"
	"             discontinuity.  If no such discontinuities have occurred\n"
	"             since the last re-initialization of the local management\n"
	"             subsystem, then this node contains the time the local\n"
	"             management subsystem re-initialized itself.\";\n"
	"        }\n"
	"\n"
	"        leaf in-octets {\n"
	"          type yang:counter64;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"The total number of octets received on the interface,\n"
	"             including framing characters.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifHCInOctets\";\n"
	"        }\n"
	"\n"
	"        leaf in-unicast-pkts {\n"
	"          type yang:counter64;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"The number of packets, delivered by this sub-layer to a\n"
	"             higher (sub-)layer, that were not addressed to a\n"
	"             multicast or broadcast address at this sub-layer.\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifHCInUcastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf in-broadcast-pkts {\n"
	"          type yang:counter64;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"The number of packets, delivered by this sub-layer to a\n"
	"             higher (sub-)layer, that were addressed to a broadcast\n"
	"             address at this sub-layer.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB -\n"
	"                       ifHCInBroadcastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf in-multicast-pkts {\n"
	"          type yang:counter64;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"The number of packets, delivered by this sub-layer to a\n"
	"             higher (sub-)layer, that were addressed to a multicast\n"
	"             address at this sub-layer.  For a MAC-layer protocol,\n"
	"             this includes both Group and Functional addresses.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB -\n"
	"                       ifHCInMulticastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf in-discards {\n"
	"          type yang:counter32;\n"
	"          status deprecated;\n"
	"\n"
	"          description\n"
	"            \"The number of inbound packets that were chosen to be\n"
	"             discarded even though no errors had been detected to\n"
	"             prevent their being deliverable to a higher-layer\n"
	"             protocol.  One possible reason for discarding such a\n"
	"             packet could be to free up buffer space.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifInDiscards\";\n"
	"        }\n"
	"\n"
	"        leaf in-errors {\n"
	"          type yang:counter32;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"For packet-oriented interfaces, the number of inbound\n"
	"             packets that contained errors preventing them from being\n"
	"             deliverable to a higher-layer protocol.  For character-\n"
	"             oriented or fixed-length interfaces, the number of\n"
	"             inbound transmission units that contained errors\n"
	"             preventing them from being deliverable to a higher-layer\n"
	"             protocol.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifInErrors\";\n"
	"        }\n"
	"\n"
	"        leaf in-unknown-protos {\n"
	"          type yang:counter32;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"For packet-oriented interfaces, the number of packets\n"
	"             received via the interface that were discarded because\n"
	"             of an unknown or unsupported protocol.  For\n"
	"             character-oriented or fixed-length interfaces that\n"
	"             support protocol multiplexing, the number of\n"
	"             transmission units received via the interface that were\n"
	"             discarded because of an unknown or unsupported protocol.\n"
	"             For any interface that does not support protocol\n"
	"             multiplexing, this counter is not present.\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifInUnknownProtos\";\n"
	"        }\n"
	"\n"
	"        leaf out-octets {\n"
	"          type yang:counter64;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"The total number of octets transmitted out of the\n"
	"             interface, including framing characters.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifHCOutOctets\";\n"
	"        }\n"
	"\n"
	"        leaf out-unicast-pkts {\n"
	"          type yang:counter64;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"The total number of packets that higher-level protocols\n"
	"             requested be transmitted and that were not addressed\n"
	"             to a multicast or broadcast address at this sub-layer,\n"
	"             including those that were discarded or not sent.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifHCOutUcastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf out-broadcast-pkts {\n"
	"          type yang:counter64;\n"
	"          status deprecated;\n"
	"\n"
	"          description\n"
	"            \"The total number of packets that higher-level protocols\n"
	"             requested be transmitted and that were addressed to a\n"
	"             broadcast address at this sub-layer, including those\n"
	"             that were discarded or not sent.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB -\n"
	"                       ifHCOutBroadcastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf out-multicast-pkts {\n"
	"          type yang:counter64;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"The total number of packets that higher-level protocols\n"
	"             requested be transmitted and that were addressed to a\n"
	"             multicast address at this sub-layer, including those\n"
	"             that were discarded or not sent.  For a MAC-layer\n"
	"             protocol, this includes both Group and Functional\n"
	"             addresses.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB -\n"
	"                       ifHCOutMulticastPkts\";\n"
	"        }\n"
	"\n"
	"        leaf out-discards {\n"
	"          type yang:counter32;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"The number of outbound packets that were chosen to be\n"
	"             discarded even though no errors had been detected to\n"
	"             prevent their being transmitted.  One possible reason\n"
	"             for discarding such a packet could be to free up buffer\n"
	"             space.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifOutDiscards\";\n"
	"        }\n"
	"\n"
	"        leaf out-errors {\n"
	"          type yang:counter32;\n"
	"          status deprecated;\n"
	"          description\n"
	"            \"For packet-oriented interfaces, the number of outbound\n"
	"             packets that could not be transmitted because of errors.\n"
	"             For character-oriented or fixed-length interfaces, the\n"
	"             number of outbound transmission units that could not be\n"
	"             transmitted because of errors.\n"
	"\n"
	"             Discontinuities in the value of this counter can occur\n"
	"             at re-initialization of the management system and at\n"
	"             other times as indicated by the value of\n"
	"             \'discontinuity-time\'.\";\n"
	"          reference\n"
	"            \"RFC 2863: The Interfaces Group MIB - ifOutErrors\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "ietf-interfaces",
	.mod_rev = "2018-02-20",
	.sub_mod_name = "",
	.sub_mod_rev = "",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
