/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"// SPDX-License-Identifier: BSD-2-Clause\n"
	"module frr-zebra {\n"
	"  yang-version 1.1;\n"
	"  namespace \"http://frrouting.org/yang/zebra\";\n"
	"  prefix frr-zebra;\n"
	"\n"
	"  import ietf-yang-types {\n"
	"    prefix yang;\n"
	"  }\n"
	"\n"
	"  import ietf-inet-types {\n"
	"    prefix inet;\n"
	"  }\n"
	"\n"
	"  import frr-affinity-map {\n"
	"    prefix frr-affinity-map;\n"
	"  }\n"
	"\n"
	"  import frr-route-map {\n"
	"    prefix frr-route-map;\n"
	"  }\n"
	"\n"
	"  import frr-route-types {\n"
	"    prefix frr-route-types;\n"
	"  }\n"
	"\n"
	"  import ietf-routing-types {\n"
	"    prefix rt-types;\n"
	"  }\n"
	"\n"
	"  import frr-nexthop {\n"
	"    prefix frr-nh;\n"
	"  }\n"
	"\n"
	"  import frr-routing {\n"
	"    prefix frr-rt;\n"
	"  }\n"
	"\n"
	"  import frr-interface {\n"
	"    prefix frr-interface;\n"
	"  }\n"
	"\n"
	"  import frr-vrf {\n"
	"    prefix frr-vrf;\n"
	"  }\n"
	"\n"
	"  organization\n"
	"    \"FRRouting\";\n"
	"  contact\n"
	"    \"FRR Users List: <mailto:frog@lists.frrouting.org>\n"
	"     FRR Development List: <mailto:dev@lists.frrouting.org>\";\n"
	"  description\n"
	"    \"This module defines a model for managing the FRR zebra daemon.\n"
	"\n"
	"     Copyright 2020 FRRouting\n"
	"\n"
	"     Redistribution and use in source and binary forms, with or without\n"
	"     modification, are permitted provided that the following conditions\n"
	"     are met:\n"
	"\n"
	"     1. Redistributions of source code must retain the above copyright notice,\n"
	"     this list of conditions and the following disclaimer.\n"
	"\n"
	"     2. Redistributions in binary form must reproduce the above copyright\n"
	"     notice, this list of conditions and the following disclaimer in the\n"
	"     documentation and/or other materials provided with the distribution.\n"
	"\n"
	"     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
	"     \\\"AS IS\\\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
	"     LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
	"     A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n"
	"     HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
	"     SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
	"     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
	"     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
	"     THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
	"     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
	"     OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\";\n"
	"\n"
	"  revision 2019-06-01 {\n"
	"    description\n"
	"      \"Initial revision.\";\n"
	"\n"
	"    reference\n"
	"      \"FRRouting\";\n"
	"  }\n"
	"\n"
	"  feature ipv6-router-advertisements {\n"
	"    description\n"
	"      \"Support for IPv6 Router Advertisements.\";\n"
	"  }\n"
	"\n"
	"  feature ptm-bfd {\n"
	"    description\n"
	"      \"Using an external PTM daemon that implements BFD.\";\n"
	"  }\n"
	"\n"
	"  typedef unix-timestamp {\n"
	"    type uint32;\n"
	"    units \"seconds\";\n"
	"    description\n"
	"      \"An absolute time in seconds since the unix epoch.\";\n"
	"  }\n"
	"\n"
	"  identity zebra-interface-type {\n"
	"    description\n"
	"      \"zebra interface type.\";\n"
	"  }\n"
	"\n"
	"  identity zif-other {\n"
	"    base zebra-interface-type;\n"
	"    description\n"
	"      \"Zebra interface type other.\";\n"
	"  }\n"
	"\n"
	"  identity zif-bridge {\n"
	"    base zebra-interface-type;\n"
	"    description\n"
	"      \"Zebra interface type bridge.\";\n"
	"  }\n"
	"\n"
	"  identity zif-vlan {\n"
	"    base zebra-interface-type;\n"
	"    description\n"
	"      \"Zebra interface type vlan.\";\n"
	"  }\n"
	"\n"
	"  identity zif-vxlan {\n"
	"    base zebra-interface-type;\n"
	"    description\n"
	"      \"Zebra interface type vxlan.\";\n"
	"  }\n"
	"\n"
	"  identity zif-vrf {\n"
	"    base zebra-interface-type;\n"
	"    description\n"
	"      \"Zebra interface type vrf.\";\n"
	"  }\n"
	"\n"
	"  identity zif-veth {\n"
	"    base zebra-interface-type;\n"
	"    description\n"
	"      \"Zebra interface type veth.\";\n"
	"  }\n"
	"\n"
	"  identity zif-bond {\n"
	"    base zebra-interface-type;\n"
	"    description\n"
	"      \"Zebra interface type bond.\";\n"
	"  }\n"
	"\n"
	"  identity zif-macvlan {\n"
	"    base zebra-interface-type;\n"
	"    description\n"
	"      \"Zebra interface type macvlan.\";\n"
	"  }\n"
	"\n"
	"  identity zif-gre {\n"
	"    base zebra-interface-type;\n"
	"    description\n"
	"      \"Zebra interface type gre.\";\n"
	"  }\n"
	"\n"
	"  identity zif-dummy {\n"
	"    base zebra-interface-type;\n"
	"    description\n"
	"      \"Zebra interface type dummy.\";\n"
	"  }\n"
	"\n"
	"  // End of ip6-route\n"
	"  /*\n"
	"   * VxLAN Network Identifier type\n"
	"   */\n"
	"\n"
	"  typedef vni-id-type {\n"
	"    type uint32 {\n"
	"      range \"0..16777215\";\n"
	"    }\n"
	"    description\n"
	"      \"A VxLAN network identifier value.\";\n"
	"  }\n"
	"\n"
	"  typedef vni-vtep-flood-type {\n"
	"    type enumeration {\n"
	"      enum \"head-end-repl\" {\n"
	"        value 0;\n"
	"        description\n"
	"          \"Head-end replication.\";\n"
	"      }\n"
	"      enum \"disabled\" {\n"
	"        value 1;\n"
	"        description\n"
	"          \"Flooding disabled.\";\n"
	"      }\n"
	"      enum \"pim-sm\" {\n"
	"        value 2;\n"
	"        description\n"
	"          \"Multicast PIM-SM.\";\n"
	"      }\n"
	"    }\n"
	"    description\n"
	"      \"Type for VTEP flood type.\";\n"
	"  }\n"
	"\n"
	"  /* PREF64 only accepts specific prefix lengths */\n"
	"  typedef pref64-prefix {\n"
	"    type inet:ipv6-prefix {\n"
	"      /* rely on inet:ipv6-prefix enforcing validity already */\n"
	"      pattern \'.*/(96|64|56|48|40|32)\';\n"
	"    }\n"
	"    description\n"
	"      \"An IPv6 prefix suitable for PREF64 announcement\";\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Common route data, shared by v4 and v6 routes.\n"
	"   */\n"
	"\n"
	"  grouping route-common {\n"
	"    description\n"
	"      \"Common information about a route.\";\n"
	"\n"
	"    leaf distance {\n"
	"      type uint8;\n"
	"      description\n"
	"        \"Admin distance based on routing protocol.\";\n"
	"    }\n"
	"\n"
	"    leaf metric {\n"
	"      type uint32;\n"
	"      description\n"
	"        \"Route metric value.\";\n"
	"    }\n"
	"\n"
	"    leaf tag {\n"
	"      type uint32 {\n"
	"        range \"1..4294967295\";\n"
	"      }\n"
	"      description\n"
	"        \"Route tag value.\";\n"
	"    }\n"
	"\n"
	"    leaf selected {\n"
	"      type empty;\n"
	"      description\n"
	"        \"Route is the selected or preferred route for the prefix.\";\n"
	"    }\n"
	"\n"
	"    leaf installed {\n"
	"      type empty;\n"
	"      description\n"
	"        \"Route is installed in the FIB.\";\n"
	"    }\n"
	"\n"
	"    leaf failed {\n"
	"      type empty;\n"
	"      description\n"
	"        \"Route installation in FIB has failed.\";\n"
	"    }\n"
	"\n"
	"    leaf queued {\n"
	"      type empty;\n"
	"      description\n"
	"        \"Route has a pending FIB operation that has not completed.\";\n"
	"    }\n"
	"\n"
	"    leaf internal-flags {\n"
	"      type int32;\n"
	"      description\n"
	"        \"Internal flags for the route.\";\n"
	"    }\n"
	"\n"
	"    leaf internal-status {\n"
	"      type int32;\n"
	"      description\n"
	"        \"Internal status for the route.\";\n"
	"    }\n"
	"\n"
	"    leaf uptime {\n"
	"      type yang:date-and-time;\n"
	"      description\n"
	"        \"Uptime for the route.\";\n"
	"    }\n"
	"\n"
	"    uses frr-nh:frr-nexthop-group-operational;\n"
	"  }\n"
	"\n"
	"  // End of route-common\n"
	"  /*\n"
	"   * IPv4 Route object.\n"
	"   */\n"
	"\n"
	"  grouping ip4-route {\n"
	"    description\n"
	"      \"An IPv4 route.\";\n"
	"    leaf prefix {\n"
	"      type inet:ipv4-prefix;\n"
	"      description\n"
	"        \"IP address (in the form A.B.C.D) and prefix length,\n"
	"         separated by the slash (/) character. The range of\n"
	"         values for the prefix-length is 0 to 32.\";\n"
	"    }\n"
	"\n"
	"    leaf protocol {\n"
	"      type frr-route-types:frr-route-types-v4;\n"
	"      description\n"
	"        \"The protocol owning the route.\";\n"
	"    }\n"
	"\n"
	"    uses route-common;\n"
	"  }\n"
	"\n"
	"  // End of ip4-route\n"
	"  /*\n"
	"   * IPv6 Route object.\n"
	"   */\n"
	"\n"
	"  grouping ip6-route {\n"
	"    description\n"
	"      \"An IPv6 route.\";\n"
	"    leaf prefix {\n"
	"      type inet:ipv6-prefix;\n"
	"      description\n"
	"        \"The route\'s IPv6 prefix.\";\n"
	"    }\n"
	"\n"
	"    leaf protocol {\n"
	"      type frr-route-types:frr-route-types-v6;\n"
	"      description\n"
	"        \"The protocol owning the route.\";\n"
	"    }\n"
	"\n"
	"    uses route-common;\n"
	"  }\n"
	"  // End of ip6-route\n"
	"\n"
	"  /*\n"
	"   * Information about EVPN VNIs\n"
	"   */\n"
	"\n"
	"  grouping vni-information {\n"
	"    description\n"
	"      \"Grouping for VNI information.\";\n"
	"\n"
	"    choice type-choice {\n"
	"      description\n"
	"        \"Choice between L2 and L3 VNI information.\";\n"
	"\n"
	"      case l2 {\n"
	"        leaf is-layer2 {\n"
	"          type empty;\n"
	"          description\n"
	"            \"Information about an L2 VNI.\";\n"
	"        }\n"
	"\n"
	"        leaf vtep-count {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"Number of VTEPs.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      case l3 {\n"
	"        leaf is-layer3 {\n"
	"          type empty;\n"
	"          description\n"
	"            \"Information about an L3 VNI.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    leaf vni-id {\n"
	"      type vni-id-type;\n"
	"      description\n"
	"        \"The VNI identifier.\";\n"
	"    }\n"
	"\n"
	"    leaf vxlan-ifname {\n"
	"      type frr-interface:interface-ref;\n"
	"      description\n"
	"        \"The VxLAN interface name.\";\n"
	"    }\n"
	"\n"
	"    leaf mac-count {\n"
	"      type uint32;\n"
	"      description\n"
	"        \"Number of valid MACs.\";\n"
	"    }\n"
	"\n"
	"    leaf neighbor-count {\n"
	"      type uint32;\n"
	"      description\n"
	"        \"Number of neighbors.\";\n"
	"    }\n"
	"\n"
	"    leaf vrf {\n"
	"      type frr-vrf:vrf-ref;\n"
	"      description\n"
	"        \"The tenant VRF.\";\n"
	"    }\n"
	"\n"
	"    leaf local-vtep-addr {\n"
	"      type inet:ipv4-address;\n"
	"      description\n"
	"        \"The local VTEP IP address.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Detailed EVPN VNI information for L2.\n"
	"   */\n"
	"\n"
	"  grouping vni-l2-detail {\n"
	"    description\n"
	"      \"Grouping for VNI L2 details.\";\n"
	"\n"
	"    leaf if-index {\n"
	"      type uint32;\n"
	"      description\n"
	"        \"The VxLAN ifindex.\";\n"
	"    }\n"
	"\n"
	"    leaf advertise-gw {\n"
	"      type empty;\n"
	"      description\n"
	"        \"The gateway MAC-IP is being advertised.\";\n"
	"    }\n"
	"\n"
	"    leaf mcast-group {\n"
	"      type rt-types:ipv4-multicast-group-address;\n"
	"      description\n"
	"        \"The VNI multicast group for BUM traffic.\";\n"
	"    }\n"
	"\n"
	"    list remote-vtep-list {\n"
	"      description\n"
	"        \"List of remote VTEPs.\";\n"
	"\n"
	"      leaf remote-vtep {\n"
	"        type inet:ipv4-address;\n"
	"        description\n"
	"          \"The remote VTEP IP address.\";\n"
	"      }\n"
	"\n"
	"      leaf vtep-flood {\n"
	"        type vni-vtep-flood-type;\n"
	"        description\n"
	"          \"VTEP flood type.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Detailed EVPN VNI information for L3.\n"
	"   */\n"
	"\n"
	"  grouping vni-l3-detail {\n"
	"    description\n"
	"      \"Grouping for VNI L3 details.\";\n"
	"\n"
	"    leaf svi-interface {\n"
	"      type frr-interface:interface-ref;\n"
	"      description\n"
	"        \"The SVI interface.\";\n"
	"    }\n"
	"\n"
	"    leaf is-up {\n"
	"      type empty;\n"
	"      description\n"
	"        \"The state is active.\";\n"
	"    }\n"
	"\n"
	"    leaf prefix-only {\n"
	"      type empty;\n"
	"      description\n"
	"        \"Prefix routes only\";\n"
	"    }\n"
	"\n"
	"    leaf router-mac {\n"
	"      type yang:mac-address;\n"
	"      description\n"
	"        \"The VNI Router MAC address.\";\n"
	"    }\n"
	"\n"
	"    list vni-list {\n"
	"      description\n"
	"        \"A list of the associated L2 VNIs.\";\n"
	"      leaf vni-id {\n"
	"        type vni-id-type;\n"
	"        description\n"
	"          \"An L2 VNI identifier.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Debug options\n"
	"   */\n"
	"\n"
	"  grouping zebra-debugs {\n"
	"    description\n"
	"      \"Grouping for Zebra debugging options.\";\n"
	"\n"
	"    leaf debug-events {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug ZAPI events.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-zapi-send {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug ZAPI messages sent.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-zapi-recv {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug ZAPI messages received.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-zapi-detail {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug ZAPI details.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-kernel {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug kernel events.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-kernel-msg-send {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug kernel messages sent.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-kernel-msg-recv {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug kernel messages received.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-rib {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug RIB processing.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-rib-detail {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug RIB processing details.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-fpm {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug the FIB Push Interface subsystem.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-nht {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug Nexthop-tracking.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-nht-detail {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug Nexthop-tracking details.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-mpls {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug MPLS.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-vxlan {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug VxLAN.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-pw {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug pseudowires.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-dplane {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug the dataplane subsystem.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-dplane-detail {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug dataplane subsystem details.\";\n"
	"    }\n"
	"\n"
	"    leaf debug-mlag {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"Debug MLAG.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping ribs {\n"
	"    description\n"
	"      \"Grouping for RIBs supported by FRR.\";\n"
	"\n"
	"    container ribs {\n"
	"      config false;\n"
	"      description\n"
	"        \"RIBs supported by FRR.\";\n"
	"      list rib {\n"
	"        key \"afi-safi-name table-id\";\n"
	"\n"
	"        description\n"
	"          \"List of RIBs, each with a specific AFI/SAFI name and table ID.\";\n"
	"\n"
	"        leaf afi-safi-name {\n"
	"          type identityref {\n"
	"            base frr-rt:afi-safi-type;\n"
	"          }\n"
	"          description\n"
	"            \"AFI, SAFI name.\";\n"
	"        }\n"
	"\n"
	"        leaf table-id {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"Routing Table id (default id - 254).\";\n"
	"        }\n"
	"\n"
	"        list route {\n"
	"          key \"prefix\";\n"
	"          \n"
	"          description\n"
	"            \"List of routes, each with a specific prefix.\";\n"
	"\n"
	"          leaf prefix {\n"
	"            type inet:ip-prefix;\n"
	"            description\n"
	"              \"The route\'s prefix.\";\n"
	"          }\n"
	"\n"
	"          list route-entry {\n"
	"            key \"protocol\";\n"
	"\n"
	"            description\n"
	"              \"List of route entries, each owned by a specific protocol.\";\n"
	"\n"
	"            leaf protocol {\n"
	"              type frr-route-types:frr-route-types;\n"
	"              description\n"
	"                \"The protocol owning the route.\";\n"
	"            }\n"
	"\n"
	"            leaf instance {\n"
	"              type uint16;\n"
	"              must \"../protocol = \\\"ospf\\\"\";\n"
	"              description\n"
	"                \"Retrieve routes from a specific OSPF instance.\";\n"
	"            }\n"
	"\n"
	"            uses route-common;\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping vrf-vni-mapping {\n"
	"    description\n"
	"      \"EVPN L3-VNI mapping corresponding to a VRF.\";\n"
	"    leaf l3vni-id {\n"
	"      type vni-id-type;\n"
	"      description\n"
	"        \"EVPN L3-VNI id to map to the VRF.\";\n"
	"    }\n"
	"\n"
	"    leaf prefix-only {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"EVPN asymmetric mode advertise prefix routes only.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End of zebra container\n"
	"  /*\n"
	"   * RPCs\n"
	"   */\n"
	"\n"
	"  rpc get-route-information {\n"
	"    description\n"
	"      \"Retrieve IPv4 or IPv6 unicast routes.\";\n"
	"    input {\n"
	"      choice ip-type {\n"
	"        description\n"
	"          \"Choice between retrieving IPv4 routes and retrieving IPv6 routes.\";\n"
	"\n"
	"        case v4 {\n"
	"          leaf ipv4 {\n"
	"            type empty;\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"Retrieve IPv4 routes.\";\n"
	"          }\n"
	"\n"
	"          leaf prefix-v4 {\n"
	"            type inet:ipv4-prefix;\n"
	"            description\n"
	"              \"Retrieve routes matching a specific prefix.\";\n"
	"          }\n"
	"\n"
	"          leaf supernets-only {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Skip routes that are subnets of classful prefix sizes.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case v6 {\n"
	"          leaf ipv6 {\n"
	"            type empty;\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"Retrieve IPv6 routes.\";\n"
	"          }\n"
	"\n"
	"          leaf prefix-v6 {\n"
	"            type inet:ipv6-prefix;\n"
	"            description\n"
	"              \"Retrieve routes matching a specific prefix.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      choice vrf-choice {\n"
	"        description\n"
	"          \"Choice between retrieving routes in a non-default VRF or |\n"
	"           retrieving routes from all VRFs.\";\n"
	"\n"
	"        case single {\n"
	"          leaf vrf {\n"
	"            type frr-vrf:vrf-ref;\n"
	"            description\n"
	"              \"Retrieve routes in a non-default vrf.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case all {\n"
	"          leaf all-vrfs {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Retrieve routes from all vrfs.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      leaf fib-routes {\n"
	"        type empty;\n"
	"        description\n"
	"          \"Retrieve FIB routes rather than RIB routes.\";\n"
	"      }\n"
	"\n"
	"      leaf table-id {\n"
	"        type uint32 {\n"
	"          range \"1..4294967295\";\n"
	"        }\n"
	"        description\n"
	"          \"Routing table id to retrieve.\";\n"
	"      }\n"
	"\n"
	"      leaf protocol {\n"
	"        type frr-route-types:frr-route-types-v4;\n"
	"        description\n"
	"          \"Retrieve routes from a specific protocol daemon.\";\n"
	"      }\n"
	"\n"
	"      leaf ospf-instance {\n"
	"        type uint32 {\n"
	"          range \"1..65535\";\n"
	"        }\n"
	"        must \"../protocol = \\\"ospf\\\"\";\n"
	"        description\n"
	"          \"Retrieve routes from a specific OSPF instance.\";\n"
	"      }\n"
	"\n"
	"      choice detail {\n"
	"        description\n"
	"          \"Choice between including detailed information and |\n"
	"           including summary information only.\";\n"
	"\n"
	"        case det {\n"
	"          leaf include-detail {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Include detailed information.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case summ {\n"
	"          leaf summary {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Include summary information only.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"    // End of input\n"
	"    output {\n"
	"      choice route-list {\n"
	"        description\n"
	"          \"Choice between IPv4 route information and IPv6 route information.\";\n"
	"\n"
	"        case v4 {\n"
	"          container routes-v4 {\n"
	"            description\n"
	"              \"IPv4 route information.\";\n"
	"            list route {\n"
	"              description\n"
	"                \"List of IPv4 routes.\";\n"
	"\n"
	"              uses ip4-route;\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case v6 {\n"
	"          container routes-v6 {\n"
	"            description\n"
	"              \"IPv6 route information.\";\n"
	"            list route {\n"
	"              description\n"
	"                \"List of IPv6 routes.\";\n"
	"\n"
	"              uses ip6-route;\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"    // End of output\n"
	"  }\n"
	"\n"
	"  // End get-route-information\n"
	"\n"
	"  rpc get-v6-mroute-info {\n"
	"    description\n"
	"      \"Retrieve IPv6 multicast routes.\";\n"
	"    input {\n"
	"      choice vrf-choice {\n"
	"        description\n"
	"          \"Choice between retrieving routes in a non-default VRF or |\n"
	"           retrieving routes from all VRFs.\";\n"
	"\n"
	"        case single {\n"
	"          leaf vrf {\n"
	"            type frr-vrf:vrf-ref;\n"
	"            description\n"
	"              \"Retrieve routes in a non-default vrf.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case all {\n"
	"          leaf all-vrfs {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Retrieve routes from all vrfs.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    output {\n"
	"      container routes {\n"
	"        description\n"
	"          \"IPv6 mcast route information.\";\n"
	"        list route {\n"
	"          description\n"
	"            \"List of IPv6 routes.\";\n"
	"\n"
	"          uses ip6-route;\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-v6-mroute-info\n"
	"\n"
	"  rpc get-vrf-info {\n"
	"    description\n"
	"      \"Retrieve VRF information; the default VRF is elided.\";\n"
	"    // Note: no input clause.\n"
	"    output {\n"
	"      list vrf-list {\n"
	"        description\n"
	"          \"List of VRF information including name, user configuration status, |\n"
	"           VRF ID, and VRF type.\";\n"
	"\n"
	"        leaf name {\n"
	"          type frr-vrf:vrf-ref;\n"
	"          description\n"
	"            \"The VRF name\";\n"
	"        }\n"
	"\n"
	"        leaf is-user-config {\n"
	"          type empty;\n"
	"          description\n"
	"            \"The VRF was configured by an admin.\";\n"
	"        }\n"
	"\n"
	"        leaf vrf-id {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"The VRF id.\";\n"
	"        }\n"
	"\n"
	"        choice vrf-type {\n"
	"          description\n"
	"            \"Choice between specifying the VRF as inactive, associated with a net namespace, |\n"
	"             or associated with a table ID.\";\n"
	"\n"
	"          case inactive {\n"
	"            leaf is-inactive {\n"
	"              type empty;\n"
	"              description\n"
	"                \"The VRF is inactive.\";\n"
	"            }\n"
	"          }\n"
	"\n"
	"          case netns {\n"
	"            leaf netns-name {\n"
	"              type string;\n"
	"              description\n"
	"                \"The net namespace name associated with the VRF.\";\n"
	"            }\n"
	"          }\n"
	"\n"
	"          case table {\n"
	"            leaf table-id {\n"
	"              type uint32;\n"
	"              description\n"
	"                \"The table-id associated with the VRF.\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-vrf-info\n"
	"\n"
	"  rpc get-vrf-vni-info {\n"
	"    description\n"
	"      \"Retrieve mappings between EVPN VNI and VRF.\";\n"
	"    // Note: no input clause.\n"
	"    output {\n"
	"      list vrf-vni-list {\n"
	"        description\n"
	"          \"List of VRF VNI information including VRF name, EVPN VNI, VxLAN interface name, |\n"
	"           SVI interface name, router MAC address, and state.\";\n"
	"\n"
	"        leaf vrf-name {\n"
	"          type frr-vrf:vrf-ref;\n"
	"          description\n"
	"            \"The VRF name.\";\n"
	"        }\n"
	"\n"
	"        leaf vni-id {\n"
	"          type vni-id-type;\n"
	"          description\n"
	"            \"The EVPN VNI.\";\n"
	"        }\n"
	"\n"
	"        leaf vxlan-if-name {\n"
	"          type frr-interface:interface-ref;\n"
	"          description\n"
	"            \"The VxLAN interface name.\";\n"
	"        }\n"
	"\n"
	"        leaf svi-if-name {\n"
	"          type frr-interface:interface-ref;\n"
	"          description\n"
	"            \"The SVI interface name.\";\n"
	"        }\n"
	"\n"
	"        leaf router-mac-addr {\n"
	"          type yang:mac-address;\n"
	"          description\n"
	"            \"Router MAC address.\";\n"
	"        }\n"
	"\n"
	"        leaf is-up {\n"
	"          type empty;\n"
	"          description\n"
	"            \"The state is active.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-vrf-vni-info\n"
	"\n"
	"  rpc get-evpn-info {\n"
	"    description\n"
	"      \"Retrieve global information about EVPN.\";\n"
	"    // Note: No input clause.\n"
	"    output {\n"
	"      leaf l2vni-count {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"Number of L2 VNIs.\";\n"
	"      }\n"
	"\n"
	"      leaf l3vni-count {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"Number of L3 VNIs.\";\n"
	"      }\n"
	"\n"
	"      leaf advertise-gateway {\n"
	"        type empty;\n"
	"        description\n"
	"          \"Advertise the gateway MAC-IP.\";\n"
	"      }\n"
	"\n"
	"      leaf advertise-svi {\n"
	"        type empty;\n"
	"        description\n"
	"          \"Advertise SVI MAC-IP.\";\n"
	"      }\n"
	"\n"
	"      leaf dup-detect {\n"
	"        type empty;\n"
	"        description\n"
	"          \"Duplicate address detection is enabled.\";\n"
	"      }\n"
	"\n"
	"      leaf dad-max-moves {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"Maximum moves allowed before address is considered duplicate.\";\n"
	"      }\n"
	"\n"
	"      leaf dad-timeout {\n"
	"        type uint32;\n"
	"        units \"seconds\";\n"
	"        description\n"
	"          \"Duplicate address detection timeout.\";\n"
	"      }\n"
	"\n"
	"      leaf dad-freeze {\n"
	"        type empty;\n"
	"        description\n"
	"          \"Duplicate address detection freeze enabled.\";\n"
	"      }\n"
	"\n"
	"      choice dad-freeze-choice {\n"
	"        description\n"
	"          \"Choice between setting duplicate address detection |\n"
	"           freeze to permanent or specifying a timer.\";\n"
	"\n"
	"        case freeze-permanent {\n"
	"          leaf dad-freeze-perm {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Duplicate address detection freeze is permanent.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case freeze-time {\n"
	"          leaf dad-freeze-time {\n"
	"            type uint32;\n"
	"            units \"seconds\";\n"
	"            description\n"
	"              \"Duplicate address detection freeze timer.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-evpn-info\n"
	"\n"
	"  rpc get-vni-info {\n"
	"    description\n"
	"      \"Retrieve information about EVPN VNIs.\";\n"
	"\n"
	"    // If no vni is specified, retrieve global list.\n"
	"    input {\n"
	"      choice vni-choice {\n"
	"        default \"all-vnis\";\n"
	"        description\n"
	"          \"Choice between retrieving information about all VNIs or a specific EVPN VNI.\";\n"
	"\n"
	"        case all-vnis {\n"
	"          leaf all-vnis {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Retrieve information about all VNIs.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case single-vni {\n"
	"          leaf vni-id {\n"
	"            type vni-id-type;\n"
	"            description\n"
	"              \"Retrieve information about a specific EVPN VNI.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      leaf detailed-info {\n"
	"        type empty;\n"
	"        description\n"
	"          \"Retrieve detailed information.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    output {\n"
	"      list vni-list {\n"
	"        description\n"
	"          \"Information about EVPN VNI objects.\";\n"
	"        uses vni-information;\n"
	"\n"
	"        choice detail-choice {\n"
	"          description\n"
	"            \"Choice between detailed L2 or L3 information.\";\n"
	"\n"
	"          case l2 {\n"
	"            description\n"
	"              \"Detailed L2 information.\";\n"
	"            uses vni-l2-detail;\n"
	"          }\n"
	"\n"
	"          case l3 {\n"
	"            description\n"
	"              \"Detailed L3 information.\";\n"
	"            uses vni-l3-detail;\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-vni-info\n"
	"\n"
	"  rpc get-evpn-vni-rmac {\n"
	"    description\n"
	"      \"Retrieve information about VxLAN VNI RMACs.\";\n"
	"    input {\n"
	"      choice vni-choice {\n"
	"        default \"all-vnis\";\n"
	"        description\n"
	"          \"Choice between retrieving information about all VNIs or |\n"
	"           a specific EVPN VNI and a single RMAC address.\";\n"
	"\n"
	"        case all-vnis {\n"
	"          leaf all-vnis {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Retrieve information about all VNIs.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case single-vni {\n"
	"          leaf vni-id {\n"
	"            type vni-id-type;\n"
	"            description\n"
	"              \"Retrieve information about a specific EVPN VNI.\";\n"
	"          }\n"
	"\n"
	"          leaf vni-rmac {\n"
	"            type yang:mac-address;\n"
	"            description\n"
	"              \"A single RMAC address.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    output {\n"
	"      list rmac-info-list {\n"
	"        description\n"
	"          \"List of RMAC information including RMAC address, remote VTEP IP address, |\n"
	"           refcount, and associated IP prefixes.\";\n"
	"\n"
	"        leaf rmac {\n"
	"          type yang:mac-address;\n"
	"          description\n"
	"            \"The RMAC address.\";\n"
	"        }\n"
	"\n"
	"        leaf remote-vtep {\n"
	"          type inet:ipv4-address;\n"
	"          description\n"
	"            \"The remote VTEP IP address.\";\n"
	"        }\n"
	"\n"
	"        leaf refcount {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"The refcount of the RMAC.\";\n"
	"        }\n"
	"\n"
	"        list prefix-list {\n"
	"          description\n"
	"            \"List of IP prefixes associated with the RMAC.\";\n"
	"\n"
	"          leaf prefix-item {\n"
	"            type inet:ip-prefix;\n"
	"            description\n"
	"              \"IP prefixes associated with the RMAC.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-evpn-vni-rmac\n"
	"\n"
	"  rpc get-evpn-vni-nexthops {\n"
	"    description\n"
	"      \"Retrieve information about EVPN nexthops.\";\n"
	"    input {\n"
	"      choice vni-choice {\n"
	"        default \"all-vnis\";\n"
	"        description\n"
	"          \"Choice between retrieving information about all VNIs or |\n"
	"           a specific EVPN VNI and a single host IP address.\";\n"
	"\n"
	"        case all-vnis {\n"
	"          leaf all-vnis {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Retrieve information about all VNIs.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case single-vni {\n"
	"          leaf vni-id {\n"
	"            type vni-id-type;\n"
	"            description\n"
	"              \"Retrieve information about a specific EVPN VNI.\";\n"
	"          }\n"
	"\n"
	"          leaf vni-ipaddr {\n"
	"            type inet:ip-address;\n"
	"            description\n"
	"              \"A single host IP address (v4 or v6).\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    output {\n"
	"      list nh-info-list {\n"
	"        description\n"
	"          \"List of nexthop information including IP address, MAC address, and refcount.\";\n"
	"\n"
	"        leaf ip-addr {\n"
	"          type inet:ip-address;\n"
	"          description\n"
	"            \"The nexthop IP address.\";\n"
	"        }\n"
	"\n"
	"        leaf mac-addr {\n"
	"          type yang:mac-address;\n"
	"          description\n"
	"            \"The nexthop MAC address.\";\n"
	"        }\n"
	"\n"
	"        leaf refcount {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"The refcount of the RMAC.\";\n"
	"        }\n"
	"\n"
	"        list prefix-list {\n"
	"          description\n"
	"            \"List of IP prefixes associated with the RMAC.\";\n"
	"\n"
	"          leaf prefix-item {\n"
	"            type inet:ip-prefix;\n"
	"            description\n"
	"              \"IP prefixes associated with the RMAC.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-evpn-vni-vteps\n"
	"\n"
	"  rpc clear-evpn-dup-addr {\n"
	"    description\n"
	"      \"Clear duplicate address detection state for one or all VNIs.\";\n"
	"    input {\n"
	"      choice clear-dup-choice {\n"
	"        description\n"
	"          \"Choice between clearing all VNIs or |\n"
	"           clearing state for a single EVPN VNI |\n"
	"           and a specific MAC or IP address.\";\n"
	"\n"
	"        case all-case {\n"
	"          leaf all-vnis {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Clear all VNIs.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case single-case {\n"
	"          leaf vni-id {\n"
	"            type vni-id-type;\n"
	"            description\n"
	"              \"Clear state for a single EVPN VNI.\";\n"
	"          }\n"
	"\n"
	"          choice ip-mac-choice {\n"
	"            description\n"
	"              \"Clear state for a specific MAC or IP address.\";\n"
	"            case ip-case {\n"
	"              leaf vni-ipaddr {\n"
	"                type inet:ip-address;\n"
	"                description\n"
	"                  \"A specific IP address (v4 or v6).\";\n"
	"              }\n"
	"            }\n"
	"\n"
	"            case mac-case {\n"
	"              leaf mac-addr {\n"
	"                type yang:mac-address;\n"
	"                description\n"
	"                  \"A specific MAC address.\";\n"
	"              }\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End clear-evpn-dup-addr\n"
	"\n"
	"  rpc get-evpn-macs {\n"
	"    description\n"
	"      \"Retrieve information about EVPN MAC addresses.\";\n"
	"    input {\n"
	"      choice all-choice {\n"
	"        default \"all-vni\";\n"
	"        description \n"
	"\t  \"Choice between retrieving information for all VNIs or |\n"
	"           including detailed results, a single VTEP address, or |\n"
	"           showing duplicate addresses.\";\n"
	"\n"
	"        case all-vni {\n"
	"          leaf all-vnis {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Retrieve information for all VNIs.\";\n"
	"          }\n"
	"\n"
	"          choice all-choices {\n"
	"            description\n"
	"              \"Choice between including detailed results, a single VTEP address, |\n"
	"               or showing duplicate addresses.\";\n"
	"\n"
	"            case detail-case {\n"
	"              leaf all-detail {\n"
	"                type empty;\n"
	"                description\n"
	"                  \"Include detailed results.\";\n"
	"              }\n"
	"            }\n"
	"\n"
	"            case vtep-case {\n"
	"              leaf all-vtep-addr {\n"
	"                type inet:ipv4-address;\n"
	"                description\n"
	"                  \"A single VTEP address.\";\n"
	"              }\n"
	"            }\n"
	"\n"
	"            case dup-case {\n"
	"              leaf all-dup {\n"
	"                type empty;\n"
	"                description\n"
	"                  \"Show duplicate addresses.\";\n"
	"              }\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case single-vni {\n"
	"          leaf vni-id {\n"
	"            type vni-id-type;\n"
	"            description\n"
	"              \"Retrieve information for a single VNI.\";\n"
	"          }\n"
	"\n"
	"          choice single-choices {\n"
	"            description\n"
	"              \"Choice between including detailed results, a specific MAC address, |\n"
	"               a single VTEP address, or showing duplicate addresses.\";\n"
	"\n"
	"            case detail-case {\n"
	"              leaf single-detail {\n"
	"                type empty;\n"
	"                description\n"
	"                  \"Include detailed results.\";\n"
	"              }\n"
	"            }\n"
	"\n"
	"            case mac-case {\n"
	"              leaf single-mac {\n"
	"                type yang:mac-address;\n"
	"                description\n"
	"                  \"A specific MAC address.\";\n"
	"              }\n"
	"            }\n"
	"\n"
	"            case vtep-case {\n"
	"              leaf single-vtep {\n"
	"                type inet:ipv4-address;\n"
	"                description\n"
	"                  \"A single VTEP address.\";\n"
	"              }\n"
	"            }\n"
	"\n"
	"            case dup-case {\n"
	"              leaf single-dup {\n"
	"                type empty;\n"
	"                description\n"
	"                  \"Show duplicate addresses.\";\n"
	"              }\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"    // End of input section\n"
	"    output {\n"
	"      list mac-list {\n"
	"        description\n"
	"          \"List of MAC addresses.\";\n"
	"\n"
	"        leaf mac-addr {\n"
	"          type yang:mac-address;\n"
	"          description\n"
	"            \"The MAC address.\";\n"
	"        }\n"
	"\n"
	"        leaf vni {\n"
	"          type vni-id-type;\n"
	"          description\n"
	"            \"The VNI value.\";\n"
	"        }\n"
	"\n"
	"        leaf local-sequence {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"Local sequence number.\";\n"
	"        }\n"
	"\n"
	"        leaf remote-sequence {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"Remote sequence number.\";\n"
	"        }\n"
	"\n"
	"        leaf dad-count {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"Duplicate detection counter.\";\n"
	"        }\n"
	"\n"
	"        leaf is-duplicate {\n"
	"          type empty;\n"
	"          description\n"
	"            \"Duplicate MAC detected.\";\n"
	"        }\n"
	"\n"
	"        leaf dup-detect-time {\n"
	"          type unix-timestamp;\n"
	"          description\n"
	"            \"If a duplicate, the detection time.\";\n"
	"        }\n"
	"\n"
	"        container dup-detect-started {\n"
	"          description\n"
	"            \"Container for duplicate detection process start time and count.\";\n"
	"\n"
	"          leaf dup-detect-start {\n"
	"            type unix-timestamp;\n"
	"            description\n"
	"              \"Duplicate detection process start time.\";\n"
	"          }\n"
	"\n"
	"          leaf dup-count {\n"
	"            type uint32;\n"
	"            description\n"
	"              \"Duplicate detection count.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        leaf is-auto {\n"
	"          type empty;\n"
	"          description\n"
	"            \"This is an Auto MAC.\";\n"
	"        }\n"
	"\n"
	"        leaf is-sticky {\n"
	"          type empty;\n"
	"          description\n"
	"            \"This is a sticky MAC.\";\n"
	"        }\n"
	"\n"
	"        leaf is-default-gw {\n"
	"          type empty;\n"
	"          description\n"
	"            \"This is a default-gateway MAC.\";\n"
	"        }\n"
	"\n"
	"        leaf is-remote-gw {\n"
	"          type empty;\n"
	"          description\n"
	"            \"This is a remote-gateway MAC.\";\n"
	"        }\n"
	"\n"
	"        list neighbor-list {\n"
	"          description\n"
	"            \"List of neighbor addresses.\";\n"
	"\n"
	"          leaf neighbor-addr {\n"
	"            type inet:ip-address;\n"
	"            description\n"
	"              \"Neighbor address.\";\n"
	"          }\n"
	"\n"
	"          leaf is-active {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Neighbor is active.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        leaf mac-count {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"Number of MACs (local and remote).\";\n"
	"        }\n"
	"\n"
	"        choice local-rem-choice {\n"
	"          description\n"
	"            \"Choice between local interface and VLAN or remote VTEP IP address.\";\n"
	"\n"
	"          case local-case {\n"
	"            leaf intf {\n"
	"              type frr-interface:interface-ref;\n"
	"              description\n"
	"                \"The local interface name.\";\n"
	"            }\n"
	"\n"
	"            leaf vlan {\n"
	"              type uint32;\n"
	"              description\n"
	"                \"A VLAN id.\";\n"
	"            }\n"
	"          }\n"
	"\n"
	"          case remote-case {\n"
	"            leaf vtep-addr {\n"
	"              type inet:ipv4-address;\n"
	"              description\n"
	"                \"The remote VTEP IP address.\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-evpn-macs\n"
	"\n"
	"  rpc get-evpn-arp-cache {\n"
	"    description\n"
	"      \"Retrieve information about EVPN neighbor cache entries.\";\n"
	"    input {\n"
	"      choice all-choice {\n"
	"        default \"all-vni\";\n"
	"        description\n"
	"          \"Choice between retrieving information for all VNIs or including detailed results or showing duplicates.\";\n"
	"        case all-vni {\n"
	"          leaf all-vnis {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Retrieve information for all VNIs.\";\n"
	"          }\n"
	"\n"
	"          choice all-choices {\n"
	"            description\n"
	"              \"Choice between including detailed results or showing duplicates.\";\n"
	"\n"
	"            case detail-case {\n"
	"              leaf all-detail {\n"
	"                type empty;\n"
	"                description\n"
	"                  \"Include detailed results.\";\n"
	"              }\n"
	"            }\n"
	"\n"
	"            case dup-case {\n"
	"              leaf all-dup {\n"
	"                type empty;\n"
	"                description\n"
	"                  \"Show duplicates.\";\n"
	"              }\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case single-vni {\n"
	"          leaf vni-id {\n"
	"            type vni-id-type;\n"
	"            description\n"
	"              \"Retrieve information for a single VNI.\";\n"
	"          }\n"
	"\n"
	"          choice single-choices {\n"
	"            description\n"
	"              \"Choice between single VTEP, neighbor address, or show duplicates.\";\n"
	"\n"
	"            case vtep-case {\n"
	"              leaf single-vtep {\n"
	"                type inet:ipv4-address;\n"
	"                description\n"
	"                  \"A single VTEP address.\";\n"
	"              }\n"
	"            }\n"
	"\n"
	"            case neighbor-case {\n"
	"              leaf neighbor-addr {\n"
	"                type inet:ip-address;\n"
	"                description\n"
	"                  \"A single neighbor address.\";\n"
	"              }\n"
	"            }\n"
	"\n"
	"            case dup-case {\n"
	"              leaf single-dup {\n"
	"                type empty;\n"
	"                description\n"
	"                  \"Show duplicates.\";\n"
	"              }\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"    // End input section\n"
	"    output {\n"
	"      list vni-list {\n"
	"        description\n"
	"          \"List of VNI containers.\";\n"
	"\n"
	"        container vni-container {\n"
	"          description\n"
	"            \"Information for one VNI.\";\n"
	"          leaf vni-id {\n"
	"            type vni-id-type;\n"
	"            description\n"
	"              \"The VNI id.\";\n"
	"          }\n"
	"\n"
	"          list neigh-list {\n"
	"            description\n"
	"              \"Information about a VNI\'s neighbor cache.\";\n"
	"            leaf mac-addr {\n"
	"              type yang:mac-address;\n"
	"              description\n"
	"                \"A neighbor MAC address.\";\n"
	"            }\n"
	"\n"
	"            leaf ip-addr {\n"
	"              type inet:ip-address;\n"
	"              description\n"
	"                \"A neighbor IP address.\";\n"
	"            }\n"
	"\n"
	"            leaf state-active {\n"
	"              type empty;\n"
	"              description\n"
	"                \"Indicates whether the entry is active.\";\n"
	"            }\n"
	"\n"
	"            choice local-remote-choice {\n"
	"              description\n"
	"                \"Choice between local and remote entries.\";\n"
	"\n"
	"              case local-case {\n"
	"                leaf is-local {\n"
	"                  type empty;\n"
	"                  description\n"
	"                    \"The entry is local.\";\n"
	"                }\n"
	"              }\n"
	"\n"
	"              case remote-case {\n"
	"                leaf is-remote {\n"
	"                  type empty;\n"
	"                  description\n"
	"                    \"The entry is remote.\";\n"
	"                }\n"
	"              }\n"
	"            }\n"
	"\n"
	"            leaf is-dup {\n"
	"              type empty;\n"
	"              description\n"
	"                \"The entry is a detected duplicate.\";\n"
	"            }\n"
	"\n"
	"            leaf is-default-gw {\n"
	"              type empty;\n"
	"              description\n"
	"                \"The entry is a default gateway.\";\n"
	"            }\n"
	"\n"
	"            leaf is-router {\n"
	"              type empty;\n"
	"              description\n"
	"                \"The entry is a router.\";\n"
	"            }\n"
	"\n"
	"            leaf local-sequence {\n"
	"              type uint32;\n"
	"              description\n"
	"                \"The local sequence number.\";\n"
	"            }\n"
	"\n"
	"            leaf remote-sequence {\n"
	"              type uint32;\n"
	"              description\n"
	"                \"The remote sequence number.\";\n"
	"            }\n"
	"\n"
	"            leaf remote-vtep {\n"
	"              type inet:ipv4-address;\n"
	"              description\n"
	"                \"The remote VTEP address.\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-evpn-arp-cache\n"
	"\n"
	"  rpc get-pbr-ipset {\n"
	"    description\n"
	"      \"RPC to retrieve PBR IP set.\";\n"
	"\n"
	"    input {\n"
	"      leaf name {\n"
	"        type string {\n"
	"          length \"1..32\";\n"
	"        }\n"
	"        description\n"
	"          \"An optional specific IPset name.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    output {\n"
	"      list ipset-list {\n"
	"        description\n"
	"          \"List of IP sets.\";\n"
	"\n"
	"        leaf name {\n"
	"          type string {\n"
	"            length \"1..32\";\n"
	"          }\n"
	"          description\n"
	"            \"The IPset name.\";\n"
	"        }\n"
	"\n"
	"        leaf ipset-type {\n"
	"          type enumeration {\n"
	"            enum \"net-net\" {\n"
	"              value 1;\n"
	"              description\n"
	"                \"Network to network IP set type.\";\n"
	"            }\n"
	"            enum \"net-port-net\" {\n"
	"              value 2;\n"
	"              description\n"
	"                \"Network to port to network IP set type.\";\n"
	"            }\n"
	"            enum \"net-port\" {\n"
	"              value 3;\n"
	"              description\n"
	"                \"Network to port IP set type.\";\n"
	"            }\n"
	"            enum \"net\" {\n"
	"              value 4;\n"
	"              description\n"
	"                \"Network IP set type.\";\n"
	"            }\n"
	"          }\n"
	"          description\n"
	"            \"Type of IP set.\";\n"
	"        }\n"
	"\n"
	"        leaf src-prefix {\n"
	"          type inet:ip-prefix;\n"
	"          description\n"
	"            \"\";\n"
	"        }\n"
	"\n"
	"        leaf dest-prefix {\n"
	"          type inet:ip-prefix;\n"
	"          description\n"
	"            \"\";\n"
	"        }\n"
	"\n"
	"        leaf src-port {\n"
	"          type inet:port-number;\n"
	"          description\n"
	"            \"\";\n"
	"        }\n"
	"\n"
	"        leaf dest-port {\n"
	"          type inet:port-number;\n"
	"          description\n"
	"            \"\";\n"
	"        }\n"
	"\n"
	"        choice proto-choice {\n"
	"          description\n"
	"            \"Filter UDP/TCP only, or a specific protocol number.\";\n"
	"          case udp-tcp-case {\n"
	"            leaf is-udp-tcp {\n"
	"              type empty;\n"
	"              description\n"
	"                \"Filter TCP/UDP ports only.\";\n"
	"            }\n"
	"          }\n"
	"\n"
	"          case proto-case {\n"
	"            leaf proto {\n"
	"              type uint32;\n"
	"              description\n"
	"                \"Filter a specific protocol number.\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container icmp-info {\n"
	"          description\n"
	"            \"Additional information for ICMP filters.\";\n"
	"          leaf type-min {\n"
	"            type uint8;\n"
	"            description\n"
	"              \"\";\n"
	"          }\n"
	"\n"
	"          leaf type-max {\n"
	"            type uint8;\n"
	"            description\n"
	"              \"\";\n"
	"          }\n"
	"\n"
	"          leaf code-min {\n"
	"            type uint8;\n"
	"            description\n"
	"              \"\";\n"
	"          }\n"
	"\n"
	"          leaf code-max {\n"
	"            type uint8;\n"
	"            description\n"
	"              \"\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container ipset-stats {\n"
	"          description\n"
	"            \"Container for IP set statistics.\";\n"
	"\n"
	"          leaf is-unique {\n"
	"            type empty;\n"
	"            description\n"
	"              \"\";\n"
	"          }\n"
	"\n"
	"          leaf packet-counter {\n"
	"            type uint64;\n"
	"            description\n"
	"              \"\";\n"
	"          }\n"
	"\n"
	"          leaf bytes-counter {\n"
	"            type uint64;\n"
	"            description\n"
	"              \"\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-pbr-ipset\n"
	"\n"
	"  rpc get-pbr-iptable {\n"
	"    description\n"
	"      \"RPC to retrieve PBR iptables.\";\n"
	"\n"
	"    input {\n"
	"      leaf name {\n"
	"        type string {\n"
	"          length \"1..32\";\n"
	"        }\n"
	"        description\n"
	"          \"An optional single IPtable name.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    output {\n"
	"      list iptable-list {\n"
	"        description\n"
	"          \"List of iptables entries.\";\n"
	"\n"
	"        leaf name {\n"
	"          type string {\n"
	"            length \"1..32\";\n"
	"          }\n"
	"          description\n"
	"            \"The IPtable name.\";\n"
	"        }\n"
	"\n"
	"        leaf unique-val {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"\";\n"
	"        }\n"
	"\n"
	"        choice action-choice {\n"
	"          description\n"
	"            \"The table action.\";\n"
	"          case drop-case {\n"
	"            leaf action-drop {\n"
	"              type empty;\n"
	"              description\n"
	"                \"\";\n"
	"            }\n"
	"          }\n"
	"\n"
	"          case redirect-case {\n"
	"            leaf action-redirect {\n"
	"              type empty;\n"
	"              description\n"
	"                \"\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"\n"
	"        leaf min-packet {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"\";\n"
	"        }\n"
	"\n"
	"        leaf max-packet {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"\";\n"
	"        }\n"
	"\n"
	"        leaf lookup-src-port {\n"
	"          type empty;\n"
	"          description\n"
	"            \"\";\n"
	"        }\n"
	"\n"
	"        leaf lookup-dst-port {\n"
	"          type empty;\n"
	"          description\n"
	"            \"\";\n"
	"        }\n"
	"\n"
	"        leaf tcp-flags {\n"
	"          type uint16;\n"
	"          description\n"
	"            \"\";\n"
	"        }\n"
	"\n"
	"        leaf tcp-flags-mask {\n"
	"          type uint16;\n"
	"          description\n"
	"            \"\";\n"
	"        }\n"
	"\n"
	"        leaf protocol-val {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"An IP protocol number.\";\n"
	"        }\n"
	"\n"
	"        container dscp-info {\n"
	"          description\n"
	"            \"Container for dscp information.\";\n"
	"\n"
	"          leaf dscp-value {\n"
	"            type uint32;\n"
	"            description\n"
	"              \"A DSCP value to match.\";\n"
	"          }\n"
	"\n"
	"          leaf invert-match {\n"
	"            type empty;\n"
	"            description\n"
	"              \"If set, exclude the specified value\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container fragment-info {\n"
	"          description\n"
	"            \"Container for fragment information.\";\n"
	"\n"
	"          leaf fragment-val {\n"
	"            type uint32;\n"
	"            description\n"
	"              \"An IP fragment value.\";\n"
	"          }\n"
	"\n"
	"          leaf invert-match {\n"
	"            type empty;\n"
	"            description\n"
	"              \"If set, exclude the specified value.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container iptable-stats {\n"
	"          description\n"
	"            \"Container for iptables statistics.\";\n"
	"\n"
	"          leaf packet-counter {\n"
	"            type uint64;\n"
	"            description\n"
	"              \"Number of packets processed by iptables.\";\n"
	"          }\n"
	"\n"
	"          leaf bytes-counter {\n"
	"            type uint64;\n"
	"            description\n"
	"              \"Number of packets processed by iptables.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container rule-info {\n"
	"          description\n"
	"            \"Information about a rule, for redirect tables.\";\n"
	"          leaf table-id {\n"
	"            type uint32;\n"
	"            description\n"
	"              \"The rule table id.\";\n"
	"          }\n"
	"\n"
	"          leaf table-fwmark {\n"
	"            type uint32;\n"
	"            description\n"
	"              \"The firewall mark for the rule.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-pbr-iptable\n"
	"  /*\n"
	"   * Handy \'all-at-once\' api to retrieve debugs\n"
	"   */\n"
	"\n"
	"  rpc get-debugs {\n"
	"    description\n"
	"      \"RPC to retrieve debug information.\";\n"
	"\n"
	"    output {\n"
	"      uses zebra-debugs;\n"
	"    }\n"
	"  }\n"
	"\n"
	"  // End get-debugs\n"
	"\n"
	"  augment \"/frr-interface:lib/frr-interface:interface\" {\n"
	"    description\n"
	"      \"Extends interface model with Zebra-related parameters.\";\n"
	"    container zebra {\n"
	"      description\n"
	"        \"Container for Zebra-related information.\";\n"
	"\n"
	"      list ipv4-addrs {\n"
	"        key \"ip prefix-length\";\n"
	"        description\n"
	"          \"The list of configured IPv4 addresses on the interface.\";\n"
	"\n"
	"        leaf ip {\n"
	"          type inet:ipv4-address-no-zone;\n"
	"          description\n"
	"            \"The IPv4 address on the interface.\";\n"
	"        }\n"
	"\n"
	"        leaf prefix-length {\n"
	"          type uint8 {\n"
	"            range \"0..32\";\n"
	"          }\n"
	"          description\n"
	"            \"The length of the subnet prefix.\";\n"
	"        }\n"
	"\n"
	"        leaf label {\n"
	"          type string;\n"
	"          description\n"
	"            \"Optional string label for the address.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      list ipv4-p2p-addrs {\n"
	"        key \"ip peer-ip peer-prefix-length\";\n"
	"        description\n"
	"          \"The list of configured peer-to-peer IPv4 addresses on the interface.\";\n"
	"\n"
	"        leaf ip {\n"
	"          type inet:ipv4-address-no-zone;\n"
	"          description\n"
	"            \"The IPv4 address on the interface.\";\n"
	"        }\n"
	"\n"
	"        leaf peer-ip {\n"
	"          type inet:ipv4-address-no-zone;\n"
	"          description\n"
	"            \"Peer address.\";\n"
	"        }\n"
	"\n"
	"        leaf peer-prefix-length {\n"
	"          type uint8 {\n"
	"            range \"0..32\";\n"
	"          }\n"
	"          description\n"
	"            \"The length of the peer subnet prefix.\";\n"
	"        }\n"
	"\n"
	"        leaf label {\n"
	"          type string;\n"
	"          description\n"
	"            \"Optional string label for the address.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      list ipv6-addrs {\n"
	"        key \"ip prefix-length\";\n"
	"        description\n"
	"          \"The list of configured IPv6 addresses on the interface.\";\n"
	"\n"
	"        leaf ip {\n"
	"          type inet:ipv6-address-no-zone;\n"
	"          description\n"
	"            \"The IPv6 address on the interface.\";\n"
	"        }\n"
	"\n"
	"        leaf prefix-length {\n"
	"          type uint8 {\n"
	"            range \"0..128\";\n"
	"          }\n"
	"          description\n"
	"            \"The length of the subnet prefix.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      leaf multicast {\n"
	"        type boolean;\n"
	"        description\n"
	"          \"Multicast flag for the interface.\";\n"
	"      }\n"
	"\n"
	"      leaf link-detect {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"Link-detection for the interface.\";\n"
	"      }\n"
	"\n"
	"      leaf enabled {\n"
	"        type boolean;\n"
	"        description\n"
	"          \"Interface admin status.\";\n"
	"      }\n"
	"\n"
	"      leaf mpls {\n"
	"        type boolean;\n"
	"        description\n"
	"          \"Interface MPLS status.\";\n"
	"      }\n"
	"\n"
	"      leaf bandwidth {\n"
	"        type uint32 {\n"
	"          range \"1..1000000\";\n"
	"        }\n"
	"        units \"megabits/sec\";\n"
	"        description\n"
	"          \"Link bandwidth informational parameter, in megabits.\";\n"
	"      }\n"
	"      container link-params {\n"
	"        presence \"Activates link parameters on this interface.\";\n"
	"        description\n"
	"          \"link-params for Traffic-Engineering (TE) use in IGP extensions.\";\n"
	"        leaf metric {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"Link metric for MPLS-TE purpose.\";\n"
	"        }\n"
	"        leaf max-bandwidth {\n"
	"          type rt-types:bandwidth-ieee-float32;\n"
	"          description\n"
	"            \"Maximum bandwidth.\";\n"
	"        }\n"
	"        leaf max-reservable-bandwidth {\n"
	"          type rt-types:bandwidth-ieee-float32;\n"
	"          description\n"
	"            \"Maximum reservable bandwidth.\";\n"
	"        }\n"
	"        container unreserved-bandwidths {\n"
	"          description\n"
	"            \"All unreserved bandwidths.\";\n"
	"          list unreserved-bandwidth {\n"
	"            key \"priority\";\n"
	"            leaf priority {\n"
	"              type uint8 {\n"
	"                range \"0 .. 7\";\n"
	"              }\n"
	"              description\n"
	"                \"Priority from 0 to 7.\";\n"
	"            }\n"
	"            leaf unreserved-bandwidth {\n"
	"              type rt-types:bandwidth-ieee-float32;\n"
	"              mandatory true;\n"
	"              description\n"
	"                \"Unreserved bandwidth.\";\n"
	"            }\n"
	"            description\n"
	"              \"List of unreserved bandwidths for different\n"
	"                priorities.\";\n"
	"          }\n"
	"        }\n"
	"        leaf residual-bandwidth {\n"
	"          type rt-types:bandwidth-ieee-float32;\n"
	"          description\n"
	"            \"Unidirectional residual bandwidth.\";\n"
	"        }\n"
	"        leaf available-bandwidth {\n"
	"          type rt-types:bandwidth-ieee-float32;\n"
	"          description\n"
	"            \"Unidirectional available bandwidth.\";\n"
	"        }\n"
	"        leaf utilized-bandwidth {\n"
	"          type rt-types:bandwidth-ieee-float32;\n"
	"          description\n"
	"            \"Unidirectional utilized bandwidth.\";\n"
	"        }\n"
	"        choice admin-group-mode {\n"
	"          description \"Admin-group mode\";\n"
	"          case legacy {\n"
	"            description\n"
	"              \"Legacy mode. Only support standard admin-group (RFC3630/5305/5329)\";\n"
	"            leaf legacy-admin-group {\n"
	"              type uint32;\n"
	"              description \"Admin-Group value\";\n"
	"            }\n"
	"          }\n"
	"          case affinity {\n"
	"            container affinities {\n"
	"              description\n"
	"                \"Container for affinity information.\";\n"
	"\n"
	"              leaf-list affinity {\n"
	"                type frr-affinity-map:affinity-map-ref;\n"
	"                must \'../../affinity-mode != \"standard\" or /frr-affinity-map:lib/frr-affinity-map:affinity-maps/frr-affinity-map:affinity-map[frr-affinity-map:name=current()]/frr-affinity-map:value < 32\' {\n"
	"                  error-message \"Affinity bit-position must be less than 32 when used with standard affinity mode\";\n"
	"                }\n"
	"                max-elements \"256\";\n"
	"                description\n"
	"                  \"Array of Attribute Names\";\n"
	"              }\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"        leaf affinity-mode {\n"
	"          type enumeration {\n"
	"              enum extended {\n"
	"              value 0;\n"
	"              description\n"
	"                \"Extended Admin-Group only (RFC7308)\";\n"
	"            }\n"
	"            enum standard {\n"
	"            value 1;\n"
	"              description\n"
	"                \"Standard Admin-Group only (RFC3630/5305/5329)\";\n"
	"            }\n"
	"            enum both {\n"
	"              value 2;\n"
	"              description\n"
	"                \"Standard and extended Admin-Group\";\n"
	"            }\n"
	"          }\n"
	"          default \"extended\";\n"
	"          description\n"
	"            \"Affinity mode\";\n"
	"        }\n"
	"        container neighbor {\n"
	"          presence \"Activates neighbor information on this interface.\";\n"
	"          leaf remote-as {\n"
	"            type inet:as-number;\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"Remote AS Number (RFC 5316 & RFC 5392)\";\n"
	"          }\n"
	"          leaf ipv4-remote-id {\n"
	"            type inet:ipv4-address;\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"IPv4 Remote ASBR ID (RFC 5316 & RFC 5392)\";\n"
	"          }\n"
	"          description\n"
	"            \"Remote ASBR information (RFC 5316 & RFC 5392)\";\n"
	"        }\n"
	"        leaf delay {\n"
	"          type uint32 {\n"
	"            range \"0..16777215\";\n"
	"          }\n"
	"          description\n"
	"            \"Average Unidirectional Link Delay\";\n"
	"        }\n"
	"        container min-max-delay {\n"
	"          presence \"Activates min/max delay.\";\n"
	"          leaf delay-min {\n"
	"            type uint32 {\n"
	"              range \"0..16777215\";\n"
	"            }\n"
	"            must \'. <= ../../delay\' {\n"
	"              error-message \"Min delay must be less than or equal to delay\";\n"
	"            }\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"Min Delay\";\n"
	"          }\n"
	"          leaf delay-max {\n"
	"            type uint32 {\n"
	"              range \"0..16777215\";\n"
	"            }\n"
	"            must \'. >= ../../delay\' {\n"
	"              error-message \"Max delay must be greater than or equal to delay\";\n"
	"            }\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"Max Delay\";\n"
	"          }\n"
	"          description\n"
	"            \"Min/Max Unidirectional Link Delay\";\n"
	"        }\n"
	"        leaf delay-variation {\n"
	"          type uint32 {\n"
	"            range \"0..16777215\";\n"
	"          }\n"
	"          description\n"
	"            \"Unidirectional Delay Variation\";\n"
	"        }\n"
	"        leaf packet-loss {\n"
	"          type decimal64 {\n"
	"            fraction-digits 6;\n"
	"            range \"0..50.331642\";\n"
	"          }\n"
	"          description\n"
	"            \"Unidirectional Link Packet Loss\";\n"
	"        }\n"
	"        // TODO -- other link-params options\n"
	"        // for (experimental/partial TE use in IGP extensions)\n"
	"      }\n"
	"      container evpn-mh {\n"
	"        description \"EVPN multihoming configuration\";\n"
	"        choice esi-choice {\n"
	"          description \"ESI type\";\n"
	"          container type-0 {\n"
	"            description\n"
	"              \"Container for type-0 information.\";\n"
	"\n"
	"            leaf esi {\n"
	"              type yang:hex-string {\n"
	"                length \"29\";\n"
	"              }\n"
	"              description\n"
	"                \"10-octet ESI.\";\n"
	"              }\n"
	"          }\n"
	"          container type-3 {\n"
	"            description\n"
	"              \"Container for type-3 information.\";\n"
	"\n"
	"            leaf system-mac {\n"
	"              type yang:mac-address;\n"
	"              description\n"
	"                \"System MAC address.\";\n"
	"            }\n"
	"            leaf local-discriminator {\n"
	"              type uint32 {\n"
	"                range \"1..16777215\";\n"
	"              }\n"
	"              description\n"
	"                \"Local discriminator.\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"        leaf df-preference {\n"
	"          type uint16;\n"
	"          default \"32767\";\n"
	"          description\n"
	"            \"Preference value used for DF election.\";\n"
	"        }\n"
	"        leaf bypass {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"Bypass mode.\";\n"
	"        }\n"
	"        leaf uplink {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"Uplink to the VxLAN core.\";\n"
	"        }\n"
	"      }\n"
	"      container ipv6-router-advertisements {\n"
	"        if-feature \"ipv6-router-advertisements\";\n"
	"        description\n"
	"          \"Support for IPv6 Router Advertisements.\";\n"
	"        leaf send-advertisements {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"A flag indicating whether or not the router sends\n"
	"            periodic Router Advertisements and responds to\n"
	"            Router Solicitations.\";\n"
	"          reference\n"
	"            \"RFC 4861: Neighbor Discovery for IP version 6 (IPv6)\n"
	"                       - AdvSendAdvertisements\";\n"
	"        }\n"
	"        leaf max-rtr-adv-interval {\n"
	"          type uint32 {\n"
	"            range \"70..1800000\";\n"
	"          }\n"
	"          units \"milliseconds\";\n"
	"          default \"600000\";\n"
	"          description\n"
	"            \"The maximum time allowed between sending unsolicited\n"
	"            multicast Router Advertisements from the interface.\";\n"
	"          reference\n"
	"            \"RFC 4861: Neighbor Discovery for IP version 6 (IPv6)\n"
	"                       - MaxRtrAdvInterval\n"
	"             RFC 6275: Mobility Support in IPv6\";\n"
	"        }\n"
	"        // Setting this value is not yet supported by the actual code.\n"
	"        /*\n"
	"        leaf min-rtr-adv-interval {\n"
	"          type uint32 {\n"
	"            range \"30..1350000\";\n"
	"          }\n"
	"          units \"milliseconds\";\n"
	"          must \". <= 0.75 * ../max-rtr-adv-interval\" {\n"
	"            description\n"
	"              \"The value MUST NOT be greater than 75\x25 of\n"
	"              \'max-rtr-adv-interval\'.\";\n"
	"          }\n"
	"          description\n"
	"            \"The minimum time allowed between sending unsolicited\n"
	"            multicast Router Advertisements from the interface.\n"
	"\n"
	"            The default value to be used operationally if this\n"
	"            leaf is not configured is determined as follows:\n"
	"\n"
	"            - if max-rtr-adv-interval >= 9 seconds, the default\n"
	"              value is 0.33 * max-rtr-adv-interval;\n"
	"\n"
	"            - otherwise, it is 0.75 * max-rtr-adv-interval.\";\n"
	"          reference\n"
	"            \"RFC 4861: Neighbor Discovery for IP version 6 (IPv6)\n"
	"                       - MaxRtrAdvInterval\n"
	"             RFC 6275: Mobility Support in IPv6\";\n"
	"        }\n"
	"        */\n"
	"        leaf managed-flag {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"The value to be placed in the \'Managed address\n"
	"            configuration\' flag field in the Router\n"
	"            Advertisement.\";\n"
	"          reference\n"
	"            \"RFC 4861: Neighbor Discovery for IP version 6 (IPv6)\n"
	"                       - AdvManagedFlag\";\n"
	"        }\n"
	"        leaf other-config-flag {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"The value to be placed in the \'Other configuration\'\n"
	"            flag field in the Router Advertisement.\";\n"
	"          reference\n"
	"            \"RFC 4861: Neighbor Discovery for IP version 6 (IPv6)\n"
	"                       - AdvOtherConfigFlag\";\n"
	"        }\n"
	"        leaf home-agent-flag {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"The value to be placed in the \'Home Agent\'\n"
	"            flag field in the Router Advertisement.\";\n"
	"          reference\n"
	"            \"RFC 6275: Mobility Support in IPv6\";\n"
	"        }\n"
	"        leaf link-mtu {\n"
	"          type uint32;\n"
	"          default \"0\";\n"
	"          description\n"
	"            \"The value to be placed in MTU options sent by the\n"
	"            router.  A value of zero indicates that no MTU options\n"
	"            are sent.\";\n"
	"          reference\n"
	"            \"RFC 4861: Neighbor Discovery for IP version 6 (IPv6)\n"
	"                       - AdvLinkMTU\";\n"
	"        }\n"
	"        leaf reachable-time {\n"
	"          type uint32 {\n"
	"            range \"0..3600000\";\n"
	"          }\n"
	"          units \"milliseconds\";\n"
	"          default \"0\";\n"
	"          description\n"
	"            \"The value to be placed in the Reachable Time field in\n"
	"            the Router Advertisement messages sent by the router.\n"
	"            A value of zero means unspecified (by this router).\";\n"
	"          reference\n"
	"            \"RFC 4861: Neighbor Discovery for IP version 6 (IPv6)\n"
	"                       - AdvReachableTime\";\n"
	"        }\n"
	"        leaf retrans-timer {\n"
	"          type uint32;\n"
	"          units \"milliseconds\";\n"
	"          default \"0\";\n"
	"          description\n"
	"            \"The value to be placed in the Retrans Timer field in\n"
	"            the Router Advertisement messages sent by the router.\n"
	"            A value of zero means unspecified (by this router).\";\n"
	"          reference\n"
	"            \"RFC 4861: Neighbor Discovery for IP version 6 (IPv6)\n"
	"                       - AdvRetransTimer\";\n"
	"        }\n"
	"        leaf cur-hop-limit {\n"
	"          type uint8;\n"
	"          description\n"
	"            \"The value to be placed in the Cur Hop Limit field in\n"
	"            the Router Advertisement messages sent by the router.\n"
	"            A value of zero means unspecified (by this router).\n"
	"\n"
	"            If this parameter is not configured, the device SHOULD\n"
	"            use the IANA-specified value for the default IPv4\n"
	"            Time to Live (TTL) parameter that was in effect at the\n"
	"            time of implementation.\";\n"
	"          reference\n"
	"            \"RFC 3232: Assigned Numbers: RFC 1700 is Replaced by\n"
	"                       an On-line Database\n"
	"             RFC 4861: Neighbor Discovery for IP version 6 (IPv6)\n"
	"                       - AdvCurHopLimit\n"
	"             IANA: IP Parameters\n"
	"                   (https://www.iana.org/assignments/ip-parameters)\";\n"
	"        }\n"
	"        leaf default-lifetime {\n"
	"          type uint16 {\n"
	"            range \"0..9000\";\n"
	"          }\n"
	"          units \"seconds\";\n"
	"          must \". = 0 or . * 1000 >= ../max-rtr-adv-interval\" {\n"
	"            description\n"
	"              \"The value MUST NOT be less than max-rtr-adv-interval.\";\n"
	"          }\n"
	"          description\n"
	"            \"The value to be placed in the Router Lifetime field of\n"
	"            Router Advertisements sent from the interface, in\n"
	"            seconds.  It MUST be either zero or between\n"
	"            max-rtr-adv-interval and 9000 seconds.  A value of zero\n"
	"            indicates that the router is not to be used as a\n"
	"            default router.  These limits may be overridden by\n"
	"            specific documents that describe how IPv6 operates over\n"
	"            different link layers.\n"
	"\n"
	"            If this parameter is not configured, the device SHOULD\n"
	"            use a value of 3 * max-rtr-adv-interval.\";\n"
	"          reference\n"
	"            \"RFC 4861: Neighbor Discovery for IP version 6 (IPv6)\n"
	"                       - AdvDefaultLifetime\";\n"
	"        }\n"
	"        leaf fast-retransmit {\n"
	"          type boolean;\n"
	"          default \"true\";\n"
	"          description\n"
	"            \"Allow sending unsolicited multicast Router Advertisements\n"
	"            more frequently than once every 3 seconds as required by\n"
	"            RFC 4861.\";\n"
	"        }\n"
	"        leaf advertisement-interval-option {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"Enable sending the Advertisement Interval Option in\n"
	"            Router Advertisements.\";\n"
	"          reference\n"
	"            \"RFC 6275: Mobility Support in IPv6\";\n"
	"        }\n"
	"        leaf home-agent-preference {\n"
	"          type uint16;\n"
	"          description\n"
	"            \"The value to be placed in the Home Agent Preference\n"
	"            field in the Router Advertisement messages sent by the\n"
	"            router.\";\n"
	"          reference\n"
	"            \"RFC 6275: Mobility Support in IPv6\";\n"
	"        }\n"
	"        leaf home-agent-lifetime {\n"
	"          type uint16;\n"
	"          description\n"
	"            \"The value to be placed in the Home Agent Lifetime\n"
	"            field in the Router Advertisement messages sent by the\n"
	"            router.\";\n"
	"          reference\n"
	"            \"RFC 6275: Mobility Support in IPv6\";\n"
	"        }\n"
	"        leaf default-router-preference {\n"
	"          type enumeration {\n"
	"            enum high {\n"
	"              value 1; /* 01 */\n"
	"              description\n"
	"                \"High preference.\";\n"
	"            }\n"
	"            enum medium {\n"
	"              value 0; /* 00 */\n"
	"              description\n"
	"                \"Medium preference.\";\n"
	"            }\n"
	"            enum low {\n"
	"              value 3; /* 11 */\n"
	"              description\n"
	"                \"Low preference.\";\n"
	"            }\n"
	"          }\n"
	"          default \"medium\";\n"
	"          description\n"
	"            \"The value to be placed in the Default Router\n"
	"            Preference field in the Router Advertisement messages\n"
	"            sent by the router.\";\n"
	"          reference\n"
	"            \"RFC 4191: Default Router Preferences and More-Specific\n"
	"                       Routes\";\n"
	"        }\n"
	"        container prefix-list {\n"
	"          description\n"
	"            \"Support for prefixes to be placed in Prefix\n"
	"            Information options in Router Advertisement messages\n"
	"            sent from the interface.\n"
	"\n"
	"            Prefixes that are advertised by default but do not\n"
	"            have their entries in the child \'prefix\' list are\n"
	"            advertised with the default values of all parameters.\n"
	"\n"
	"            The link-local prefix SHOULD NOT be included in the\n"
	"            list of advertised prefixes.\";\n"
	"          reference\n"
	"            \"RFC 4861: Neighbor Discovery for IP version 6 (IPv6)\n"
	"                       - AdvPrefixList\";\n"
	"          list prefix {\n"
	"            key \"prefix-spec\";\n"
	"            description\n"
	"              \"Support for an advertised prefix entry.\";\n"
	"            leaf prefix-spec {\n"
	"              type inet:ipv6-prefix;\n"
	"              description\n"
	"                \"IPv6 address prefix.\";\n"
	"            }\n"
	"            // FRR doesn\'t support \'no-advertise\'. Keeping the code\n"
	"            // here for future reference.\n"
	"            /*\n"
	"            choice control-adv-prefixes {\n"
	"              default \"advertise\";\n"
	"              description\n"
	"                \"Either (1) the prefix is explicitly removed from the\n"
	"                set of advertised prefixes or (2) the parameters with\n"
	"                which the prefix is advertised are specified (default\n"
	"                case).\";\n"
	"              leaf no-advertise {\n"
	"                type empty;\n"
	"                description\n"
	"                  \"The prefix will not be advertised.\n"
	"\n"
	"                  This can be used for removing the prefix from\n"
	"                  the default set of advertised prefixes.\";\n"
	"              }\n"
	"              case advertise {\n"
	"            */\n"
	"                leaf valid-lifetime {\n"
	"                  type uint32;\n"
	"                  units \"seconds\";\n"
	"                  default \"2592000\";\n"
	"                  description\n"
	"                    \"The value to be placed in the Valid Lifetime\n"
	"                    in the Prefix Information option.  The\n"
	"                    designated value of all 1\'s (0xffffffff)\n"
	"                      represents infinity.\";\n"
	"                  reference\n"
	"                    \"RFC 4861: Neighbor Discovery for IP version 6\n"
	"                              (IPv6) - AdvValidLifetime\";\n"
	"                }\n"
	"                leaf on-link-flag {\n"
	"                  type boolean;\n"
	"                  default \"true\";\n"
	"                  description\n"
	"                    \"The value to be placed in the on-link flag\n"
	"                    (\'L-bit\') field in the Prefix Information\n"
	"                    option.\";\n"
	"                  reference\n"
	"                    \"RFC 4861: Neighbor Discovery for IP version 6\n"
	"                              (IPv6) - AdvOnLinkFlag\";\n"
	"                }\n"
	"                leaf preferred-lifetime {\n"
	"                  type uint32;\n"
	"                  units \"seconds\";\n"
	"                  must \". <= ../valid-lifetime\" {\n"
	"                    description\n"
	"                      \"This value MUST NOT be greater than\n"
	"                      valid-lifetime.\";\n"
	"                  }\n"
	"                  default \"604800\";\n"
	"                  description\n"
	"                    \"The value to be placed in the Preferred\n"
	"                    Lifetime in the Prefix Information option.\n"
	"                    The designated value of all 1\'s (0xffffffff)\n"
	"                    represents infinity.\";\n"
	"                  reference\n"
	"                    \"RFC 4861: Neighbor Discovery for IP version 6\n"
	"                              (IPv6) - AdvPreferredLifetime\";\n"
	"                }\n"
	"                leaf autonomous-flag {\n"
	"                  type boolean;\n"
	"                  default \"true\";\n"
	"                  description\n"
	"                    \"The value to be placed in the Autonomous Flag\n"
	"                    field in the Prefix Information option.\";\n"
	"                  reference\n"
	"                    \"RFC 4861: Neighbor Discovery for IP version 6\n"
	"                              (IPv6) - AdvAutonomousFlag\";\n"
	"                }\n"
	"                leaf router-address-flag {\n"
	"                  type boolean;\n"
	"                  default \"false\";\n"
	"                  description\n"
	"                    \"The value to be placed in the Router Address\n"
	"                    flag field in the Prefix Information option.\";\n"
	"                  reference\n"
	"                    \"RFC 6275: Mobility Support in IPv6\";\n"
	"                }\n"
	"            /*\n"
	"              }\n"
	"            }\n"
	"            */\n"
	"            // This is closing brackets for `case advertise` and\n"
	"            // `choice control-adv-prefixes`.\n"
	"          }\n"
	"        }\n"
	"        container rdnss {\n"
	"          description\n"
	"            \"A list of recursive DNS server addresses that are placed\n"
	"            in Recursive DNS Server (RDNSS) options in Router\n"
	"            Advertisement messages sent from the interface.\";\n"
	"          reference\n"
	"            \"RFC 8106: IPv6 Router Advertisement Options for DNS\n"
	"                       Configuration\";\n"
	"          list rdnss-address {\n"
	"            key \"address\";\n"
	"            description\n"
	"              \"Recursive DNS server address.\";\n"
	"            leaf address {\n"
	"              type inet:ipv6-address;\n"
	"              description\n"
	"                \"IPv6 address of a recursive DNS server.\";\n"
	"            }\n"
	"            leaf lifetime {\n"
	"              type uint32;\n"
	"              units \"seconds\";\n"
	"              description\n"
	"                \"The value that is placed in the Lifetime field in the\n"
	"                RDNSS option.  The designated value of all 1\'s\n"
	"                (0xffffffff) represents infinity.\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"        container dnssl {\n"
	"          description\n"
	"            \"A list of domain names that are placed in DNS Search List (DNSSL)\n"
	"            options in Router Advertisement messages sent from the interface.\";\n"
	"          reference\n"
	"            \"RFC 8106: IPv6 Router Advertisement Options for DNS\n"
	"                       Configuration\";\n"
	"          list dnssl-domain {\n"
	"            key \"domain\";\n"
	"            description\n"
	"              \"Domain name for the search list.\";\n"
	"            leaf domain {\n"
	"              type inet:domain-name;\n"
	"              description\n"
	"                \"Domain name for the search list.\";\n"
	"            }\n"
	"            leaf lifetime {\n"
	"              type uint32;\n"
	"              units \"seconds\";\n"
	"              description\n"
	"                \"The value that is placed in the Lifetime field in the\n"
	"                DNSSL option.  The designated value of all 1\'s\n"
	"                (0xffffffff) represents infinity.\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"        container pref64 {\n"
	"          description\n"
	"            \"A list of NAT64 prefixes that are placed in the PREF64 option in\n"
	"            Router Advertisement messages sent from the interface.\";\n"
	"          reference\n"
	"            \"RFC 8781: Discovering PREF64 in Router Advertisements\";\n"
	"          list pref64-prefix {\n"
	"            key \"prefix\";\n"
	"            description\n"
	"              \"NAT64 prefix details\";\n"
	"            leaf prefix {\n"
	"              type pref64-prefix;\n"
	"              description\n"
	"                \"NAT64 prefix, typically 64:ff9b::/96\";\n"
	"            }\n"
	"            leaf lifetime {\n"
	"              type uint16;\n"
	"              units \"seconds\";\n"
	"              description\n"
	"                \"Lifetime of the NAT64 prefix to be placed in RAs.\n"
	"\t\tIf omitted, the lifetime will be calculated automatically as\n"
	"\t\tMaxRtrAdvInterval * 3\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"      leaf ptm-enable {\n"
	"        if-feature ptm-bfd;\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"Enable PTM on the interface.\";\n"
	"      }\n"
	"      container state {\n"
	"        config false;\n"
	"        description\n"
	"          \"Operational data.\";\n"
	"        leaf up-count {\n"
	"          type uint16;\n"
	"          description\n"
	"            \"Interface Up count.\";\n"
	"        }\n"
	"\n"
	"        leaf down-count {\n"
	"          type uint16;\n"
	"          description\n"
	"            \"Interface Down count.\";\n"
	"        }\n"
	"\n"
	"        leaf zif-type {\n"
	"          type identityref {\n"
	"            base zebra-interface-type;\n"
	"          }\n"
	"          description\n"
	"            \"zebra interface type.\";\n"
	"        }\n"
	"\n"
	"        leaf ptm-status {\n"
	"          type string;\n"
	"          default \"disabled\";\n"
	"          description\n"
	"            \"Interface PTM status.\";\n"
	"        }\n"
	"\n"
	"        leaf vlan-id {\n"
	"          type uint16 {\n"
	"            range \"1..4094\";\n"
	"          }\n"
	"          description\n"
	"            \"A VLAN id.\";\n"
	"        }\n"
	"\n"
	"        leaf vni-id {\n"
	"          type vni-id-type;\n"
	"          description\n"
	"            \"A VNI id.\";\n"
	"        }\n"
	"\n"
	"        leaf remote-vtep {\n"
	"          type inet:ipv4-address;\n"
	"          description\n"
	"            \"The remote VTEP IP address.\";\n"
	"        }\n"
	"\n"
	"        leaf mcast-group {\n"
	"          type rt-types:ipv4-multicast-group-address;\n"
	"          description\n"
	"            \"The VNI multicast group for BUM traffic.\";\n"
	"        }\n"
	"\n"
	"        leaf bond {\n"
	"          type frr-interface:interface-ref;\n"
	"          description\n"
	"            \"The bond interface this interface belongs to.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  augment \"/frr-vrf:lib/frr-vrf:vrf\" {\n"
	"    description\n"
	"      \"Extends VRF model with Zebra-related parameters.\";\n"
	"    container zebra {\n"
	"      description\n"
	"        \"Zebra\'s vrf specific configuration and operational model.\";\n"
	"\n"
	"      leaf router-id {\n"
	"        type yang:dotted-quad;\n"
	"        description\n"
	"          \"A 32-bit number in the form of a dotted quad that is used by\n"
	"           some routing protocols identifying a router.\";\n"
	"      }\n"
	"\n"
	"      leaf ipv6-router-id {\n"
	"        type inet:ipv6-address-no-zone;\n"
	"        description\n"
	"          \"A 128-bit number in the form of an IPv6 address that is used by\n"
	"           some routing protocols identifying a router.\";\n"
	"      }\n"
	"\n"
	"      list filter-protocol {\n"
	"        key \"afi-safi protocol\";\n"
	"        description\n"
	"          \"Filter routing info exchanged between zebra and protocol.\";\n"
	"        leaf afi-safi {\n"
	"          type identityref {\n"
	"            base frr-rt:afi-safi-type;\n"
	"          }\n"
	"          description\n"
	"            \"AFI-SAFI type.\";\n"
	"        }\n"
	"        leaf protocol {\n"
	"          // This should be identityref to frr-rt:control-plane-protocol someday\n"
	"          type string;\n"
	"          description\n"
	"            \"The protocol to filter.\";\n"
	"        }\n"
	"        leaf route-map {\n"
	"          type frr-route-map:route-map-ref;\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"A route-map to filter routes.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      list filter-nht {\n"
	"        key \"afi-safi protocol\";\n"
	"        description\n"
	"          \"Filter next hop tracking route resolution.\";\n"
	"        leaf afi-safi {\n"
	"          type identityref {\n"
	"            base frr-rt:afi-safi-type;\n"
	"          }\n"
	"          description\n"
	"            \"AFI-SAFI type.\";\n"
	"        }\n"
	"        leaf protocol {\n"
	"          // This should be identityref to frr-rt:control-plane-protocol someday\n"
	"          type string;\n"
	"          description\n"
	"            \"The protocol to filter.\";\n"
	"        }\n"
	"        leaf route-map {\n"
	"          type frr-route-map:route-map-ref;\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"A route-map to filter nexthops.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      leaf resolve-via-default {\n"
	"        type boolean;\n"
	"        description\n"
	"          \"Resolve IPv4 nexthops via the default route. This is true by default\n"
	"           for traditional profile and false by default for datacenter profile.\n"
	"           Removing the leaf sets it back to the default value for the profile.\";\n"
	"      }\n"
	"\n"
	"      leaf ipv6-resolve-via-default {\n"
	"        type boolean;\n"
	"        description\n"
	"          \"Resolve IPv4 nexthops via the default route. This is true by default\n"
	"           for traditional profile and false by default for datacenter profile.\n"
	"           Removing the leaf sets it back to the default value for the profile.\";\n"
	"      }\n"
	"\n"
	"      container netns {\n"
	"        description\n"
	"          \"Configuration for netns VRF backend.\";\n"
	"        container table-range {\n"
	"          presence \"Activates table-range configuration.\";\n"
	"          description\n"
	"            \"The range of tables to use for this netns.\";\n"
	"          leaf start {\n"
	"            type uint32;\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"The first table to use.\";\n"
	"          }\n"
	"          leaf end {\n"
	"            type uint32;\n"
	"            must \". >= ../start\" {\n"
	"              error-message \"End table must be greater than or equal to start table\";\n"
	"            }\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"The last table to use.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container mpls {\n"
	"        description\n"
	"          \"MPLS Configuration.\";\n"
	"          leaf fec-nexthop-resolution {\n"
	"            type boolean;\n"
	"            description\n"
	"              \"Authorise nexthop resolution over all labeled routes.\";\n"
	"          }\n"
	"      }\n"
	"\n"
	"      uses ribs;\n"
	"\n"
	"      uses vrf-vni-mapping;\n"
	"    }\n"
	"  }\n"
	"\n"
	"  augment \"/frr-vrf:lib/frr-vrf:vrf/frr-zebra:zebra/ribs/rib/route/route-entry/nexthop-group/nexthop\" {\n"
	"    description\n"
	"      \"Augments the nexthop with operational data.\";\n"
	"\n"
	"    uses frr-nh:frr-nexthop-operational;\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Main zebra container\n"
	"   */\n"
	"\n"
	"  container zebra {\n"
	"    description\n"
	"      \"Data model for the Zebra daemon.\";\n"
	"    leaf ip-forwarding {\n"
	"      type boolean;\n"
	"      description\n"
	"        \"IP forwarding status.\";\n"
	"    }\n"
	"    leaf ipv6-forwarding {\n"
	"      type boolean;\n"
	"       description\n"
	"        \"IPv6 forwarding status.\";\n"
	"    }\n"
	"    leaf workqueue-hold-timer {\n"
	"      type uint32 {\n"
	"        range \"0..10000\";\n"
	"      }\n"
	"      units \"milliseconds\";\n"
	"      default \"10\";\n"
	"      description\n"
	"        \"Work-queue processing hold timer, in milliseconds.\";\n"
	"    }\n"
	"    leaf zapi-packets {\n"
	"      type uint32 {\n"
	"        range \"1..10000\";\n"
	"      }\n"
	"      default \"1000\";\n"
	"      description\n"
	"        \"Number of ZAPI packets to process before relinquishing\n"
	"         the main thread.\";\n"
	"    }\n"
	"    container import-kernel-table {\n"
	"      description\n"
	"        \"Parameters to use when importing IPv4 routes from a non-main kernel\n"
	"         routing table.\";\n"
	"      leaf table-id {\n"
	"        type uint32 {\n"
	"          range \"1..252\";\n"
	"        }\n"
	"        description\n"
	"          \"The kernel table id.\";\n"
	"      }\n"
	"      leaf distance {\n"
	"        type uint32 {\n"
	"          range \"1..255\";\n"
	"        }\n"
	"        default \"15\";\n"
	"        description\n"
	"          \"The admin distance to use for imported routes.\";\n"
	"      }\n"
	"      leaf route-map {\n"
	"        type frr-route-map:route-map-ref;\n"
	"        description\n"
	"          \"A route-map to filter imported routes.\";\n"
	"      }\n"
	"    }\n"
	"    leaf allow-external-route-update {\n"
	"      type empty;\n"
	"      description\n"
	"        \"Allow FRR-controlled routes to be overwritten by external processes\";\n"
	"    }\n"
	"    leaf dplane-queue-limit {\n"
	"      type uint32 {\n"
	"        range \"0..10000\";\n"
	"      }\n"
	"      default \"200\";\n"
	"      description\n"
	"        \"Limit on the number of updates queued to the dataplane subsystem.\";\n"
	"    }\n"
	"    leaf ptm-enable {\n"
	"      if-feature ptm-bfd;\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Enable PTM globally.\";\n"
	"    }\n"
	"    leaf route-map-delay {\n"
	"      type uint32 {\n"
	"        range \"0..600\";\n"
	"      }\n"
	"      units \"seconds\";\n"
	"      default \"5\";\n"
	"      description\n"
	"        \"Time to wait before route-map updates are processed.\";\n"
	"    }\n"
	"    /*\n"
	"     * Debug options\n"
	"     */\n"
	"    container debugs {\n"
	"      description\n"
	"        \"This container contains debug information for the zebra daemon.\";\n"
	"\n"
	"      uses zebra-debugs;\n"
	"    }\n"
	"    /* End of debugs */\n"
	"    /*\n"
	"     * End of configuration attributes\n"
	"     */\n"
	"    /*\n"
	"     * Operational data.\n"
	"     */\n"
	"    container state {\n"
	"      config false;\n"
	"      description\n"
	"        \"Operational data.\";\n"
	"      leaf max-multipath {\n"
	"        type uint16 {\n"
	"          range \"1..65535\";\n"
	"        }\n"
	"        description\n"
	"          \"The maximum number of nexthops for a route.  At this point it\n"
	"           is unlikely that a multipath number will ever get larger then\n"
	"           1024 but to allow for future expansions, the yang returns a\n"
	"           16 bit number\";\n"
	"      }\n"
	"      leaf ip-forwarding {\n"
	"        type boolean;\n"
	"        description\n"
	"          \"IP forwarding status.\";\n"
	"      }\n"
	"      leaf ipv6-forwarding {\n"
	"        type boolean;\n"
	"        description\n"
	"          \"IPv6 forwarding status.\";\n"
	"      }\n"
	"      leaf mpls-forwarding {\n"
	"        type boolean;\n"
	"        description\n"
	"          \"MPLS forwarding status.\";\n"
	"      }   \n"
	"    }\n"
	"    // End of operational / state container\n"
	"  }\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "frr-zebra",
	.mod_rev = "2019-06-01",
	.sub_mod_name = "",
	.sub_mod_rev = "",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
