/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"// SPDX-License-Identifier: BSD-2-Clause\n"
	"module frr-vrrpd {\n"
	"  yang-version 1.1;\n"
	"  namespace \"http://frrouting.org/yang/vrrpd\";\n"
	"  prefix frr-vrrpd;\n"
	"\n"
	"  import ietf-inet-types {\n"
	"    prefix inet;\n"
	"  }\n"
	"\n"
	"  import ietf-yang-types {\n"
	"    prefix yang;\n"
	"  }\n"
	"\n"
	"  import frr-interface {\n"
	"    prefix frr-interface;\n"
	"  }\n"
	"\n"
	"  organization\n"
	"    \"FRRouting\";\n"
	"  contact\n"
	"    \"FRR Users List:       <mailto:frog@lists.frrouting.org>\n"
	"     FRR Development List: <mailto:dev@lists.frrouting.org>\";\n"
	"  description\n"
	"    \"This module defines a model for managing FRR vrrpd daemon.\n"
	"\n"
	"     Copyright 2020 FRRouting\n"
	"\n"
	"     Redistribution and use in source and binary forms, with or without\n"
	"     modification, are permitted provided that the following conditions\n"
	"     are met:\n"
	"\n"
	"     1. Redistributions of source code must retain the above copyright notice,\n"
	"     this list of conditions and the following disclaimer.\n"
	"\n"
	"     2. Redistributions in binary form must reproduce the above copyright\n"
	"     notice, this list of conditions and the following disclaimer in the\n"
	"     documentation and/or other materials provided with the distribution.\n"
	"\n"
	"     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
	"     \\\"AS IS\\\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
	"     LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
	"     A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n"
	"     HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
	"     SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
	"     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
	"     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
	"     THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
	"     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
	"     OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\";\n"
	"\n"
	"  revision 2019-09-09 {\n"
	"    description\n"
	"      \"Initial revision.\";\n"
	"  }\n"
	"\n"
	"  grouping ip-vrrp-config {\n"
	"    description\n"
	"      \"Configuration data for VRRP on IP interfaces\";\n"
	"    leaf virtual-router-id {\n"
	"      type uint8 {\n"
	"        range \"1..255\";\n"
	"      }\n"
	"      description\n"
	"        \"Set the virtual router id for use by the VRRP group. This\n"
	"         usually also determines the virtual MAC address that is\n"
	"         generated for the VRRP group\";\n"
	"    }\n"
	"\n"
	"    leaf version {\n"
	"      type enumeration {\n"
	"        enum \"2\" {\n"
	"          value 2;\n"
	"          description\n"
	"            \"VRRP version 2.\";\n"
	"        }\n"
	"        enum \"3\" {\n"
	"          value 3;\n"
	"          description\n"
	"            \"VRRP version 3.\";\n"
	"        }\n"
	"      }\n"
	"      default \"3\";\n"
	"    }\n"
	"\n"
	"    leaf priority {\n"
	"      type uint8 {\n"
	"        range \"1..254\";\n"
	"      }\n"
	"      default \"100\";\n"
	"      description\n"
	"        \"Specifies the sending VRRP interface\'s priority\n"
	"         for the virtual router. Higher values equal higher\n"
	"         priority\";\n"
	"    }\n"
	"\n"
	"    leaf preempt {\n"
	"      type boolean;\n"
	"      default \"true\";\n"
	"      description\n"
	"        \"When set to true, enables preemption by a higher\n"
	"         priority backup router of a lower priority master router\";\n"
	"    }\n"
	"\n"
	"    leaf accept-mode {\n"
	"      type boolean;\n"
	"      default \"true\";\n"
	"      description\n"
	"        \"Configure whether packets destined for\n"
	"         virtual addresses are accepted even when the virtual\n"
	"         address is not owned by the router interface\";\n"
	"    }\n"
	"\n"
	"    leaf checksum-with-ipv4-pseudoheader {\n"
	"      type boolean;\n"
	"      default \"true\";\n"
	"      description\n"
	"        \"Enabled if VRRPv3 checksum for IPv4 involves pseudoheader\";\n"
	"    }\n"
	"\n"
	"    leaf advertisement-interval {\n"
	"      type uint16 {\n"
	"        range \"1..4095\";\n"
	"      }\n"
	"      units \"centiseconds\";\n"
	"      default \"100\";\n"
	"      description\n"
	"        \"Sets the interval between successive VRRP\n"
	"         advertisements -- RFC 5798 defines this as a 12-bit\n"
	"         value expressed as 0.1 seconds, with default 100, i.e.,\n"
	"         1 second. Several implementation express this in units of\n"
	"         seconds\";\n"
	"    }\n"
	"\n"
	"    leaf shutdown {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Administrative shutdown for this VRRP group.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping ip-vrrp-state {\n"
	"    description\n"
	"      \"Grouping for operational state data for a virtual router\";\n"
	"    leaf current-priority {\n"
	"      type uint8;\n"
	"      config false;\n"
	"      description\n"
	"        \"Operational value of the priority for the\n"
	"         interface in the VRRP group.\";\n"
	"    }\n"
	"\n"
	"    leaf vrrp-interface {\n"
	"      type frr-interface:interface-ref;\n"
	"      config false;\n"
	"      description\n"
	"        \"The interface used to transmit VRRP traffic.\";\n"
	"    }\n"
	"\n"
	"    leaf source-address {\n"
	"      type inet:ip-address;\n"
	"      config false;\n"
	"      description\n"
	"        \"The source IP address used for VRRP advertisements.\";\n"
	"    }\n"
	"\n"
	"    leaf state {\n"
	"      type enumeration {\n"
	"        enum \"Initialize\" {\n"
	"          description\n"
	"            \"State when virtual router is waiting for a Startup event.\";\n"
	"        }\n"
	"        enum \"Master\" {\n"
	"          description\n"
	"            \"State when virtual router is functioning as the forwarding router\n"
	"             for the virtual addresses.\";\n"
	"        }\n"
	"        enum \"Backup\" {\n"
	"          description\n"
	"            \"State when virtual router is monitoring the availability and state\n"
	"             of the Master router.\";\n"
	"        }\n"
	"      }\n"
	"      config false;\n"
	"    }\n"
	"\n"
	"    leaf master-advertisement-interval {\n"
	"      type uint16 {\n"
	"        range \"0..4095\";\n"
	"      }\n"
	"      units \"centiseconds\";\n"
	"      config false;\n"
	"      description\n"
	"        \"Advertisement interval contained in advertisements received from the Master.\";\n"
	"    }\n"
	"\n"
	"    leaf skew-time {\n"
	"      type uint16;\n"
	"      units \"centiseconds\";\n"
	"      config false;\n"
	"      description\n"
	"        \"Time to skew Master_Down_Interval.\";\n"
	"    }\n"
	"\n"
	"    container counter {\n"
	"      config false;\n"
	"      leaf state-transition {\n"
	"        type yang:zero-based-counter32;\n"
	"        description\n"
	"          \"Number of state transitions the virtual router has experienced.\";\n"
	"      }\n"
	"\n"
	"      container tx {\n"
	"        leaf advertisement {\n"
	"          type yang:zero-based-counter32;\n"
	"          description\n"
	"            \"Number of sent VRRP advertisements.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container rx {\n"
	"        leaf advertisement {\n"
	"          type yang:zero-based-counter32;\n"
	"          description\n"
	"            \"Number of received VRRP advertisements.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping ip-vrrp-top {\n"
	"    description\n"
	"      \"Top-level grouping for Virtual Router Redundancy Protocol\";\n"
	"    container vrrp {\n"
	"      description\n"
	"        \"Enclosing container for VRRP groups handled by this\n"
	"         IP interface\";\n"
	"      reference\n"
	"        \"RFC 5798 - Virtual Router Redundancy Protocol\n"
	"         (VRRP) Version 3 for IPv4 and IPv6\";\n"
	"      list vrrp-group {\n"
	"        key \"virtual-router-id\";\n"
	"        description\n"
	"          \"List of VRRP groups, keyed by virtual router id\";\n"
	"        uses ip-vrrp-config;\n"
	"\n"
	"        container v4 {\n"
	"          leaf-list virtual-address {\n"
	"            type inet:ipv4-address;\n"
	"            description\n"
	"              \"Configure one or more IPv4 virtual addresses for the\n"
	"               VRRP group\";\n"
	"          }\n"
	"\n"
	"          uses ip-vrrp-state {\n"
	"            augment \"counter/tx\" {\n"
	"              leaf gratuitous-arp {\n"
	"                type yang:zero-based-counter32;\n"
	"                description\n"
	"                  \"Number of sent gratuitous ARP requests.\";\n"
	"              }\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container v6 {\n"
	"          when \"../version = 3\";\n"
	"          leaf-list virtual-address {\n"
	"            type inet:ipv6-address;\n"
	"            description\n"
	"              \"Configure one or more IPv6 virtual addresses for the\n"
	"               VRRP group\";\n"
	"          }\n"
	"\n"
	"          uses ip-vrrp-state {\n"
	"            augment \"counter/tx\" {\n"
	"              leaf neighbor-advertisement {\n"
	"                type yang:zero-based-counter32;\n"
	"                description\n"
	"                  \"Number of sent unsolicited Neighbor Advertisements.\";\n"
	"              }\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  augment \"/frr-interface:lib/frr-interface:interface\" {\n"
	"    uses ip-vrrp-top;\n"
	"  }\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "frr-vrrpd",
	.mod_rev = "2019-09-09",
	.sub_mod_name = "",
	.sub_mod_rev = "",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
