/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"// SPDX-License-Identifier: BSD-2-Clause\n"
	"module frr-pim {\n"
	"  yang-version \"1.1\";\n"
	"  namespace \"http://frrouting.org/yang/pim\";\n"
	"\n"
	"  prefix frr-pim;\n"
	"\n"
	"  import frr-filter {\n"
	"    prefix frr-filter;\n"
	"  }\n"
	"\n"
	"  import frr-interface {\n"
	"    prefix frr-interface;\n"
	"  }\n"
	"\n"
	"  import frr-routing {\n"
	"    prefix \"frr-rt\";\n"
	"  }\n"
	"\n"
	"  import ietf-routing-types {\n"
	"    prefix \"rt-types\";\n"
	"  }\n"
	"\n"
	"  import ietf-inet-types {\n"
	"    prefix \"inet\";\n"
	"  }\n"
	"\n"
	"  organization\n"
	"    \"FRRouting\";\n"
	"\n"
	"  contact\n"
	"    \"FRR Users List:       <mailto:frog@lists.frrouting.org>\n"
	"     FRR Development List: <mailto:dev@lists.frrouting.org>\";\n"
	"\n"
	"  description\n"
	"    \"The module defines a collection of YANG definitions common for\n"
	"     PIM (Protocol Independent Multicast) model.\n"
	"\n"
	"     Copyright 2020 FRRouting\n"
	"\n"
	"     Redistribution and use in source and binary forms, with or without\n"
	"     modification, are permitted provided that the following conditions\n"
	"     are met:\n"
	"\n"
	"     1. Redistributions of source code must retain the above copyright notice,\n"
	"     this list of conditions and the following disclaimer.\n"
	"\n"
	"     2. Redistributions in binary form must reproduce the above copyright\n"
	"     notice, this list of conditions and the following disclaimer in the\n"
	"     documentation and/or other materials provided with the distribution.\n"
	"\n"
	"     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
	"     \\\"AS IS\\\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
	"     LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
	"     A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n"
	"     HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
	"     SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
	"     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
	"     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
	"     THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
	"     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
	"     OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\";\n"
	"\n"
	"  revision 2021-11-22 {\n"
	"    description\n"
	"      \"Initial revision.\";\n"
	"    reference\n"
	"      \"RFC XXXX: A YANG Data Model for PIM\";\n"
	"  }\n"
	"\n"
	"  identity pimd {\n"
	"    base frr-rt:routing-protocol;\n"
	"    description\n"
	"      \"\'Pim\' routing pseudo-protocol.\";\n"
	"  }\n"
	"\n"
	"  typedef plist-ref {\n"
	"    type string;\n"
	"  }\n"
	"\n"
	"  typedef access-list-ref {\n"
	"    type string;\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Multicast RPF mode configurable type\n"
	"   */\n"
	"\n"
	"  typedef mcast-rpf-lookup-mode {\n"
	"    type enumeration {\n"
	"      enum \"none\" {\n"
	"        value 0;\n"
	"        description\n"
	"          \"No mode set.\";\n"
	"      }\n"
	"      enum \"mrib-only\" {\n"
	"        value 1;\n"
	"        description\n"
	"          \"Lookup in unicast RIB only.\";\n"
	"      }\n"
	"      enum \"urib-only\" {\n"
	"        value 2;\n"
	"        description\n"
	"          \"Lookup in multicast RIB only.\";\n"
	"      }\n"
	"      enum \"mrib-then-urib\" {\n"
	"        value 3;\n"
	"        description\n"
	"          \"Try multicast RIB first, fall back to unicast RIB.\";\n"
	"      }\n"
	"      enum \"lower-distance\" {\n"
	"        value 4;\n"
	"        description\n"
	"          \"Lookup both unicast and mcast, use entry with lower distance.\";\n"
	"      }\n"
	"      enum \"longer-prefix\" {\n"
	"        value 5;\n"
	"        description\n"
	"          \"Lookup both unicast and mcast, use entry with longer prefix.\";\n"
	"      }\n"
	"    }\n"
	"    description\n"
	"      \"Multicast RPF lookup behavior\";\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Groupings\n"
	"   */\n"
	"\n"
	"  grouping msdp-timers {\n"
	"    leaf hold-time {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      units seconds;\n"
	"      default 75;\n"
	"      description\n"
	"        \"Hold period is started at the MSDP peer connection establishment\n"
	"         and is reset every new message. When the period expires the\n"
	"         connection is closed. This value should be greater than the\n"
	"         remote keep-alive time.\";\n"
	"    }\n"
	"\n"
	"    leaf keep-alive {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      units seconds;\n"
	"      default 60;\n"
	"      description\n"
	"        \"To maintain a connection established it is necessary to send\n"
	"         keep alive messages in a certain frequency and this allows its\n"
	"         configuration. This value should be less than the remote\n"
	"         hold time.\";\n"
	"    }\n"
	"\n"
	"    leaf connection-retry {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      units seconds;\n"
	"      default 30;\n"
	"      description\n"
	"        \"This period is used in the MSDP peer with the highest IP value\n"
	"         in the pair and configures the interval between TCP connection\n"
	"         attempts.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping msdp-authentication {\n"
	"    description\n"
	"      \"MSDP authentication options.\";\n"
	"\n"
	"    leaf authentication-type {\n"
	"      type enumeration {\n"
	"        enum None {\n"
	"          value 0;\n"
	"          description\n"
	"            \"No authentication.\";\n"
	"        }\n"
	"        enum MD5 {\n"
	"          value 1;\n"
	"          description\n"
	"            \"Use MD5 digest.\";\n"
	"        }\n"
	"      }\n"
	"      default None;\n"
	"      description\n"
	"        \"Authentication method.\";\n"
	"    }\n"
	"\n"
	"    leaf authentication-key {\n"
	"      when \"../authentication-type = \'MD5\'\";\n"
	"      mandatory true;\n"
	"      type string;\n"
	"      description\n"
	"        \"Authentication key.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-pim-config-attributes {\n"
	"    description\n"
	"      \"A grouping defining per address family pim global attributes\";\n"
	"\n"
	"    list mcast-rpf-lookup {\n"
	"      key \"group-list source-list\";\n"
	"      description\n"
	"        \"RPF lookup modes.\";\n"
	"\n"
	"      leaf group-list {\n"
	"        type plist-ref;\n"
	"        description\n"
	"          \"Multicast group prefix list.\";\n"
	"      }\n"
	"\n"
	"      leaf source-list {\n"
	"        type plist-ref;\n"
	"        description\n"
	"          \"Unicast source address prefix list.\";\n"
	"      }\n"
	"\n"
	"      leaf mode {\n"
	"        type mcast-rpf-lookup-mode;\n"
	"        default \"none\";\n"
	"        description\n"
	"          \"Multicast RPF lookup behavior.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    leaf ecmp {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Enable PIM ECMP.\";\n"
	"    }\n"
	"\n"
	"    leaf ecmp-rebalance {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Enable PIM ECMP Rebalance.\";\n"
	"    }\n"
	"\n"
	"    leaf keep-alive-timer {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      default \"210\";\n"
	"      description\n"
	"        \"Keep alive Timer in seconds.\";\n"
	"    }\n"
	"\n"
	"    leaf rp-keep-alive-timer {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      default \"210\";\n"
	"      description\n"
	"        \"RP keep alive Timer in seconds.\";\n"
	"    }\n"
	"\n"
	"    leaf send-v6-secondary {\n"
	"      when \"../frr-pim:address-family = \'frr-rt:ipv4\'\" {\n"
	"        description\n"
	"          \"Only applicable to IPv4 address family.\";\n"
	"      }\n"
	"      type boolean;\n"
	"      default \"true\";\n"
	"      description\n"
	"        \"Send v6 secondary addresses.\";\n"
	"    }\n"
	"\n"
	"    container spt-switchover {\n"
	"      description\n"
	"        \"SPT-Switchover.\";\n"
	"\n"
	"      leaf spt-action {\n"
	"        type enumeration {\n"
	"          enum \"PIM_SPT_IMMEDIATE\" {\n"
	"            value 0;\n"
	"            description\n"
	"              \"Immediate switch to SPT Tree.\";\n"
	"          }\n"
	"          enum \"PIM_SPT_INFINITY\" {\n"
	"            value 1;\n"
	"            description\n"
	"              \"Never switch to SPT Tree.\";\n"
	"          }\n"
	"        }\n"
	"        default \"PIM_SPT_IMMEDIATE\";\n"
	"        description\n"
	"          \"SPT-Switchover action\";\n"
	"      }\n"
	"\n"
	"      leaf spt-infinity-prefix-list {\n"
	"        when \"../spt-action = \'PIM_SPT_INFINITY\'\" {\n"
	"          description\n"
	"            \"This leaf is only valid when the spt action\n"
	"             is PIM_SPT_INFINITY.\";\n"
	"        }\n"
	"        type plist-ref;\n"
	"        description\n"
	"          \"Prefix-List to control which groups to switch.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    leaf ssm-prefix-list {\n"
	"        type plist-ref;\n"
	"        description\n"
	"          \"Prefix-list used to define Source-Specific Multicast address range.\";\n"
	"    }\n"
	"\n"
	"    leaf dm-prefix-list {\n"
	"        type plist-ref;\n"
	"        description\n"
	"          \"Prefix-list used to define Dennse Mode Multicast address range.\";\n"
	"    }\n"
	"\n"
	"\n"
	"    leaf-list ssm-pingd-source-ip {\n"
	"      type inet:ip-address;\n"
	"      description\n"
	"        \"Enable ssmpingd operation.\";\n"
	"    }\n"
	"\n"
	"    /* Global timers configuration. */\n"
	"    container msdp {\n"
	"      description \"Global MSDP configuration.\";\n"
	"      uses msdp-timers;\n"
	"\n"
	"      leaf log-neighbor-events {\n"
	"        type boolean;\n"
	"        default false;\n"
	"        description\n"
	"          \"Log all MSDP neighbor related events.\";\n"
	"      }\n"
	"\n"
	"      leaf log-sa-events {\n"
	"        type boolean;\n"
	"        default false;\n"
	"        description\n"
	"          \"Log all MSDP SA related events.\";\n"
	"      }\n"
	"\n"
	"      leaf originator-id {\n"
	"        type inet:ip-address;\n"
	"        description\n"
	"          \"Configure the RP address for the SAs.\n"
	"\n"
	"           By default the local system RP address will be used.\";\n"
	"      }\n"
	"\n"
	"      leaf shutdown {\n"
	"        type boolean;\n"
	"        default false;\n"
	"        description\n"
	"          \"Shutdown MSDP functionality.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    list msdp-mesh-groups {\n"
	"      key \"name\";\n"
	"      description\n"
	"        \"RFC 3618 Section 10.2. MSDP mesh-group semantics\n"
	"\n"
	"         Groups multiple MSDP peers to reduce SA flooding typically used\n"
	"         in intra-domain settings.\";\n"
	"\n"
	"      leaf name {\n"
	"        type string {\n"
	"          length 1..64;\n"
	"        }\n"
	"        description\n"
	"          \"The mesh group name.\";\n"
	"      }\n"
	"\n"
	"      leaf source {\n"
	"        type inet:ip-address;\n"
	"        description\n"
	"          \"Source IP address for the TCP connections.\";\n"
	"      }\n"
	"\n"
	"      list members {\n"
	"        key \"address\";\n"
	"\n"
	"        leaf address {\n"
	"          type inet:ip-address;\n"
	"          description\n"
	"            \"Peer member IP address.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    list msdp-peer {\n"
	"      key \"peer-ip\";\n"
	"      description\n"
	"        \"Configure MSDP peer.\";\n"
	"\n"
	"      leaf peer-ip {\n"
	"        type inet:ip-address;\n"
	"        description\n"
	"          \"MSDP peer IP address.\";\n"
	"      }\n"
	"\n"
	"      leaf source-ip {\n"
	"        mandatory true;\n"
	"        type inet:ip-address;\n"
	"        description\n"
	"          \"MSDP source IP address.\";\n"
	"      }\n"
	"\n"
	"      leaf sa-filter-in {\n"
	"        type frr-filter:access-list-name;\n"
	"        description\n"
	"          \"Access list name used to filter the incoming SAs exchanged.\";\n"
	"      }\n"
	"\n"
	"      leaf sa-filter-out {\n"
	"        type frr-filter:access-list-name;\n"
	"        description\n"
	"          \"Access list name used to filter the outgoing SAs exchanged.\";\n"
	"      }\n"
	"\n"
	"      uses msdp-authentication;\n"
	"\n"
	"      leaf sa-limit {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"Peer SA maximum limit.\";\n"
	"      }\n"
	"\n"
	"      leaf as {\n"
	"        type inet:as-number;\n"
	"        description\n"
	"          \"BGP Autonomous System number.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    container mlag {\n"
	"      presence\n"
	"        \"Multi-chassis link aggregation.\";\n"
	"\n"
	"     leaf peerlink-rif {\n"
	"        type frr-interface:interface-ref;\n"
	"        description\n"
	"         \"Outgoing interface name.\";\n"
	"      }\n"
	"\n"
	"      leaf reg-address {\n"
	"        type inet:ip-address;\n"
	"        description\n"
	"          \"reg address.\";\n"
	"      }\n"
	"\n"
	"      leaf my-role {\n"
	"        type enumeration {\n"
	"          enum \"MLAG_ROLE_NONE\" {\n"
	"            value 0;\n"
	"            description\n"
	"              \"MLAG role none.\";\n"
	"          }\n"
	"          enum \"MLAG_ROLE_PRIMARY\" {\n"
	"            value 1;\n"
	"            description\n"
	"              \"MLAG role primary.\";\n"
	"          }\n"
	"\n"
	"          enum \"MLAG_ROLE_SECONDARY\" {\n"
	"            value 2;\n"
	"            description\n"
	"              \"MLAG role secondary.\";\n"
	"          }\n"
	"        }\n"
	"        default \"MLAG_ROLE_NONE\";\n"
	"        description\n"
	"          \"Mlag role.\";\n"
	"      }\n"
	"\n"
	"      leaf peer-state {\n"
	"       type boolean;\n"
	"       default \"false\";\n"
	"       description\n"
	"         \"Peer state\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    leaf register-accept-list {\n"
	"        type plist-ref;\n"
	"        description\n"
	"          \"Only accept registers from a specific source prefix list.\";\n"
	"    }\n"
	"  } // global-pim-config-attributes\n"
	"\n"
	"  grouping interface-pim-config-attributes {\n"
	"    description\n"
	"      \"A grouping defining pim interface attributes per address family.\";\n"
	"\n"
	"    leaf pim-enable {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Enable PIM flag on the interface.\";\n"
	"    }\n"
	"    leaf pim-passive-enable {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Disable exchange of protocol packets.\";\n"
	"    }\n"
	"    leaf pim-mode {\n"
	"      type enumeration {\n"
	"        enum \"SPARSE\" {\n"
	"          value 0;\n"
	"          description\n"
	"            \"Sparse mode.\";\n"
	"        }\n"
	"        enum \"DENSE\" {\n"
	"          value 1;\n"
	"          description\n"
	"            \"Dense mode.\";\n"
	"        }\n"
	"        enum \"SPARSE_DENSE\" {\n"
	"          value 2;\n"
	"          description\n"
	"            \"Sparse-Dense mode.\";\n"
	"        }\n"
	"        enum \"SSM\" {\n"
	"          value 3;\n"
	"          description\n"
	"            \"Source Specific Multicast only.\";\n"
	"        }\n"
	"      }\n"
	"      default \"SPARSE\";\n"
	"      description\n"
	"        \"PIM interface mode\";\n"
	"    }\n"
	"\n"
	"    leaf hello-interval {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      default \"30\";\n"
	"      description\n"
	"        \"Hello interval\";\n"
	"    }\n"
	"\n"
	"    leaf hello-holdtime {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      must \". > ./../hello-interval\" {\n"
	"      error-message \"HoldTime must be greater than Hello\";\n"
	"      }\n"
	"      description\n"
	"        \"Hello holdtime\";\n"
	"    }\n"
	"\n"
	"    leaf neighbor-filter-prefix-list {\n"
	"      type plist-ref;\n"
	"      description\n"
	"        \"Prefix-List to filter allowed PIM neighbors.\";\n"
	"    }\n"
	"\n"
	"    container bfd {\n"
	"      presence\n"
	"        \"Enable BFD support on the interface.\";\n"
	"\n"
	"      leaf min-rx-interval {\n"
	"        type uint16 {\n"
	"          range \"1..max\";\n"
	"        }\n"
	"        default \"300\";\n"
	"          description\n"
	"            \"Required min receive interval\";\n"
	"      }\n"
	"\n"
	"      leaf min-tx-interval {\n"
	"        type uint16 {\n"
	"          range \"1..max\";\n"
	"        }\n"
	"        default \"300\";\n"
	"        description\n"
	"          \"Desired min transmit interval\";\n"
	"      }\n"
	"\n"
	"      leaf detect_mult {\n"
	"        type uint8 {\n"
	"          range \"2..255\";\n"
	"        }\n"
	"        default \"3\";\n"
	"        description\n"
	"          \"Detect Multiplier\";\n"
	"      }\n"
	"\n"
	"      leaf profile {\n"
	"        type string;\n"
	"        description\n"
	"          \"Use a preconfigure BFD profile.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    leaf bsm {\n"
	"      type boolean;\n"
	"      default \"true\";\n"
	"      description\n"
	"        \"Enables BSM support on the interface.\";\n"
	"    }\n"
	"\n"
	"    leaf unicast-bsm {\n"
	"      type boolean;\n"
	"      default \"true\";\n"
	"      description\n"
	"        \"Accept/Send unicast BSM on the interface.\";\n"
	"    }\n"
	"\n"
	"    leaf active-active {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Mark interface as Active-Active for MLAG operations.\";\n"
	"    }\n"
	"\n"
	"    leaf dr-priority {\n"
	"      type uint32;\n"
	"      default 1;\n"
	"      description\n"
	"        \"DR (Designated Router) priority\";\n"
	"    }\n"
	"\n"
	"    leaf use-source {\n"
	"      type inet:ip-address;\n"
	"      description\n"
	"        \"Primary address of the interface set by user.\";\n"
	"    }\n"
	"\n"
	"    leaf multicast-boundary-oil {\n"
	"      type plist-ref;\n"
	"      description\n"
	"        \"Prefix-List to define multicast boundary by group\";\n"
	"    }\n"
	"\n"
	"    leaf multicast-boundary-acl {\n"
	"      type access-list-ref;\n"
	"      description\n"
	"        \"Access-list to define multicast boundary by source and group\";\n"
	"    }\n"
	"\n"
	"    list mroute {\n"
	"      key \"source-addr group-addr\";\n"
	"      description\n"
	"        \"Add multicast route.\";\n"
	"\n"
	"      leaf oif {\n"
	"        type frr-interface:interface-ref;\n"
	"        description\n"
	"          \"Outgoing interface name.\";\n"
	"      }\n"
	"\n"
	"      leaf source-addr {\n"
	"        type inet:ip-address;\n"
	"        description\n"
	"          \"Multicast source address.\";\n"
	"      }\n"
	"\n"
	"      leaf group-addr {\n"
	"        type rt-types:ip-multicast-group-address;\n"
	"        description\n"
	"          \"Multicast group address.\";\n"
	"      }\n"
	"    }\n"
	"  } // interface-pim-config-attributes\n"
	"\n"
	"  grouping router-pim-config-attributes {\n"
	"    description\n"
	"      \"A grouping defining pim router attributes per address family.\";\n"
	"    leaf packets {\n"
	"      type uint8 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      default \"3\";\n"
	"      description\n"
	"        \"Number of packets to process at one time per fd.\";\n"
	"    }\n"
	"    leaf join-prune-interval {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      default \"60\";\n"
	"      description\n"
	"        \"Join Prune Send Interval in seconds.\";\n"
	"    }\n"
	"    leaf register-suppress-time {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      default \"60\";\n"
	"      description\n"
	"        \"Register Suppress Timer.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Global Configuration data nodes\n"
	"   */\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/\"\n"
	"        + \"frr-rt:control-plane-protocol\" {\n"
	"    container pim {\n"
	"      when \"../frr-rt:type = \'frr-pim:pimd\'\" {\n"
	"        description\n"
	"          \"This container is only valid for the \'pim\' routing\n"
	"           protocol.\";\n"
	"      }\n"
	"      description\n"
	"        \"PIM configuration data.\";\n"
	"      list address-family {\n"
	"        key \"address-family\";\n"
	"        description\n"
	"          \"Each list entry for one address family.\";\n"
	"        uses frr-rt:address-family;\n"
	"        uses global-pim-config-attributes;\n"
	"\n"
	"      } //address-family\n"
	"    } // pim\n"
	"  } // augment\n"
	"\n"
	"  /*\n"
	"   * Per-interface configuration data\n"
	"   */\n"
	"  augment \"/frr-interface:lib/frr-interface:interface\" {\n"
	"    container pim {\n"
	"      list address-family {\n"
	"        key \"address-family\";\n"
	"        description\n"
	"          \"Each list entry for one address family.\";\n"
	"        uses frr-rt:address-family;\n"
	"        uses interface-pim-config-attributes;\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Router configuration data\n"
	"   */\n"
	"  container pim {\n"
	"    description\n"
	"      \"PIM router parameters.\";\n"
	"    list address-family {\n"
	"      key \"address-family\";\n"
	"      description\n"
	"        \"Each list entry for one address family.\";\n"
	"      uses frr-rt:address-family;\n"
	"      uses router-pim-config-attributes;\n"
	"    }\n"
	"  }\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "frr-pim",
	.mod_rev = "2021-11-22",
	.sub_mod_name = "",
	.sub_mod_rev = "",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
