/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"// SPDX-License-Identifier: BSD-2-Clause\n"
	"module frr-pim-rp {\n"
	"  yang-version \"1.1\";\n"
	"  namespace \"http://frrouting.org/yang/pim-rp\";\n"
	"\n"
	"  prefix frr-pim-rp;\n"
	"\n"
	"  import ietf-inet-types {\n"
	"    prefix \"inet\";\n"
	"  }\n"
	"\n"
	"  import frr-routing {\n"
	"    prefix \"frr-rt\";\n"
	"  }\n"
	"\n"
	"  import frr-pim {\n"
	"    prefix \"frr-pim\";\n"
	"  }\n"
	"\n"
	"  import frr-route-types {\n"
	"    prefix frr-route-types;\n"
	"  }\n"
	"\n"
	"  import frr-interface {\n"
	"    prefix \"frr-interface\";\n"
	"  }\n"
	"\n"
	"  organization\n"
	"    \"FRRouting\";\n"
	"\n"
	"  contact\n"
	"    \"FRR Users List:       <mailto:frog@lists.frrouting.org>\n"
	"     FRR Development List: <mailto:dev@lists.frrouting.org>\";\n"
	"\n"
	"  description\n"
	"    \"The module defines a collection of YANG definitions common for\n"
	"     all PIM (Protocol Independent Multicast) RP (Rendezvous Point) model.\n"
	"\n"
	"     Copyright 2020 FRRouting\n"
	"\n"
	"     Redistribution and use in source and binary forms, with or without\n"
	"     modification, are permitted provided that the following conditions\n"
	"     are met:\n"
	"\n"
	"     1. Redistributions of source code must retain the above copyright notice,\n"
	"     this list of conditions and the following disclaimer.\n"
	"\n"
	"     2. Redistributions in binary form must reproduce the above copyright\n"
	"     notice, this list of conditions and the following disclaimer in the\n"
	"     documentation and/or other materials provided with the distribution.\n"
	"\n"
	"     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
	"     \\\"AS IS\\\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
	"     LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
	"     A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n"
	"     HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
	"     SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
	"     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
	"     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
	"     THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
	"     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
	"     OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\";\n"
	"\n"
	"  revision 2024-09-26 {\n"
	"    description\n"
	"      \"Add support for embedded RP.\";\n"
	"    reference\n"
	"      \"RFC 3956: Embedding the Rendezvous Point (RP) Address in an IPv6\n"
	"       Multicast Address\";\n"
	"  }\n"
	"\n"
	"  revision 2017-03-09 {\n"
	"    description\n"
	"      \"Initial revision.\";\n"
	"    reference\n"
	"      \"RFC XXXX: A YANG Data Model for PIM RP\";\n"
	"  }\n"
	"\n"
	"  typedef plist-ref {\n"
	"    type string;\n"
	"    description\n"
	"      \"Type definition for prefix list references.\";\n"
	"  }\n"
	"\n"
	"  /*\n"
	"   * Groupings\n"
	"   */\n"
	"  grouping static-rp-container {\n"
	"    description\n"
	"      \"Grouping of static RP container.\";\n"
	"\n"
	"    container static-rp {\n"
	"      description\n"
	"        \"Containing static RP attributes.\";\n"
	"\n"
	"      list rp-list {\n"
	"        key \"rp-address\";\n"
	"        description\n"
	"          \"A list of RP addresses.\";\n"
	"\n"
	"        leaf rp-address {\n"
	"          type inet:ip-address;\n"
	"          description\n"
	"            \"Specifies a static RP address.\";\n"
	"        }\n"
	"\n"
	"        choice group-list-or-prefix-list {\n"
	"          description \"Use group-list or prefix-list\";\n"
	"          case group-list {\n"
	"            leaf-list group-list{\n"
	"              type frr-route-types:ip-multicast-group-prefix;\n"
	"              description\n"
	"                \"List of multicast group address.\";\n"
	"            }\n"
	"          }\n"
	"          case prefix-list {\n"
	"            leaf prefix-list {\n"
	"              type plist-ref;\n"
	"              description\n"
	"                \"Group prefix-list filter\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    } // static-rp\n"
	"  } // static-rp-container\n"
	"\n"
	"  grouping embedded-rp-group {\n"
	"    description\n"
	"      \"Grouping for embedded RP configurations.\";\n"
	"\n"
	"    container embedded-rp {\n"
	"      description \"Embedded RP configurations.\";\n"
	"\n"
	"      leaf enable {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Toggle embedded RP state:\n"
	"\n"
	"           When enabled the learned RP from the multicast group address\n"
	"           will be preferred over any static or dynamic RP configuration.\n"
	"\n"
	"           When disabled the packet will be processed as usual.\";\n"
	"      }\n"
	"\n"
	"      leaf group-list {\n"
	"        type plist-ref;\n"
	"        description\n"
	"          \"Restrict embedded RP prefix ranges.\n"
	"\n"
	"           The default is to treat all multicast groups in FF70::/12\n"
	"           range as embedded RP. When a group prefix list is configured\n"
	"           and group does not match one of its permit entries it will\n"
	"           be treated as regular multicast group.\";\n"
	"      }\n"
	"\n"
	"      leaf maximum-rps {\n"
	"        type uint32;\n"
	"        default 25;\n"
	"        description\n"
	"          \"Maximum allowed number of RPs to learn.\";\n"
	"      }\n"
	"    } // embedded-rp container\n"
	"  } // embedded-rp group\n"
	"\n"
	"  grouping auto-rp-container {\n"
	"    description\n"
	"      \"Grouping of AutoRP container.\";\n"
	"\n"
	"    container auto-rp {\n"
	"      description\n"
	"        \"Containing AutoRP attributes.\";\n"
	"\n"
	"      leaf discovery-enabled {\n"
	"        type boolean;\n"
	"        description\n"
	"          \"Flag indicating if Auto RP discovery is enabled.\";\n"
	"      }\n"
	"\n"
	"      leaf announce-scope {\n"
	"        type uint8;\n"
	"        description\n"
	"          \"The TTL of the C-RP Announcement packet.\";\n"
	"      }\n"
	"\n"
	"      leaf announce-interval {\n"
	"        type uint16;\n"
	"        description\n"
	"          \"The time between sending C-RP announcement packets (seconds).\";\n"
	"      }\n"
	"\n"
	"      leaf announce-holdtime {\n"
	"        type uint16;\n"
	"        description\n"
	"          \"The hold time in seconds advertised in the announcement packet.\";\n"
	"      }\n"
	"\n"
	"      list candidate-rp-list {\n"
	"        key \"rp-address\";\n"
	"        description\n"
	"          \"A list of Candidate RP addresses.\";\n"
	"\n"
	"        leaf rp-address {\n"
	"          type inet:ip-address;\n"
	"          description\n"
	"            \"Specifies a candidate RP address.\";\n"
	"        }\n"
	"\n"
	"        choice group-or-prefix-list {\n"
	"          description \"Use group or prefix-list\";\n"
	"          case group {\n"
	"            leaf group {\n"
	"              type frr-route-types:ip-multicast-group-prefix;\n"
	"              description\n"
	"                \"Multicast group prefix.\";\n"
	"            }\n"
	"          }\n"
	"          case prefix-list {\n"
	"            leaf prefix-list {\n"
	"              type plist-ref;\n"
	"              description\n"
	"                \"Group prefix-list filter\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      } // candidate-rp-list\n"
	"\n"
	"      container mapping-agent {\n"
	"        description\n"
	"          \"AutoRP mapping agent configuration data.\";\n"
	"\n"
	"        leaf send-rp-discovery {\n"
	"          type boolean;\n"
	"          default false;\n"
	"          description\n"
	"            \"Make this router an AutoRP mapping agent\";\n"
	"        }\n"
	"\n"
	"        leaf discovery-scope {\n"
	"          type uint8;\n"
	"          default 31;\n"
	"          description\n"
	"            \"The TTL of the discovery packet\";\n"
	"        }\n"
	"\n"
	"        leaf discovery-interval {\n"
	"          type uint16 {\n"
	"            range \"1 .. 65535\";\n"
	"          }\n"
	"          default 60;\n"
	"          description\n"
	"            \"The time between sending discovery advertisements (seconds)\";\n"
	"        }\n"
	"\n"
	"        leaf discovery-holdtime {\n"
	"          type uint16 {\n"
	"            range \"0 .. 65535\";\n"
	"          }\n"
	"          default 180;\n"
	"          description\n"
	"            \"The hold time in seconds advertised in the discovery packet.\";\n"
	"        }\n"
	"\n"
	"        choice source-address-or-interface {\n"
	"          default if-loopback;\n"
	"          description \"Source address to use for mapping agent operation\";\n"
	"          leaf address {\n"
	"            type inet:ip-address;\n"
	"            description\n"
	"              \"Source IP address for mapping agent operation.\";\n"
	"          }\n"
	"          leaf interface {\n"
	"            type frr-interface:interface-ref;\n"
	"            description\n"
	"              \"Interface to use for mapping agent operation.\";\n"
	"          }\n"
	"          leaf if-loopback {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Loopback interface for mapping agent operation.\";\n"
	"          }\n"
	"          leaf if-any {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Any interface for mapping agent operation.\";\n"
	"          }\n"
	"        }\n"
	"      } // mapping-agent\n"
	"    } // auto-rp\n"
	"  } // auto-rp-container\n"
	"\n"
	"  /*\n"
	"   * Configuration data nodes\n"
	"   */\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/\"\n"
	"    + \"frr-rt:control-plane-protocol/frr-pim:pim/\"\n"
	"    + \"frr-pim:address-family\" {\n"
	"    description \"PIM RP augmentation.\";\n"
	"\n"
	"    container rp {\n"
	"      description\n"
	"        \"PIM RP configuration data.\";\n"
	"      uses static-rp-container;\n"
	"\n"
	"      uses auto-rp-container {\n"
	"        when \"../frr-pim:address-family = \'frr-rt:ipv4\'\" {\n"
	"          description\n"
	"            \"Only applicable to IPv4 address family.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      uses embedded-rp-group {\n"
	"        when \"../frr-pim:address-family = \'frr-rt:ipv6\'\" {\n"
	"          description\n"
	"            \"Only available for IPv6 addresses.\";\n"
	"        }\n"
	"      }\n"
	"    } // rp\n"
	"  } // augment\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "frr-pim-rp",
	.mod_rev = "2024-09-26",
	.sub_mod_name = "",
	.sub_mod_rev = "",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
