/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"// SPDX-License-Identifier: BSD-2-Clause\n"
	"module frr-isisd {\n"
	"  yang-version 1.1;\n"
	"  namespace \"http://frrouting.org/yang/isisd\";\n"
	"  prefix frr-isisd;\n"
	"\n"
	"  import ietf-yang-types {\n"
	"    prefix yang;\n"
	"  }\n"
	"\n"
	"  import ietf-inet-types {\n"
	"    prefix inet;\n"
	"  }\n"
	"\n"
	"  import frr-interface {\n"
	"    prefix frr-interface;\n"
	"  }\n"
	"\n"
	"  import frr-vrf {\n"
	"    prefix frr-vrf;\n"
	"  }\n"
	"\n"
	"  import frr-route-map {\n"
	"    prefix frr-route-map;\n"
	"  }\n"
	"\n"
	"  import frr-route-types {\n"
	"    prefix frr-route-types;\n"
	"  }\n"
	"\n"
	"  organization\n"
	"    \"FRRouting\";\n"
	"  contact\n"
	"    \"FRR Users List: <mailto:frog@lists.frrouting.org> FRR Development\n"
	"     List: <mailto:dev@lists.frrouting.org>\";\n"
	"  description\n"
	"    \"This module defines a model for managing FRR isisd daemon.\n"
	"\n"
	"     Copyright 2020 FRRouting\n"
	"\n"
	"     Redistribution and use in source and binary forms, with or without\n"
	"     modification, are permitted provided that the following conditions\n"
	"     are met:\n"
	"\n"
	"     1. Redistributions of source code must retain the above copyright notice,\n"
	"     this list of conditions and the following disclaimer.\n"
	"\n"
	"     2. Redistributions in binary form must reproduce the above copyright\n"
	"     notice, this list of conditions and the following disclaimer in the\n"
	"     documentation and/or other materials provided with the distribution.\n"
	"\n"
	"     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
	"     \\\"AS IS\\\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
	"     LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
	"     A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n"
	"     HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
	"     SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
	"     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
	"     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
	"     THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
	"     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
	"     OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\";\n"
	"\n"
	"  revision 2021-02-15 {\n"
	"    description\n"
	"      \"Group SRGB and SRLB in a container so that they can be displayed\n"
	"       and configured together\";\n"
	"    reference\n"
	"      \"ISO/IEC 10589:2002.\";\n"
	"  }\n"
	"  revision 2020-04-06 {\n"
	"    description\n"
	"      \"Group LSP timers in a container so that they can be displayed and\n"
	"       configured together\";\n"
	"    reference\n"
	"      \"ISO/IEC 10589:2002.\";\n"
	"  }\n"
	"  revision 2019-12-17 {\n"
	"    description\n"
	"      \"Changed default area is-type to level-1-2\";\n"
	"    reference\n"
	"      \"ISO/IEC 10589:2002.\";\n"
	"  }\n"
	"  revision 2019-09-09 {\n"
	"    description\n"
	"      \"Changed interface references to use\n"
	"       frr-interface:interface-ref typedef\";\n"
	"    reference\n"
	"      \"ISO/IEC 10589:2002.\";\n"
	"  }\n"
	"  revision 2018-07-26 {\n"
	"    description\n"
	"      \"Initial revision.\";\n"
	"    reference\n"
	"      \"ISO/IEC 10589:2002.\";\n"
	"  }\n"
	"\n"
	"  typedef level {\n"
	"    type enumeration {\n"
	"      enum \"level-1\" {\n"
	"        value 1;\n"
	"        description\n"
	"          \"This enum indicates L1-only capability.\";\n"
	"      }\n"
	"      enum \"level-2\" {\n"
	"        value 2;\n"
	"        description\n"
	"          \"This enum indicates L2-only capability.\";\n"
	"      }\n"
	"      enum \"level-1-2\" {\n"
	"        value 3;\n"
	"        description\n"
	"          \"This enum indicates capability for both levels.\";\n"
	"      }\n"
	"    }\n"
	"    description\n"
	"      \"This type defines IS-IS level of an object.\";\n"
	"  }\n"
	"\n"
	"  typedef extended-circuit-id {\n"
	"    type uint32;\n"
	"    description\n"
	"      \"This type defines the extended circuit ID\n"
	"       associated with an interface.\";\n"
	"  }\n"
	"\n"
	"  typedef hello-padding-type {\n"
	"    type enumeration {\n"
	"      enum \"always\" {\n"
	"        value 0;\n"
	"        description\n"
	"          \"Add padding to all hello packets.\";\n"
	"      }\n"
	"      enum \"disabled\" {\n"
	"        value 1;\n"
	"        description\n"
	"          \"Do not add any padding to hello packets.\";\n"
	"      } \n"
	"      enum \"during-adjacency-formation\" {\n"
	"        value 2;\n"
	"        description\n"
	"          \"Add padding to hello packets during adjacency formation only.\";\n"
	"      }\n"
	"    }\n"
	"    description\n"
	"      \"Type for hello padding configuration.\";\n"
	"  }\n"
	"\n"
	"  typedef network-type {\n"
	"    type enumeration {\n"
	"      enum \"unknown\" {\n"
	"        value 0;\n"
	"        description\n"
	"          \"Unknown network type. Only valid as a state.\";\n"
	"      }\n"
	"      enum \"broadcast\" {\n"
	"        value 1;\n"
	"        description\n"
	"          \"Broadcast circuit network-type.\";\n"
	"      }\n"
	"      enum \"point-to-point\" {\n"
	"        value 2;\n"
	"        description\n"
	"          \"Point-to-point circuit network-type.\";\n"
	"      }\n"
	"      enum \"loopback\" {\n"
	"        value 3;\n"
	"        description\n"
	"          \"Loopback circuit network-type. Only valid as a state.\";\n"
	"      }\n"
	"    }\n"
	"    description\n"
	"      \"Type of network for an IS-IS interface.\";\n"
	"  }\n"
	"\n"
	"  typedef lsp-id {\n"
	"    type string {\n"
	"      pattern \"[0-9A-Fa-f]{4}\\\\.[0-9A-Fa-f]{4}\\\\.[0-9A-Fa-f]{4}\\\\.[0-9][0-9]-[0-9][0-9]\";\n"
	"    }\n"
	"    description\n"
	"      \"This type defines the IS-IS LSP ID format using a\n"
	"       pattern, An example LSP ID is 0143.0438.AeF0.02-01\";\n"
	"  }\n"
	"\n"
	"  typedef snpa {\n"
	"    type string {\n"
	"      length \"0 .. 20\";\n"
	"    }\n"
	"    description\n"
	"      \"This type defines the Subnetwork Point\n"
	"       of Attachment (SNPA) format.\n"
	"       The SNPA should be encoded according to the rules\n"
	"       specified for the particular type of subnetwork\n"
	"       being used. As an example, for an ethernet subnetwork,\n"
	"       the SNPA is encoded as a MAC address like\n"
	"       \'00aa.bbcc.ddee\'.\";\n"
	"  }\n"
	"\n"
	"  typedef system-id {\n"
	"    type string {\n"
	"      pattern \"[0-9A-Fa-f]{4}\\\\.[0-9A-Fa-f]{4}\\\\.[0-9A-Fa-f]{4}\";\n"
	"    }\n"
	"    description\n"
	"      \"This type defines IS-IS system-id using a pattern,\n"
	"       An example system-id is 0143.0438.AeF0\";\n"
	"  }\n"
	"\n"
	"  typedef net-address {\n"
	"    type string {\n"
	"      pattern \"[a-fA-F0-9]{2}(\\\\.[a-fA-F0-9]{4}){3,9}\\\\.[a-fA-F0-9]{2}\";\n"
	"    }\n"
	"    description\n"
	"      \"This type defines an OSI NET address using a pattern,\n"
	"       An example net-address is 49.0123.6452.1972.00\";\n"
	"  }\n"
	"\n"
	"  typedef if-state-type {\n"
	"    type enumeration {\n"
	"      enum \"up\" {\n"
	"        value 0;\n"
	"        description\n"
	"          \"Up state.\";\n"
	"      }\n"
	"      enum \"down\" {\n"
	"        value 1;\n"
	"        description\n"
	"          \"Down state\";\n"
	"      }\n"
	"    }\n"
	"    description\n"
	"      \"This type defines the state of an interface\";\n"
	"  }\n"
	"\n"
	"  typedef adj-state-type {\n"
	"    type enumeration {\n"
	"      enum \"up\" {\n"
	"        value 0;\n"
	"        description\n"
	"          \"State indicates the adjacency is established.\";\n"
	"      }\n"
	"      enum \"down\" {\n"
	"        value 1;\n"
	"        description\n"
	"          \"State indicates the adjacency is NOT established.\";\n"
	"      }\n"
	"      enum \"init\" {\n"
	"        value 2;\n"
	"        description\n"
	"          \"State indicates the adjacency is establishing.\";\n"
	"      }\n"
	"      enum \"failed\" {\n"
	"        value 3;\n"
	"        description\n"
	"          \"State indicates the adjacency is failed.\";\n"
	"      }\n"
	"    }\n"
	"    description\n"
	"      \"This type defines states of an adjacency\";\n"
	"  }\n"
	"\n"
	"  typedef metric-style-type {\n"
	"    type enumeration {\n"
	"      enum \"narrow\" {\n"
	"        value 0;\n"
	"        description\n"
	"          \"This enum describes narrow metric style\";\n"
	"        reference\n"
	"          \"RFC1195\";\n"
	"      }\n"
	"      enum \"wide\" {\n"
	"        value 1;\n"
	"        description\n"
	"          \"This enum describes wide metric style\";\n"
	"        reference\n"
	"          \"RFC5305\";\n"
	"      }\n"
	"      enum \"transition\" {\n"
	"        value 2;\n"
	"        description\n"
	"          \"This enum describes transition metric style\";\n"
	"      }\n"
	"    }\n"
	"    description\n"
	"      \"Enumeration for IS-IS metric styles.\";\n"
	"  }\n"
	"\n"
	"  typedef access-list-ref {\n"
	"    type string;\n"
	"    description\n"
	"      \"Reference to a access list.\";\n"
	"  }\n"
	"\n"
	"  typedef prefix-list-ref {\n"
	"    type string;\n"
	"    description\n"
	"      \"Reference to a prefix list.\";\n"
	"  }\n"
	"\n"
	"  grouping redistribute-attributes {\n"
	"    description\n"
	"      \"Common optional attributes of any redistribute entry.\";\n"
	"    leaf route-map {\n"
	"      type frr-route-map:route-map-ref;\n"
	"      description\n"
	"        \"Applies the conditions of the specified route-map to routes that\n"
	"         are redistributed into this routing instance.\";\n"
	"    }\n"
	"\n"
	"    leaf metric {\n"
	"      type uint32 {\n"
	"        range \"0..16777215\";\n"
	"      }\n"
	"      default \"0\";\n"
	"      description\n"
	"        \"Metric used for the redistributed route. If 0,\n"
	"         the default-metric attribute is used instead.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping redistribute-default {\n"
	"    description\n"
	"      \"Redistribution of default route within a level.\";\n"
	"    leaf always {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Always advertise default route.\";\n"
	"    }\n"
	"\n"
	"    uses redistribute-attributes;\n"
	"  }\n"
	"\n"
	"  grouping isis-password {\n"
	"    description\n"
	"      \"Authentication attributes or an IS-IS area or domain.\";\n"
	"    leaf password {\n"
	"      type string {\n"
	"        length \"1..254\";\n"
	"      }\n"
	"      mandatory true;\n"
	"      description\n"
	"        \"Actual password.\";\n"
	"    }\n"
	"\n"
	"    leaf password-type {\n"
	"      type enumeration {\n"
	"        enum \"clear\" {\n"
	"          value 1;\n"
	"          description\n"
	"            \"Clear-text password type.\";\n"
	"        }\n"
	"        enum \"md5\" {\n"
	"          value 54;\n"
	"          description\n"
	"            \"MD5 password type.\";\n"
	"        }\n"
	"      }\n"
	"      mandatory true;\n"
	"      description\n"
	"        \"Type of password used.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping isis-area-password {\n"
	"    description\n"
	"      \"Grouping for IS-IS area password configuration.\";\n"
	"\n"
	"    uses isis-password;\n"
	"\n"
	"    leaf authenticate-snp {\n"
	"      type enumeration {\n"
	"        enum \"none\" {\n"
	"          value 0;\n"
	"          description\n"
	"            \"No SNP authentication.\";\n"
	"        }\n"
	"        enum \"send-only\" {\n"
	"          value 1;\n"
	"          description\n"
	"            \"Send authenticated PDUs but do not check on receiving.\";\n"
	"        }\n"
	"        enum \"validate\" {\n"
	"          value 3;\n"
	"          description\n"
	"            \"Send authenticated PDUs and check on receiving.\";\n"
	"        }\n"
	"      }\n"
	"      default \"none\";\n"
	"      description\n"
	"        \"SNP PDUs authentication.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-config-lfa {\n"
	"    description\n"
	"      \"Grouping for LFA configuration.\";\n"
	"\n"
	"    container lfa {\n"
	"      description\n"
	"        \"LFA configuration.\";\n"
	"\n"
	"      leaf load-sharing {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"Load share prefixes across multiple backups.\";\n"
	"      }\n"
	"      leaf priority-limit {\n"
	"        type enumeration {\n"
	"          enum \"critical\" {\n"
	"            value 0;\n"
	"            description\n"
	"              \"Compute for critical priority prefixes only.\";\n"
	"          }\n"
	"          enum \"high\" {\n"
	"            value 1;\n"
	"            description\n"
	"              \"Compute for critical & high priority prefixes.\";\n"
	"          }\n"
	"          enum \"medium\" {\n"
	"            value 2;\n"
	"            description\n"
	"              \"Compute for critical, high & medium priority prefixes.\";\n"
	"          }\n"
	"        }\n"
	"        description\n"
	"          \"Limit backup computation up to the prefix priority.\";\n"
	"      }\n"
	"      list tiebreaker {\n"
	"        key \"index type\";\n"
	"        unique \"type\";\n"
	"        description\n"
	"          \"Configure tiebreaker for multiple backups.\";\n"
	"        leaf index {\n"
	"          type uint8 {\n"
	"            range \"1..255\";\n"
	"          }\n"
	"          description\n"
	"            \"Preference order among tiebreakers.\";\n"
	"        }\n"
	"        leaf type {\n"
	"          type enumeration {\n"
	"            enum \"downstream\" {\n"
	"              value 0;\n"
	"              description\n"
	"                \"Prefer backup path via downstream node.\";\n"
	"            }\n"
	"            enum \"lowest-backup-metric\" {\n"
	"              value 1;\n"
	"              description\n"
	"                \"Prefer backup path with lowest total metric.\";\n"
	"            }\n"
	"            enum \"node-protecting\" {\n"
	"              value 2;\n"
	"              description\n"
	"                \"Prefer node protecting backup path.\";\n"
	"            }\n"
	"          }\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"Tiebreaker type.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-config-remote-lfa {\n"
	"    description\n"
	"      \"Grouping for Remote LFA configuration.\";\n"
	"\n"
	"    container remote-lfa {\n"
	"      description\n"
	"        \"Remote LFA configuration.\";\n"
	"\n"
	"      leaf prefix-list {\n"
	"        type prefix-list-ref;\n"
	"        description\n"
	"          \"Filter PQ node router ID based on prefix list.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping interface-config-lfa {\n"
	"    description\n"
	"      \"Grouping for LFA configuration on an interface.\";\n"
	"\n"
	"    container lfa {\n"
	"      description\n"
	"        \"LFA configuration.\";\n"
	"      leaf enable {\n"
	"        type boolean;\n"
	"        default false;\n"
	"        description\n"
	"          \"Enables LFA computation.\";\n"
	"      }\n"
	"      leaf-list exclude-interface {\n"
	"        type frr-interface:interface-ref;\n"
	"        description\n"
	"          \"Exclude an interface from computation.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping interface-config-remote-lfa {\n"
	"    description\n"
	"      \"Grouping for remote LFA configuration.\";\n"
	"\n"
	"    container remote-lfa {\n"
	"      description\n"
	"        \"Remote LFA configuration.\";\n"
	"\n"
	"      leaf enable {\n"
	"        type boolean;\n"
	"        must \". = \'false\' or ../../lfa/enable = \'true\'\" {\n"
	"          error-message\n"
	"            \"Remote LFA depends on classic LFA being configured in the interface.\";\n"
	"        }\n"
	"        default false;\n"
	"        description\n"
	"          \"Enables remote LFA computation using LDP tunnels.\";\n"
	"\n"
	"      }\n"
	"      leaf maximum-metric {\n"
	"        type uint32 {\n"
	"          range \"1..16777215\";\n"
	"        }\n"
	"        description\n"
	"          \"Limit remote LFA node selection within the metric.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping interface-config-ti-lfa {\n"
	"    description\n"
	"      \"Grouping for TI-LFA configuration.\";\n"
	"\n"
	"    container ti-lfa {\n"
	"      description\n"
	"        \"TI-LFA configuration.\";\n"
	"      leaf enable {\n"
	"        type boolean;\n"
	"        must \". = \'false\' or ../../lfa/enable = \'false\'\" {\n"
	"          error-message\n"
	"            \"Can\'t enable both classic LFA and TI-LFA in the same interface.\";\n"
	"        }\n"
	"        default false;\n"
	"        description\n"
	"          \"Enables TI-LFA computation.\";\n"
	"      }\n"
	"      leaf node-protection {\n"
	"        type boolean;\n"
	"        must \". = \'false\' or ../enable = \'true\'\";\n"
	"        default false;\n"
	"        description\n"
	"          \"Node protection is provided by the alternate.\";\n"
	"      }\n"
	"      leaf link-fallback {\n"
	"        type boolean;\n"
	"        must \". = \'false\' or ../enable = \'true\'\";\n"
	"        default false;\n"
	"        description\n"
	"          \"Fallback to link protection.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping interface-config {\n"
	"    description\n"
	"      \"Interface configuration grouping\";\n"
	"    leaf area-tag {\n"
	"      type string;\n"
	"      mandatory true;\n"
	"      description\n"
	"        \"Area-tag associated to this circuit.\";\n"
	"    }\n"
	"\n"
	"    leaf ipv4-routing {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Routing IS-IS IPv4 traffic over this circuit.\";\n"
	"    }\n"
	"\n"
	"    leaf ipv6-routing {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Routing IS-IS IPv6 traffic over this circuit.\";\n"
	"    }\n"
	"\n"
	"    leaf circuit-type {\n"
	"      type level;\n"
	"      default \"level-1-2\";\n"
	"      description\n"
	"        \"IS-type of this circuit.\";\n"
	"    }\n"
	"\n"
	"    container bfd-monitoring {\n"
	"      description\n"
	"        \"Container for BFD monitoring configuration.\";\n"
	"\n"
	"      leaf enabled {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Monitor IS-IS peers on this circuit.\";\n"
	"      }\n"
	"      leaf profile {\n"
	"        type string;\n"
	"        description\n"
	"          \"Let BFD use a pre-configured profile.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    container csnp-interval {\n"
	"      description\n"
	"        \"Complete Sequence Number PDU (CSNP) generation interval.\";\n"
	"      leaf level-1 {\n"
	"        type uint16 {\n"
	"          range \"1..600\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"10\";\n"
	"        description\n"
	"          \"CNSP interval for level-1\";\n"
	"      }\n"
	"\n"
	"      leaf level-2 {\n"
	"        type uint16 {\n"
	"          range \"1..600\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"10\";\n"
	"        description\n"
	"          \"CNSP interval for level-2\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    container psnp-interval {\n"
	"      description\n"
	"        \"Partial Sequence Number PDU (PSNP) generation interval.\";\n"
	"      leaf level-1 {\n"
	"        type uint16 {\n"
	"          range \"1..120\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"2\";\n"
	"        description\n"
	"          \"PNSP interval for level-1\";\n"
	"      }\n"
	"\n"
	"      leaf level-2 {\n"
	"        type uint16 {\n"
	"          range \"1..120\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"2\";\n"
	"        description\n"
	"          \"PCNSP interval for level-2\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    container hello {\n"
	"      description\n"
	"        \"Parameters related to IS-IS hello PDUs.\";\n"
	"      leaf padding {\n"
	"        type hello-padding-type;\n"
	"        default \"always\";\n"
	"        description\n"
	"          \"Type of padding for IS-IS hello packets.\";\n"
	"      }\n"
	"\n"
	"      container interval {\n"
	"        description\n"
	"          \"Interval between consecutive hello messages.\";\n"
	"        leaf level-1 {\n"
	"          type uint32 {\n"
	"            range \"1..600\";\n"
	"          }\n"
	"          units \"seconds\";\n"
	"          default \"3\";\n"
	"          description\n"
	"            \"Holding time for level-1; interval will depend on multiplier.\";\n"
	"        }\n"
	"\n"
	"        leaf level-2 {\n"
	"          type uint32 {\n"
	"            range \"1..600\";\n"
	"          }\n"
	"          units \"seconds\";\n"
	"          default \"3\";\n"
	"          description\n"
	"            \"Holding time for level-2; interval will depend on multiplier.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container multiplier {\n"
	"        description\n"
	"          \"Multiplier for the hello messages holding time.\";\n"
	"        leaf level-1 {\n"
	"          type uint16 {\n"
	"            range \"2..100\";\n"
	"          }\n"
	"          default \"10\";\n"
	"          description\n"
	"            \"Multiplier for the hello holding time.\";\n"
	"        }\n"
	"\n"
	"        leaf level-2 {\n"
	"          type uint16 {\n"
	"            range \"2..100\";\n"
	"          }\n"
	"          default \"10\";\n"
	"          description\n"
	"            \"Multiplier for the hello holding time.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    container metric {\n"
	"      description\n"
	"        \"Default metric for this IS-IS circuit.\";\n"
	"      leaf level-1 {\n"
	"        type uint32 {\n"
	"          range \"0..16777215\";\n"
	"        }\n"
	"        must \". < 64 or not(/frr-isisd:isis/instance[area-tag = current()/../../area-tag]/metric-style) or /frr-isisd:isis/instance[area-tag = current()/../../area-tag]/metric-style != \'narrow\'\";\n"
	"        default \"10\";\n"
	"        description\n"
	"          \"Default level-1 metric for this IS-IS circuit.\";\n"
	"      }\n"
	"\n"
	"      leaf level-2 {\n"
	"        type uint32 {\n"
	"          range \"0..16777215\";\n"
	"        }\n"
	"        must \". < 64 or not(/frr-isisd:isis/instance[area-tag = current()/../../area-tag]/metric-style) or /frr-isisd:isis/instance[area-tag = current()/../../area-tag]/metric-style != \'narrow\'\";\n"
	"        default \"10\";\n"
	"        description\n"
	"          \"Default level-2 metric for this IS-IS circuit.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    container priority {\n"
	"      description\n"
	"        \"Priority for Designated Router election.\";\n"
	"      leaf level-1 {\n"
	"        type uint8 {\n"
	"          range \"0..127\";\n"
	"        }\n"
	"        default \"64\";\n"
	"        description\n"
	"          \"Level-1 priority for this IS-IS circuit.\";\n"
	"      }\n"
	"\n"
	"      leaf level-2 {\n"
	"        type uint8 {\n"
	"          range \"0..127\";\n"
	"        }\n"
	"        default \"64\";\n"
	"        description\n"
	"          \"Level-2 priority for this IS-IS circuit.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    leaf network-type {\n"
	"      type network-type;\n"
	"      must \"(. = \\\"point-to-point\\\") or (. = \\\"broadcast\\\")\";\n"
	"      default \"broadcast\";\n"
	"      description\n"
	"        \"Explicitly configured type of IS-IS circuit (broadcast or point-to-point).\";\n"
	"    }\n"
	"\n"
	"    leaf passive {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Interface is in passive mode.\";\n"
	"    }\n"
	"\n"
	"    container password {\n"
	"      presence \"Present if a password is set for this IS interface.\";\n"
	"      uses isis-password;\n"
	"\n"
	"      description\n"
	"        \"Container for the password of this IS interface.\";\n"
	"    }\n"
	"\n"
	"    leaf disable-three-way-handshake {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Disables three-way handshake when creating new adjacencies.\";\n"
	"    }\n"
	"\n"
	"    container multi-topology {\n"
	"      description\n"
	"        \"IS-IS topologies configured on this circuit.\";\n"
	"      leaf standard {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"Standard (IPV4 unicast) topology.\";\n"
	"      }\n"
	"\n"
	"      leaf ipv4-multicast {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"IPv4 multicast topology.\";\n"
	"      }\n"
	"\n"
	"      leaf ipv4-management {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"IPv4 management topology.\";\n"
	"      }\n"
	"\n"
	"      leaf ipv6-unicast {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"IPv6 unicast topology.\";\n"
	"      }\n"
	"\n"
	"      leaf ipv6-multicast {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"IPv6 multicast topology.\";\n"
	"      }\n"
	"\n"
	"      leaf ipv6-management {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"IPv6 management topology.\";\n"
	"      }\n"
	"\n"
	"      leaf ipv6-dstsrc {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"IPv6 destination-source topology.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    container mpls {\n"
	"      description\n"
	"        \"Configuration of MPLS parameters\";\n"
	"      leaf ldp-sync {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"Enable MPLS LDP-Sync functionality on this circuit.\";\n"
	"      }\n"
	"      leaf holddown {\n"
	"        type uint16 {\n"
	"          range \"0..10000\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        description\n"
	"          \"Time to wait for LDP-Sync to occur before restoring interface metric.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    container fast-reroute {\n"
	"      description\n"
	"        \"Interface IP Fast-reroute configuration.\";\n"
	"      container level-1 {\n"
	"        description\n"
	"          \"Level-1 IP Fast-reroute configuration.\";\n"
	"        uses interface-config-lfa;\n"
	"        uses interface-config-remote-lfa;\n"
	"        uses interface-config-ti-lfa;\n"
	"      }\n"
	"      container level-2 {\n"
	"        description\n"
	"          \"Level-2 IP Fast-reroute configuration.\";\n"
	"        uses interface-config-lfa;\n"
	"        uses interface-config-remote-lfa;\n"
	"        uses interface-config-ti-lfa;\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping adjacency-state {\n"
	"    description\n"
	"      \"Adjacency state\";\n"
	"    container adjacencies {\n"
	"      config false;\n"
	"      description\n"
	"        \"This container lists the adjacencies of\n"
	"         the local node.\";\n"
	"      list adjacency {\n"
	"        description\n"
	"          \"List of operational adjacencies.\";\n"
	"        leaf neighbor-sys-type {\n"
	"          type level;\n"
	"          description\n"
	"            \"Level capability of neighboring system\";\n"
	"        }\n"
	"\n"
	"        leaf neighbor-sysid {\n"
	"          type system-id;\n"
	"          description\n"
	"            \"The system-id of the neighbor\";\n"
	"        }\n"
	"\n"
	"        leaf neighbor-extended-circuit-id {\n"
	"          type extended-circuit-id;\n"
	"          description\n"
	"            \"Circuit ID of the neighbor\";\n"
	"        }\n"
	"\n"
	"        leaf neighbor-snpa {\n"
	"          type snpa;\n"
	"          description\n"
	"            \"SNPA of the neighbor\";\n"
	"        }\n"
	"\n"
	"        leaf hold-timer {\n"
	"          type uint16;\n"
	"          units \"seconds\";\n"
	"          description\n"
	"            \"The holding time in seconds for this\n"
	"             adjacency. This value is based on\n"
	"             received hello PDUs and the elapsed\n"
	"             time since receipt.\";\n"
	"        }\n"
	"\n"
	"        leaf neighbor-priority {\n"
	"          type uint8 {\n"
	"            range \"0 .. 127\";\n"
	"          }\n"
	"          description\n"
	"            \"Priority of the neighboring IS for becoming\n"
	"             the DIS.\";\n"
	"        }\n"
	"\n"
	"        leaf state {\n"
	"          type adj-state-type;\n"
	"          description\n"
	"            \"This leaf describes the state of the interface.\";\n"
	"        }\n"
	"\n"
	"        uses adjacency-sids;\n"
	"        uses lan-adjacency-sids;\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping event-counters {\n"
	"    description\n"
	"      \"Grouping for IS-IS interface event counters\";\n"
	"    container event-counters {\n"
	"      config false;\n"
	"      description\n"
	"        \"IS-IS interface event counters.\";\n"
	"      leaf adjacency-changes {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"The number of times an adjacency state change has\n"
	"           occurred on this interface.\";\n"
	"      }\n"
	"\n"
	"      leaf adjacency-number {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"The number of adjacencies on this interface.\";\n"
	"      }\n"
	"\n"
	"      leaf init-fails {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"The number of times initialization of this\n"
	"           interface has failed. This counts events such\n"
	"           as PPP NCP failures. Failures to form an\n"
	"           adjacency are counted by adjacency-rejects.\";\n"
	"      }\n"
	"\n"
	"      leaf adjacency-rejects {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"The number of times an adjacency has been\n"
	"           rejected on this interface.\";\n"
	"      }\n"
	"\n"
	"      leaf id-len-mismatch {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"The number of times an IS-IS PDU with an ID\n"
	"           field length different from that for this\n"
	"           system has been received on this interface.\";\n"
	"      }\n"
	"\n"
	"      leaf max-area-addresses-mismatch {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"The number of times an IS-IS PDU has been\n"
	"           received on this interface with the\n"
	"           max area address field differing from that of\n"
	"           this system.\";\n"
	"      }\n"
	"\n"
	"      leaf authentication-type-fails {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"Number of authentication type mismatches.\";\n"
	"      }\n"
	"\n"
	"      leaf authentication-fails {\n"
	"        type uint32;\n"
	"        description\n"
	"          \"Number of authentication key failures.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping interface-state {\n"
	"    description\n"
	"      \"IS-IS interface operational state.\";\n"
	"    uses adjacency-state;\n"
	"\n"
	"    uses event-counters;\n"
	"  }\n"
	"\n"
	"  grouping notification-instance-hdr {\n"
	"    description\n"
	"      \"Instance specific IS-IS notification data grouping\";\n"
	"    leaf routing-instance {\n"
	"      type string;\n"
	"      description\n"
	"        \"Name of the routing-instance instance.\";\n"
	"    }\n"
	"\n"
	"    leaf routing-protocol-name {\n"
	"      type string;\n"
	"      description\n"
	"        \"Name of the IS-IS instance.\";\n"
	"    }\n"
	"\n"
	"    leaf isis-level {\n"
	"      type level;\n"
	"      description\n"
	"        \"IS-IS level of the instance.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping notification-interface-hdr {\n"
	"    description\n"
	"      \"Interface specific IS-IS notification data grouping\";\n"
	"    leaf interface-name {\n"
	"      type frr-interface:interface-ref;\n"
	"      description\n"
	"        \"IS-IS interface name\";\n"
	"    }\n"
	"\n"
	"    leaf interface-level {\n"
	"      type level;\n"
	"      description\n"
	"        \"IS-IS level of the interface.\";\n"
	"    }\n"
	"\n"
	"    leaf extended-circuit-id {\n"
	"      type extended-circuit-id;\n"
	"      description\n"
	"        \"Eextended circuit-id of the interface.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping adjacency-sids {\n"
	"    description\n"
	"      \"IS-IS segment routing adjacency SID grouping.\";\n"
	"    container adjacency-sids {\n"
	"      description\n"
	"        \"This container lists the information of adjacency SID.\";\n"
	"      list adjacency-sid {\n"
	"        description\n"
	"          \"List of adjacency SIDs.\";\n"
	"\n"
	"        leaf af {\n"
	"          type uint8;\n"
	"          description\n"
	"            \"This leaf describes the protocol-family associated with the\n"
	"              adjacency SID.\";\n"
	"        }\n"
	"\n"
	"        leaf value {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"This leaf describes the value of adjacency SID.\";\n"
	"        }\n"
	"\n"
	"        leaf weight {\n"
	"          type uint8;\n"
	"          description\n"
	"            \"This leaf describes the weight of the adjacency SID.\";\n"
	"        }\n"
	"\n"
	"        leaf protection-requested {\n"
	"          type boolean;\n"
	"          description\n"
	"            \"This leaf describes if the adjacency SID must be protected.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping lan-adjacency-sids {\n"
	"    description\n"
	"      \"IS-IS segment routing LAN adjacency SID grouping.\";\n"
	"    container lan-adjacency-sids {\n"
	"      description\n"
	"        \"This container lists the information of LAN adjacency SID.\";\n"
	"      list lan-adjacency-sid {\n"
	"        description\n"
	"          \"List of LAN adjacency SIDs.\";\n"
	"\n"
	"        leaf af {\n"
	"          type uint8;\n"
	"          description\n"
	"            \"This leaf describes the protocol-family associated with the\n"
	"              LAN adjacency SID.\";\n"
	"        }\n"
	"\n"
	"        leaf value {\n"
	"          type uint32;\n"
	"          description\n"
	"            \"This leaf describes the value of LAN adjacency SID.\";\n"
	"        }\n"
	"\n"
	"        leaf weight {\n"
	"          type uint8;\n"
	"          description\n"
	"            \"This leaf describes the weight of the LAN adjacency SID.\";\n"
	"        }\n"
	"\n"
	"        leaf protection-requested {\n"
	"          type boolean;\n"
	"          description\n"
	"            \"This leaf describes if the LAN adjacency SID must be protected.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  container isis {\n"
	"    description\n"
	"      \"Configuration of the IS-IS routing daemon.\";\n"
	"    list instance {\n"
	"      key \"area-tag vrf\";\n"
	"      description\n"
	"        \"IS-IS routing instance.\";\n"
	"      leaf area-tag {\n"
	"        type string;\n"
	"        description\n"
	"          \"Area-tag associated to this routing instance.\";\n"
	"      }\n"
	"\n"
	"      leaf vrf {\n"
	"        type frr-vrf:vrf-ref;\n"
	"        description\n"
	"          \"VRF NAME.\";\n"
	"      }\n"
	"\n"
	"      leaf is-type {\n"
	"        type level;\n"
	"        default \"level-1-2\";\n"
	"        description\n"
	"          \"Level of the IS-IS routing instance (OSI only).\";\n"
	"      }\n"
	"\n"
	"      leaf-list area-address {\n"
	"        type net-address;\n"
	"        max-elements 3;\n"
	"        description\n"
	"          \"List of OSI NET addresses for this protocol instance.\";\n"
	"      }\n"
	"\n"
	"      leaf dynamic-hostname {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"Dynamic hostname support for IS-IS.\";\n"
	"      }\n"
	"\n"
	"      leaf attach-send {\n"
	"        type boolean;\n"
	"        default \"true\";\n"
	"        description\n"
	"          \"If true, attached bits are sent in LSP if L1/L2 router for inter-area traffic.\";\n"
	"      }\n"
	"\n"
	"      leaf attach-receive-ignore {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"If false, attached bits received in LSP, cause default route add, if L1 router for inter-area traffic.\";\n"
	"      }\n"
	"\n"
	"      leaf attached {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"\tstatus deprecated;\n"
	"        description\n"
	"          \"If true, identify as L1/L2 router for inter-area traffic.\";\n"
	"      }\n"
	"\n"
	"      container overload {\n"
	"        description\n"
	"          \"Overload bit configuration.\";\n"
	"        leaf enabled {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"If true, avoid any transit traffic.\";\n"
	"        }\n"
	"\n"
	"        leaf on-startup {\n"
	"          type uint32 {\n"
	"            range \"0..86400\";\n"
	"          }\n"
	"          units \"seconds\";\n"
	"          default \"0\";\n"
	"          description\n"
	"            \"The duration the overload bit should be set on startup.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      leaf metric-style {\n"
	"        type metric-style-type;\n"
	"        must \". = \'wide\' or count(../multi-topology/*) = 0\";\n"
	"        default \"wide\";\n"
	"        description\n"
	"          \"Define the style of TLVs metric supported.\";\n"
	"      }\n"
	"\n"
	"      leaf advertise-high-metrics {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Advertise high metric value on all interfaces.\";\n"
	"      }\n"
	"\n"
	"      leaf purge-originator {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Use the RFC 6232 purge-originator.\";\n"
	"        reference\n"
	"          \"RFC6232\";\n"
	"      }\n"
	"\n"
	"      leaf advertise-passive-only {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Advertise prefixes of passive interfaces only\";\n"
	"      }\n"
	"\n"
	"      leaf admin-group-send-zero {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Allow sending the default admin-group value of 0x00000000\";\n"
	"      }\n"
	"\n"
	"      leaf asla-legacy-flag {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Set the legacy flag (aka. L-FLAG) in the ASLA Sub-TLV.\";\n"
	"      }\n"
	"\n"
	"      container lsp {\n"
	"        description\n"
	"          \"Configuration of Link-State Packets (LSP) parameters\";\n"
	"        leaf mtu {\n"
	"          type uint16 {\n"
	"            range \"128..4352\";\n"
	"          }\n"
	"          default \"1497\";\n"
	"          description\n"
	"            \"MTU of an LSP.\";\n"
	"        }\n"
	"\n"
	"        container timers {\n"
	"          description\n"
	"            \"LSP-related timers\";\n"
	"          container level-1 {\n"
	"            description\n"
	"              \"Level-1 LSP-related timers\";\n"
	"            leaf refresh-interval {\n"
	"              type uint16;\n"
	"              units \"seconds\";\n"
	"              default \"900\";\n"
	"              description\n"
	"                \"LSP refresh interval for level-1.\";\n"
	"            }\n"
	"\n"
	"            leaf maximum-lifetime {\n"
	"              type uint16 {\n"
	"                range \"350..65535\";\n"
	"              }\n"
	"              units \"seconds\";\n"
	"              must \". >= ../refresh-interval + 300\";\n"
	"              default \"1200\";\n"
	"              description\n"
	"                \"Maximum LSP lifetime for level-1.\";\n"
	"            }\n"
	"\n"
	"            leaf generation-interval {\n"
	"              type uint16 {\n"
	"                range \"1..120\";\n"
	"              }\n"
	"              units \"seconds\";\n"
	"              must \". < ../refresh-interval\";\n"
	"              default \"30\";\n"
	"              description\n"
	"                \"Minimum time allowed before level-1 LSP retransmissions.\";\n"
	"            }\n"
	"          }\n"
	"\n"
	"          container level-2 {\n"
	"            description\n"
	"              \"Level-2 LSP-related timers\";\n"
	"            leaf refresh-interval {\n"
	"              type uint16;\n"
	"              units \"seconds\";\n"
	"              default \"900\";\n"
	"              description\n"
	"                \"LSP refresh interval for level-2.\";\n"
	"            }\n"
	"\n"
	"            leaf maximum-lifetime {\n"
	"              type uint16 {\n"
	"                range \"350..65535\";\n"
	"              }\n"
	"              units \"seconds\";\n"
	"              must \". >= ../refresh-interval + 300\";\n"
	"              default \"1200\";\n"
	"              description\n"
	"                \"Maximum LSP lifetime for level-2.\";\n"
	"            }\n"
	"\n"
	"            leaf generation-interval {\n"
	"              type uint16 {\n"
	"                range \"1..120\";\n"
	"              }\n"
	"              units \"seconds\";\n"
	"              must \". < ../refresh-interval\";\n"
	"              default \"30\";\n"
	"              description\n"
	"                \"Minimum time allowed before level-2 LSP retransmissions.\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container spf {\n"
	"        description\n"
	"          \"Parameters related to the Shortest Path First algorithm.\";\n"
	"        container ietf-backoff-delay {\n"
	"          presence \"Present if IETF SPF back-off delay is enabled.\";\n"
	"          description\n"
	"            \"SPF back-off delay algorithm parameters (see RFC 8405).\";\n"
	"          leaf init-delay {\n"
	"            type uint16 {\n"
	"              range \"0..60000\";\n"
	"            }\n"
	"            units \"msec\";\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"Delay used while in QUIET state\";\n"
	"          }\n"
	"\n"
	"          leaf short-delay {\n"
	"            type uint16 {\n"
	"              range \"0..60000\";\n"
	"            }\n"
	"            units \"msec\";\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"Delay used while in SHORT_WAIT state\";\n"
	"          }\n"
	"\n"
	"          leaf long-delay {\n"
	"            type uint16 {\n"
	"              range \"0..60000\";\n"
	"            }\n"
	"            units \"msec\";\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"Delay used while in LONG_WAIT state\";\n"
	"          }\n"
	"\n"
	"          leaf hold-down {\n"
	"            type uint16 {\n"
	"              range \"0..60000\";\n"
	"            }\n"
	"            units \"msec\";\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"Time with no received IGP events before considering IGP stable\";\n"
	"          }\n"
	"\n"
	"          leaf time-to-learn {\n"
	"            type uint16 {\n"
	"              range \"0..60000\";\n"
	"            }\n"
	"            units \"msec\";\n"
	"            mandatory true;\n"
	"            description\n"
	"              \"Maximum duration needed to learn all the events related to a\n"
	"               single failure\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container minimum-interval {\n"
	"          description\n"
	"            \"Minimum interval between consecutive executions of the\n"
	"             SPF algorithm.\";\n"
	"          leaf level-1 {\n"
	"            type uint16 {\n"
	"              range \"1..120\";\n"
	"            }\n"
	"            units \"seconds\";\n"
	"            default \"1\";\n"
	"            description\n"
	"              \"Minimum time between consecutive level-1 SPFs.\";\n"
	"          }\n"
	"\n"
	"          leaf level-2 {\n"
	"            type uint16 {\n"
	"              range \"1..120\";\n"
	"            }\n"
	"            units \"seconds\";\n"
	"            default \"1\";\n"
	"            description\n"
	"              \"Minimum time between consecutive level-2 SPFs.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container prefix-priorities {\n"
	"          description\n"
	"            \"SPF Prefix Priority configuration\";\n"
	"\n"
	"          container critical {\n"
	"            description\n"
	"              \"Critical prefix priority\";\n"
	"            leaf access-list-name {\n"
	"              type access-list-ref;\n"
	"              description\n"
	"                \"Access List to determine prefixes for\n"
	"                 this priority\";\n"
	"            }\n"
	"          }\n"
	"          container high {\n"
	"            description\n"
	"              \"High prefix priority\";\n"
	"            leaf access-list-name {\n"
	"              type access-list-ref;\n"
	"              description\n"
	"                \"Access List to determine prefixes for\n"
	"                 this priority\";\n"
	"            }\n"
	"          }\n"
	"          container medium {\n"
	"            description\n"
	"              \"Medium prefix priority\";\n"
	"            leaf access-list-name {\n"
	"              type access-list-ref;\n"
	"              description\n"
	"                \"Access List to determine prefixes for\n"
	"                 this priority\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container area-password {\n"
	"        presence \"Present if authentication is required for IS level-1.\";\n"
	"        description\n"
	"          \"Authentication password for an IS-IS area.\";\n"
	"        uses isis-area-password;\n"
	"      }\n"
	"\n"
	"      container domain-password {\n"
	"        presence \"Present if authentication is required for IS level-2.\";\n"
	"        description\n"
	"          \"Authentication password for an IS-IS domain.\";\n"
	"        uses isis-area-password;\n"
	"      }\n"
	"\n"
	"      container default-information-originate {\n"
	"        description\n"
	"          \"Distribution of default information.\";\n"
	"        list ipv4 {\n"
	"          key \"level\";\n"
	"          description\n"
	"            \"Distribute default route for IPv4.\";\n"
	"          leaf level {\n"
	"            type level;\n"
	"            must \"(. != \\\"level-1-2\\\") and ((../../../is-type = \\\"level-1-2\\\") or (. = ../../../is-type))\";\n"
	"            description\n"
	"              \"Specifies the level to which the default route should be distributed.\";\n"
	"          }\n"
	"\n"
	"          uses redistribute-default;\n"
	"        }\n"
	"\n"
	"        list ipv6 {\n"
	"          key \"level\";\n"
	"          description\n"
	"            \"Distribute default route for IPv6.\";\n"
	"          leaf level {\n"
	"            type level;\n"
	"            must \"(. != \\\"level-1-2\\\") and ((../../../is-type = \\\"level-1-2\\\") or (. = ../../../is-type))\";\n"
	"            description\n"
	"              \"Specifies the level to which the default route should be distributed.\";\n"
	"          }\n"
	"\n"
	"          uses redistribute-default;\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container redistribute {\n"
	"        description\n"
	"          \"Redistributes routes learned from other routing protocols.\";\n"
	"        list ipv4 {\n"
	"          key \"protocol level\";\n"
	"          description\n"
	"            \"IPv4 route redistribution.\";\n"
	"          leaf protocol {\n"
	"            type frr-route-types:frr-route-types-v4;\n"
	"            must \". != \\\"isis\\\"\";\n"
	"            description\n"
	"              \"Originating routing protocol for the IPv4 routes.\";\n"
	"          }\n"
	"\n"
	"          leaf level {\n"
	"            type level;\n"
	"            must \"(. != \\\"level-1-2\\\") and ((../../../is-type = \\\"level-1-2\\\") or (. = ../../../is-type))\";\n"
	"            description\n"
	"              \"IS-IS level into which the routes should be redistributed.\";\n"
	"          }\n"
	"\n"
	"          choice protocol-type {\n"
	"            description\n"
	"              \"Choice of routing protocol type.\";\n"
	"\n"
	"            case protocol-table {\n"
	"              when \"./protocol = \\\"table\\\"\";\n"
	"              list table {\n"
	"                when \"../protocol = \\\"table\\\"\";\n"
	"                key \"table\";\n"
	"                description\n"
	"                  \"Routing table number\";\n"
	"\n"
	"                leaf table {\n"
	"                  type uint16 {\n"
	"                     range \"1..65535\";\n"
	"                  }\n"
	"                  description\n"
	"                    \"Routing table number.\";\n"
	"                }\n"
	"\n"
	"                uses redistribute-attributes;\n"
	"              }\n"
	"            }\n"
	"            case protocol-other {\n"
	"              uses redistribute-attributes;\n"
	"            }\n"
	"          }\n"
	"\n"
	"        }\n"
	"        list ipv6 {\n"
	"          key \"protocol level\";\n"
	"          description\n"
	"            \"IPv6 route redistribution.\";\n"
	"          leaf protocol {\n"
	"            type frr-route-types:frr-route-types-v6;\n"
	"            must \". != \\\"isis\\\"\";\n"
	"            description\n"
	"              \"Originating routing protocol for the IPv6 routes.\";\n"
	"          }\n"
	"\n"
	"          leaf level {\n"
	"            type level;\n"
	"            must \"(. != \\\"level-1-2\\\") and ((../../../is-type = \\\"level-1-2\\\") or (. = ../../../is-type))\";\n"
	"            description\n"
	"              \"IS-IS level into which the routes should be redistributed.\";\n"
	"          }\n"
	"\n"
	"          choice protocol-type {\n"
	"            description\n"
	"                \"Choice of routing protocol type.\";\n"
	"\n"
	"            case protocol-table {\n"
	"              list table {\n"
	"                when \"../protocol = \\\"table\\\"\";\n"
	"                key \"table\";\n"
	"\n"
	"                description\n"
	"                  \"List of routing tables for the \'table\' protocol.\";\n"
	"\n"
	"                leaf table {\n"
	"                  type uint16 {\n"
	"                     range \"1..65535\";\n"
	"                  }\n"
	"                  description\n"
	"                    \"Routing table number.\";\n"
	"                }\n"
	"\n"
	"                uses redistribute-attributes;\n"
	"              }\n"
	"              when \"./protocol = \\\"table\\\"\";\n"
	"            }\n"
	"            case protocol-other {\n"
	"              uses redistribute-attributes;\n"
	"            }\n"
	"          }\n"
	"\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container multi-topology {\n"
	"        description\n"
	"          \"IS-IS topologies configured for this area.\";\n"
	"        container ipv4-multicast {\n"
	"          presence \"Present if a separate IPv4-multicast topology is configured for this area.\";\n"
	"          description\n"
	"            \"IPv4 multicast topology.\";\n"
	"          leaf overload {\n"
	"            type boolean;\n"
	"            default \"false\";\n"
	"            description\n"
	"              \"If set to true, the router will advertise itself as overloaded to its neighbors.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container ipv4-management {\n"
	"          presence \"Present if a separate IPv4-management topology is configured for this area.\";\n"
	"          description\n"
	"            \"IPv4 management topology.\";\n"
	"          leaf overload {\n"
	"            type boolean;\n"
	"            default \"false\";\n"
	"            description\n"
	"              \"If set to true, the router will advertise itself as overloaded to its neighbors.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container ipv6-unicast {\n"
	"          presence \"Present if a separate IPv6-unicast topology is configured for this area.\";\n"
	"          description\n"
	"            \"IPv6 unicast topology.\";\n"
	"          leaf overload {\n"
	"            type boolean;\n"
	"            default \"false\";\n"
	"            description\n"
	"              \"If set to true, the router will advertise itself as overloaded to its neighbors.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container ipv6-multicast {\n"
	"          presence \"Present if a separate IPv6-multicast topology is configured for this area.\";\n"
	"          description\n"
	"            \"IPv6 multicast topology.\";\n"
	"          leaf overload {\n"
	"            type boolean;\n"
	"            default \"false\";\n"
	"            description\n"
	"              \"If set to true, the router will advertise itself as overloaded to its neighbors.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container ipv6-management {\n"
	"          presence \"Present if a separate IPv6-management topology is configured for this area.\";\n"
	"          description\n"
	"            \"IPv6 management topology.\";\n"
	"          leaf overload {\n"
	"            type boolean;\n"
	"            default \"false\";\n"
	"            description\n"
	"              \"If set to true, the router will advertise itself as overloaded to its neighbors.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container ipv6-dstsrc {\n"
	"          presence \"Present if a separate IPv6 destination-source topology is configured for this area.\";\n"
	"          description\n"
	"            \"IPv6 destination-source topology.\";\n"
	"          leaf overload {\n"
	"            type boolean;\n"
	"            default \"false\";\n"
	"            description\n"
	"              \"If set to true, the router will advertise itself as overloaded to its neighbors.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container fast-reroute {\n"
	"        description\n"
	"          \"IP Fast-reroute configuration.\";\n"
	"        container level-1 {\n"
	"          description\n"
	"            \"Level-1 IP Fast-reroute configuration.\";\n"
	"          uses global-config-lfa;\n"
	"          uses global-config-remote-lfa;\n"
	"        }\n"
	"        container level-2 {\n"
	"          description\n"
	"            \"Level-2 IP Fast-reroute configuration.\";\n"
	"          uses global-config-lfa;\n"
	"          uses global-config-remote-lfa;\n"
	"        }\n"
	"      }\n"
	"\n"
	"      leaf log-adjacency-changes {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Log changes to the IS-IS adjacencies in this area.\";\n"
	"      }\n"
	"\n"
	"      leaf log-pdu-drops {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Log any dropped PDUs in this area.\";\n"
	"      }\n"
	"\n"
	"      container mpls-te {\n"
	"        presence \"Present if MPLS-TE is enabled.\";\n"
	"        description\n"
	"          \"Enable MPLS-TE functionality.\";\n"
	"        leaf router-address {\n"
	"          type inet:ipv4-address;\n"
	"          description\n"
	"            \"Stable IP address of the advertising router.\";\n"
	"        }\n"
	"        leaf router-address-v6 {\n"
	"          type inet:ipv6-address;\n"
	"          description\n"
	"            \"Stable IPv6 address of the advertising router.\";\n"
	"        }\n"
	"        leaf export {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"Export Link State informatin.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container flex-algos {\n"
	"        description\n"
	"          \"Flex-Algo Table\";\n"
	"        list flex-algo {\n"
	"          key \"flex-algo\";\n"
	"          description\n"
	"            \"Configuration for an IS-IS Flex-Algo\";\n"
	"          leaf advertise-definition {\n"
	"            type boolean;\n"
	"            description\n"
	"              \"If TRUE, Flex-Algo definition is advertised\";\n"
	"          }\n"
	"          container affinity-include-alls {\n"
	"            description\n"
	"              \"Set the include-all affinity\";\n"
	"            leaf-list affinity-include-all {\n"
	"              type string;\n"
	"              max-elements \"256\";\n"
	"              description\n"
	"                \"Array of Attribute Names\";\n"
	"            }\n"
	"          }\n"
	"          container affinity-include-anies {\n"
	"            description\n"
	"              \"Set the include-any affinity\";\n"
	"            leaf-list affinity-include-any {\n"
	"              type string;\n"
	"              max-elements \"256\";\n"
	"              description\n"
	"                \"Array of Attribute Names\";\n"
	"            }\n"
	"          }\n"
	"          container affinity-exclude-anies {\n"
	"            description\n"
	"              \"Set the exclude-any affinity\";\n"
	"            leaf-list affinity-exclude-any {\n"
	"              type string;\n"
	"              max-elements \"256\";\n"
	"              description\n"
	"                \"Array of Attribute Names\";\n"
	"            }\n"
	"          }\n"
	"          leaf prefix-metric {\n"
	"            type empty;\n"
	"            description\n"
	"              \"Use Flex-algo Prefix Metric\";\n"
	"          }\n"
	"          leaf metric-type {\n"
	"\t\t    type enumeration {\n"
	"\t\t      enum \"igp\" {\n"
	"\t\t        value 0;\n"
	"\t\t\tdescription\n"
	"\t\t\t  \"IGP Metric\";\n"
	"\t\t      }\n"
	"\t\t      enum \"min-uni-link-delay\" {\n"
	"\t\t        value 1;\n"
	"\t\t\tdescription\n"
	"\t\t\t  \"RFC 8570 Sec 4.2 Min Unidirectional Link Delay\";\n"
	"\t\t      }\n"
	"\t\t      enum \"te-default\" {\n"
	"\t\t        value 2;\n"
	"\t\t\tdescription\n"
	"\t\t\t  \"RFC 5305 Sec 3.7 Traffic Engineering Default Metric\";\n"
	"\t\t      }\n"
	"\t\t    }\n"
	"                    default \"igp\";\n"
	"                    description\n"
	"                      \"Set the Flex-Algo metric-type\";\n"
	"          }\n"
	"          leaf priority {\n"
	"            type uint32 {\n"
	"              range \"0..255\";\n"
	"            }\n"
	"            description\n"
	"              \"Set the Flex-Algo priority\";\n"
	"          }\n"
	"          leaf dplane-sr-mpls {\n"
	"            type empty;\n"
	"            description\n"
	"\t          \"Advertise and participate in the Flex-Algo Segment-Routing MPLS data-plane\";\n"
	"          }\n"
	"          leaf dplane-srv6 {\n"
	"            type empty;\n"
	"            description\n"
	"\t          \"Advertise and participate in the Flex-Algo Segment-Routing SRv6 data-plane\";\n"
	"          }\n"
	"          leaf dplane-ip {\n"
	"            type empty;\n"
	"            description\n"
	"\t          \"Advertise and participate in the Flex-Algo IP data-plane\";\n"
	"          }\n"
	"          leaf flex-algo {\n"
	"            type uint32 {\n"
	"              range \"128..255\";\n"
	"            }\n"
	"            description\n"
	"              \"Flex-Algo\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container segment-routing {\n"
	"        description\n"
	"          \"Segment Routing global configuration.\";\n"
	"        leaf enabled {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"Enables segment-routing protocol extensions.\";\n"
	"        }\n"
	"        container label-blocks {\n"
	"          description\n"
	"            \"Local and global label blocks.\";\n"
	"          container srgb {\n"
	"            description\n"
	"              \"Global blocks to be advertised.\";\n"
	"            leaf lower-bound {\n"
	"                type uint32;\n"
	"                must \"../upper-bound > .\";\n"
	"                default \"16000\";\n"
	"                description\n"
	"                  \"Lower value in the label range.\";\n"
	"            }\n"
	"            leaf upper-bound {\n"
	"                type uint32;\n"
	"                must \". > ../lower-bound\";\n"
	"                default \"23999\";\n"
	"                description\n"
	"                  \"Upper value in the label range.\";\n"
	"            }\n"
	"          }\n"
	"          container srlb {\n"
	"            description\n"
	"              \"Local blocks to be advertised.\";\n"
	"            leaf lower-bound {\n"
	"                type uint32;\n"
	"                must \"../upper-bound > .\";\n"
	"                default \"15000\";\n"
	"                description\n"
	"                  \"Lower value in the label range.\";\n"
	"            }\n"
	"            leaf upper-bound {\n"
	"                type uint32;\n"
	"                must \". > ../lower-bound\";\n"
	"                default \"15999\";\n"
	"                description\n"
	"                  \"Upper value in the label range.\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"        container msd {\n"
	"          description\n"
	"            \"MSD configuration.\";\n"
	"          leaf node-msd {\n"
	"            type uint8;\n"
	"            description\n"
	"              \"Node MSD is the lowest MSD supported by the node.\";\n"
	"          }\n"
	"        }\n"
	"        container prefix-sid-map {\n"
	"          description\n"
	"            \"Prefix SID configuration.\";\n"
	"          list prefix-sid {\n"
	"            key \"prefix\";\n"
	"            unique \"sid-value-type sid-value\";\n"
	"            description\n"
	"              \"List of prefix SID mapped to IPv4/IPv6\n"
	"               local prefixes.\";\n"
	"            leaf prefix {\n"
	"              type inet:ip-prefix;\n"
	"              description\n"
	"                \"Connected prefix sid.\";\n"
	"            }\n"
	"            leaf sid-value-type {\n"
	"              type enumeration {\n"
	"                enum \"index\" {\n"
	"                  value 0;\n"
	"                  description\n"
	"                    \"The value will be interpreted as an index.\";\n"
	"                }\n"
	"                enum \"absolute\" {\n"
	"                  value 1;\n"
	"                  description\n"
	"                    \"The value will become interpreted as an absolute\n"
	"                     value.\";\n"
	"                }\n"
	"              }\n"
	"              default \"index\";\n"
	"              description\n"
	"                \"This leaf defines how value must be interpreted.\";\n"
	"            }\n"
	"            leaf sid-value {\n"
	"              type uint32;\n"
	"              mandatory true;\n"
	"              description\n"
	"                \"Value associated with prefix. The value must be\n"
	"                 interpreted in the context of sid-value-type.\";\n"
	"            }\n"
	"            leaf last-hop-behavior {\n"
	"              type enumeration {\n"
	"                enum \"explicit-null\" {\n"
	"                  value 0;\n"
	"                  description\n"
	"                    \"Use explicit-null for the SID.\";\n"
	"                }\n"
	"                enum \"no-php\" {\n"
	"                  value 1;\n"
	"                  description\n"
	"                    \"Do not use Penultimate Hop Popping (PHP)\n"
	"                     for the SID.\";\n"
	"                }\n"
	"                enum \"php\" {\n"
	"                  value 2;\n"
	"                  description\n"
	"                    \"Use PHP for the SID.\";\n"
	"                }\n"
	"              }\n"
	"              default \"php\";\n"
	"              description\n"
	"                \"Configure last hop behavior.\";\n"
	"            }\n"
	"            leaf n-flag-clear {\n"
	"              type boolean;\n"
	"              default \"false\";\n"
	"              description\n"
	"                \"Not a node SID\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"        container algorithm-prefix-sids {\n"
	"          description\n"
	"            \"Algorithm SID Table\";\n"
	"          list algorithm-prefix-sid {\n"
	"            key \"prefix algo\";\n"
	"            description\n"
	"              \"Assign prefix SID for algorithm to an\n"
	"               interface, ISISPHPFlag will be rejected\n"
	"               if set to disable, ISISEXPLICITNULLFlag\n"
	"               will override the value of ISISPHPFlag\";\n"
	"            leaf algo {\n"
	"              type uint8 {\n"
	"                range \"128..255\";\n"
	"              }\n"
	"              description\n"
	"                \"Algorithm\";\n"
	"            }\n"
	"            leaf prefix {\n"
	"              type inet:ip-prefix;\n"
	"              mandatory true;\n"
	"              description\n"
	"                \"Connected prefix sid.\";\n"
	"            }\n"
	"            leaf sid-value-type {\n"
	"              type enumeration {\n"
	"                enum \"index\" {\n"
	"                  value 0;\n"
	"                  description\n"
	"                    \"The value will be interpreted as an index.\";\n"
	"                }\n"
	"                enum \"absolute\" {\n"
	"                  value 1;\n"
	"                  description\n"
	"                    \"The value will become interpreted as an absolute\n"
	"                     value.\";\n"
	"                }\n"
	"              }\n"
	"              default \"index\";\n"
	"              description\n"
	"                \"This leaf defines how value must be interpreted.\";\n"
	"            }\n"
	"            leaf sid-value {\n"
	"              type uint32 {\n"
	"                range \"0..1048575\";\n"
	"              }\n"
	"              mandatory true;\n"
	"              description\n"
	"                \"Value associated with prefix. The value must be\n"
	"                 interpreted in the context of sid-value-type.\";\n"
	"            }\n"
	"            leaf last-hop-behavior {\n"
	"              type enumeration {\n"
	"                enum \"explicit-null\" {\n"
	"                  value 0;\n"
	"                  description\n"
	"                    \"Use explicit-null for the SID.\";\n"
	"                }\n"
	"                enum \"no-php\" {\n"
	"                  value 1;\n"
	"                  description\n"
	"                    \"Do not use Penultimate Hop Popping (PHP)\n"
	"                     for the SID.\";\n"
	"                }\n"
	"                enum \"php\" {\n"
	"                  value 2;\n"
	"                  description\n"
	"                    \"Use PHP for the SID.\";\n"
	"                }\n"
	"              }\n"
	"              default \"php\";\n"
	"              description\n"
	"                \"Configure last hop behavior.\";\n"
	"            }\n"
	"            leaf n-flag-clear {\n"
	"              type boolean;\n"
	"              default \"false\";\n"
	"              description\n"
	"                \"Not a node SID\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container segment-routing-srv6 {\n"
	"        description\n"
	"          \"Segment Routing over IPv6 (SRv6) global configuration.\";\n"
	"        leaf enabled {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"Enable IS-IS extensions to support Segment Routing over\n"
	"             IPv6 data plane (SRv6).\";\n"
	"          reference\n"
	"            \"RFC 9352\";\n"
	"        }\n"
	"        leaf locator {\n"
	"          type string;\n"
	"          description\n"
	"            \"SRv6 locator.\";\n"
	"        }\n"
	"        container msd {\n"
	"          description\n"
	"            \"SRv6 Maximum SRv6 SID Depths.\";\n"
	"          container node-msd {\n"
	"            description\n"
	"              \"SRv6 Node Maximum SRv6 SID Depths.\";\n"
	"            leaf max-segs-left {\n"
	"              type uint8 {\n"
	"                range \"0..255\";\n"
	"              }\n"
	"              default 3;\n"
	"              description\n"
	"               \"Maximum Segments Left MSD.\";\n"
	"            }\n"
	"            leaf max-end-pop {\n"
	"              type uint8 {\n"
	"                range \"0..255\";\n"
	"              }\n"
	"              default 3;\n"
	"              description\n"
	"               \"Maximum End Pop MSD.\";\n"
	"            }\n"
	"            leaf max-h-encaps {\n"
	"              type uint8 {\n"
	"                range \"0..255\";\n"
	"              }\n"
	"              default 2;\n"
	"              description\n"
	"               \"Maximum H.Encaps MSD.\";\n"
	"            }\n"
	"            leaf max-end-d {\n"
	"              type uint8 {\n"
	"                range \"0..255\";\n"
	"              }\n"
	"              default 5;\n"
	"              description\n"
	"               \"Maximum End D MSD.\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"        leaf interface {\n"
	"          type string;\n"
	"          default \"sr0\";\n"
	"          description\n"
	"            \"Dummy interface used to install SRv6 SIDs into the Linux data plane.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container mpls {\n"
	"        description\n"
	"          \"Configuration of MPLS parameters\";\n"
	"        container ldp-sync {\n"
	"          presence \"Present if MPLS LDP-Sync is enabled.\";\n"
	"          description\n"
	"            \"Enable MPLS LDP-Sync functionality.\";\n"
	"          leaf holddown {\n"
	"            type uint16 {\n"
	"              range \"0..10000\";\n"
	"            }\n"
	"            units \"seconds\";\n"
	"            default \"0\";\n"
	"            description\n"
	"              \"Time to wait for LDP-Sync to occur before restoring interface metric.\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"    }\n"
	"  }\n"
	"\n"
	"  augment \"/frr-interface:lib/frr-interface:interface\" {\n"
	"    description\n"
	"      \"Extends interface model with IS-IS related parameters.\";\n"
	"    container isis {\n"
	"      presence \"Present if an IS-IS circuit is defined for this interface.\";\n"
	"      description\n"
	"        \"IS-IS interface parameters.\";\n"
	"      uses interface-config;\n"
	"    }\n"
	"  }\n"
	"\n"
	"  augment \"/frr-interface:lib/frr-interface:interface/frr-interface:state\" {\n"
	"    description\n"
	"      \"Extends interface model with IS-IS operational data.\";\n"
	"    container isis {\n"
	"      presence \"Present if an IS-IS circuit is defined for this interface.\";\n"
	"      description\n"
	"        \"IS-IS interface operational data.\";\n"
	"\n"
	"      uses interface-state;\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification database-overload {\n"
	"    description\n"
	"      \"This notification is sent when an IS-IS instance\n"
	"       overload state changes.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    leaf overload {\n"
	"      type enumeration {\n"
	"        enum \"off\" {\n"
	"          value 0;\n"
	"          description\n"
	"            \"Indicates IS-IS instance has left overload state\";\n"
	"        }\n"
	"        enum \"on\" {\n"
	"          value 1;\n"
	"          description\n"
	"            \"Indicates IS-IS instance has entered overload state\";\n"
	"        }\n"
	"      }\n"
	"      description\n"
	"        \"New overload state of the IS-IS instance\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification lsp-too-large {\n"
	"    description\n"
	"      \"This notification is sent when we attempt to propagate\n"
	"       an LSP that is larger than the dataLinkBlockSize for the\n"
	"       circuit.  The notification generation must be throttled\n"
	"       with at least 5 seconds between successive\n"
	"       notifications.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf pdu-size {\n"
	"      type uint32;\n"
	"      description\n"
	"        \"Size of the LSP PDU\";\n"
	"    }\n"
	"\n"
	"    leaf lsp-id {\n"
	"      type lsp-id;\n"
	"      description\n"
	"        \"LSP ID\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification if-state-change {\n"
	"    description\n"
	"      \"This notification is sent when an interface\n"
	"       state change is detected.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf state {\n"
	"      type if-state-type;\n"
	"      description\n"
	"        \"Interface state.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification corrupted-lsp-detected {\n"
	"    description\n"
	"      \"This notification is sent when we find that\n"
	"       an LSP that was stored in memory has become\n"
	"       corrupted.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    leaf lsp-id {\n"
	"      type lsp-id;\n"
	"      description\n"
	"        \"LSP ID\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification attempt-to-exceed-max-sequence {\n"
	"    description\n"
	"      \"This notification is sent when the system\n"
	"       wraps the 32-bit sequence counter of an LSP.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    leaf lsp-id {\n"
	"      type lsp-id;\n"
	"      description\n"
	"        \"LSP ID\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification id-len-mismatch {\n"
	"    description\n"
	"      \"This notification is sent when we receive a PDU\n"
	"       with a different value for the System ID length.\n"
	"       The notification generation must be throttled\n"
	"       with at least 5 seconds between successive\n"
	"       notifications.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf pdu-field-len {\n"
	"      type uint8;\n"
	"      description\n"
	"        \"Size of the ID length in the received PDU\";\n"
	"    }\n"
	"\n"
	"    leaf raw-pdu {\n"
	"      type binary;\n"
	"      description\n"
	"        \"Received raw PDU.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification max-area-addresses-mismatch {\n"
	"    description\n"
	"      \"This notification is sent when we receive a PDU\n"
	"       with a different value for the Maximum Area Addresses.\n"
	"       The notification generation must be throttled\n"
	"       with at least 5 seconds between successive\n"
	"       notifications.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf max-area-addresses {\n"
	"      type uint8;\n"
	"      description\n"
	"        \"Received number of supported areas\";\n"
	"    }\n"
	"\n"
	"    leaf raw-pdu {\n"
	"      type binary;\n"
	"      description\n"
	"        \"Received raw PDU.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification own-lsp-purge {\n"
	"    description\n"
	"      \"This notification is sent when the system receives\n"
	"       a PDU with its own system ID and zero age.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf lsp-id {\n"
	"      type lsp-id;\n"
	"      description\n"
	"        \"LSP ID\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification sequence-number-skipped {\n"
	"    description\n"
	"      \"This notification is sent when the system receives a\n"
	"       PDU with its own system ID and different contents. The\n"
	"       system has to reoriginate the LSP with a higher sequence\n"
	"       number.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf lsp-id {\n"
	"      type lsp-id;\n"
	"      description\n"
	"        \"LSP ID\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification authentication-type-failure {\n"
	"    description\n"
	"      \"This notification is sent when the system receives a\n"
	"       PDU with the wrong authentication type field.\n"
	"       The notification generation must be throttled\n"
	"       with at least 5 seconds between successive\n"
	"       notifications.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf raw-pdu {\n"
	"      type binary;\n"
	"      description\n"
	"        \"Received raw PDU.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification authentication-failure {\n"
	"    description\n"
	"      \"This notification is sent when the system receives\n"
	"       a PDU with the wrong authentication information.\n"
	"       The notification generation must be throttled with\n"
	"       with at least 5 seconds between successive\n"
	"       notifications.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf raw-pdu {\n"
	"      type binary;\n"
	"      description\n"
	"        \"Received raw PDU.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification version-skew {\n"
	"    description\n"
	"      \"This notification is sent when the system receives a\n"
	"       PDU with a different protocol version number.\n"
	"       The notification generation must be throttled\n"
	"       with at least 5 seconds between successive\n"
	"       notifications.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf protocol-version {\n"
	"      type uint8;\n"
	"      description\n"
	"        \"Protocol version received in the PDU.\";\n"
	"    }\n"
	"\n"
	"    leaf raw-pdu {\n"
	"      type binary;\n"
	"      description\n"
	"        \"Received raw PDU.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification area-mismatch {\n"
	"    description\n"
	"      \"This notification is sent when the system receives a\n"
	"       Hello PDU from an IS that does not share any area\n"
	"       address. The notification generation must be throttled\n"
	"       with at least 5 seconds between successive\n"
	"       notifications.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf raw-pdu {\n"
	"      type binary;\n"
	"      description\n"
	"        \"Received raw PDU.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification rejected-adjacency {\n"
	"    description\n"
	"      \"This notification is sent when the system receives a\n"
	"       Hello PDU from an IS but does not establish an adjacency\n"
	"       for some reason. The notification generation must be\n"
	"       throttled with at least 5 seconds between successive\n"
	"       notifications.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf raw-pdu {\n"
	"      type binary;\n"
	"      description\n"
	"        \"Received raw PDU.\";\n"
	"    }\n"
	"\n"
	"    leaf reason {\n"
	"      type string;\n"
	"      description\n"
	"        \"The system may provide a reason to reject the\n"
	"         adjacency. If the reason is not available,\n"
	"         an empty string will be returned.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification lsp-error-detected {\n"
	"    description\n"
	"      \"This notification is sent when the system  receives an\n"
	"       LSP with a parse error. The notification generation must\n"
	"       be throttled with at least 5 seconds between successive\n"
	"       notifications.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf lsp-id {\n"
	"      type lsp-id;\n"
	"      description\n"
	"        \"LSP ID.\";\n"
	"    }\n"
	"\n"
	"    leaf raw-pdu {\n"
	"      type binary;\n"
	"      description\n"
	"        \"Received raw PDU.\";\n"
	"    }\n"
	"\n"
	"    leaf error-offset {\n"
	"      type uint32;\n"
	"      description\n"
	"        \"If the problem is a malformed TLV, the error-offset\n"
	"         points to the start of the TLV. If the problem is with\n"
	"         the LSP header, the error-offset points to the errant\n"
	"         byte\";\n"
	"    }\n"
	"\n"
	"    leaf tlv-type {\n"
	"      type uint8;\n"
	"      description\n"
	"        \"If the problem is a malformed TLV, the tlv-type is set\n"
	"         to the type value of the suspicious TLV. Otherwise,\n"
	"         this leaf is not present.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification adjacency-state-change {\n"
	"    description\n"
	"      \"This notification is sent when an IS-IS adjacency\n"
	"       moves to Up state or to Down state.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf neighbor {\n"
	"      type string;\n"
	"      description\n"
	"        \"Name of the neighbor. If the name of the neighbor is\n"
	"         not available, it is not returned.\";\n"
	"    }\n"
	"\n"
	"    leaf neighbor-system-id {\n"
	"      type system-id;\n"
	"      description\n"
	"        \"Neighbor system-id\";\n"
	"    }\n"
	"\n"
	"    leaf state {\n"
	"      type adj-state-type;\n"
	"      description\n"
	"        \"New state of the IS-IS adjacency.\";\n"
	"    }\n"
	"\n"
	"    leaf reason {\n"
	"      type string;\n"
	"      description\n"
	"        \"If the adjacency is going to DOWN,  this leaf provides\n"
	"         a reason for the adjacency going down. The reason is\n"
	"         provided as a text. If the adjacency is going to UP, no\n"
	"         reason is provided.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification lsp-received {\n"
	"    description\n"
	"      \"This notification is sent when an LSP is received.\n"
	"       The notification generation must be throttled with at\n"
	"       least 5 seconds between successive notifications.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    uses notification-interface-hdr;\n"
	"\n"
	"    leaf lsp-id {\n"
	"      type lsp-id;\n"
	"      description\n"
	"        \"LSP ID\";\n"
	"    }\n"
	"\n"
	"    leaf sequence {\n"
	"      type uint32;\n"
	"      description\n"
	"        \"Sequence number of the received LSP.\";\n"
	"    }\n"
	"\n"
	"    leaf received-timestamp {\n"
	"      type yang:timestamp;\n"
	"      description\n"
	"        \"Timestamp when the LSP was received.\";\n"
	"    }\n"
	"\n"
	"    leaf neighbor-system-id {\n"
	"      type system-id;\n"
	"      description\n"
	"        \"Neighbor system-id of LSP sender\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  notification lsp-generation {\n"
	"    description\n"
	"      \"This notification is sent when an LSP is regenerated.\n"
	"       The notification generation must be throttled with at\n"
	"       least 5 seconds between successive notifications.\";\n"
	"    uses notification-instance-hdr;\n"
	"\n"
	"    leaf lsp-id {\n"
	"      type lsp-id;\n"
	"      description\n"
	"        \"LSP ID\";\n"
	"    }\n"
	"\n"
	"    leaf sequence {\n"
	"      type uint32;\n"
	"      description\n"
	"        \"Sequence number of the received LSP.\";\n"
	"    }\n"
	"\n"
	"    leaf send-timestamp {\n"
	"      type yang:timestamp;\n"
	"      description\n"
	"        \"Timestamp when our LSP was regenerated.\";\n"
	"    }\n"
	"  }\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "frr-isisd",
	.mod_rev = "2021-02-15",
	.sub_mod_name = "",
	.sub_mod_rev = "",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
